/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.XbrlTypeConstant;
import kd.imc.rim.common.helper.ElectAccVoucherHelper;
import kd.imc.rim.common.helper.RecognitionCheckHelper;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.recognition.listener.IRecognitionListener;
import kd.imc.rim.common.invoice.recognition.listener.RecognitionListenerResult;
import kd.imc.rim.common.invoice.recognitionnew.task.FileUploadAndSignTask;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.RecognitionCheckService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.FormFileEntity;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.extract.ZipExtractUtil;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.file.utils.FileConvertUtils;

public class ElectAccVoucherService {
    private static Log logger = LogFactory.getLog(ElectAccVoucherService.class);
    private static final String awsRecognitionImpl = "kd.imc.rim.common.invoice.recognitionnew.impl.AwsRecognitionService";
    private static ThreadPool xbrlUploadThreadPool = ThreadPools.newFixedThreadPool((String)"xbrlUploadThreadPool", (int)10);
    private ElectAccVoucherHelper electAccVoucherHelper = new ElectAccVoucherHelper();

    public JSONObject dealVoucher(String fileUrl, String fileName, Object orgId, JSONObject businessParam, IRecognitionListener recognitionListener) throws IOException {
        JSONObject result = new JSONObject();
        boolean isVoucherOrg = ElectAccVoucherService.checkOrg(orgId);
        if (!isVoucherOrg) {
            result.put("errcode", (Object)"0004");
            result.put("description", (Object)ResManager.loadKDString((String)"\u975e\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u8bd5\u70b9\u4f01\u4e1a", (String)"ElectAccVoucherService_0", (String)"imc-rim-common", (Object[])new Object[0]));
            return result;
        }
        if (StringUtils.isEmpty((String)fileUrl) || StringUtils.isEmpty((String)fileName)) {
            return result;
        }
        logger.info("\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u89e3\u6790\u5f00\u59cb\uff1a{}", (Object)fileName);
        return this.extracted(fileUrl, fileName, orgId, businessParam, recognitionListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject extracted(String fileUrl, String fileName, Object orgId, JSONObject businessParam, IRecognitionListener recognitionListener) throws IOException {
        JSONObject result = new JSONObject();
        Map<String, String> configMap = ImcConfigUtil.getValue("rim_recog_check");
        String recognitionImplStr = configMap.get("rimpl");
        boolean isAwsRecognition = StringUtils.isEmpty((String)recognitionImplStr) || awsRecognitionImpl.equals(recognitionImplStr);
        RecognitionCheckHelper recognitionCheckHelper = new RecognitionCheckHelper();
        byte[] fileByte = null;
        if (businessParam != null) {
            fileByte = businessParam.getBytes("fileByte");
        }
        FormFileEntity fileEntity = recognitionCheckHelper.getFormFileEntity(fileUrl, fileName, fileByte);
        try (InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream(FileServiceFactory.getAttachmentFileService().getInputStream(fileUrl), fileByte);){
            JSONObject checkZipFileResult;
            fileByte = FileUtils.getByte(fileInputStream);
            String fileType = FileUtils.getFileType(fileName);
            Future xbrlUploadSubmit = null;
            if (!"zip".equalsIgnoreCase(fileType)) {
                xbrlUploadSubmit = xbrlUploadThreadPool.submit((Callable)new FileUploadAndSignTask(fileEntity.getFileUrl(), fileByte, fileEntity.getFileName(), fileEntity.getFileType(), fileEntity.getFileHash(), fileEntity.getSignatureFlag(), "1", RequestContext.get()));
            }
            if (Objects.nonNull(checkZipFileResult = this.checkZipFile(fileByte, fileType))) {
                JSONObject jSONObject = checkZipFileResult;
                return jSONObject;
            }
            long startTime = System.currentTimeMillis();
            if (isAwsRecognition) {
                result = this.electAccVoucherHelper.getByAwsAPI(orgId, fileByte, fileName);
            } else {
                result = this.electAccVoucherHelper.getByAnalysis(fileType, fileByte);
                boolean signPassFlag = result.getBoolean("signPassFlag");
                if (!signPassFlag) {
                    result.put("errcode", (Object)"0004");
                    result.put("description", (Object)ResManager.loadKDString((String)"\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u9a8c\u7b7e\u4e0d\u901a\u8fc7", (String)"ElectAccVoucherService_1", (String)"imc-rim-common", (Object[])new Object[0]));
                    JSONObject jSONObject = result;
                    return jSONObject;
                }
            }
            if (!"0000".equals(result.getString("errcode"))) {
                JSONObject jSONObject = result;
                return jSONObject;
            }
            String xbrlInfo = result.getString("xbrlInfo");
            JSONObject resultInvoice = this.electAccVoucherHelper.toInvoiceJson(xbrlInfo, orgId, businessParam.getString("taxNo"));
            if (resultInvoice == null) {
                result.put("errcode", (Object)"0005");
                result.put("description", (Object)ResManager.loadKDString((String)"\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u8f6c\u6362\u5931\u8d25", (String)"ElectAccVoucherService_2", (String)"imc-rim-common", (Object[])new Object[0]));
                JSONObject jSONObject = result;
                return jSONObject;
            }
            String voucherFileUrl = ElectAccVoucherService.getVoucherFileUrl(fileType, fileByte, xbrlInfo);
            if (resultInvoice.containsKey((Object)"isUploadOriginal") && !resultInvoice.getBoolean("isUploadOriginal").booleanValue() && xbrlUploadSubmit != null) {
                ElectAccVoucherService.uploadGet(xbrlUploadSubmit, resultInvoice);
            }
            if (resultInvoice.containsKey((Object)"isUploadOriginal") && resultInvoice.getBoolean("isUploadOriginal").booleanValue()) {
                resultInvoice.put("originalState", (Object)"1");
            } else if (!"zip".equalsIgnoreCase(fileType)) {
                resultInvoice.put("originalState", (Object)"1");
                resultInvoice.put("originalTime", (Object)new Date());
            } else {
                resultInvoice.put("originalState", (Object)"0");
            }
            String serialNo = resultInvoice.getString("serialNo");
            if (StringUtils.isEmpty((String)serialNo)) {
                serialNo = UUID.randomUUID();
                resultInvoice.put("serialNo", (Object)serialNo);
            }
            if ("zip".equalsIgnoreCase(fileType)) {
                resultInvoice.put("isZipFile", (Object)Boolean.TRUE);
            }
            resultInvoice.put("fileType", (Object)FileUtils.convertFileTypeNum(fileType));
            resultInvoice.put("fileName", (Object)fileName);
            resultInvoice.put("fileHash", (Object)fileEntity.getFileHash());
            try (TXHandle h = TX.required();){
                try {
                    String xbrlType = resultInvoice.getString("xbrlType");
                    String invoiceDate = resultInvoice.getString("invoiceDate");
                    Long invoiceType = resultInvoice.getLong("invoiceType");
                    String xbrlName = this.getTargetName(serialNo, xbrlType, invoiceType, invoiceDate);
                    if (xbrlName == null) {
                        xbrlName = fileName;
                    }
                    ElectAccVoucherService.saveVoucher(serialNo, xbrlName, voucherFileUrl, xbrlType);
                    resultInvoice = this.saveInvoice(businessParam, resultInvoice, fileUrl, fileByte);
                }
                catch (Throwable e) {
                    logger.info("\u4fdd\u5b58\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u51fa\u9519\uff1a{}", (Object)e);
                    h.markRollback();
                    String errorMsg = ResManager.loadKDString((String)"\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u4fdd\u5b58\u5f02\u5e38\u6216\u8005\u53d1\u7968\u6570\u636e\u4fdd\u5b58\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ElectAccVoucherService_9", (String)"imc-rim-common", (Object[])new Object[0]);
                    if (e instanceof MsgException) {
                        errorMsg = ((MsgException)e).getErrorMsg();
                    }
                    resultInvoice.put("errorMsg", (Object)errorMsg);
                    if (businessParam != null && "1".equals(businessParam.getString("throwSaveError"))) {
                        throw e;
                    }
                }
            }
            if (resultInvoice.get((Object)"mainId") != null) {
                DynamicObject invoiceObject = BusinessDataServiceHelper.loadSingle((Object)resultInvoice.get((Object)"mainId"), (String)"rim_invoice");
                String invoiceType = resultInvoice.getString("invoiceType");
                InvoiceSaveService service = InvoiceSaveService.newInstance(invoiceType);
                if (service != null) {
                    service.setMainInvoiceInfo(invoiceObject);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceObject});
                }
            }
            RecognitionCheckService.setInvoiceSeq(resultInvoice, businessParam, 0, 0);
            result.put("errcode", (Object)"0000");
            result.put("description", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ElectAccVoucherService_8", (String)"imc-rim-common", (Object[])new Object[0]));
            JSONArray resultArray = new JSONArray();
            resultInvoice.put("fileType", (Object)FileUtils.convertFileTypeNum(FileUtils.getFileType(fileName)));
            resultArray.add((Object)resultInvoice);
            result.put("data", (Object)resultArray);
            RecognitionListenerResult listener = new RecognitionListenerResult(fileUrl, fileName, 1, 1, resultArray);
            if (recognitionListener != null) {
                recognitionListener.handle(listener);
            }
            logger.info("\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u603b\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
            return result;
        }
        catch (Throwable throwable) {
            logger.info("\u89e3\u6790\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u51fa\u9519\uff1a{}", (Object)throwable);
            result.put("errcode", (Object)"0002");
            result.put("description", (Object)ResManager.loadKDString((String)"\u89e3\u6790\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u51fa\u9519", (String)"ElectAccVoucherService_4", (String)"imc-rim-common", (Object[])new Object[0]));
            return result;
        }
    }

    private String getTargetName(String serialNo, String xbrlType, Long invoiceType, String invoiceDate) {
        String prefix = "";
        if (StringUtils.isNotEmpty((String)invoiceDate)) {
            invoiceDate = invoiceDate.replaceAll("-", "");
        }
        if (XbrlTypeConstant.AIR_ELE.getCode().equals(xbrlType)) {
            prefix = "atr_issuer_";
        } else if (XbrlTypeConstant.BANK_RECEIPT.getCode().equals(xbrlType)) {
            prefix = "bker_issuer_";
        } else if (XbrlTypeConstant.BANK_STATEMENT.getCode().equals(xbrlType)) {
            prefix = "bkrs_issuer_";
        } else if (XbrlTypeConstant.FINANCIAL.getCode().equals(xbrlType)) {
            prefix = "efi_issuer_";
        } else if (XbrlTypeConstant.TRAIN_ELE.getCode().equals(xbrlType)) {
            prefix = "rai_issuer_";
        } else if (XbrlTypeConstant.COVERINGWARRANT.getCode().equals(xbrlType)) {
            prefix = "ntrev_gpm_issuer_";
        } else if (XbrlTypeConstant.E_VAT.getCode().equals(xbrlType)) {
            prefix = InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) ? "inv_ord_issuer_" : "inv_spcl_issuer_";
        }
        if (StringUtils.isEmpty((String)prefix)) {
            return null;
        }
        return prefix + invoiceDate + '_' + serialNo + ".xml";
    }

    private JSONObject checkZipFile(byte[] fileByte, String fileType) {
        if ("zip".equalsIgnoreCase(fileType)) {
            int fileLimit = 2;
            Map<String, String> zipFileMap = ZipExtractUtil.extractFileForXml(fileByte);
            if (zipFileMap.isEmpty()) {
                return ResultContant.createJSONObject("0002", ResManager.loadKDString((String)"\u89e3\u6790zip\u538b\u7f29\u5305\u4e3a\u7a7a", (String)"ElectAccVoucherService_5", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            if (zipFileMap.size() != fileLimit) {
                return ResultContant.createJSONObject("0003", String.format(ResManager.loadKDString((String)"\u89e3\u6790zip\u538b\u7f29\u5305\u53ea\u5305\u542b%1$s\u4e2a\u6587\u4ef6", (String)"ElectAccVoucherService_6", (String)"imc-rim-common", (Object[])new Object[0]), zipFileMap.size()));
            }
            for (Map.Entry<String, String> map : zipFileMap.entrySet()) {
                String key = map.getKey();
                boolean checkFileType = FileUtils.checkFileType(key, "xml", "sign");
                if (checkFileType) continue;
                return ResultContant.createJSONObject("0003", ResManager.loadKDString((String)"\u89e3\u6790zip\u538b\u7f29\u5305\u53ea\u80fd\u5305\u542bxml/sign\u6587\u4ef6", (String)"ElectAccVoucherService_7", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
        return null;
    }

    private JSONObject saveInvoice(JSONObject businessParam, JSONObject resultInvoice, String fileUrl, byte[] fileByte) {
        Long tax_org = null;
        if (null != businessParam) {
            businessParam.remove((Object)"fileByte");
            resultInvoice.putAll((Map)businessParam);
            tax_org = businessParam.getLong("tax_org");
        }
        if (!ObjectUtils.isEmpty(tax_org)) {
            resultInvoice.put("tax_org", tax_org);
        }
        InvoiceCollectService invoiceCollectService = new InvoiceCollectService();
        String fileHash = FileConvertUtils.getSHA256((byte[])fileByte);
        if (StringUtils.isEmpty((String)resultInvoice.getString("serialNo"))) {
            resultInvoice.put("serialNo", (Object)UUID.randomUUID());
        }
        try (DLock lock = DLock.create((String)(resultInvoice.getString("invoiceNo") + "saveVoucher"), (String)"saveVoucherLock");){
            if (lock.tryLock(10000L)) {
                if (!resultInvoice.containsKey((Object)"checkStatus")) {
                    resultInvoice.put("checkStatus", (Object)"1");
                }
                resultInvoice = invoiceCollectService.saveInvoice(resultInvoice, fileUrl, fileHash);
                CacheHelper.put(resultInvoice.getString("invoiceNo") + "saveVoucher", resultInvoice.toJSONString(), 10000);
            } else {
                JSONObject cacheObject = JSON.parseObject((String)CacheHelper.get(resultInvoice.getString("invoiceNo") + "saveVoucher"));
                if (cacheObject != null) {
                    resultInvoice = cacheObject;
                    CacheHelper.remove(resultInvoice.getString("invoiceNo") + "saveVoucher");
                }
            }
        }
        return resultInvoice;
    }

    public static boolean checkOrg(Object orgId) {
        boolean isVoucherOrg = false;
        try {
            DynamicObject orgObject;
            if (orgId != null && (orgObject = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bdm_org")) != null && "1".equals(orgObject.get("epinfo.isvoucher"))) {
                isVoucherOrg = true;
            }
        }
        catch (Throwable t) {
            logger.info("\u83b7\u53d6\u4f01\u4e1a\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u5f00\u5173\u51fa\u9519\uff1a{}", (Object)t);
            isVoucherOrg = false;
        }
        return isVoucherOrg;
    }

    private static String getVoucherFileUrl(String fileType, byte[] fileByte, String xbrlInfo) throws IOException {
        String fileUploadUrl;
        if ("zip".equalsIgnoreCase(fileType)) {
            fileUploadUrl = FileConvertUtils.upload((byte[])fileByte, (String)fileType);
        } else {
            try (ByteArrayInputStream xbrlStream = new ByteArrayInputStream(xbrlInfo.getBytes(StandardCharsets.UTF_8));){
                fileUploadUrl = FileConvertUtils.upload((byte[])FileUtils.getByte(xbrlStream), (String)"xml");
            }
        }
        return fileUploadUrl;
    }

    private static void uploadGet(Future<JSONObject> xbrlUploadSubmit, JSONObject resultInvoice) {
        try {
            JSONObject result = xbrlUploadSubmit.get();
            if (result != null) {
                resultInvoice.put("imageUrl", (Object)result.getString("imageUrl"));
                resultInvoice.put("ofdUrl", (Object)result.getString("ofdUrl"));
                resultInvoice.put("pdfUrl", (Object)result.getString("pdfUrl"));
                resultInvoice.put("snapshotUrl", (Object)result.getString("imageUrl"));
                resultInvoice.put("synConvert", (Object)result.getString("synConvert"));
            }
        }
        catch (Exception e) {
            logger.info("\u7535\u5b50\u4f1a\u8ba1\u51ed\u8bc1\u6587\u4ef6\u4e0a\u4f20\u51fa\u9519\uff1a{}", (Object)e);
        }
    }

    public static void saveVoucher(String serialNo, String xbrlName, String fileUploadUrl, String xbrlType) {
        DynamicObject voucherObject = QueryServiceHelper.queryOne((String)"rim_invoice_voucher", (String)"id, serial_no, xbrl_name, xbrl_url, xbrl_type, receive_xbrl_url, receive_xbrl_name, create_time, update_time", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)serialNo)});
        if (voucherObject == null) {
            voucherObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_invoice_voucher");
            voucherObject.set("serial_no", (Object)serialNo);
            voucherObject.set("xbrl_name", (Object)xbrlName);
            voucherObject.set("xbrl_url", (Object)fileUploadUrl);
            voucherObject.set("xbrl_type", (Object)xbrlType);
            voucherObject.set("receive_xbrl_url", (Object)"");
            voucherObject.set("receive_xbrl_name", (Object)"");
            voucherObject.set("create_time", (Object)new Date());
            voucherObject.set("update_time", (Object)new Date());
        } else {
            voucherObject = BusinessDataServiceHelper.loadSingle((Object)voucherObject.get("id"), (String)"rim_invoice_voucher");
            voucherObject.set("xbrl_name", (Object)xbrlName);
            voucherObject.set("xbrl_url", (Object)fileUploadUrl);
            voucherObject.set("xbrl_type", (Object)xbrlType);
            voucherObject.set("update_time", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{voucherObject});
    }
}

