/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionCheckTask;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.invoice.verify.VerifyStatisticsService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.message.constant.ErrorType;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.EInvoiceZipXmlDealService;
import kd.imc.rim.common.service.ElectAccVoucherService;
import kd.imc.rim.common.service.RecognitionCheckService;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RecognitionCheckAPIService {
    private static Log logger = LogFactory.getLog(RecognitionCheckAPIService.class);
    private static RecognitionCheckAPIService service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final RecognitionCheckAPIService getInstance() {
        Class<RecognitionCheckAPIService> clazz = RecognitionCheckAPIService.class;
        synchronized (RecognitionCheckAPIService.class) {
            if (service == null) {
                service = new RecognitionCheckAPIService();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public JSONArray execute(JSONObject data) {
        try {
            long start = System.currentTimeMillis();
            if (data == null) {
                throw new MsgException(ErrorType.EMPTY_PARAM);
            }
            RecognitionCheckParam rcParam = (RecognitionCheckParam)JSONObject.toJavaObject((JSON)data, RecognitionCheckParam.class);
            this.checkParam(rcParam);
            String fileName = this.fileName(rcParam.getFileType());
            Pair<String, byte[]> filePair = this.upFile(rcParam, fileName);
            String fileUrl = (String)filePair.getLeft();
            JSONObject businessParam = this.getBusinessParam(data);
            businessParam.put("fileByte", filePair.getRight());
            Long orgId = businessParam.getLong("org_id");
            String billType = data.getString("billType");
            String billId = data.getString("billId");
            JSONObject invoiceResult = new JSONObject();
            String fileType = rcParam.getFileType();
            List<String> isNeedDealFileTypeList = Arrays.asList("10", "4", "1");
            boolean isNeedDeal = isNeedDealFileTypeList.contains(fileType);
            if (isNeedDeal) {
                ElectAccVoucherService electAccVoucherService = new ElectAccVoucherService();
                invoiceResult = electAccVoucherService.dealVoucher(fileUrl, fileName, orgId, businessParam, null);
            }
            if (!"0000".equals(invoiceResult.getString("errcode")) && "9".equals(rcParam.getFileType())) {
                logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c(\u6570\u7535\u7968XML\u6587\u4ef6\u89e3\u6790)\uff0c\u6587\u4ef6\u5904\u7406\u8017\u65f6{}\uff0c\u6587\u4ef6{}", (Object)(System.currentTimeMillis() - start), (Object)fileUrl);
                invoiceResult = EInvoiceZipXmlDealService.analysisAndCheckSave(fileUrl, fileName, businessParam.getLong("org_id"), businessParam, null);
                logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c(\u6570\u7535\u7968XML\u6587\u4ef6\u89e3\u6790)\uff0c\u6587\u4ef6\u5904\u7406\u8017\u65f6{}\uff0c\u7ed3\u679c{}", (Object)(System.currentTimeMillis() - start), (Object)invoiceResult);
            }
            if (!"0000".equals(invoiceResult.getString("errcode"))) {
                logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff0c\u6587\u4ef6\u5904\u7406\u8017\u65f6{}\uff0c\u6587\u4ef6{}", (Object)(System.currentTimeMillis() - start), (Object)fileUrl);
                invoiceResult = RecognitionCheckService.getInstance().recognitionCheckInvoice(fileUrl, fileName, null, businessParam);
                logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff0c\u8bc6\u522b\u67e5\u9a8c\u8017\u65f6{},\u7ed3\u679c\uff1a{}", (Object)(System.currentTimeMillis() - start), (Object)invoiceResult);
            }
            JSONArray recognitionResultData = new JSONArray();
            if (ResultContant.isSuccess(invoiceResult).booleanValue()) {
                JSONArray invoiceArray = invoiceResult.getJSONArray("data");
                if (invoiceArray != null) {
                    recognitionResultData.addAll((Collection)invoiceArray);
                }
                RecognitionCheckTask.classOfInvoice(invoiceArray);
                JSONArray attachArray = invoiceResult.getJSONArray("attach");
                if (!CollectionUtils.isEmpty((Collection)recognitionResultData)) {
                    logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff0c\u8bc6\u522b\u67e5\u9a8c\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
                    boolean needUserRelation = !"0".equals(businessParam.getString("needUserRelation"));
                    JSONArray result = this.verify(orgId, billType, rcParam, recognitionResultData, billId, needUserRelation);
                    this.mixFinalInfo(result, recognitionResultData);
                    return result;
                }
                if (!CollectionUtils.isEmpty((Collection)attachArray)) {
                    JSONArray attachData = new JSONArray();
                    InvoiceSaveService saveService = InvoiceSaveService.newInstance("11");
                    for (int index = 0; index < attachArray.size(); ++index) {
                        JSONObject attach = attachArray.getJSONObject(index);
                        if (CollectionUtils.isEmpty((Map)attach)) continue;
                        JSONObject attachMap = new JSONObject();
                        attachMap.put("snapshotUrl", (Object)attach.getString("snapshot_url"));
                        attachMap.put("downloadUrl", (Object)attach.getString("attach_url"));
                        attachMap.put("fileType", (Object)attach.getString("attach_type"));
                        attachMap.put("pageNo", (Object)attach.getString("page_no"));
                        attachMap.put("totalPage", (Object)attach.getString("page_sum"));
                        attachMap.put("serialNo", (Object)attach.getString("serialNo"));
                        attachMap.put("totalAmount", (Object)BigDecimal.ZERO);
                        attachMap.put("invoiceType", (Object)"11");
                        attachMap.put("saleList", (Object)"1");
                        attachMap.put("collect_type", (Object)CollectTypeEnum.MSG_SERVICE.getCode());
                        attachMap.put("resource", (Object)"\u7b2c\u4e09\u65b9");
                        saveService.save(attachMap);
                        attachData.add((Object)attachMap);
                    }
                    logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff0c\u8bc6\u522b\u67e5\u9a8c\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
                    return attachData;
                }
                throw new MsgException("9999", ResManager.loadKDString((String)"\u8bc6\u522b\u67e5\u9a8c\u5931\u8d25", (String)"RecognitionCheckAPIService_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            throw new MsgException(invoiceResult.getString("errcode"), invoiceResult.getString("description"));
        }
        catch (MsgException e) {
            logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff1a", (Object)e);
            throw new MsgException(e.getErrorCode(), e.getErrorMsg());
        }
        catch (Exception e) {
            logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff1a", (Object)e);
            throw new MsgException("9999", String.format(ResManager.loadKDString((String)"\u8bc6\u522b\u67e5\u9a8c\u5931\u8d25\uff0c\u5185\u90e8\u7a0b\u5e8f\u51fa\u73b0\u9519\u8bef\uff1a%1$s", (String)"RecognitionCheckAPIService_10", (String)"imc-rim-common", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void mixFinalInfo(JSONArray result, JSONArray invoices) {
        if (result != null) {
            block0: for (int i = 0; i < result.size(); ++i) {
                String serialNo;
                JSONObject invoiceInfo = result.getJSONObject(i);
                String invoiceType = invoiceInfo.getString("invoiceType");
                if (InputInvoiceTypeEnum.TRAIN_REFUND.getAwsType().equals(invoiceType)) {
                    invoiceInfo.put("taxRate", (Object)"");
                }
                if (!InputInvoiceTypeEnum.needCheckAws(invoiceType).booleanValue()) {
                    invoiceInfo.remove((Object)"checkStatus");
                }
                if (StringUtils.isEmpty((CharSequence)(serialNo = invoiceInfo.getString("serialNo")))) continue;
                for (int j = 0; j < invoices.size(); ++j) {
                    JSONObject invoice = invoices.getJSONObject(j);
                    String serialNo2 = invoice.getString("serialNo");
                    if (!serialNo.equals(serialNo2)) continue;
                    invoiceInfo.put("pageNo", invoice.get((Object)"pageNo"));
                    continue block0;
                }
            }
        }
    }

    private Pair<String, byte[]> upFileOfBase64(String base64, String fileType, String fileName) {
        boolean cacheAws;
        String fileFlag = RimConfigUtils.getConfig("rim_recog_check", "filebyte");
        String url = FileUploadUtils.getInvoiceDir("invoice") + fileName;
        String fileId = MD5.SHA256Hex(fileType + base64);
        String path = this.queryFilePath(fileId, cacheAws = this.cacheAwsFile());
        if (StringUtils.isEmpty((CharSequence)path)) {
            path = FileUploadUtils.uploadBase64(url, fileName, base64, cacheAws);
            FileUtils.saveFilePath("", path, fileId, fileType);
        }
        logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff0c\u539f\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668\uff1afileName\uff1a" + fileName + ", url\uff1a" + url + ", fileId: " + fileId);
        if ("1".equals(fileFlag)) {
            byte[] decodedBytes = Base64.getDecoder().decode(base64);
            return Pair.of((Object)path, (Object)decodedBytes);
        }
        return Pair.of((Object)path, null);
    }

    private Pair<String, byte[]> upFileOfUrl(String url, String fileType, String fileName) {
        logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c,\u5916\u90e8\u4f20\u5165\u7684url:{}", (Object)url);
        if (!url.startsWith("https:") && !url.startsWith("http:")) {
            return Pair.of((Object)url, null);
        }
        String fileId = MD5.SHA256Hex(fileType + url);
        boolean cacheAws = this.cacheAwsFile();
        String path = this.queryFilePath(fileId, cacheAws);
        byte[] bytes = null;
        if (StringUtils.isEmpty((CharSequence)path)) {
            Pair<String, byte[]> pair = FileUtils.getFileContent(url);
            if (pair == null || pair.getRight() == null) {
                throw new MsgException("9999", ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (String)"RecognitionCheckAPIService_2", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff0c\u4e0b\u8f7d\u6587\u4ef6{}\u7c7b\u578b{}\u5927\u5c0f{}\uff1a", new Object[]{url, pair.getLeft(), ((byte[])pair.getRight()).length});
            String storePath = FileUploadUtils.getInvoiceDir("invoice") + fileName;
            path = FileUploadUtils.uploadBytes(storePath, fileName, (byte[])pair.getRight());
            FileUtils.saveFilePath(url, path, fileId, fileType);
            bytes = (byte[])pair.getRight();
        }
        logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff0c\u539f\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668\uff1afileName\uff1a" + fileName + ", url\uff1a" + url + ", fileId: " + fileId);
        String fileFlag = RimConfigUtils.getConfig("rim_recog_check", "filebyte");
        if ("1".equals(fileFlag)) {
            return Pair.of((Object)path, bytes);
        }
        return Pair.of((Object)path, null);
    }

    private boolean cacheAwsFile() {
        return !"0".equals(RimConfigUtils.getConfig("rim_recog_check", "query_awsfile"));
    }

    private String queryFilePath(String fileId, boolean cacheAws) {
        if (cacheAws) {
            return FileUtils.queryFilePath(fileId);
        }
        return null;
    }

    private Pair<String, byte[]> upFile(RecognitionCheckParam rcParam, String fileName) {
        if (!StringUtils.isEmpty((CharSequence)rcParam.getBase64())) {
            return this.upFileOfBase64(rcParam.getBase64(), rcParam.getFileType(), fileName);
        }
        return this.upFileOfUrl(rcParam.getFileDownUrl(), rcParam.getFileType(), fileName);
    }

    private JSONArray verify(Long orgId, String billType, RecognitionCheckParam rcParam, JSONArray recognitionCheckInvoice, String billId, boolean needUserRelation) {
        long start = System.currentTimeMillis();
        JSONArray result = new JSONArray();
        ArrayList mainIdList = Lists.newArrayListWithExpectedSize((int)recognitionCheckInvoice.size());
        ArrayList uncheckIdList = Lists.newArrayListWithExpectedSize((int)recognitionCheckInvoice.size());
        HashMap fileMap = Maps.newHashMap();
        for (int index = 0; index < recognitionCheckInvoice.size(); ++index) {
            JSONObject invoice = recognitionCheckInvoice.getJSONObject(index);
            if (fileMap.isEmpty()) {
                fileMap.put("snapshotUrl", invoice.getString("snapshotUrl"));
                fileMap.put("imageUrl", invoice.getString("imageUrl"));
                fileMap.put("ofdUrl", invoice.getString("ofdUrl"));
                fileMap.put("pdfUrl", invoice.getString("pdfUrl"));
                fileMap.put("xmlUrl", invoice.getString("xmlUrl"));
                fileMap.put("fileType", invoice.getString("fileType"));
            }
            String serialNo = invoice.getString("serialNo");
            Long mainId = invoice.getLong("mainId");
            Long uncheckId = invoice.getLong("unCheckId");
            if (StringUtils.isEmpty((CharSequence)serialNo)) {
                String invoiceType = invoice.getString("invoiceType");
                String enumType = InputInvoiceTypeEnum.getAwsType(invoiceType);
                invoice.put("invoiceType", (Object)enumType);
                JSONObject targetInvoice = recognitionCheckInvoice.getJSONObject(index);
                this.setInvoiceTag(targetInvoice);
                result.add((Object)targetInvoice);
                continue;
            }
            if (uncheckId != null) {
                uncheckIdList.add(uncheckId);
                continue;
            }
            if (mainId != null) {
                mainIdList.add(mainId);
                continue;
            }
            logger.info("uncheckId:{} ----- mainId:{} ----- recognitionCheckInvoice:{}", new Object[]{uncheckId, mainId, recognitionCheckInvoice.get(index)});
            JSONObject targetInvoice = recognitionCheckInvoice.getJSONObject(index);
            this.setInvoiceTag(targetInvoice);
            result.add((Object)targetInvoice);
        }
        logger.info("mainIdList:{} ----- uncheckIdList:{}", (Object)mainIdList, (Object)uncheckIdList);
        if (!(StringUtils.equals((CharSequence)rcParam.getVerifyFlag(), (CharSequence)"1") || CollectionUtils.isEmpty((Collection)mainIdList) && CollectionUtils.isEmpty((Collection)uncheckIdList))) {
            Map<String, Object> map = VerifyUtil.noVerify(mainIdList, uncheckIdList, null);
            result.addAll((Collection)((JSONArray)map.get("data")));
            String verifySaveFlag = RimConfigUtils.getConfig("verify_save");
            if ("0".equals(verifySaveFlag)) {
                JSONArray data = (JSONArray)map.get("data");
                for (int i = 0; i < data.size(); ++i) {
                    JSONObject invoiceInfo = data.getJSONObject(i);
                    String serialNo = invoiceInfo.getString("serialNo");
                    String invoiceType = invoiceInfo.getString("invoiceType");
                    VerifyUtil.updateInvoiceDelStatus(serialNo, InputInvoiceTypeEnum.getEntity(InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType)), needUserRelation);
                    VerifyUtil.updateInvoiceDelStatus(serialNo, "rim_invoice", needUserRelation);
                    VerifyUtil.updateInvoiceDelStatus(serialNo, "rim_invoice_uncheck", needUserRelation);
                }
            }
        } else {
            List<Object> taxList = Lists.newArrayList();
            List<Object> nameList = Lists.newArrayList();
            if (rcParam.getCompanyInfo() != null && !rcParam.getCompanyInfo().isEmpty()) {
                taxList = rcParam.getCompanyInfo().stream().map(CompanyInfo::getTaxNo).collect(Collectors.toList());
                nameList = rcParam.getCompanyInfo().stream().map(CompanyInfo::getName).collect(Collectors.toList());
            }
            HashMap param = Maps.newHashMapWithExpectedSize((int)4);
            param.put("buyer_tax_no", taxList);
            param.put("buyer_name", nameList);
            param.put("orgId", orgId);
            param.put("billType", billType);
            param.put("billId", billId);
            List<CompanyInfo> salerInfo = rcParam.getSalerInfo();
            List<Object> salerNoList = Lists.newArrayList();
            List<Object> salerNameList = Lists.newArrayList();
            if (!CollectionUtils.isEmpty(salerInfo)) {
                salerNoList = salerInfo.stream().map(CompanyInfo::getTaxNo).collect(Collectors.toList());
                salerNameList = salerInfo.stream().map(CompanyInfo::getName).collect(Collectors.toList());
            }
            param.put("saler_tax_no", salerNoList);
            param.put("saler_name", salerNameList);
            JSONArray verify = VerifyUtil.verifyByMainIds(param, mainIdList, uncheckIdList, true);
            for (int i = 0; i < verify.size(); ++i) {
                JSONObject invoiceInfo = verify.getJSONObject(i);
                String errorLevel = invoiceInfo.getString("errorLevel");
                String invoiceType = invoiceInfo.getString("invoiceType");
                String serialNo = invoiceInfo.getString("serialNo");
                VerifyUtil.updateDataStatus(errorLevel, serialNo, InputInvoiceTypeEnum.getInvoiceTypeByAwsType(invoiceType), Boolean.TRUE, needUserRelation);
            }
            VerifyStatisticsService.asyncSaveVerifyStatistics(verify, null, null);
            result.addAll((Collection)verify);
        }
        this.addErrorCode(result, fileMap);
        logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff0c\u5408\u89c4\u6027\u6821\u9a8c\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
        return result;
    }

    private void setInvoiceTag(JSONObject targetInvoice) {
        if (targetInvoice == null || targetInvoice.isEmpty()) {
            return;
        }
        Long unSaveInvoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType(targetInvoice.getString("invoiceType"));
        if (InputInvoiceTypeEnum.needCheck(unSaveInvoiceType).booleanValue()) {
            targetInvoice.put("needCheck", (Object)"1");
        } else {
            targetInvoice.put("needCheck", (Object)"0");
        }
        if (InputInvoiceTypeEnum.isElectricInvoice(unSaveInvoiceType)) {
            targetInvoice.put("isElectricInvoice", (Object)"1");
        } else {
            targetInvoice.put("isElectricInvoice", (Object)"0");
        }
    }

    private void addErrorCode(JSONArray result, Map<String, String> fileMap) {
        logger.info("openservice addErrorCode fileMap:{}", fileMap);
        List serialNos = result.toJavaList(JSONObject.class).stream().map(v -> v.getString("serialNo")).collect(Collectors.toList());
        QFilter qf = new QFilter("serial_no", "in", serialNos);
        DynamicObject[] checkResultArr = BusinessDataServiceHelper.load((String)"rim_invoice_uncheck", (String)"check_result,serial_no", (QFilter[])new QFilter[]{qf});
        Map<Object, Object> serialNoMapChechResult = Maps.newHashMap();
        if (checkResultArr != null && checkResultArr.length > 0) {
            serialNoMapChechResult = Arrays.asList(checkResultArr).stream().collect(Collectors.toMap(v -> v.getString("serial_no"), v -> v.getString("check_result")));
        }
        for (int i = 0; i < result.size(); ++i) {
            boolean flag2;
            JSONObject json = result.getJSONObject(i);
            String serialNo = json.getString("serialNo");
            String checkStatus = json.getString("checkStatus");
            String invoiceType = json.getString("invoiceType");
            if (StringUtils.isNotEmpty((CharSequence)invoiceType) && invoiceType.length() > 2) {
                invoiceType = InputInvoiceTypeEnum.getAwsType(invoiceType);
            }
            json.put("invoiceType", (Object)invoiceType);
            json.put("errorCode", (Object)"0000");
            json.put("description", (Object)ResManager.loadKDString((String)"\u6210\u529f", (String)"RecognitionCheckAPIService_3", (String)"imc-rim-common", (Object[])new Object[0]));
            if (StringUtils.isEmpty((CharSequence)serialNo)) {
                json.put("errorCode", (Object)"3006");
                json.put("description", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u5fc5\u8981\u5b57\u6bb5\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"RecognitionCheckAPIService_4", (String)"imc-rim-common", (Object[])new Object[0]));
                this.putValidateInfo(json);
            } else {
                String checkResult = (String)serialNoMapChechResult.get(serialNo);
                if (StringUtils.isNotBlank((CharSequence)checkResult) && !"1".equals(checkStatus)) {
                    int rightIndex = checkResult.indexOf(93);
                    int leftIndex = checkResult.indexOf(91);
                    String errorCode = "";
                    String description = "";
                    errorCode = checkResult.substring(leftIndex + 1, rightIndex);
                    description = checkResult.substring(rightIndex + 1);
                    json.put("errorCode", (Object)errorCode);
                    json.put("description", (Object)description);
                }
            }
            BigDecimal totalTaxAmount = json.getBigDecimal("totalTaxAmount");
            BigDecimal taxAmount = json.getBigDecimal("taxAmount");
            boolean flag = totalTaxAmount != null && totalTaxAmount.compareTo(BigDecimal.ZERO) == 0;
            boolean bl = flag2 = taxAmount != null && taxAmount.compareTo(BigDecimal.ZERO) > 0;
            if (flag && flag2) {
                json.put("totalTaxAmount", (Object)taxAmount);
            }
            if (fileMap.isEmpty()) continue;
            String fileType = fileMap.get("fileType");
            json.put("fileType", (Object)fileType);
            if ("1".equals(fileType)) {
                json.put("pdfUrl", (Object)fileMap.get("pdfUrl"));
                json.put("downloadUrl", (Object)fileMap.get("pdfUrl"));
            } else if ("4".equals(fileType)) {
                json.put("ofdUrl", (Object)fileMap.get("ofdUrl"));
                json.put("downloadUrl", (Object)fileMap.get("ofdUrl"));
            } else if ("9".equals(fileType)) {
                json.put("xmlUrl", (Object)fileMap.get("xmlUrl"));
                json.put("downloadUrl", (Object)fileMap.get("xmlUrl"));
            } else if ("2".equals(fileType)) {
                json.put("downloadUrl", (Object)fileMap.get("imageUrl"));
            }
            json.put("fileType", (Object)fileMap.get("fileType"));
        }
    }

    private void putValidateInfo(JSONObject json) {
        String awsType = json.getString("invoiceType");
        this.checkValidate(json, "totalAmount", "totalTaxAmount");
        if (InputInvoiceTypeEnum.TAXI_INVOICE.getAwsType().equals(awsType)) {
            this.checkValidate(json, "price");
        } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getAwsType().equals(awsType)) {
            this.checkValidate(json, "taxRate");
        } else if (InputInvoiceTypeEnum.GENERAL_PAPER.getAwsType().equals(awsType) || InputInvoiceTypeEnum.ROAD_BRIDGE.getAwsType().equals(awsType)) {
            this.checkValidate(json, "invoiceAmount");
        } else if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.getAwsType().equals(awsType) || InputInvoiceTypeEnum.TRAIN_REFUND.getAwsType().equals(awsType) || InputInvoiceTypeEnum.BOAT_INVOICE.getAwsType().equals(awsType)) {
            this.checkValidate(json, "taxRate");
        } else if (InputInvoiceTypeEnum.AIR_INVOICE.getAwsType().equals(awsType)) {
            this.checkValidate(json, "taxRate", "invoiceAmount");
        }
    }

    private void checkValidate(JSONObject json, String ... validateKey) {
        for (String key : validateKey) {
            if ("taxRate".equals(key) && !InputInvoiceTypeEnum.TRAIN_REFUND.getAwsType().equals(json.getString("invoiceType"))) {
                if (InputInvoiceTypeEnum.AIR_INVOICE.getAwsType().equals(json.getString("invoiceType")) || InputInvoiceTypeEnum.TRAIN_INVOICE.getAwsType().equals(json.getString("invoiceType"))) {
                    json.put(key, (Object)"0.09");
                    continue;
                }
                if (!InputInvoiceTypeEnum.TRANSPORT_INVOICE.getAwsType().equals(json.getString("invoiceType")) && !InputInvoiceTypeEnum.BOAT_INVOICE.getAwsType().equals(json.getString("invoiceType"))) continue;
                json.put(key, (Object)"0.03");
                continue;
            }
            json.putIfAbsent((Object)key, (Object)"");
        }
    }

    private String fileName(String fileType) {
        String fileName = String.valueOf(UUID.randomUUID());
        if (StringUtils.equals((CharSequence)fileType, (CharSequence)"1")) {
            fileName = fileName + ".pdf";
        } else if (StringUtils.equals((CharSequence)fileType, (CharSequence)"2")) {
            fileName = fileName + ".png";
        } else if (StringUtils.equals((CharSequence)fileType, (CharSequence)"4")) {
            fileName = fileName + ".ofd";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fileType, (CharSequence)"pdf")) {
            fileName = fileName + ".pdf";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fileType, (CharSequence)"ofd")) {
            fileName = fileName + ".ofd";
        } else if (FileUtils.isImage(fileType)) {
            fileName = fileName + ".jpg";
        } else if (StringUtils.equals((CharSequence)fileType, (CharSequence)"9")) {
            fileName = fileName + ".xml";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fileType, (CharSequence)"xml")) {
            fileName = fileName + ".xml";
        }
        return fileName;
    }

    private void checkParam(RecognitionCheckParam rcParam) {
        if (StringUtils.isBlank((CharSequence)rcParam.getBase64()) && StringUtils.isEmpty((CharSequence)rcParam.getFileDownUrl())) {
            throw new MsgException("0001", ResManager.loadKDString((String)"\u6587\u4ef6\u4fe1\u606f\u4e3a\u7a7a", (String)"RecognitionCheckAPIService_5", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)rcParam.getFileType())) {
            throw new MsgException("0001", ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u578b\u4e3a\u7a7a", (String)"RecognitionCheckAPIService_6", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (!Arrays.asList("1", "2", "4", "9", "10", "pdf", "ofd", "png", "bmp", "jpg", "jpeg", "webp").contains(rcParam.getFileType())) {
            throw new MsgException("0001", ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u5728\u6709\u6548\u8303\u56f4\u5185", (String)"RecognitionCheckAPIService_7", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)rcParam.getVerifyFlag(), (CharSequence)"1")) {
            if (StringUtils.isBlank((CharSequence)rcParam.getBillType())) {
                throw new MsgException("0001", ResManager.loadKDString((String)"\u5982\u9700\u8fd4\u56de\u5408\u89c4\u6027\u6821\u9a8c\u7ed3\u679c\uff0c\u8bf7\u586b\u5199\u5355\u636e\u7c7b\u578b", (String)"RecognitionCheckAPIService_8", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            DynamicObject expenseType = BusinessDataServiceHelper.loadSingle((String)"rim_expense_type", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)rcParam.getBillType())});
            if (expenseType == null) {
                throw new MsgException("0001", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u672a\u5f55\u5165", (String)"RecognitionCheckAPIService_9", (String)"imc-rim-common", (Object[])new Object[0]));
            }
        }
    }

    private JSONObject getBusinessParam(JSONObject param) {
        boolean isCollectOwner;
        boolean isAutoSign;
        String state;
        Long orgId;
        JSONObject businessParam = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)param.getString("taxNo"))) {
            businessParam.put("taxNo", (Object)param.getString("taxNo"));
        }
        if ((orgId = param.getLong("orgId")) == null || orgId == 0L) {
            orgId = TenantUtils.getOrgByNumberOrTaxNo(param.getString("orgNumber"), param.getString("taxNo"));
        }
        if (orgId > 0L) {
            businessParam.put("org_id", (Object)orgId);
        } else {
            businessParam.put("org_id", (Object)RequestContext.get().getOrgId());
            businessParam.put("replaceorg", (Object)"1");
        }
        if (StringUtils.isNotBlank((CharSequence)param.getString("collect_type"))) {
            businessParam.put("collect_type", (Object)param.getString("collect_type"));
        } else {
            businessParam.put("collect_type", (Object)CollectTypeEnum.MSG_SERVICE.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getString("resource"))) {
            businessParam.put("resource", (Object)param.getString("resource"));
        } else {
            businessParam.put("resource", (Object)"\u7b2c\u4e09\u65b9");
        }
        businessParam.put("isAdmin", (Object)Boolean.TRUE);
        if ("1".equals(param.getString("notCheck"))) {
            businessParam.put("notCheck", (Object)"1");
        }
        if ("1".equals(state = RimConfigUtils.getConfig("original_state"))) {
            businessParam.put("originalState", (Object)"1");
        }
        if (isAutoSign = SysParamUtil.getSysParamByOrgId(orgId, "is_autosign")) {
            boolean isHit = SysParamUtil.isHitValue(orgId, "autosign_config", "3");
            if (isHit) {
                businessParam.put("originalState", (Object)"1");
                businessParam.put("autoSignExpenseStatus", SysParamUtil.getParamValue(orgId, "autosign_expstatus"));
            } else {
                businessParam.remove((Object)"originalState");
            }
        }
        if (isCollectOwner = SysParamUtil.getSysParamByOrgId(orgId, "is_collectowner")) {
            boolean isHit = SysParamUtil.isHitValue(orgId, "collectowner_config", "2");
            if (!isHit) {
                businessParam.put("needUserRelation", (Object)"0");
            }
        } else {
            businessParam.put("needUserRelation", (Object)"0");
        }
        businessParam.put("needSaveInvoice", (Object)"0");
        businessParam.put("throwSaveError", (Object)"1");
        logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff0c\u8bc6\u522b\u67e5\u9a8c\u4e1a\u52a1\u6807\u8bc6\uff1a" + businessParam);
        return businessParam;
    }

    public static class CompanyInfo {
        private String taxNo;
        private String name;

        public String getTaxNo() {
            return this.taxNo;
        }

        public void setTaxNo(String taxNo) {
            this.taxNo = taxNo;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class RecognitionCheckParam {
        private String base64;
        private String fileDownUrl;
        private String fileType;
        private String verifyFlag;
        private String billType;
        private List<CompanyInfo> companyInfo;
        private List<CompanyInfo> salerInfo;

        public String getBase64() {
            return this.base64;
        }

        public void setBase64(String base64) {
            this.base64 = base64;
        }

        public String getFileType() {
            return this.fileType;
        }

        public void setFileType(String fileType) {
            this.fileType = fileType;
        }

        public String getVerifyFlag() {
            return this.verifyFlag;
        }

        public void setVerifyFlag(String verifyFlag) {
            this.verifyFlag = verifyFlag;
        }

        public String getBillType() {
            return this.billType;
        }

        public void setBillType(String billType) {
            this.billType = billType;
        }

        public List<CompanyInfo> getCompanyInfo() {
            return this.companyInfo;
        }

        public List<CompanyInfo> getSalerInfo() {
            return this.salerInfo;
        }

        public void setSalerInfo(List<CompanyInfo> salerInfo) {
            this.salerInfo = salerInfo;
        }

        public void setCompanyInfo(List<CompanyInfo> companyInfo) {
            this.companyInfo = companyInfo;
        }

        public String getFileDownUrl() {
            return this.fileDownUrl;
        }

        public void setFileDownUrl(String fileDownUrl) {
            this.fileDownUrl = fileDownUrl;
        }
    }
}

