/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DES3Util;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.Sha256HMACUtil;
import kd.imc.rim.common.utils.UUID;

public class AisinoService {
    private static Log LOGGER = LogFactory.getLog(AisinoService.class);
    private String baseUrl;
    private String proxy;
    private boolean unitTest = false;
    private String msgType;
    private int connectTimeout = 20000;
    private int socketTimeout = 60000;
    private static final String LOGIN_PATH = "/login";
    private static final String INVOICE_PATH = "/invoice/";
    private static final String TOKEN_CACHE = "rim_aisino_token:";
    private static final int CACHE_TIME_OUT = 82800;
    private static final String SIGN_TYPE = "HMacSHA256";
    private static final String ZIP_CODE = "0";
    private static final String ENCRYPT_CODE = "1";

    private AisinoService(String baseUrl, String proxy, int connectTimeoutSecond, int socketTimeoutSecond) {
        this.baseUrl = baseUrl;
        this.proxy = proxy;
        this.connectTimeout = connectTimeoutSecond * 1000;
        this.socketTimeout = socketTimeoutSecond * 1000;
        this.unitTest = RimConfigUtils.isUnitTest();
    }

    public static AisinoService newInstance() {
        int socketSec;
        Map<String, String> map = ImcConfigUtil.getValue("rim_deduction");
        String url = map.get("aisino_url");
        String proxy = map.get("aisino_proxy");
        int conSec = BigDecimalUtil.transDecimal(map.get("connect")).intValue();
        if (conSec < 1) {
            conSec = 20;
        }
        if ((socketSec = BigDecimalUtil.transDecimal(map.get("socket")).intValue()) < 1) {
            socketSec = 60;
        }
        return new AisinoService(url, proxy, conSec, socketSec);
    }

    public JSONObject postAppJson(String interfaceCode, Long orgId, String taxNo, Map<String, Object> body) {
        String url = null;
        this.msgType = interfaceCode;
        JSONObject result = new JSONObject();
        try {
            long startTime = System.currentTimeMillis();
            JSONObject configResult = this.getAisinoConfig(orgId);
            if (configResult == null) {
                LOGGER.error("\u5f53\u524d\u7ec4\u7ec7\u672a\u914d\u7f6e\u822a\u4fe1\u63a5\u53e3\u53c2\u6570\uff0c\u8bf7\u5148\u914d\u7f6e\u822a\u4fe1\u63a5\u53e3\u53c2\u6570");
                return ResultContant.createJSONObject("0001", ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u914d\u7f6e\u822a\u4fe1\u63a5\u53e3\u53c2\u6570\uff0c\u8bf7\u5148\u914d\u7f6e\u822a\u4fe1\u63a5\u53e3\u53c2\u6570", (String)"AisinoService_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            String username = configResult.getString("username");
            String secret = configResult.getString("secret");
            String des_key = configResult.getString("des_key");
            String encrypt_key = configResult.getString("encrypt_key");
            String token = this.getAccessToken(username, secret);
            url = this.baseUrl + INVOICE_PATH + interfaceCode;
            String qqlsh = UUID.getBatchNoForAisino(taxNo);
            String checkStr = JSONObject.toJSONString(body);
            byte[] encodeByte = DES3Util.des3EncodeECB(des_key.getBytes(StandardCharsets.UTF_8), checkStr.getBytes(StandardCharsets.UTF_8));
            String content = Base64.getEncoder().encodeToString(encodeByte);
            String message = interfaceCode + ZIP_CODE + ENCRYPT_CODE + username + token + taxNo + SIGN_TYPE + qqlsh + content;
            String signature = this.getSignature(message, encrypt_key);
            JSONObject param = new JSONObject();
            param.put("interfaceCode", (Object)interfaceCode);
            param.put("zipCode", (Object)ZIP_CODE);
            param.put("encryptCode", (Object)ENCRYPT_CODE);
            param.put("userName", (Object)username);
            param.put("access_token", (Object)token);
            param.put("taxpayerId", (Object)taxNo);
            param.put("signtype", (Object)SIGN_TYPE);
            param.put("signature", (Object)signature);
            param.put("qqlsh", (Object)qqlsh);
            param.put("content", (Object)content);
            LOGGER.info("\u8bf7\u6c42\u822a\u4fe1\u539f\u59cb\u53c2\u6570:{} body:{}", (Object)url, body);
            JSONObject aisinoResult = this.postAppJson(url, JSONObject.toJSONString((Object)param));
            aisinoResult = this.convertResult(aisinoResult, des_key);
            return aisinoResult;
        }
        catch (MsgException e) {
            result.put("errcode", (Object)e.getErrorCode());
            result.put("description", (Object)String.format(ResManager.loadKDString((String)"\u67e5\u9a8c\u63a5\u53e3\u5931\u8d25-%1$s", (String)"AisinoService_1", (String)"imc-rim-common", (Object[])new Object[0]), e.getErrorMsg()));
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u822a\u4fe1error:" + url, (Throwable)e);
            result.put("errcode", (Object)"1132");
            result.put("description", (Object)ResManager.loadKDString((String)"\u8c03\u7528\u67e5\u9a8c\u63a5\u53e3\u670d\u52a1\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"AisinoService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        return result;
    }

    public JSONObject postAppJson(String url, String body) throws IOException {
        String testResult = this.getUnitTestResult();
        if (!StringUtils.isEmpty((CharSequence)testResult)) {
            return JSONObject.parseObject((String)testResult);
        }
        String str = HttpUtil.doPostJson(url, this.proxy, null, body, this.connectTimeout, this.socketTimeout);
        try {
            return JSONObject.parseObject((String)str);
        }
        catch (Exception e) {
            LOGGER.error("postAppJson-Exception:" + str, (Throwable)e);
            return null;
        }
    }

    public String getAccessToken(String username, String secret) throws IOException {
        String key = TOKEN_CACHE + username;
        long startTime = System.currentTimeMillis();
        String token = CacheHelper.get(key);
        LOGGER.info("\u83b7\u53d6\u7f13\u5b58\u7684\u822a\u4fe1token\uff1a{},\u8017\u65f6\uff1a{}", (Object)token, (Object)(System.currentTimeMillis() - startTime));
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            return token;
        }
        JSONObject param = new JSONObject();
        String url = this.baseUrl + LOGIN_PATH;
        String timestamp = DateUtils.format(new Date(), "yyyyMMddHHmmss");
        String sign = this.getSignature(username + timestamp + SIGN_TYPE, secret);
        param.put("username", (Object)username);
        param.put("timestamp", (Object)timestamp);
        param.put("signtype", (Object)SIGN_TYPE);
        param.put("signature", (Object)sign);
        long startTime2 = System.currentTimeMillis();
        JSONObject resultObj = this.postAppJson(url, param.toJSONString());
        LOGGER.info("\u83b7\u53d6\u63a5\u53e3\u7684\u822a\u4fe1token\uff1a{},\u8017\u65f6\uff1a{}", (Object)resultObj, (Object)(System.currentTimeMillis() - startTime2));
        if ("0000".equals(resultObj.get((Object)"code"))) {
            token = resultObj.getString("access_token");
            CacheHelper.put(key, token, 82800);
            return token;
        }
        LOGGER.info("\u8bf7\u6c42\u822a\u4fe1token\u5931\u8d25:" + resultObj);
        throw new MsgException(resultObj.getString("code"), resultObj.getString("msg"));
    }

    private JSONObject convertResult(JSONObject result, String desKey) throws Exception {
        if (result == null) {
            return null;
        }
        JSONObject resultJson = new JSONObject();
        resultJson.put("errcode", (Object)result.getString("code"));
        resultJson.put("description", (Object)result.getString("msg"));
        resultJson.put("interfaceCode", (Object)result.getString("interfaceCode"));
        resultJson.put("qqlsh", (Object)result.getString("qqlsh"));
        resultJson.put("taxpayerId", (Object)result.getString("taxpayerId"));
        String zipCode = result.getString("zipCode");
        resultJson.put("zipCode", (Object)zipCode);
        String content = result.getString("content");
        JSONObject data = null;
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            String encoded = "";
            encoded = ENCRYPT_CODE.equals(zipCode) ? DES3Util.ees3DecodeECBzip(desKey, content) : DES3Util.ees3DecodeECB(desKey, content);
            data = JSONObject.parseObject((String)encoded);
        }
        resultJson.put("data", data);
        if ("3502".equals(resultJson.getString("errcode"))) {
            resultJson.put("description", (Object)String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:%s\u672a\u83b7\u5f97\u822a\u4fe1\u6388\u6743", (String)"AisinoService_3", (String)"imc-rim-common", (Object[])new Object[0]), result.getString("taxpayerId")));
        }
        LOGGER.info("\u8bf7\u6c42\u822a\u4fe1\u8fd4\u56de\u7ed3\u679c(\u8f6c\u6362\u540e):" + resultJson);
        return resultJson;
    }

    public JSONObject getAisinoConfig(Long orgId) {
        Map<String, String> configMap = ImcConfigUtil.getValue("rim_deduction");
        if (configMap != null) {
            String username = configMap.get("aisino_username");
            String secret = configMap.get("aisino_secret");
            String encrypt_key = configMap.get("aisino_encrypt_key");
            String des_key = configMap.get("aisino_3des_key");
            String tax_no = configMap.get("aisino_tax_no");
            if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)secret)) {
                JSONObject result = new JSONObject();
                result.put("username", (Object)username);
                result.put("secret", (Object)secret);
                result.put("encrypt_key", (Object)encrypt_key);
                result.put("des_key", (Object)des_key);
                result.put("tax_no", (Object)tax_no);
                return result;
            }
        }
        return null;
    }

    public String getProxy() {
        return this.proxy;
    }

    private String getSignature(String message, String secret) {
        return Sha256HMACUtil.sha256HMAC(message, secret).toUpperCase();
    }

    private String getUnitTestResult() {
        if (this.unitTest && !StringUtils.isEmpty((CharSequence)this.msgType)) {
            return CacheHelper.get("Aision-" + this.msgType);
        }
        return null;
    }
}

