/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import org.apache.commons.collections.CollectionUtils;

public class AllEleAuthUtil {
    private static Log LOGGER = LogFactory.getLog(AllEleAuthUtil.class);
    private static final String ACCOUNT_CACHE = "rim_aws_fpy_account:";
    private static final String BDM_EINVOICE = "bdm_einvoice_account";
    private static final String BDM_FIELDS = "taxno,cityname,entryentity.isdefault,entryentity.accounttype,entryentity.isenable,entryentity.defaultbusiness,entryentity.account";

    public static String getAllEaccount(String taxNo) {
        String cacheKey = ACCOUNT_CACHE + taxNo;
        String account = CacheHelper.get(cacheKey);
        if (StringUtils.isNotEmpty((CharSequence)account)) {
            return taxNo;
        }
        JSONObject accountAndCity = AllEleAuthUtil.getAllEaccountAndCity(taxNo);
        if (accountAndCity != null) {
            return accountAndCity.getString("account");
        }
        return "";
    }

    public static JSONObject getAllEaccountAndCity(String taxNo) {
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            return null;
        }
        QFilter qFilter = new QFilter("taxno", "=", (Object)taxNo);
        DynamicObject accountObj = BusinessDataServiceHelper.loadSingleFromCache((String)BDM_EINVOICE, (String)BDM_FIELDS, (QFilter[])qFilter.toArray());
        if (accountObj == null) {
            return null;
        }
        DynamicObjectCollection items = accountObj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)items)) {
            return null;
        }
        JSONObject account = null;
        for (DynamicObject item : items) {
            if (!AllEleAuthUtil.isInputAccount(item)) continue;
            account = new JSONObject();
            account.put("taxNo", (Object)accountObj.getString("taxno"));
            account.put("city", (Object)accountObj.getString("cityname"));
            account.put("account", (Object)item.getString("account"));
            break;
        }
        LOGGER.info("\u83b7\u53d6\u5168\u7535\u8d26\u53f7\u7ed3\u679c:{},{}", (Object)taxNo, account);
        return account;
    }

    public static List<JSONObject> getInputAccounts(List<String> taxNos) {
        ArrayList<JSONObject> accounts = new ArrayList<JSONObject>(8);
        if (CollectionUtils.isEmpty(taxNos)) {
            return accounts;
        }
        QFilter qFilter = new QFilter("taxno", "in", taxNos);
        Object[] accountObjs = BusinessDataServiceHelper.load((String)BDM_EINVOICE, (String)BDM_FIELDS, (QFilter[])qFilter.toArray());
        if (ObjectUtils.isEmpty((Object[])accountObjs)) {
            return accounts;
        }
        block0: for (Object accountObj : accountObjs) {
            DynamicObjectCollection items = accountObj.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)items)) continue;
            for (DynamicObject item : items) {
                if (!AllEleAuthUtil.isInputAccount(item)) continue;
                JSONObject json = new JSONObject();
                json.put("taxNo", (Object)accountObj.getString("taxno"));
                json.put("city", (Object)accountObj.getString("cityname"));
                json.put("account", (Object)item.getString("account"));
                accounts.add(json);
                continue block0;
            }
        }
        return accounts;
    }

    private static boolean isInputAccount(DynamicObject item) {
        if (item == null || StringUtils.isEmpty((CharSequence)item.getString("account"))) {
            return false;
        }
        String isEnable = item.getString("isenable");
        String isDefault = item.getString("isdefault");
        String defaultBusiness = item.getString("defaultbusiness");
        String accountType = item.getString("accounttype");
        if ("1".equals(isEnable) && "1".equals(isDefault)) {
            boolean inputBusiness = "2".equals(defaultBusiness) || "3".equals(defaultBusiness);
            boolean inputAuth = "2".equals(accountType) || "3".equals(accountType);
            return inputBusiness && inputAuth;
        }
        return false;
    }

    public static String getTaxCity(String taxNo) {
        if (StringUtils.isBlank((CharSequence)taxNo)) {
            return "";
        }
        QFilter filter = new QFilter("number", "=", (Object)taxNo);
        DynamicObject baseinfo = QueryServiceHelper.queryOne((String)"bdm_enterprise_baseinfo", (String)"id,tax_city", (QFilter[])new QFilter[]{filter});
        if (baseinfo == null) {
            return "";
        }
        long taxCityId = DynamicObjectUtil.getDynamicObjectLongValue(baseinfo.get("tax_city"));
        if (taxCityId <= 0L) {
            return "";
        }
        QFilter idFilter = new QFilter("id", "=", (Object)taxCityId);
        DynamicObject cityInfo = QueryServiceHelper.queryOne((String)"bdm_tax_city_info", (String)"id,number,status", (QFilter[])new QFilter[]{idFilter});
        if (cityInfo == null) {
            return "";
        }
        return cityInfo.getString("number");
    }
}

