/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.AwsFpyConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.helper.ApiLogHelper;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.AesUtil;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.UUID;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.codec.binary.Base64;

public class AwsFpyService {
    private static Log LOGGER = LogFactory.getLog(AwsFpyService.class);
    private String baseUrl;
    private String proxy;
    private boolean unitTest = false;
    private String msgType;
    private static String TOKEN_CACHE = "rim_aws_fpy_token:";
    private static String TENANT_TOKEN_CACHE = "rim_tenant_fpy_aws_token:";
    private static String ACCOUNT_CACHE = "rim_aws_fpy_account:";
    private static String TENANT_EN_KEY_CACHE = "rim_tenant_en_key:";
    private static String ENCRYPT_KEY_CACHE = "rim_encrypt_key:";
    private static int CACHE_TIME_OUT = 600;
    private static int TENANT_CACHE_TIME_OUT = 86400;
    private static String config_type = "dim_imc_config_fpy";
    private JSONObject globalConfig;

    private AwsFpyService(String configType) {
        String url;
        Map<String, String> map;
        if (StringUtils.isEmpty((CharSequence)configType)) {
            configType = config_type;
        }
        if (((map = ImcConfigUtil.getValue(configType)).isEmpty() || StringUtils.isEmpty((CharSequence)AwsFpyService.getValue(map, "url", configType + "_url"))) && !config_type.equals(configType)) {
            map = ImcConfigUtil.getValue(config_type);
            configType = config_type;
        }
        if (StringUtils.isEmpty((CharSequence)(url = AwsFpyService.getValue(map, "url", configType + "_url")))) {
            url = "https://api-dev.piaozone.com/test";
        }
        String proxy = AwsFpyService.getValue(map, "proxy", configType + "_proxy");
        this.baseUrl = url;
        this.proxy = proxy;
        String clientId = AwsFpyService.getValue(map, "clientid", configType + "_clientid");
        String clientSecret = AwsFpyService.getValue(map, "clientsecret", configType + "_clientsecret");
        String encryptKey = AwsFpyService.getValue(map, "encryptkey", configType + "_encryptkey");
        String type = AwsFpyService.getValue(map, "type", configType + "_type");
        String unittest = AwsFpyService.getValue(map, "unittest", configType + "_unittest");
        JSONObject result = new JSONObject();
        result.put("client_id", (Object)StringUtils.trim((String)clientId));
        result.put("client_secret", (Object)StringUtils.trim((String)clientSecret));
        result.put("encrypt_key", (Object)StringUtils.trim((String)encryptKey));
        result.put("type", (Object)type);
        result.put("baseUrl", (Object)url);
        result.put("proxy", (Object)proxy);
        this.globalConfig = result;
        this.unitTest = "1".equals(unittest);
    }

    public static AwsFpyService newInstance(String type) {
        return new AwsFpyService(type);
    }

    @SdkDeprecated
    public static AwsFpyService newInstance() {
        return new AwsFpyService(config_type);
    }

    public JSONObject postAppJson(String msgType, Long orgId, Map<String, Object> body, Map<String, Object> params) {
        if (body != null) {
            body.put("traceId", RequestContext.get().getTraceId());
            body.put("tenantId", RequestContext.get().getTenantId());
        }
        return this.postAppJson(msgType, orgId, JSONObject.toJSONString(body), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject postAppJson(String msgType, Long orgId, String body, Map<String, Object> params) {
        JSONObject jSONObject;
        long startTime;
        JSONObject result;
        String url;
        block13: {
            JSONObject param;
            this.msgType = msgType;
            url = null;
            result = null;
            startTime = System.currentTimeMillis();
            String testResult = null;
            if (this.unitTest) {
                param = new HashMap(2);
                param.put("body", body);
                testResult = CommonUtils.getUnitTestResult("Aws-", msgType);
            }
            if (StringUtils.isEmpty(testResult)) break block13;
            param = JSONObject.parseObject(testResult);
            if (StringUtils.isEmpty((CharSequence)url)) {
                url = this.baseUrl;
            }
            ApiLogHelper.asyncSaveLog(msgType, url, body, JSONObject.toJSONString((Object)result), startTime, msgType);
            return param;
        }
        try {
            String token = this.getAccessToken(orgId);
            url = this.getUrl(msgType, token);
            if (!CollectionUtils.isEmpty(params)) {
                StringBuilder builder = new StringBuilder(url);
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    builder.append('&').append(entry.getKey()).append('=').append(entry.getValue());
                }
                url = builder.toString();
            }
            jSONObject = result = this.postAppJson(url, body);
        }
        catch (Exception e) {
            JSONObject jSONObject2;
            try {
                LOGGER.info("\u8bf7\u6c42\u53d1\u7968\u4e91error:{}-{}", url, (Object)e);
                result = new JSONObject();
                result.put("errcode", (Object)"1132");
                result.put("description", (Object)ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u670d\u52a1\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"AwsFpyService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                if (e instanceof MsgException) {
                    result.put("errcode", (Object)((MsgException)e).getErrorCode());
                    result.put("description", (Object)((MsgException)e).getErrorMsg());
                }
                jSONObject2 = result;
            }
            catch (Throwable throwable) {
                if (StringUtils.isEmpty(url)) {
                    url = this.baseUrl;
                }
                ApiLogHelper.asyncSaveLog(msgType, url, body, JSONObject.toJSONString(result), startTime, msgType);
                throw throwable;
            }
            if (StringUtils.isEmpty((CharSequence)url)) {
                url = this.baseUrl;
            }
            ApiLogHelper.asyncSaveLog(msgType, url, body, JSONObject.toJSONString((Object)result), startTime, msgType);
            return jSONObject2;
        }
        if (StringUtils.isEmpty((CharSequence)url)) {
            url = this.baseUrl;
        }
        ApiLogHelper.asyncSaveLog(msgType, url, body, JSONObject.toJSONString((Object)result), startTime, msgType);
        return jSONObject;
    }

    public JSONObject postAppJson(String msgType, Long orgId, Map<String, Object> body) {
        return this.postAppJson(msgType, orgId, body, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject postEncryptAppJson(String msgType, Long orgId, Map<String, Object> body) {
        JSONObject jSONObject;
        long startTime;
        JSONObject result;
        String url;
        block11: {
            JSONObject param;
            this.msgType = msgType;
            url = null;
            result = null;
            startTime = System.currentTimeMillis();
            String testResult = null;
            if (this.unitTest) {
                param = new HashMap(2);
                param.put("body", body);
                testResult = CommonUtils.getUnitTestResult("Aws-", msgType, (Map<String, Object>)param);
            }
            if (StringUtils.isEmpty(testResult)) break block11;
            param = JSONObject.parseObject(testResult);
            if (StringUtils.isEmpty((CharSequence)url)) {
                url = this.baseUrl;
            }
            ApiLogHelper.asyncSaveLog(msgType, url, JSONObject.toJSONString(body), JSONObject.toJSONString((Object)result), startTime, msgType);
            return param;
        }
        try {
            String token = this.getAccessToken(orgId);
            url = this.getUrl(msgType, token);
            body.put("traceId", RequestContext.get().getTraceId());
            body.put("tenantId", RequestContext.get().getTenantId());
            String conent = this.encryptByToken(JSONObject.toJSONString(body), token);
            jSONObject = result = this.postAppJson(url, conent);
        }
        catch (Exception e) {
            JSONObject jSONObject2;
            try {
                LOGGER.info("\u8bf7\u6c42\u53d1\u7968\u4e91error:{}-{}", url, (Object)e);
                result = new JSONObject();
                result.put("errcode", (Object)"1132");
                result.put("description", (Object)ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u670d\u52a1\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"AwsFpyService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                if (e instanceof MsgException) {
                    result.put("errcode", (Object)((MsgException)e).getErrorCode());
                    result.put("description", (Object)((MsgException)e).getErrorMsg());
                }
                jSONObject2 = result;
            }
            catch (Throwable throwable) {
                if (StringUtils.isEmpty(url)) {
                    url = this.baseUrl;
                }
                ApiLogHelper.asyncSaveLog(msgType, url, JSONObject.toJSONString(body), JSONObject.toJSONString(result), startTime, msgType);
                throw throwable;
            }
            if (StringUtils.isEmpty((CharSequence)url)) {
                url = this.baseUrl;
            }
            ApiLogHelper.asyncSaveLog(msgType, url, JSONObject.toJSONString(body), JSONObject.toJSONString((Object)result), startTime, msgType);
            return jSONObject2;
        }
        if (StringUtils.isEmpty((CharSequence)url)) {
            url = this.baseUrl;
        }
        ApiLogHelper.asyncSaveLog(msgType, url, JSONObject.toJSONString(body), JSONObject.toJSONString((Object)result), startTime, msgType);
        return jSONObject;
    }

    public JSONObject postCheckInvoice(String msgType, CheckParam checkParam) {
        String url = null;
        Map<String, Object> extMap = checkParam.getExtMap();
        try {
            String token = this.getAccessToken(Long.parseLong(extMap.get("orgId") + ""));
            url = this.getUrl(msgType, token);
            JSONObject checkParamJson = JSONObject.parseObject((String)checkParam.toString());
            checkParamJson.put("traceId", (Object)RequestContext.get().getTraceId());
            checkParamJson.put("tenantId", (Object)RequestContext.get().getTenantId());
            return this.postAppJson(url, checkParamJson.toJSONString());
        }
        catch (Exception e) {
            LOGGER.info("\u8bf7\u6c42\u53d1\u7968\u4e91error:{}-{}", url, (Object)e);
            JSONObject result = new JSONObject();
            result.put("errcode", (Object)"1132");
            result.put("description", (Object)ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u670d\u52a1\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"AwsFpyService_0", (String)"imc-rim-common", (Object[])new Object[0]));
            if (e instanceof MsgException) {
                result.put("errcode", (Object)((MsgException)e).getErrorCode());
                result.put("description", (Object)((MsgException)e).getErrorMsg());
            }
            return result;
        }
    }

    public JSONObject postAppJsonByTenant(String msgType, Long orgId, Map<String, Object> body, String taxNo) {
        return this.postAppJsonByTenant(msgType, orgId, body, null, taxNo, false);
    }

    public JSONObject postAppJsonByTenant(String msgType, Long orgId, Map<String, Object> body, Map<String, Object> params, String taxNo) {
        return this.postAppJsonByTenant(msgType, orgId, body, params, taxNo, false);
    }

    public JSONObject postAppJsonByTenantNew(String msgType, Long orgId, Map<String, Object> body, Map<String, Object> params, String taxNo, boolean isEncrypt) {
        if (body != null) {
            body.put("traceId", RequestContext.get().getTraceId());
            body.put("tenantId", RequestContext.get().getTenantId());
        }
        return this.postAppJsonByTenantNew(msgType, orgId, JSONObject.toJSONString(body), params, taxNo, isEncrypt);
    }

    public JSONObject postAppJsonByTenant(String msgType, Long orgId, Map<String, Object> body, Map<String, Object> params, String taxNo, boolean isEncrypt) {
        if (body != null) {
            body.put("traceId", RequestContext.get().getTraceId());
            body.put("tenantId", RequestContext.get().getTenantId());
        }
        return this.postAppJsonByTenant(msgType, orgId, JSONObject.toJSONString(body), params, taxNo, isEncrypt);
    }

    public JSONObject getTenantAccessToken(Long orgId) throws IOException {
        String token = this.getAccessToken(orgId);
        JSONObject config = this.getAwsConfig(orgId);
        String encryptkey = config.getString("encrypt_key");
        LOGGER.info("encryptkey\uff1a {}", (Object)encryptkey);
        String url = this.getUrl("MSG_GET_TENANT", token);
        JSONObject param = new JSONObject();
        param.put("ts", (Object)System.currentTimeMillis());
        JSONObject resultObj = this.postAppJson(url, param.toJSONString());
        if ("0000".equals(resultObj.get((Object)"errcode"))) {
            String data = resultObj.getString("data");
            String result = null;
            try {
                result = AesUtil.decryptECB(data, encryptkey);
            }
            catch (Exception e) {
                LOGGER.info("\u8bf7\u6c42\u53d1\u7968\u4e91token\u5931\u8d25, \u89e3\u5bc6\u5931\u8d25:" + resultObj);
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), e.getMessage());
            }
            return JSONObject.parseObject((String)result);
        }
        LOGGER.info("\u8bf7\u6c42\u53d1\u7968\u4e91token\u5931\u8d25:" + resultObj);
        throw new MsgException(resultObj.getString("errcode"), resultObj.getString("description"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject postAppJsonByTenantNew(String msgType, Long orgId, String body, Map<String, Object> params, String taxNo, boolean isEncrypt) {
        JSONObject jSONObject;
        String bodyString;
        long startTime;
        JSONObject result;
        String url;
        block16: {
            JSONObject param;
            this.msgType = msgType;
            url = null;
            result = null;
            startTime = System.currentTimeMillis();
            bodyString = body;
            String testResult = null;
            if (this.unitTest) {
                param = new HashMap(2);
                param.put("body", body);
                param.put("taxNo", taxNo);
                testResult = CommonUtils.getUnitTestResult("Aws-", msgType);
            }
            if (StringUtils.isEmpty(testResult)) break block16;
            param = JSONObject.parseObject(testResult);
            if (StringUtils.isEmpty((CharSequence)url)) {
                url = this.baseUrl;
            }
            ApiLogHelper.asyncSaveLog(msgType, url, bodyString, JSONObject.toJSONString((Object)result), startTime, msgType);
            return param;
        }
        try {
            JSONObject tokenResult = this.getTenantAccessToken(orgId);
            url = this.getUrl(msgType, tokenResult.getString("access_token"));
            String entryKey = tokenResult.getString("tenantEncKey");
            if (!CollectionUtils.isEmpty(params)) {
                StringBuilder builder = new StringBuilder(url);
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    builder.append('&').append(entry.getKey()).append('=').append(entry.getValue());
                }
                url = builder.toString();
            }
            if (isEncrypt) {
                body = this.encrypt(body, entryKey);
            }
            LOGGER.info("\u8bf7\u6c42\u53d1\u7968\u4e91:" + url + " param:" + bodyString);
            jSONObject = result = this.postAppJson(url, body);
        }
        catch (Exception e) {
            JSONObject jSONObject2;
            try {
                LOGGER.info("\u8bf7\u6c42\u53d1\u7968\u4e91error:{}-{}", url, (Object)e);
                result = new JSONObject();
                result.put("errcode", (Object)"1132");
                result.put("description", (Object)ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u670d\u52a1\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"AwsFpyService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                if (e instanceof MsgException) {
                    result.put("errcode", (Object)((MsgException)e).getErrorCode());
                    result.put("description", (Object)((MsgException)e).getErrorMsg());
                } else if (e instanceof KDException) {
                    KDException kdException = (KDException)e;
                    result.put("errcode", (Object)kdException.getErrorCode().getCode());
                    result.put("description", (Object)kdException.getErrorCode().getMessage());
                }
                jSONObject2 = result;
            }
            catch (Throwable throwable) {
                if (StringUtils.isEmpty(url)) {
                    url = this.baseUrl;
                }
                ApiLogHelper.asyncSaveLog(msgType, url, bodyString, JSONObject.toJSONString(result), startTime, msgType);
                throw throwable;
            }
            if (StringUtils.isEmpty((CharSequence)url)) {
                url = this.baseUrl;
            }
            ApiLogHelper.asyncSaveLog(msgType, url, bodyString, JSONObject.toJSONString((Object)result), startTime, msgType);
            return jSONObject2;
        }
        if (StringUtils.isEmpty((CharSequence)url)) {
            url = this.baseUrl;
        }
        ApiLogHelper.asyncSaveLog(msgType, url, bodyString, JSONObject.toJSONString((Object)result), startTime, msgType);
        return jSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject postAppJsonByTenant(String msgType, Long orgId, String body, Map<String, Object> params, String taxNo, boolean isEncrypt) {
        JSONObject param;
        String token;
        String bodyString;
        long startTime;
        JSONObject result;
        String url;
        block17: {
            this.msgType = msgType;
            url = null;
            result = null;
            startTime = System.currentTimeMillis();
            bodyString = body;
            token = "";
            String testResult = null;
            if (this.unitTest) {
                param = new HashMap(2);
                param.put("body", body);
                param.put("taxNo", taxNo);
                testResult = CommonUtils.getUnitTestResult("Aws-", msgType);
            }
            if (StringUtils.isEmpty(testResult)) break block17;
            param = JSONObject.parseObject(testResult);
            if (StringUtils.isEmpty((CharSequence)url)) {
                url = this.baseUrl;
            }
            this.removeTenantToken(taxNo, token, result);
            ApiLogHelper.asyncSaveLog(msgType, url, bodyString, JSONObject.toJSONString((Object)result), startTime, msgType);
            return param;
        }
        try {
            token = this.getTenantAccessToken(taxNo);
            url = this.getUrl(msgType, token);
            if (!CollectionUtils.isEmpty(params)) {
                StringBuilder builder = new StringBuilder(url);
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    builder.append('&').append(entry.getKey()).append('=').append(entry.getValue());
                }
                url = builder.toString();
            }
            if (isEncrypt) {
                body = this.encryptByTenantToken(body, token);
            }
            if ((result = this.postAppJson(url, body)) != null) {
                param = JSONObject.parseObject((String)bodyString);
                result.put("account", (Object)param.getString("account"));
            }
            param = result;
        }
        catch (Exception e) {
            JSONObject jSONObject;
            try {
                LOGGER.info("\u8bf7\u6c42\u53d1\u7968\u4e91error:{}-{}", url, (Object)e);
                result = new JSONObject();
                result.put("errcode", (Object)"1132");
                result.put("description", (Object)ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u670d\u52a1\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"AwsFpyService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                if (e instanceof MsgException) {
                    result.put("errcode", (Object)((MsgException)e).getErrorCode());
                    result.put("description", (Object)((MsgException)e).getErrorMsg());
                } else if (e instanceof KDException) {
                    KDException kdException = (KDException)e;
                    result.put("errcode", (Object)kdException.getErrorCode().getCode());
                    result.put("description", (Object)kdException.getErrorCode().getMessage());
                }
                jSONObject = result;
            }
            catch (Throwable throwable) {
                if (StringUtils.isEmpty(url)) {
                    url = this.baseUrl;
                }
                this.removeTenantToken(taxNo, token, result);
                ApiLogHelper.asyncSaveLog(msgType, url, bodyString, JSONObject.toJSONString((Object)result), startTime, msgType);
                throw throwable;
            }
            if (StringUtils.isEmpty((CharSequence)url)) {
                url = this.baseUrl;
            }
            this.removeTenantToken(taxNo, token, result);
            ApiLogHelper.asyncSaveLog(msgType, url, bodyString, JSONObject.toJSONString((Object)result), startTime, msgType);
            return jSONObject;
        }
        if (StringUtils.isEmpty((CharSequence)url)) {
            url = this.baseUrl;
        }
        this.removeTenantToken(taxNo, token, result);
        ApiLogHelper.asyncSaveLog(msgType, url, bodyString, JSONObject.toJSONString((Object)result), startTime, msgType);
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject allEPostAppJson(Long orgId, String taxNo, JSONObject body) {
        JSONObject jSONObject;
        String allEaccount;
        JSONObject result;
        String token;
        String requestPath;
        String requestString;
        long startTime;
        String url;
        block20: {
            block19: {
                url = null;
                startTime = System.currentTimeMillis();
                requestString = null;
                requestPath = "";
                token = "";
                result = null;
                requestPath = body.getString("request_path");
                if (!this.unitTest) break block19;
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("taxNo", taxNo);
                param.put("body", (String)body);
                String testResult = CommonUtils.getUnitTestResult("Aws-", requestPath);
                if (StringUtils.isEmpty((CharSequence)testResult)) break block19;
                JSONObject jSONObject2 = JSONObject.parseObject((String)testResult);
                if (StringUtils.isEmpty((CharSequence)url)) {
                    url = this.baseUrl;
                }
                this.removeTenantToken(taxNo, token, result);
                ApiLogHelper.asyncSaveLog(requestPath, url, requestString, JSONObject.toJSONString((Object)result), startTime);
                return jSONObject2;
            }
            token = this.getTenantAccessToken(taxNo);
            StringBuilder urlBuilder = new StringBuilder();
            String reqid = UUID.getReqid();
            urlBuilder.append(this.baseUrl).append("/bill-websocket/v2/invoicewebsocket/push").append('?').append("access_token=").append(token).append("&fpdk_type=4").append('&').append("operationType=").append("2").append('&').append("reqid=").append(reqid).append('&').append("taxNo=").append(taxNo);
            String nameConfig = ImcConfigUtil.getValue("websocket_config_name", taxNo);
            if (StringUtils.isNotEmpty((CharSequence)nameConfig)) {
                urlBuilder.append('&').append("name=").append(nameConfig);
            }
            body.put("traceId", (Object)RequestContext.get().getTraceId());
            body.put("tenantId", (Object)RequestContext.get().getTenantId());
            body.put("reqid", (Object)reqid);
            url = urlBuilder.toString();
            allEaccount = this.getAllEaccount(taxNo);
            if (!StringUtils.isEmpty((CharSequence)allEaccount)) break block20;
            JSONObject jSONObject3 = ResultContant.createJSONObject(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7:[%s]\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u8fdb\u884c\u76f8\u5173\u914d\u7f6e", (String)"AwsFpyService_1", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
            if (StringUtils.isEmpty((CharSequence)url)) {
                url = this.baseUrl;
            }
            this.removeTenantToken(taxNo, token, result);
            ApiLogHelper.asyncSaveLog(requestPath, url, requestString, JSONObject.toJSONString((Object)result), startTime);
            return jSONObject3;
        }
        try {
            String[] values;
            body.put("account", (Object)allEaccount);
            JSONObject param = new JSONObject();
            param.put("requestId", (Object)body.getString("requestId"));
            param.put("data", (Object)body);
            requestString = JSONObject.toJSONString((Object)param);
            String encryptData = this.encryptByTenantToken(body.toJSONString(), token);
            param.put("data", (Object)encryptData);
            String timeoutconfig = RimConfigUtils.getConfig("rim_rpa", "timeout");
            int connectTimeout = 0;
            int socketTimeout = 0;
            if (StringUtils.isNotEmpty((CharSequence)timeoutconfig) && (values = timeoutconfig.trim().split(",")).length >= 2) {
                connectTimeout = BigDecimalUtil.transDecimal(values[0]).intValue();
                socketTimeout = BigDecimalUtil.transDecimal(values[1]).intValue();
            }
            if (connectTimeout < 1) {
                connectTimeout = 20000;
            }
            if (socketTimeout < 1) {
                socketTimeout = 60000;
            }
            if ((result = this.postAppJson(url, JSONObject.toJSONString((Object)param), connectTimeout, socketTimeout)) != null) {
                result.put("account", (Object)allEaccount);
            }
            jSONObject = result;
        }
        catch (Exception e) {
            JSONObject jSONObject4;
            try {
                LOGGER.info("\u8bf7\u6c42\u53d1\u7968\u4e91-\u5168\u7535error:{}-{}", (Object)CommonUtils.getUrlLog(url), (Object)e);
                result = new JSONObject();
                result.put("errcode", (Object)"1132");
                result.put("description", (Object)ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u670d\u52a1\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"AwsFpyService_0", (String)"imc-rim-common", (Object[])new Object[0]));
                if (e instanceof MsgException) {
                    result.put("errcode", (Object)((MsgException)e).getErrorCode());
                    result.put("description", (Object)((MsgException)e).getErrorMsg());
                } else if (e instanceof KDException) {
                    KDException kdException = (KDException)e;
                    result.put("errcode", (Object)kdException.getErrorCode().getCode());
                    result.put("description", (Object)kdException.getErrorCode().getMessage());
                }
                jSONObject4 = result;
            }
            catch (Throwable throwable) {
                if (StringUtils.isEmpty(url)) {
                    url = this.baseUrl;
                }
                this.removeTenantToken(taxNo, token, result);
                ApiLogHelper.asyncSaveLog(requestPath, url, requestString, JSONObject.toJSONString((Object)result), startTime);
                throw throwable;
            }
            if (StringUtils.isEmpty((CharSequence)url)) {
                url = this.baseUrl;
            }
            this.removeTenantToken(taxNo, token, result);
            ApiLogHelper.asyncSaveLog(requestPath, url, requestString, JSONObject.toJSONString((Object)result), startTime);
            return jSONObject4;
        }
        if (StringUtils.isEmpty((CharSequence)url)) {
            url = this.baseUrl;
        }
        this.removeTenantToken(taxNo, token, result);
        ApiLogHelper.asyncSaveLog(requestPath, url, requestString, JSONObject.toJSONString((Object)result), startTime);
        return jSONObject;
    }

    public String getAllEaccount(String taxNo) {
        String cacheKey = ACCOUNT_CACHE + taxNo;
        String account = CacheHelper.get(cacheKey);
        if (StringUtils.isNotEmpty((CharSequence)account)) {
            return account;
        }
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        try {
            account = (String)DispatchServiceHelper.invokeBizService((String)"imc", (String)"bdm", (String)"AllEInvoiceInputHelper", (String)"getInputEleAccount", (Object[])new Object[]{param});
        }
        catch (Exception e) {
            LOGGER.info("\u83b7\u53d6\u5168\u7535\u8d26\u53f7\u5931\u8d25:{}", (Object)e);
        }
        return account;
    }

    public JSONObject postAppJson(String url, String body, int connectTime, int readTime) throws IOException {
        String testResult = null;
        if (this.unitTest) {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("body", body);
            param.put("url", url);
            testResult = CommonUtils.getUnitTestResult("Aws-", this.msgType, param);
        }
        if (!StringUtils.isEmpty(testResult)) {
            return JSONObject.parseObject(testResult);
        }
        String str = HttpUtil.doPostJson(url, this.proxy, null, body, connectTime, readTime);
        try {
            return JSONObject.parseObject((String)str);
        }
        catch (Exception e) {
            LOGGER.info("postAppJson-Exception:{}-{}", (Object)str, (Object)e);
            return null;
        }
    }

    public JSONObject postAppJson(String url, String body) throws IOException {
        return this.postAppJson(url, body, 20000, 60000);
    }

    public JSONObject getAppJson(String url) throws IOException {
        String str = HttpUtil.doGet(url, this.proxy);
        try {
            return JSONObject.parseObject((String)str);
        }
        catch (Exception e) {
            LOGGER.info("getAppJson-Exception:{}-{}", (Object)str, (Object)e);
            return null;
        }
    }

    public String getAccessToken(Long orgId) throws IOException {
        String key = TOKEN_CACHE + orgId;
        String token = CacheHelper.get(key);
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            return token;
        }
        JSONObject configResult = this.getAwsConfig(orgId);
        if (configResult == null) {
            LOGGER.info("\u5f53\u524d\u7ec4\u7ec7\u672a\u914d\u7f6e\u53d1\u7968\u4e91\u63a5\u53e3\u53c2\u6570\uff0c\u8bf7\u5148\u914d\u7f6e\u53d1\u7968\u4e91\u63a5\u53e3\u53c2\u6570");
            throw new MsgException("0001", ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u914d\u7f6e\u53d1\u7968\u4e91\u63a5\u53e3\u53c2\u6570\uff0c\u8bf7\u5148\u914d\u7f6e\u53d1\u7968\u4e91\u63a5\u53e3\u53c2\u6570", (String)"AwsFpyService_2", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        String clientId = configResult.getString("client_id");
        String clientSecret = configResult.getString("client_secret");
        String encrypt_key = configResult.getString("encrypt_key");
        String access_token = this.getAccessToken(clientId, clientSecret);
        if (StringUtils.isNotEmpty((CharSequence)access_token)) {
            CacheHelper.put(key, access_token, CACHE_TIME_OUT);
            CacheHelper.put(ENCRYPT_KEY_CACHE + access_token, encrypt_key, CACHE_TIME_OUT);
        }
        return access_token;
    }

    public void removeTenantToken(String taxNo, String token, JSONObject result) {
        if (result != null && "1300".equals(result.getString("errcode")) && StringUtils.contains((CharSequence)result.getString("description"), (CharSequence)"TOKEN")) {
            if (StringUtils.isNotBlank((CharSequence)token)) {
                CacheHelper.remove(TENANT_EN_KEY_CACHE + token);
            }
            if (StringUtils.isBlank((CharSequence)taxNo)) {
                return;
            }
            QFilter qFilter = new QFilter("taxno", "=", (Object)taxNo);
            DynamicObject config = QueryServiceHelper.queryOne((String)"bdm_einvoice_account", (String)"clientid", (QFilter[])qFilter.toArray());
            if (config != null) {
                CacheHelper.remove(TENANT_TOKEN_CACHE + config.getString("clientid"));
            }
        }
    }

    public String getTenantAccessToken(String taxNo) throws IOException {
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        String config = (String)DispatchServiceHelper.invokeBizService((String)"imc", (String)"bdm", (String)"AllEInvoiceInputHelper", (String)"getAwsTenantConfig", (Object[])new Object[]{param});
        if (StringUtils.isEmpty((CharSequence)config)) {
            throw new MsgException(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7a0e\u53f7%s\u7684aws\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u53d1\u7968\u4e91\u300b\u57fa\u7840\u8d44\u6599\u300b\u4f01\u4e1a\u7ba1\u7406\u300b\u6570\u7535\u914d\u7f6e\u5217\u8868\uff0c\u8fdb\u884c\u5347\u7ea7\u6570\u7535\u53d1\u7968", (String)"AwsFpyService_3", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        JSONObject configJson = JSONObject.parseObject((String)config);
        if (configJson == null) {
            throw new MsgException(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7a0e\u53f7%s\u7684aws\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u53d1\u7968\u4e91\u300b\u57fa\u7840\u8d44\u6599\u300b\u4f01\u4e1a\u7ba1\u7406\u300b\u6570\u7535\u914d\u7f6e\u5217\u8868\uff0c\u8fdb\u884c\u5347\u7ea7\u6570\u7535\u53d1\u7968", (String)"AwsFpyService_3", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        if (!ResultContant.isSuccess(configJson).booleanValue() || configJson.get((Object)"data") == null) {
            throw new MsgException(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7a0e\u53f7%s\u7684aws\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u53d1\u7968\u4e91\u300b\u57fa\u7840\u8d44\u6599\u300b\u4f01\u4e1a\u7ba1\u7406\u300b\u6570\u7535\u914d\u7f6e\u5217\u8868\uff0c\u8fdb\u884c\u5347\u7ea7\u6570\u7535\u53d1\u7968", (String)"AwsFpyService_3", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        JSONObject data = configJson.getJSONObject("data");
        String clientId = data.getString("clientId");
        if (StringUtils.isEmpty((CharSequence)clientId)) {
            throw new MsgException(ErrorType.NEED_LOGIN.getCode(), String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7a0e\u53f7%s\u7684aws\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u53d1\u7968\u4e91\u300b\u57fa\u7840\u8d44\u6599\u300b\u4f01\u4e1a\u7ba1\u7406\u300b\u6570\u7535\u914d\u7f6e\u5217\u8868\uff0c\u8fdb\u884c\u5347\u7ea7\u6570\u7535\u53d1\u7968", (String)"AwsFpyService_3", (String)"imc-rim-common", (Object[])new Object[0]), taxNo));
        }
        String token = CacheHelper.get(TENANT_TOKEN_CACHE + clientId);
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            return token;
        }
        String clientSecret = data.getString("clientSecret");
        String encrypt_key = data.getString("encryptKey");
        String access_token = this.getAccessToken(clientId, clientSecret);
        if (StringUtils.isNotEmpty((CharSequence)access_token)) {
            CacheHelper.put(TENANT_TOKEN_CACHE + clientId, access_token, TENANT_CACHE_TIME_OUT);
            CacheHelper.put(TENANT_EN_KEY_CACHE + access_token, encrypt_key, TENANT_CACHE_TIME_OUT);
        }
        return access_token;
    }

    public String getAccessToken(String clientId, String clientSecret) throws IOException {
        JSONObject param = new JSONObject();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = MD5.md5Hex(clientId + clientSecret + timestamp);
        String url = this.baseUrl + "/base/oauth/token";
        param.put("client_id", (Object)clientId);
        param.put("sign", (Object)sign);
        param.put("timestamp", (Object)timestamp);
        JSONObject resultObj = this.postAppJson(url, param.toJSONString());
        if ("0000".equals(resultObj.get((Object)"errcode"))) {
            return resultObj.getString("access_token");
        }
        LOGGER.info("\u8bf7\u6c42\u53d1\u7968\u4e91token\u5931\u8d25:" + resultObj);
        throw new MsgException(resultObj.getString("errcode"), resultObj.getString("description"));
    }

    public JSONObject getAwsConfig(Long orgId) {
        boolean enable;
        QFilter enableQFilter;
        DynamicObject configResult;
        JSONObject globalConfig = this.getGlobalConfig();
        if (globalConfig != null && "1".equals(globalConfig.get((Object)"type"))) {
            return globalConfig;
        }
        QFilter filter = null;
        if (orgId != null) {
            filter = new QFilter("org", "=", (Object)orgId);
        }
        if ((configResult = QueryServiceHelper.queryOne((String)"er_bd_kdinvoicecloudcfg", (String)"taxregnum,firmname,client_id,client_secret,encrypt_key", (QFilter[])new QFilter[]{filter, enableQFilter = new QFilter("enable", "=", (Object)(enable = true))})) != null) {
            JSONObject result = new JSONObject();
            result.put("client_id", (Object)StringUtils.trim((String)configResult.getString("client_id")));
            result.put("client_secret", (Object)StringUtils.trim((String)configResult.getString("client_secret")));
            result.put("encrypt_key", (Object)StringUtils.trim((String)configResult.getString("encrypt_key")));
            return result;
        }
        return globalConfig;
    }

    public JSONObject getGlobalConfig() {
        return this.globalConfig;
    }

    public String getUrl(String type, String token) {
        this.msgType = type;
        String eventType = AwsFpyConstant.getEventType(type);
        if (StringUtils.isNotEmpty((CharSequence)eventType)) {
            return this.baseUrl + "/m3/bill/firmament/img/handle" + "?access_token=" + token + "&eventType=" + eventType;
        }
        String path = AwsFpyConstant.getUrl(type);
        if (StringUtils.contains((CharSequence)path, (CharSequence)"?")) {
            return this.baseUrl + path + "&access_token=" + token;
        }
        return this.baseUrl + path + "?access_token=" + token;
    }

    public String getUrl(String type) {
        return this.baseUrl + AwsFpyConstant.getUrl(type);
    }

    public String encryptByTenantToken(String content, String token) {
        String encryptkey = CacheHelper.get(TENANT_EN_KEY_CACHE + token) + "";
        return this.encryptContentByToken(content, encryptkey);
    }

    public String encryptByToken(String content, String token) {
        String encryptkey = CacheHelper.get(ENCRYPT_KEY_CACHE + token) + "";
        return this.encryptContentByToken(content, encryptkey);
    }

    private String encryptContentByToken(String content, String encryptkey) {
        if (encryptkey.length() != 16) {
            LOGGER.info("\u53d1\u7968\u4e91\u8bf7\u6c42\u53c2\u6570\u52a0\u5bc6\u9519\u8bef\uff1a" + encryptkey);
            return "";
        }
        return AesUtil.encryptECB(content, encryptkey);
    }

    public String encrypt(String content, String encryptkey) {
        return this.encryptContentByToken(content, encryptkey);
    }

    public String decryptData(String content, String encryptkey) {
        if (encryptkey.length() != 16) {
            LOGGER.info("\u6570\u636e\u89e3\u5bc6\u9519\u8bef\uff1a" + encryptkey);
            return "";
        }
        try {
            byte[] raw = encryptkey.getBytes(StandardCharsets.UTF_8.name());
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            char[] cs2 = new char[]{'E', 'C', 'B', '/', 'P', 'K', 'C', 'S', '5', 'P', 'a', 'd', 'd', 'i', 'n', 'g'};
            Cipher cipher = Cipher.getInstance("AES/" + String.valueOf(cs2));
            cipher.init(2, skeySpec);
            byte[] encrypted = cipher.doFinal(new Base64().decode(content));
            return new String(encrypted);
        }
        catch (Exception e) {
            LOGGER.info("\u6570\u636e\u89e3\u5bc6\u5931\u8d25\u5931\u8d25{}", (Object)e);
            throw new MsgException(e, ResManager.loadKDString((String)"\u6570\u636e\u89e3\u5bc6\u5931\u8d25", (String)"AwsFpyService_5", (String)"imc-rim-common", (Object[])new Object[0]));
        }
    }

    @SdkDeprecated
    public String getProxy() {
        return this.proxy;
    }

    public static String getValue(Map<String, String> map, String ... keys) {
        for (String key : keys) {
            String value = map.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

