/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CurrencyUtils {
    private static final Map<Long, Integer> precisionMap = new HashMap<Long, Integer>();
    public static final Long FpzsMainService_100_id;

    public static Integer getAmtPrecision(Long currencyId) {
        if (currencyId == null) {
            return 2;
        }
        Integer precision = precisionMap.get(currencyId);
        if (precision == null) {
            QFilter qFilter = new QFilter("id", "=", (Object)currencyId);
            DynamicObject bdCurrency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,amtprecision", (QFilter[])qFilter.toArray());
            int amtprecision = 2;
            if (bdCurrency != null) {
                amtprecision = bdCurrency.getInt("amtprecision");
            }
            precisionMap.put(currencyId, amtprecision);
            return amtprecision;
        }
        return precision;
    }

    private static Map<Long, Integer> getAllCurrencyPrecision() {
        DynamicObjectCollection bdCurrency = QueryServiceHelper.query((String)"bd_currency", (String)"id,amtprecision", null);
        Map<Long, Integer> collect = bdCurrency.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getInt("amtprecision"), (a, b) -> a));
        return collect;
    }

    private static Long getCNYId() {
        QFilter qFilter = new QFilter("number", "=", (Object)"CNY").or("number", "=", (Object)"cny");
        qFilter.and("issystem", "=", (Object)"1");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id", (QFilter[])qFilter.toArray());
        if (dynamicObject != null) {
            return dynamicObject.getLong("id");
        }
        return 0L;
    }

    public static String getFormatByPrecision(int precision) {
        switch (precision) {
            case 0: {
                return "##0";
            }
            case 1: {
                return "##0.0";
            }
            case 3: {
                return "##0.000";
            }
            case 4: {
                return "##0.0000";
            }
        }
        return "##0.00";
    }

    public static String getDeliFormatByPrecision(int precision) {
        switch (precision) {
            case 0: {
                return "###,##0";
            }
            case 1: {
                return "###,##0.0";
            }
            case 3: {
                return "###,##0.000";
            }
            case 4: {
                return "###,##0.0000";
            }
        }
        return "###,##0.00";
    }

    public static void modifyScaleDynamically(AbstractFormPlugin plugin, String field, int precision) {
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("sc", precision);
        HashMap<String, HashMap<String, Integer>> fieldMap = new HashMap<String, HashMap<String, Integer>>();
        fieldMap.put("item", param);
        plugin.getView().updateControlMetadata(field, fieldMap);
    }

    static {
        precisionMap.putAll(CurrencyUtils.getAllCurrencyPrecision());
        precisionMap.put(0L, 2);
        FpzsMainService_100_id = CurrencyUtils.getCNYId();
    }
}

