/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.HttpUtil;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.UUID;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class FileUtils {
    private static Log logger = LogFactory.getLog(FileUtils.class);
    public static final String FILE_TYPE_PDF = "pdf";
    public static final String FILE_TYPE_OFD = "ofd";
    public static final String FILE_TYPE_JPG = "jpg";
    public static final String FILE_TYPE_XML = "xml";
    private static final String USER_DIR = "user.dir";
    private static final String FILE_TEMP = "fileTemp";
    public static final String BASE_UPLOAD_ABS_PATH = System.getProperty("user.dir") + File.separator + "fileTemp" + File.separator;

    public static boolean isImage(String fileType) {
        return "png".equalsIgnoreCase(fileType) || "bmp".equalsIgnoreCase(fileType) || FILE_TYPE_JPG.equalsIgnoreCase(fileType) || "jpeg".equalsIgnoreCase(fileType) || "webp".equalsIgnoreCase(fileType);
    }

    public static boolean isAllowPreviewFileType(String fileType) {
        return FileUtils.isImage(fileType) || FILE_TYPE_PDF.equalsIgnoreCase(fileType) || FILE_TYPE_OFD.equalsIgnoreCase(fileType) || "txt".equalsIgnoreCase(fileType) || "pptx".equalsIgnoreCase(fileType) || "ppt".equalsIgnoreCase(fileType) || "doc".equalsIgnoreCase(fileType) || "docx".equalsIgnoreCase(fileType) || "xls".equalsIgnoreCase(fileType) || "xlsx".equalsIgnoreCase(fileType) || "2".equalsIgnoreCase(fileType) || "1".equalsIgnoreCase(fileType) || "4".equalsIgnoreCase(fileType) || "7".equalsIgnoreCase(fileType) || "6".equalsIgnoreCase(fileType) || "8".equalsIgnoreCase(fileType) || "5".equalsIgnoreCase(fileType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSHA256(InputStream file) {
        try {
            int length;
            MessageDigest MD52 = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[8192];
            while ((length = file.read(buffer)) != -1) {
                MD52.update(buffer, 0, length);
            }
            String string = new String(Hex.encodeHex((byte[])MD52.digest()));
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String downLoadAndUpload(String fileUrl) {
        return FileUtils.downLoadAndUpload(fileUrl, null);
    }

    public static InputStream getInputStreamByGet(String url) throws ClientProtocolException, IOException {
        return FileUtils.getInputStreamByGet(url, 60000, 60000);
    }

    private static InputStream getInputStreamByGet(String url, int connectionTimeout, int readTimeout) throws ClientProtocolException, IOException {
        String proxy = HttpUtil.getProxy(url, null);
        CloseableHttpClient httpclient = HttpUtil.getConnection(proxy, false, connectionTimeout, readTimeout);
        HttpGet httpGet = HttpUtil.getHttpGet(HttpUtil.replaceUrl(url));
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
        return response.getEntity().getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downLoadAndUploadTemp(String fileUrl, String fileName) {
        String tempSavePath = "";
        if (StringUtils.isEmpty((String)fileUrl) || fileUrl.indexOf("http") != 0) {
            return fileUrl;
        }
        AwsFpyService service = AwsFpyService.newInstance();
        CloseableHttpClient client = HttpUtil.getConnection(service.getProxy(), false);
        HttpGet get = HttpUtil.getHttpGet(HttpUtil.replaceUrl(fileUrl));
        CloseableHttpResponse response = null;
        try {
            long start = System.currentTimeMillis();
            response = (CloseableHttpResponse)client.execute((HttpUriRequest)get);
            int statusCode = response.getStatusLine().getStatusCode();
            if (200 == statusCode) {
                String fileType = "";
                fileType = FileUtils.getSuffixFromDisposition(response);
                if (StringUtils.isEmpty((String)fileType)) {
                    fileType = FileUtils.getSuffixFromContentType(response);
                }
                HttpEntity entity = response.getEntity();
                if (StringUtils.isEmpty((String)fileName)) {
                    fileName = UUID.randomUUIDZero() + '.' + fileType;
                } else if (fileName.indexOf(46) < 0) {
                    fileName = fileName + '.' + fileType;
                }
                tempSavePath = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, entity.getContent(), 5000);
            } else {
                if (302 == statusCode) {
                    Header header = response.getFirstHeader("location");
                    String newUrl = header.getValue();
                    logger.info("\u91cd\u5b9a\u5411:" + newUrl);
                    String string = FileUtils.downLoadAndUpload(newUrl, fileName);
                    return string;
                }
                logger.error(String.format("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25[%s]%s", statusCode, fileUrl));
            }
            logger.info(String.format("\u4e0b\u8f7d\u6587\u4ef6\u8017\u65f6[%s]%s", System.currentTimeMillis() - start, fileUrl));
        }
        catch (IOException e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + fileUrl, (Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            try {
                get.abort();
                get.releaseConnection();
            }
            catch (Exception exception) {}
        }
        return tempSavePath;
    }

    public static String downLoadAndUpload(String fileUrl, String fileName) {
        return (String)FileUtils.downLoadAndUpload(fileUrl, fileName, true, false);
    }

    public static JSONObject downLoadAndUploadWithFileType(String fileUrl, String fileName) {
        return (JSONObject)FileUtils.downLoadAndUpload(fileUrl, fileName, true, true);
    }

    public static String downLoadAndUpload(String fileUrl, String fileName, boolean proxy) {
        return (String)FileUtils.downLoadAndUpload(fileUrl, fileName, proxy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object downLoadAndUpload(String fileUrl, String fileName, boolean proxy, boolean needFileType) {
        String tempSavePath = "";
        String urlFileType = "";
        if (StringUtils.isEmpty((String)fileUrl) || fileUrl.indexOf("http") != 0) {
            if (needFileType) {
                JSONObject result = new JSONObject();
                result.put("file_url", (Object)fileUrl);
                return result;
            }
            return fileUrl;
        }
        String fileId = FileUtils.getFileId(fileUrl);
        if (needFileType) {
            JSONObject pathAndType = FileUtils.queryFilePathAndType(fileId);
            if (pathAndType != null) {
                return pathAndType;
            }
        } else {
            String path = FileUtils.queryFilePath(fileId);
            if (!StringUtils.isEmpty((String)path)) {
                return path;
            }
        }
        CloseableHttpClient client = null;
        AwsFpyService service = AwsFpyService.newInstance();
        client = proxy ? HttpUtil.getConnection(service.getProxy(), false) : HttpUtil.getConnection(null, false);
        HttpGet get = HttpUtil.getHttpGet(HttpUtil.replaceUrl(fileUrl));
        CloseableHttpResponse response1 = null;
        CloseableHttpResponse response302 = null;
        try {
            urlFileType = FileUtils.getFileType(fileUrl);
            if (!StringUtils.isEmpty((String)urlFileType) && !"do".equals(urlFileType)) {
                fileName = UUID.randomUUIDZero() + '.' + urlFileType;
            }
            long start = System.currentTimeMillis();
            response1 = (CloseableHttpResponse)client.execute((HttpUriRequest)get);
            int statusCode1 = response1.getStatusLine().getStatusCode();
            if (200 == statusCode1) {
                Pair<String, String> pair = FileUtils.dealResponse(response1, fileName, fileUrl);
                tempSavePath = (String)pair.getLeft();
                if (StringUtils.isNotEmpty((String)((String)pair.getRight()))) {
                    urlFileType = (String)pair.getRight();
                }
            } else if (302 == statusCode1) {
                HttpGet newget;
                int statusCode2;
                Header header = response1.getFirstHeader("location");
                String newUrl = header.getValue();
                logger.info("\u91cd\u5b9a\u5411:" + newUrl);
                if (StringUtils.isEmpty((String)fileName) && !StringUtils.isEmpty((String)(urlFileType = FileUtils.getFileType(newUrl)))) {
                    fileName = UUID.randomUUIDZero() + '.' + urlFileType;
                }
                if (200 == (statusCode2 = (response302 = (CloseableHttpResponse)client.execute((HttpUriRequest)(newget = HttpUtil.getHttpGet(HttpUtil.replaceUrl(newUrl))))).getStatusLine().getStatusCode())) {
                    Pair<String, String> pair = FileUtils.dealResponse(response302, fileName, newUrl);
                    tempSavePath = (String)pair.getLeft();
                    if (StringUtils.isNotEmpty((String)((String)pair.getRight()))) {
                        urlFileType = (String)pair.getRight();
                    }
                } else {
                    logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25302[{}]{}", (Object)statusCode2, (Object)newUrl);
                }
            } else {
                logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25[{}]{}", (Object)statusCode1, (Object)fileUrl);
            }
            logger.info("\u4e0b\u8f7d\u6587\u4ef6\u8017\u65f6[{}]{}", (Object)(System.currentTimeMillis() - start), (Object)fileUrl);
        }
        catch (IOException e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + fileUrl, (Throwable)e);
        }
        finally {
            if (response1 != null) {
                try {
                    response1.close();
                }
                catch (IOException e) {}
            }
            if (response302 != null) {
                try {
                    response302.close();
                }
                catch (IOException e) {}
            }
            try {
                get.abort();
                get.releaseConnection();
            }
            catch (Exception e) {}
        }
        if (!StringUtils.isEmpty((String)tempSavePath)) {
            FileUtils.saveFilePath(fileUrl, tempSavePath, fileId, urlFileType);
        }
        if (needFileType) {
            JSONObject result = new JSONObject();
            result.put("file_url", (Object)tempSavePath);
            result.put("file_type", (Object)urlFileType);
            return result;
        }
        return tempSavePath;
    }

    public static Pair<String, byte[]> downLoadFileToByte(String fileUrl, String fileName) {
        return FileUtils.downLoadFileToByte(fileUrl, fileName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<String, byte[]> downLoadFileToByte(String fileUrl, String fileName, boolean proxy) {
        logger.info("downLoadFileToByte,fileUrl:{}, fileName:{}", (Object)fileUrl, (Object)fileName);
        if (StringUtils.isEmpty((String)fileUrl) || fileUrl.indexOf("http") != 0) {
            return null;
        }
        byte[] fileByte = null;
        String urlFileType = "";
        CloseableHttpClient client = null;
        AwsFpyService service = AwsFpyService.newInstance();
        client = proxy ? HttpUtil.getConnection(service.getProxy(), false) : HttpUtil.getConnection(null, false);
        HttpGet get = HttpUtil.getHttpGet(HttpUtil.replaceUrl(fileUrl));
        CloseableHttpResponse response1 = null;
        CloseableHttpResponse response302 = null;
        try {
            urlFileType = FileUtils.getFileType(fileUrl);
            if (!StringUtils.isEmpty((String)urlFileType) && !"do".equals(urlFileType)) {
                fileName = UUID.randomUUIDZero() + '.' + urlFileType;
            }
            long start = System.currentTimeMillis();
            response1 = (CloseableHttpResponse)client.execute((HttpUriRequest)get);
            int statusCode1 = response1.getStatusLine().getStatusCode();
            if (200 == statusCode1) {
                HttpEntity entity1 = response1.getEntity();
                fileByte = FileUtils.getByte(entity1.getContent());
                if (StringUtils.isEmpty((String)urlFileType)) {
                    urlFileType = FileUtils.getSuffixFromDisposition(response1);
                }
            } else if (302 == statusCode1) {
                HttpGet newget;
                int statusCode2;
                Header header = response1.getFirstHeader("location");
                String newUrl = header.getValue();
                logger.info("\u91cd\u5b9a\u5411:" + newUrl);
                if (StringUtils.isEmpty((String)fileName)) {
                    urlFileType = FileUtils.getFileType(newUrl);
                }
                if (200 == (statusCode2 = (response302 = (CloseableHttpResponse)client.execute((HttpUriRequest)(newget = HttpUtil.getHttpGet(HttpUtil.replaceUrl(newUrl))))).getStatusLine().getStatusCode())) {
                    HttpEntity entity2 = response302.getEntity();
                    fileByte = FileUtils.getByte(entity2.getContent());
                    if (StringUtils.isEmpty((String)urlFileType)) {
                        urlFileType = FileUtils.getSuffixFromDisposition(response302);
                    }
                } else {
                    logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25302[{}]{}:{}", new Object[]{statusCode2, newUrl, JSON.toJSONString((Object)response302)});
                }
            } else {
                logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25[{}]{}:{}", new Object[]{statusCode1, fileUrl, JSON.toJSONString((Object)response1)});
            }
            logger.info("\u4e0b\u8f7d\u6587\u4ef6\u8017\u65f6[{}]{}", (Object)(System.currentTimeMillis() - start), (Object)fileUrl);
        }
        catch (IOException e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + fileUrl, (Throwable)e);
        }
        finally {
            if (response1 != null) {
                try {
                    response1.close();
                }
                catch (IOException iOException) {}
            }
            if (response302 != null) {
                try {
                    response302.close();
                }
                catch (IOException iOException) {}
            }
            try {
                get.abort();
                get.releaseConnection();
            }
            catch (Exception exception) {}
        }
        return Pair.of((Object)urlFileType, fileByte);
    }

    private static Pair<String, String> dealResponse(CloseableHttpResponse response, String fileName, String fileUrl) throws UnsupportedOperationException, IOException {
        String fileType = FileUtils.getSuffixFromDisposition(response);
        if (StringUtils.isEmpty((String)fileType) && FILE_TYPE_OFD.equals(fileType = FileUtils.getSuffixFromContentType(response))) {
            String fileTypeFromName = FileUtils.getFileType(fileName);
            if (!StringUtils.isEmpty((String)fileType)) {
                fileType = fileTypeFromName;
            }
        }
        HttpEntity entity = response.getEntity();
        if (StringUtils.isEmpty((String)fileName)) {
            fileName = UUID.randomUUIDZero() + '.' + fileType;
        } else if (fileName.indexOf(46) < 0) {
            fileName = fileName + '.' + fileType;
        }
        if (StringUtils.isEmpty((String)fileType) && fileName.indexOf(46) < 0) {
            logger.error("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef\u53d6\u6d88\u4e0a\u4f20:" + fileUrl);
            return Pair.of(null, (Object)fileType);
        }
        byte[] fileByte = FileUtils.getByte(entity.getContent());
        try (ByteArrayInputStream bs = new ByteArrayInputStream(fileByte);){
            String url = FileUploadUtils.upload(FileUploadUtils.getInvoiceDir("invoice") + fileName, fileName, bs);
            Pair pair = Pair.of((Object)url, (Object)fileType);
            return pair;
        }
    }

    public static void saveFilePath(String remoteurl, String localurl, String fileId, String urlFileType) {
        try {
            if (StringUtils.isEmpty((String)remoteurl) || StringUtils.isEmpty((String)localurl)) {
                logger.info("\u6587\u4ef6\u5730\u5740\u4e0d\u5b8c\u6574{}", (Object)fileId);
                return;
            }
            DynamicObject downResult = BusinessDataServiceHelper.newDynamicObject((String)"rim_download_file");
            downResult.set("fileid", (Object)fileId);
            downResult.set("http_url", (Object)remoteurl);
            downResult.set("file_url", (Object)localurl);
            downResult.set("create_time", (Object)new Date());
            downResult.set("file_type", (Object)FileUtils.convertFileType(urlFileType));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downResult});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String convertFileType(String fileType) {
        logger.info("\u4e0b\u8f7d\u6587\u4ef6\u7c7b\u578b{}", (Object)fileType);
        if ("1".equals(fileType) || FILE_TYPE_PDF.equals(fileType)) {
            return FILE_TYPE_PDF;
        }
        if ("4".equals(fileType) || FILE_TYPE_OFD.equals(fileType)) {
            return FILE_TYPE_OFD;
        }
        if ("9".equals(fileType) || FILE_TYPE_XML.equals(fileType)) {
            return FILE_TYPE_XML;
        }
        return FILE_TYPE_JPG;
    }

    public static String convertFileTypeNum(String fileType) {
        if ("1".equals(fileType) || FILE_TYPE_PDF.equals(fileType)) {
            return "1";
        }
        if ("4".equals(fileType) || FILE_TYPE_OFD.equals(fileType)) {
            return "4";
        }
        if ("9".equals(fileType) || FILE_TYPE_XML.equals(fileType)) {
            return "9";
        }
        return "2";
    }

    public static String queryFilePath(String fileId) {
        QFilter filter;
        DynamicObject obj;
        if (!StringUtils.isEmpty((String)fileId) && (obj = QueryServiceHelper.queryOne((String)"rim_download_file", (String)"id,file_url", (QFilter[])new QFilter[]{filter = new QFilter("fileid", "=", (Object)fileId)})) != null && !StringUtils.isEmpty((String)obj.getString("file_url"))) {
            logger.info("\u5df2\u5b58\u5728\u8def\u5f84fileId:{},{}", (Object)fileId, (Object)obj.getString("file_url"));
            return obj.getString("file_url");
        }
        return null;
    }

    public static Pair<String, String> queryFileUrl(String fileId) {
        QFilter filter;
        DynamicObject obj;
        if (!StringUtils.isEmpty((String)fileId) && (obj = QueryServiceHelper.queryOne((String)"rim_download_file", (String)"id,file_url,http_url", (QFilter[])new QFilter[]{filter = new QFilter("fileid", "=", (Object)fileId)})) != null && !StringUtils.isEmpty((String)obj.getString("file_url"))) {
            return Pair.of((Object)obj.getString("file_url"), (Object)obj.getString("http_url"));
        }
        return Pair.of((Object)"", (Object)"");
    }

    public static JSONObject queryFilePathAndType(String fileId) {
        if (!StringUtils.isEmpty((String)fileId)) {
            JSONObject result = new JSONObject();
            QFilter filter = new QFilter("fileid", "=", (Object)fileId);
            DynamicObject obj = QueryServiceHelper.queryOne((String)"rim_download_file", (String)"id,file_url,file_type", (QFilter[])new QFilter[]{filter});
            if (obj != null && !StringUtils.isEmpty((String)obj.getString("file_url"))) {
                result.put("file_url", (Object)obj.getString("file_url"));
                result.put("file_type", (Object)obj.getString("file_type"));
                return result;
            }
        }
        return null;
    }

    public static String getSuffixFromDisposition(CloseableHttpResponse response) {
        Header[] headers = response.getHeaders("Content-Disposition");
        if (headers == null) {
            headers = response.getHeaders("content-disposition");
        }
        if (headers != null) {
            for (Header header : headers) {
                String value = header.getValue().replace("\"", "");
                logger.info("getSuffixFromDisposition headervalue:{}", (Object)value);
                int nameIndex = value.indexOf("filename");
                if (nameIndex <= 0 || value.length() <= 10) continue;
                String fileName = value.substring(nameIndex + 10, value.length());
                if ((fileName = fileName.replace(";", "")).lastIndexOf(46) <= 0) continue;
                return fileName.substring(fileName.lastIndexOf(46) + 1);
            }
        }
        return null;
    }

    private static String getSuffixFromContentType(CloseableHttpResponse response) {
        Header[] headers = response.getHeaders("Content-Type");
        if (headers != null) {
            for (Header header : headers) {
                if (header.getValue().indexOf(FILE_TYPE_PDF) > 0) {
                    return FILE_TYPE_PDF;
                }
                if (header.getValue().indexOf("octet") > 0) {
                    return FILE_TYPE_OFD;
                }
                if (header.getValue().indexOf("image/png") >= 0) {
                    return "png";
                }
                if (header.getValue().indexOf("image/gif") >= 0) {
                    return "gif";
                }
                if (header.getValue().indexOf("image") >= 0) {
                    return FILE_TYPE_JPG;
                }
                if (header.getValue().indexOf("html") < 0) continue;
                return "html";
            }
        }
        return null;
    }

    public static ByteArrayOutputStream cloneInputStream(InputStream input) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return baos;
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u5f00\u7968\u4eba\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean isExcel(String fileName) {
        return FileUtils.checkFileType(fileName, "xls", "xlsx");
    }

    public static boolean checkFileType(String fileName, String ... types) {
        if (fileName == null || types == null || types.length < 1) {
            return false;
        }
        String fileType = FileUtils.getFileType(fileName);
        if ("".equals(fileType)) {
            return false;
        }
        for (String str : types) {
            if (!fileType.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    @SdkDeprecated
    public static String getFileType(String fileName, String fileUrl) {
        String fileType = FileUtils.getFileType(fileName);
        if (StringUtils.isEmpty((String)fileType)) {
            fileType = FileUtils.getFileTypeByPath(fileUrl);
        }
        return fileType;
    }

    @SdkDeprecated
    public static String getFileType(String fileName) {
        if (fileName != null && fileName.startsWith("http")) {
            int idx = fileName.indexOf("?");
            if (idx > 0) {
                fileName = fileName.substring(0, idx);
            }
            if ((idx = fileName.lastIndexOf("/")) > 7) {
                fileName = fileName.substring(idx, fileName.length());
            } else {
                return "";
            }
        }
        return FilenameUtils.getExtension((String)fileName);
    }

    public static String getFileTypeByPath(String fileName) {
        String type = FileUtils.getFileType(fileName);
        if (StringUtils.isEmpty((String)type)) {
            return FileUtils.getFileType(FileUtils.getRealPath(fileName));
        }
        return type;
    }

    public static String getRealPath(String fileId) {
        if (StringUtils.isEmpty((String)fileId) || fileId.startsWith("http")) {
            return "";
        }
        if (MetadataUtil.exists("bos_svc_attachment").booleanValue()) {
            try {
                QFilter filter = new QFilter("number", "=", (Object)fileId);
                DynamicObject object = QueryServiceHelper.queryOne((String)"bos_svc_attachment", (String)"path", (QFilter[])filter.toArray());
                if (object != null) {
                    return object.getString("path");
                }
            }
            catch (Exception filter) {
                // empty catch block
            }
        }
        String path = "";
        try {
            String sql = "select fpath from t_bas_filepathmapping where FFILEID = ? ";
            path = (String)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new String[]{fileId}, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws Exception {
                    String path = "";
                    while (rs.next()) {
                        path = rs.getString("fpath");
                    }
                    return path;
                }
            });
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u771f\u5b9e\u5730\u5740\u5931\u8d25\uff1a" + e);
        }
        return path;
    }

    public static Pair<String, byte[]> getFileContent(String fileUrl) {
        return FileUtils.getFileContent(fileUrl, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Pair<String, byte[]> getFileContent(String fileUrl, Boolean proxy) {
        if (StringUtils.isEmpty((String)fileUrl)) {
            return null;
        }
        if (fileUrl.indexOf("http") != 0) {
            FileService service = FileServiceFactory.getAttachmentFileService();
            if (service.exists(fileUrl)) {
                String fileType = FileUtils.getFileType(fileUrl);
                if (!StringUtils.isEmpty((String)fileType)) return Pair.of((Object)fileType, (Object)FileUtils.getByte(service.getInputStream(fileUrl)));
                String path = FileUtils.getRealPath(fileUrl);
                fileType = FileUtils.getFileType(path);
                return Pair.of((Object)fileType, (Object)FileUtils.getByte(service.getInputStream(fileUrl)));
            }
            logger.info("\u6587\u4ef6\u4e0d\u5b58\u5728:" + fileUrl);
            return null;
        }
        AwsFpyService service = AwsFpyService.newInstance();
        CloseableHttpClient client = HttpUtil.getConnection(proxy != false ? service.getProxy() : null, false);
        HttpGet get = HttpUtil.getHttpGet(HttpUtil.replaceUrl(fileUrl));
        CloseableHttpResponse response = null;
        CloseableHttpResponse response302 = null;
        try {
            long start = System.currentTimeMillis();
            response = (CloseableHttpResponse)client.execute((HttpUriRequest)get);
            int statusCode = response.getStatusLine().getStatusCode();
            if (200 == statusCode) {
                Pair<String, byte[]> pair = FileUtils.getContentFromResonse(fileUrl, response);
                return pair;
            }
            if (302 == statusCode) {
                Header header = response.getFirstHeader("location");
                String newUrl = header.getValue();
                logger.info("\u91cd\u5b9a\u5411:" + newUrl);
                HttpGet get302 = HttpUtil.getHttpGet(HttpUtil.replaceUrl(newUrl));
                response302 = (CloseableHttpResponse)client.execute((HttpUriRequest)get302);
                int statusCode302 = response302.getStatusLine().getStatusCode();
                if (200 == statusCode302) {
                    Pair<String, byte[]> pair = FileUtils.getContentFromResonse(fileUrl, response302);
                    return pair;
                }
                logger.error(String.format("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25302[%s]%s:%s", statusCode, newUrl, JSON.toJSONString((Object)response302)));
            }
            logger.info("\u4e0b\u8f7d\u6587\u4ef6\u8017\u65f6[{}]{},{}", new Object[]{System.currentTimeMillis() - start, statusCode, fileUrl});
            return null;
        }
        catch (IOException e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + fileUrl, (Throwable)e);
            return null;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            if (response302 != null) {
                try {
                    response302.close();
                }
                catch (IOException iOException) {}
            }
            try {
                get.abort();
                get.releaseConnection();
            }
            catch (Exception exception) {}
        }
    }

    public static Pair<String, byte[]> getContentFromResonse(String fileUrl, CloseableHttpResponse response) throws IOException {
        String fileType = FileUtils.getSuffixFromDisposition(response);
        if (StringUtils.isEmpty((String)fileType) && FILE_TYPE_OFD.equals(fileType = FileUtils.getSuffixFromContentType(response)) && StringUtils.isEmpty((String)(fileType = FileUtils.getFileType(fileUrl)))) {
            fileType = FILE_TYPE_OFD;
        }
        HttpEntity entity = response.getEntity();
        return Pair.of((Object)fileType, (Object)FileUtils.getByte(entity.getContent()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getAttachmentByte(String savePath) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream bos = service.getInputStream(savePath);){
            byte[] byArray = FileUtils.getByte(bos);
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getByte(InputStream inputStream) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String encodeBase64File(InputStream inputFile) throws Exception {
        if (inputFile == null) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = inputFile.read(buffer))) {
            output.write(buffer, 0, n);
        }
        String retStr = Base64.encodeBase64String((byte[])output.toByteArray());
        return retStr;
    }

    public static String truncateFileName(String fileName, int maxLength) {
        String nameWithoutExtension;
        if (StringUtils.isEmpty((String)fileName)) {
            return fileName;
        }
        if (fileName.length() <= maxLength) {
            return fileName;
        }
        int dotIndex = fileName.lastIndexOf(46);
        String extension = "";
        if (dotIndex != -1) {
            nameWithoutExtension = fileName.substring(0, dotIndex);
            extension = fileName.substring(dotIndex);
        } else {
            nameWithoutExtension = fileName;
        }
        int availableLength = maxLength - extension.length();
        if (availableLength <= 0) {
            return "";
        }
        return nameWithoutExtension.substring(0, Math.min(availableLength, nameWithoutExtension.length())) + extension;
    }

    public static String getFileId(String url) {
        return MD5.md5Hex(url);
    }

    public static String getFileType(JSONObject invoiceJson) {
        ArrayList<Integer> priority = new ArrayList<Integer>();
        JSONArray invoiceFiles = invoiceJson.getJSONArray("invoiceFiles");
        if (invoiceFiles == null) {
            logger.info("\u627e\u4e0d\u5230\u6587\u4ef6");
            return "";
        }
        block12: for (int i = 0; i < invoiceFiles.size(); ++i) {
            JSONObject invoice = invoiceFiles.getJSONObject(i);
            String fileExtends = "";
            String originalExtends = invoice.getString("fileExtends");
            if (originalExtends == null) {
                priority.add(i, 6);
                continue;
            }
            fileExtends = FileUtils.isImage(originalExtends) ? "img" : originalExtends.toLowerCase();
            switch (fileExtends) {
                case "xml": {
                    priority.add(i, 1);
                    continue block12;
                }
                case "ofd": {
                    priority.add(i, 2);
                    continue block12;
                }
                case "pdf": {
                    priority.add(i, 3);
                    continue block12;
                }
                case "img": {
                    priority.add(i, 4);
                    continue block12;
                }
                default: {
                    priority.add(i, 5);
                }
            }
        }
        int minIndex = -1;
        int minValue = 5;
        for (int i = 0; i < priority.size(); ++i) {
            if ((Integer)priority.get(i) > minValue) continue;
            minValue = (Integer)priority.get(i);
            minIndex = i;
        }
        if (minIndex != -1) {
            if (minValue == 5) {
                return null;
            }
            JSONObject finalInvoice = invoiceFiles.getJSONObject(minIndex);
            logger.info("\u83b7\u53d6\u7684\u6587\u4ef6\u540e\u7f00\uff1a{}", (Object)finalInvoice.getString("fileExtends"));
            return finalInvoice.getString("fileExtends");
        }
        logger.info("\u627e\u4e0d\u5230\u6587\u4ef6");
        return "";
    }

    public static String getFileTypeByExtension(String fileExtension) {
        if (StringUtils.isEmpty((String)fileExtension) || FileUtils.isImage(fileExtension)) {
            return "2";
        }
        switch (fileExtension = fileExtension.toLowerCase()) {
            case "doc": 
            case "docx": 
            case "5": {
                return "5";
            }
            case "xls": 
            case "xlsx": 
            case "6": {
                return "6";
            }
            case "txt": 
            case "8": {
                return "8";
            }
            case "pptx": 
            case "7": {
                return "7";
            }
            case "ofd": 
            case "4": {
                return "4";
            }
            case "pdf": 
            case "1": {
                return "1";
            }
            case "xml": 
            case "9": {
                return "9";
            }
        }
        return fileExtension;
    }

    public static String getExtensionByFileType(String fileType) {
        if (StringUtils.isEmpty((String)fileType)) {
            return "";
        }
        switch (fileType = fileType.toLowerCase()) {
            case "2": {
                return "doc";
            }
            case "5": {
                return FILE_TYPE_JPG;
            }
            case "6": {
                return "xls";
            }
            case "7": {
                return "pptx";
            }
            case "8": {
                return "txt";
            }
            case "4": {
                return FILE_TYPE_OFD;
            }
            case "1": {
                return FILE_TYPE_PDF;
            }
            case "9": {
                return FILE_TYPE_XML;
            }
        }
        return fileType;
    }

    public static void copySheet(Sheet sourceSheet, Workbook destWorkbook, String newSheetName) {
        int i;
        Sheet newSheet = destWorkbook.createSheet(newSheetName);
        for (i = 0; i <= sourceSheet.getLastRowNum(); ++i) {
            Row sourceRow = sourceSheet.getRow(i);
            if (sourceRow == null) continue;
            Row newRow = newSheet.createRow(i);
            for (int j = 0; j < sourceRow.getLastCellNum(); ++j) {
                Cell sourceCell = sourceRow.getCell(j);
                if (sourceCell == null) continue;
                Cell newCell = newRow.createCell(j);
                FileUtils.copyCellValueOnly(sourceCell, newCell);
            }
        }
        for (i = 0; i < sourceSheet.getRow(0).getLastCellNum(); ++i) {
            newSheet.setColumnWidth(i, sourceSheet.getColumnWidth(i));
        }
    }

    private static void copyCellValueOnly(Cell sourceCell, Cell newCell) {
        switch (sourceCell.getCellType()) {
            case STRING: {
                newCell.setCellValue(sourceCell.getStringCellValue());
                break;
            }
            case NUMERIC: {
                newCell.setCellValue(sourceCell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                newCell.setCellValue(sourceCell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                try {
                    newCell.setCellValue(sourceCell.getNumericCellValue());
                }
                catch (IllegalStateException e) {
                    newCell.setCellValue(sourceCell.getStringCellValue());
                }
                break;
            }
            case BLANK: {
                newCell.setBlank();
                break;
            }
            default: {
                newCell.setBlank();
            }
        }
    }
}

