/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.util.Date;
import java.util.Optional;
import java.util.function.Supplier;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.MD5;

public class LockUtils {
    private static Log LOGGER = LogFactory.getLog(LockUtils.class);

    public static <T> T lock(String cacheKey, String cacheName, int waitSeconds, Supplier<T> supplier) {
        return (T)LockUtils.lock(cacheKey, cacheName, waitSeconds, supplier, () -> null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T lock(String cacheKey, String cacheName, int waitSeconds, Supplier<T> supplier, Supplier<T> timeoutBack) {
        LOGGER.info("key[{}]\u5c1d\u8bd5\u4e0a\u9501,\u81ea\u65cb\u65f6\u95f4[{}]\u79d2", (Object)cacheKey, (Object)waitSeconds);
        Date now = new Date();
        Date endTime = DateUtils.addSecond(now, waitSeconds);
        DLock lock = LockUtils.createDLockByMd5(cacheKey, cacheName);
        while (true) {
            if (lock.tryLock()) {
                try {
                    T t = supplier.get();
                    return t;
                }
                finally {
                    lock.unlock();
                }
            }
            now = new Date();
            if (now.after(endTime)) {
                return timeoutBack.get();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static DLock createDLockByMd5(String cacheKey) {
        return LockUtils.createDLockByMd5(cacheKey, null);
    }

    public static DLock createDLockByMd5(String cacheKey, String cacheName) {
        String newKey = MD5.md5Hex(cacheKey);
        newKey = Optional.ofNullable(newKey).orElse(cacheKey);
        LOGGER.info("\u5f00\u59cb\u521b\u5efaDLock,cacheKey:{},newKey:{}", (Object)cacheKey, (Object)newKey);
        return DLock.create((String)newKey, (String)cacheName);
    }
}

