/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextBasedataEdit;
import org.apache.commons.compress.utils.Lists;

public class MetadataUtil {
    public static final String KEY_TYPE = "type";
    public static final String KEY_FORMAT = "format";
    public static final String KEY_NAME = "name";
    public static final String KEY_ITEMS = "items";
    public static final String KEY_SCALE = "scale";
    public static final String FORMAT_DECIMAL = "decimal";
    public static final String FORMAT_DATE = "date";
    public static final String FORMAT_STRING = "string";
    public static final String FORMAT_COMBO = "combo";

    public static Map<String, Object> getField(String entityid, String fieldId) {
        return MetadataUtil.getFieldMap(entityid).get(fieldId);
    }

    public static String getFieldType(String entityid, String fieldId) {
        Map<String, Object> filedMap = MetadataUtil.getFieldMap(entityid).get(fieldId);
        if (filedMap != null) {
            return (String)filedMap.get(KEY_TYPE);
        }
        return null;
    }

    public static Format getDateFormat(String entityid, String fieldId) {
        Map<String, Object> filedMap = MetadataUtil.getFieldMap(entityid).get(fieldId);
        if (filedMap != null) {
            return (Format)filedMap.get(KEY_FORMAT);
        }
        return null;
    }

    public static String getComboItemName(String entityid, String fieldId, String value) {
        Map valueMap;
        Map<String, Object> filedMap = MetadataUtil.getFieldMap(entityid).get(fieldId);
        if (filedMap != null && (valueMap = (Map)filedMap.get(KEY_ITEMS)) != null) {
            return (String)valueMap.get(value);
        }
        return "";
    }

    public static JSONObject getFeildFormatMap(String entityId) {
        JSONObject feildFormat = new JSONObject();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (mainEntityType != null) {
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            MetadataUtil.setObject(mainPros, feildFormat);
        }
        return feildFormat;
    }

    public static Map<String, Map<String, Object>> getFieldMap(String entityid) {
        HashMap<String, Map<String, Object>> typeMap = new HashMap<String, Map<String, Object>>(16);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        if (mainEntityType != null) {
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            MetadataUtil.setFiledMap(mainPros, typeMap, mainEntityType);
        }
        return typeMap;
    }

    private static void setFiledMap(DataEntityPropertyCollection pros, Map<String, Map<String, Object>> typeMap, MainEntityType mainEntityType) {
        for (IDataEntityProperty property : pros) {
            EntryProp entryProp;
            DynamicObjectType dynamicObjectType;
            HashMap<String, Object> filedMap = new HashMap<String, Object>(8);
            if (property.getDisplayName() != null) {
                filedMap.put(KEY_NAME, property.getDisplayName().getLocaleValue());
            }
            filedMap.put(KEY_TYPE, property.getClass().getSimpleName());
            if (property instanceof DateTimeProp) {
                DateTimeProp pop = (DateTimeProp)property;
                pop.createFilterFields(mainEntityType);
                DateFormat format = ((DateTimeProp)property).getDateFormat();
                filedMap.put(KEY_FORMAT, format);
            } else if (property instanceof ComboProp) {
                List comboItems = ((ComboProp)property).getComboItems();
                if (comboItems != null) {
                    LinkedHashMap<String, String> items = new LinkedHashMap<String, String>(8);
                    for (ValueMapItem item : comboItems) {
                        items.put(item.getValue(), item.getName().getLocaleValue());
                    }
                    filedMap.put(KEY_ITEMS, items);
                }
            } else if (property instanceof DecimalProp) {
                DecimalProp decProp = (DecimalProp)property;
                filedMap.put(KEY_FORMAT, new DecimalFormat(MetadataUtil.getFormatByScale(decProp.getScale())));
            } else if (property instanceof EntryProp && (dynamicObjectType = (entryProp = (EntryProp)property).getDynamicCollectionItemPropertyType()) != null) {
                DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
                MetadataUtil.setFiledMap(properties, typeMap, mainEntityType);
            }
            typeMap.put(property.getName(), filedMap);
        }
    }

    public static String getFormatByScale(int scale) {
        if (scale < 1) {
            return "#####0";
        }
        return "#####0.00";
    }

    private static void setObject(DataEntityPropertyCollection mainPros, JSONObject feildFormat) {
        for (IDataEntityProperty property : mainPros) {
            String feildName = property.getName();
            if (property instanceof DateTimeProp) {
                feildFormat.put(feildName, (Object)FORMAT_DATE);
                continue;
            }
            if (property instanceof ComboProp) {
                feildFormat.put(feildName, (Object)FORMAT_COMBO);
                continue;
            }
            if (property instanceof DecimalProp) {
                feildFormat.put(feildName, (Object)FORMAT_DECIMAL);
                continue;
            }
            if (property instanceof EntryProp) {
                DataEntityPropertyCollection sonProps = ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties();
                JSONObject sonFeildForm = ObjectUtils.isEmpty((Object)feildFormat.getJSONObject(feildName)) ? new JSONObject() : feildFormat.getJSONObject(feildName);
                feildFormat.put(property.getName(), (Object)sonFeildForm);
                MetadataUtil.setObject(sonProps, sonFeildForm);
                continue;
            }
            feildFormat.put(feildName, (Object)FORMAT_STRING);
        }
    }

    public static Boolean exists(String entityId) {
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            return Boolean.FALSE;
        }
        try {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            return mainEntityType != null;
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
    }

    public static String getFields(String entityId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (mainEntityType != null) {
            StringBuilder sb = new StringBuilder();
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            ArrayList noAliasBaseDataIds = Lists.newArrayList();
            for (IDataEntityProperty property : mainPros) {
                if (!StringUtils.isEmpty((CharSequence)property.getAlias()) || !(property instanceof BasedataProp)) continue;
                noAliasBaseDataIds.add(property.getName());
            }
            for (IDataEntityProperty property : mainPros) {
                String target;
                String propertyName;
                if (StringUtils.isEmpty((CharSequence)property.getAlias()) || (propertyName = property.getName()).contains("_id") && !StringUtils.isEmpty((CharSequence)(target = propertyName.split("_id")[0])) && noAliasBaseDataIds.contains(target) || property instanceof EntryProp) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                if (property instanceof BasedataProp) {
                    sb.append(property.getName()).append(".id as ").append(property.getName());
                    continue;
                }
                sb.append(property.getName());
            }
            return sb.toString();
        }
        return "*";
    }

    public static Object getRealValue(EntryGrid grid, IDataEntityProperty prop, Object val) {
        if (null == val) {
            return "";
        }
        if (prop instanceof BooleanProp) {
            return Boolean.TRUE.equals(val) ? ResManager.loadKDString((String)"\u662f", (String)"MetadataUtil_0", (String)"imc-rim-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"MetadataUtil_1", (String)"imc-rim-common", (Object[])new Object[0]);
        }
        if (prop instanceof ComboProp) {
            return MetadataUtil.getExportComboValue((ComboProp)prop, val);
        }
        if (prop instanceof BasedataProp) {
            return MetadataUtil.getDisplayNameFromBasedata(grid, prop, val);
        }
        if (prop instanceof TimeProp) {
            return MetadataUtil.formatTimeStr((Integer)val);
        }
        if (prop instanceof DateProp) {
            String name = prop.getName();
            DateFormat dateFormat = ((DateProp)prop).getDateFormat();
            if (StringUtils.contains((CharSequence)name, (CharSequence)"account_date")) {
                dateFormat = new SimpleDateFormat("yyyy-MM");
            }
            return MetadataUtil.formatDateStr((Date)val, dateFormat);
        }
        if (prop instanceof DateTimeProp) {
            DateFormat dateFormat = ((DateTimeProp)prop).getDateFormat();
            return MetadataUtil.formatDateStr((Date)val, dateFormat);
        }
        return val;
    }

    private static String formatTimeStr(Integer timeObj) {
        if (timeObj != null && timeObj >= 0) {
            int time = timeObj;
            int second = time % 60;
            int minute = (time /= 60) % 60;
            int hour = (time /= 60) % 24;
            return String.format("%02d:%02d:%02d", hour, minute, second);
        }
        return "";
    }

    private static String formatDateStr(Date dateObj, DateFormat dateFormat) {
        if (dateObj != null) {
            return dateFormat.format(dateObj);
        }
        return "";
    }

    private static Object getExportComboValue(ComboProp prop, Object param) {
        List<String> values = Arrays.asList(param.toString().split(","));
        List items = prop.getComboItems();
        if (items != null && !items.isEmpty()) {
            ArrayList<String> vals = new ArrayList<String>();
            for (ValueMapItem item : items) {
                if (!values.contains(item.getValue())) continue;
                vals.add(null == item.getName() ? "" : item.getName().toString());
            }
            String val = String.join((CharSequence)" ", vals);
            return val;
        }
        return param;
    }

    public static Object getDisplayNameFromBasedata(EntryGrid grid, IDataEntityProperty prop, Object val) {
        Object[] result = new Object[]{val};
        MetadataUtil.replaceValAtBasedataProp(grid.getItems(), prop, val, result);
        val = result[0];
        DynamicObject base = (DynamicObject)result[0];
        return base.getLocaleString(KEY_NAME).getLocaleValue();
    }

    private static void replaceValAtBasedataProp(List<Control> items, IDataEntityProperty prop, Object valObj, Object[] result) {
        Pattern replaceNumber = Pattern.compile("number");
        Pattern replaceName = Pattern.compile(KEY_NAME);
        Iterator<Control> var7 = items.iterator();
        while (var7.hasNext()) {
            String displayProp;
            Control item = var7.next();
            if (item instanceof Container) {
                MetadataUtil.replaceValAtBasedataProp(((Container)item).getItems(), prop, valObj, result);
            }
            if (item instanceof TextBasedataEdit) continue;
            if (item instanceof MulBasedataEdit && prop.getName().equals(((BasedataEdit)item).getFieldKey())) {
                displayProp = ((BasedataEdit)item).getDisplayProp();
                if (displayProp == null || "".equals(displayProp)) {
                    result[0] = ((Object[])valObj)[1];
                    continue;
                }
            } else {
                if (!(item instanceof BasedataEdit) || !prop.getName().equals(((BasedataEdit)item).getFieldKey())) continue;
                displayProp = ((BasedataEdit)item).getDisplayProp();
                if (displayProp != null && !"".equals(displayProp)) {
                    if (!(valObj instanceof Object[]) || !valObj.getClass().isArray() || ((Object[])valObj).length < 2) continue;
                    result[0] = displayProp;
                    result[0] = result[0].toString().replaceAll("number", ((Object[])valObj)[0].toString());
                    result[0] = result[0].toString().replaceAll(KEY_NAME, ((Object[])valObj)[1].toString());
                    continue;
                }
                result[0] = ((Object[])valObj)[1];
                continue;
            }
            if (!(valObj instanceof List)) continue;
            ArrayList<String> valStrs = new ArrayList<String>();
            for (Object val : (List)valObj) {
                if (!(val instanceof Object[]) || !val.getClass().isArray() || ((Object[])val).length < 2) continue;
                String resultTmp = replaceNumber.matcher(displayProp).replaceAll(((Object[])val)[0].toString());
                resultTmp = replaceName.matcher(resultTmp).replaceAll(((Object[])val)[1].toString());
                valStrs.add(resultTmp);
            }
            result[0] = String.join((CharSequence)";", valStrs);
        }
        return;
    }
}

