/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.util.HashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.rim.common.constant.RimPermItemEnum;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.StringUtils;

public class PermissionUtils {
    public static HasPermOrgResult getAllPermOrgs(IFormView view) {
        return PermissionUtils.getAllPermOrgs(view, "47150e89000000ac");
    }

    public static HasPermOrgResult getAllPermOrgs(String appNumber, String entityid, String perm) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        return PermissionUtils.getAllPermOrgsByUserId(appNumber, entityid, perm, userId);
    }

    public static HasPermOrgResult getAllPermOrgsByUserId(String appNumber, String entityid, String perm, Long userId) {
        String appid = null;
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
                appid = mainEntityType.getAppId();
            }
        }
        userId = userId == null || userId == 0L ? Long.valueOf(RequestContext.get().getUserId()) : userId;
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityid, (String)perm);
        return hasPermOrgResult;
    }

    public static HasPermOrgResult getAllPermOrgs(IFormView view, String perm) {
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = null;
        String entityid = view.getEntityId();
        if (view instanceof ListView) {
            entityid = ((ListView)view).getBillFormId();
        }
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
                appid = mainEntityType.getAppId();
            }
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityid, (String)perm);
        return hasPermOrgResult;
    }

    public static HasPermOrgResult getAllPermOrgs(IFormView view, String entityId, String perm) {
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = null;
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                appid = mainEntityType.getAppId();
            }
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityId, (String)perm);
        return hasPermOrgResult;
    }

    public static Boolean checkPermission(String userId, Long orgId, IFormView view, String perm) {
        int checkPerm = PermissionServiceHelper.checkPermission((Long)Long.parseLong(userId), (Long)orgId, (String)"rim", (String)view.getEntityId(), (String)perm);
        return checkPerm > 0;
    }

    public static Boolean checkPermission(String userId, Long orgId, String entityId, String ... perms) {
        for (String perm : perms) {
            int checkPerm = PermissionServiceHelper.checkPermission((Long)Long.parseLong(userId), (Long)orgId, (String)"rim", (String)entityId, (String)perm);
            if (checkPerm <= 0) continue;
            return true;
        }
        return false;
    }

    public static void checkPermissionNew(String entityId, AbstractFormPlugin that, RimPermItemEnum permItemEnum, String metadataId) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            entityId = PermissionUtils.getEntityIdByView(that.getView());
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        String appId = mainEntityType.getAppId();
        PermissionUtils.checkPermission(appId, entityId, that, permItemEnum, null, metadataId);
    }

    public static void checkPermission(AbstractFormPlugin that, RimPermItemEnum permItemEnum, String metadataId) {
        String entityId = PermissionUtils.getEntityIdByView(that.getView());
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        String appId = mainEntityType.getAppId();
        PermissionUtils.checkPermission(appId, entityId, that, permItemEnum, null, metadataId);
    }

    public static void checkPermission(String appId, String entityId, AbstractFormPlugin that, RimPermItemEnum permItemEnum, String action, String metadataId) {
        RequestContext requestContext = RequestContext.get();
        String caption = that.getView().getFormShowParameter().getCaption();
        if (PermissionServiceHelper.checkPermission((Long)Long.parseLong(requestContext.getUserId()), (Long)requestContext.getOrgId(), (String)appId, (String)entityId, (String)permItemEnum.getPermId()) != 1) {
            if (RimPermItemEnum.ACTION_HIDE.getPermId().equals(action)) {
                that.getView().setVisible(Boolean.FALSE, new String[]{metadataId});
            } else {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)caption)) {
                    caption = that.getView().getFormShowParameter().getFormName();
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650", (String)"PermissionUtils_0", (String)"imc-rim-common", (Object[])new Object[0]), caption, permItemEnum.getDescription()));
            }
        }
    }

    public static String getEntityIdByView(IFormView view) {
        String entityId = view.getEntityId();
        if (view instanceof ListView) {
            entityId = ((ListView)view).getBillFormId();
        }
        return entityId;
    }

    public static void addTempFilePermission(String url, String entityId, String permissionItemId) {
        PermissionUtils.addTempFilePermission(url, "rim", entityId, null, permissionItemId, CommonUtils.getTempFileMaxTimeout());
    }

    public static void addTempFilePermission(String url, String entityId, String permissionItemId, int timeout) {
        PermissionUtils.addTempFilePermission(url, "rim", entityId, null, permissionItemId, timeout);
    }

    public static void addTempFilePermission(String url, String appId, String entityId, Object billPkId, String permissionItemId, int timeout) {
        try {
            DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
            String tempFileId = UrlUtil.getParam((String)url, (String)"id");
            HashMap<String, Object> refEntitiyMap = new HashMap<String, Object>(2);
            refEntitiyMap.put("entityNum", entityId);
            refEntitiyMap.put("permissionItemId", permissionItemId);
            refEntitiyMap.put("appId", appId);
            refEntitiyMap.put("billPkId", billPkId);
            redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), timeout);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean genEnableNoPermBtnHide(Long orgId) {
        AppParam appParam = new AppParam();
        appParam.setAppId("83bfebc8000037ac");
        appParam.setViewType("15");
        appParam.setOrgId(orgId);
        appParam.setActBookId(Long.valueOf(0L));
        Object isEnable = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"enable_nopermbtnhide");
        return Boolean.parseBoolean(String.valueOf(isEnable));
    }
}

