/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.RimRetryTemplate;

public class RimRetryPostUtil {
    private static Log LOGGER = LogFactory.getLog(RimRetryPostUtil.class);
    private static final int DEFAULT_RETRY_TIMES = 3;
    private static final int DEFAULT_SLEEP_TIMES = 1000;

    public static JSONObject retryPost(Supplier<JSONObject> supplier, Set<String> errorcodes) {
        return RimRetryPostUtil.retryPost(supplier, errorcodes, 3, 1000);
    }

    public static JSONObject retryPost(final Supplier<JSONObject> supplier, final Set<String> errorcodes, final int retryTimes, int sleepTimes) {
        JSONObject resultJson = null;
        try {
            resultJson = new RimRetryTemplate(){

                @Override
                protected JSONObject doBiz(int retryTime) throws Exception {
                    boolean isRetry;
                    LOGGER.info("\u7b2c{}\u6b21\u91cd\u8bd5\u8bf7\u6c42", (Object)retryTime);
                    JSONObject result = (JSONObject)supplier.get();
                    boolean bl = isRetry = result == null || errorcodes != null && errorcodes.contains(result.getString("errcode"));
                    if (isRetry && retryTime != retryTimes) {
                        throw new Exception(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25,\u91cd\u8bd5", (String)"RimRetryPostUtil_0", (String)"imc-rim-common", (Object[])new Object[0]));
                    }
                    return result;
                }
            }.setRetryTime(retryTimes).setSleepTime(sleepTimes).execute();
        }
        catch (InterruptedException e) {
            LOGGER.error("retryPost\u9519\u8bef", (Throwable)e);
        }
        return resultJson;
    }

    public static JSONObject retryPost(AwsFpyService service, String msgType, Long orgId, JSONObject bodyJson, Set<String> errorcodes) {
        return RimRetryPostUtil.retryPost(service, msgType, orgId, bodyJson, errorcodes, 3, 1000);
    }

    public static JSONObject retryPost(final AwsFpyService service, final String msgType, final Long orgId, final JSONObject bodyJson, final Set<String> errorcodes, final int retryTimes, int sleepTimes) {
        JSONObject resultJson = null;
        try {
            resultJson = new RimRetryTemplate(){

                @Override
                protected JSONObject doBiz(int retryTime) throws Exception {
                    boolean isRetry;
                    LOGGER.info("\u7b2c{}\u6b21\u91cd\u8bd5\u8bf7\u6c42{}", (Object)retryTime, (Object)msgType);
                    JSONObject result = service.postAppJson(msgType, orgId, (Map<String, Object>)bodyJson);
                    boolean bl = isRetry = result == null || errorcodes != null && errorcodes.contains(result.getString("errcode"));
                    if (isRetry && retryTime != retryTimes) {
                        throw new Exception(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25,\u91cd\u8bd5", (String)"RimRetryPostUtil_0", (String)"imc-rim-common", (Object[])new Object[0]));
                    }
                    return result;
                }
            }.setRetryTime(retryTimes).setSleepTime(sleepTimes).execute();
        }
        catch (InterruptedException e) {
            LOGGER.error("retryPost\u9519\u8bef", (Throwable)e);
        }
        return resultJson;
    }

    public static JSONObject retryPost(final Supplier<JSONObject> executeSupplier, final Predicate<JSONObject> isRetryPredicate, final int retryTimes, int sleepTimes) {
        JSONObject resultJson = null;
        try {
            resultJson = new RimRetryTemplate(){

                @Override
                protected JSONObject doBiz(int retryTime) throws Exception {
                    LOGGER.info("\u7b2c{}\u6b21\u91cd\u8bd5\u8bf7\u6c42", (Object)retryTime);
                    JSONObject result = (JSONObject)executeSupplier.get();
                    boolean isRetry = isRetryPredicate.test(result);
                    if (isRetry && retryTime != retryTimes) {
                        throw new Exception(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25,\u91cd\u8bd5", (String)"RimRetryPostUtil_0", (String)"imc-rim-common", (Object[])new Object[0]));
                    }
                    return result;
                }
            }.setRetryTime(retryTimes).setSleepTime(sleepTimes).execute();
        }
        catch (InterruptedException e) {
            LOGGER.error("retryPost\u9519\u8bef", (Throwable)e);
        }
        return resultJson;
    }
}

