/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class Sha256HMACUtil {
    private static Log LOGGER = LogFactory.getLog(Sha256HMACUtil.class);

    public static String sha256HMAC(String message, String secret) {
        return Sha256HMACUtil.sha256HMAC(message, secret.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha256HMAC(String message, byte[] secret) {
        String hash = "";
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(secret, "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] bytes = sha256_HMAC.doFinal(message.getBytes(StandardCharsets.UTF_8));
            hash = Sha256HMACUtil.byteArrayToHexString(bytes);
        }
        catch (Exception e) {
            LOGGER.info("HmacSHA256\u52a0\u5bc6\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return hash;
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }

    public static byte[] sha256HMACOriginal(String message, byte[] secret) {
        byte[] originData = null;
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(secret, "HmacSHA256");
            sha256_HMAC.init(secret_key);
            originData = sha256_HMAC.doFinal(message.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.info("HmacSHA256\u52a0\u5bc6\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return originData;
    }
}

