/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import org.apache.commons.compress.utils.Lists;

public class TenantUtils {
    private static final Log logger = LogFactory.getLog(TenantUtils.class);
    public static final String DEF_TENANT_NO = " ";
    private static String cache_org_taxinfo = "cache_org_taxinfo";
    private static int cache_time_out = 300;

    public static final String getTenantNo(Long orgId) {
        return DEF_TENANT_NO;
    }

    public static final String getTenantNo() {
        return DEF_TENANT_NO;
    }

    public static final Long getOrgByNumberOrTaxNo(String orgNumber, String taxNo) {
        QFilter filter;
        logger.info("\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u6216\u8005\u7a0e\u53f7\u83b7\u53d6\u7ec4\u7ec7{},{}", (Object)orgNumber, (Object)taxNo);
        if (!StringUtils.isEmpty((CharSequence)orgNumber)) {
            try {
                filter = new QFilter("number", "=", (Object)orgNumber);
                List pks = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])new QFilter[]{filter}, null, (int)2);
                if (!CollectionUtils.isEmpty((Collection)pks)) {
                    return (Long)pks.get(0);
                }
                logger.info("\u7ec4\u7ec7\u7f16\u7801{}\u4e0d\u5b58\u5728", (Object)orgNumber);
            }
            catch (Exception e) {
                logger.info("\u7ec4\u7ec7\u7f16\u7801{}\u67e5\u8be2\u7ec4\u7ec7\u5931\u8d25:{}", (Object)orgNumber, (Object)e.getMessage());
            }
        }
        if (!StringUtils.isEmpty((CharSequence)taxNo)) {
            filter = new QFilter("number", "=", (Object)taxNo);
            DynamicObject baseinfo = QueryServiceHelper.queryOne((String)"bdm_enterprise_baseinfo", (String)"id,org_id", (QFilter[])new QFilter[]{filter});
            if (!ObjectUtils.isEmpty((Object)baseinfo)) {
                long orgId = BigDecimalUtil.transDecimal(baseinfo.get("org_id")).longValue();
                if (orgId > 0L) {
                    return orgId;
                }
                QFilter filterOrg = new QFilter("epinfo", "=", baseinfo.get("id")).and("enterprisemainorg", "=", (Object)"1");
                DynamicObject orgObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_org", (String)"id", (QFilter[])filterOrg.toArray());
                if (!ObjectUtils.isEmpty((Object)orgObject) && (orgId = BigDecimalUtil.transDecimal(orgObject.get("id")).longValue()) > 0L) {
                    return orgId;
                }
            }
            logger.info("\u7a0e\u53f7\u6ca1\u6709\u5bf9\u5e94\u7ec4\u7ec7:{}", (Object)taxNo);
        }
        return 0L;
    }

    public static final Long getOrgByThirdOrgNo(String thirdOrg) {
        try {
            QFilter idFilter;
            DynamicObject thirdOrgObject;
            if (!StringUtils.isEmpty((CharSequence)thirdOrg) && (thirdOrgObject = QueryServiceHelper.queryOne((String)"bdm_third_org", (String)"id,third_org_no,org_no,orgid", (QFilter[])new QFilter[]{idFilter = new QFilter("third_org_no", "=", (Object)thirdOrg)})) != null) {
                Long orgid = thirdOrgObject.getLong("orgid");
                if (orgid != null && orgid > 0L) {
                    return orgid;
                }
                String orgNumber = thirdOrgObject.getString("org_no");
                QFilter filter = new QFilter("number", "=", (Object)orgNumber);
                List pks = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])new QFilter[]{filter}, null, (int)2);
                if (!CollectionUtils.isEmpty((Collection)pks)) {
                    return (Long)pks.get(0);
                }
                logger.info("\u7ec4\u7ec7\u7f16\u7801{}\u4e0d\u5b58\u5728", (Object)orgNumber);
            }
        }
        catch (Exception e) {
            logger.info("\u5916\u90e8\u7ec4\u7ec7\u7f16\u7801{}\u67e5\u8be2\u7ec4\u7ec7\u5931\u8d25:{}", (Object)thirdOrg, (Object)e.getMessage());
        }
        return 0L;
    }

    public static final Boolean useNewTaxOrg() {
        QFilter f1 = new QFilter("fnumber", "=", (Object)"40");
        Map orgBizMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", (String)"id,fnumber,fname", (QFilter[])new QFilter[]{f1}, null);
        return orgBizMap != null;
    }

    public static final Long getTaxOrgId(Long orgId, String buyerTaxNo) {
        Long org;
        if (StringUtils.isNotEmpty((CharSequence)buyerTaxNo) && (org = TenantUtils.getTaxOrgIdByTaxNo(buyerTaxNo)) > 0L) {
            return org;
        }
        String orgTaxNo = TenantUtils.getTaxNoByOrgId(orgId);
        if (orgTaxNo != null && !orgTaxNo.equals(buyerTaxNo)) {
            return TenantUtils.getTaxOrgIdByTaxNo(orgTaxNo);
        }
        return 0L;
    }

    public static final Long getTaxOrgId(Long orgId) {
        String orgTaxNo = TenantUtils.getTaxNoByOrgId(orgId);
        if (StringUtils.isNotEmpty((CharSequence)orgTaxNo)) {
            return TenantUtils.getTaxOrgIdByTaxNo(orgTaxNo);
        }
        return 0L;
    }

    public static final Long getTaxOrgIdByTaxNo(String taxNo) {
        Long orgId = 0L;
        try {
            if (StringUtils.isNotEmpty((CharSequence)taxNo)) {
                if (MetadataUtil.exists("bastax_taxorg").booleanValue()) {
                    QFilter filter = new QFilter("unifiedsocialcode", "=", (Object)taxNo);
                    DynamicObject list = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{filter});
                    if (list != null) {
                        orgId = DynamicObjectUtil.getDynamicObjectLongValue(list.get("org"));
                    }
                    logger.info("\u83b7\u53d6\u7a0e\u52a1\u7ec4\u7ec7{}\u7a0e\u53f7{}", (Object)orgId, (Object)taxNo);
                } else {
                    logger.info("\u83b7\u53d6\u7a0e\u52a1\u7ec4\u7ec7\u5931\u8d25:bastax_taxorg\u4e0d\u5b58\u5728," + taxNo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7a0e\u52a1\u7ec4\u7ec7\u5931\u8d25:" + taxNo, (Throwable)e);
            return orgId;
        }
        return orgId;
    }

    public static final String getTaxNoByTaxOrgId(Long taxOrgId) {
        try {
            if (taxOrgId != null) {
                QFilter filter = new QFilter("org", "=", (Object)taxOrgId);
                DynamicObject list = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"unifiedsocialcode", (QFilter[])new QFilter[]{filter});
                if (list != null) {
                    return list.getString("unifiedsocialcode");
                }
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    public static Map<String, String> getCompanyNameAndTaxNoByTaxOrgId(Long taxOrgId) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        try {
            if (taxOrgId != null) {
                QFilter filter = new QFilter("org", "=", (Object)taxOrgId);
                DynamicObject list = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"taxpayer,unifiedsocialcode", (QFilter[])new QFilter[]{filter});
                if (list != null) {
                    map.put("taxNo", list.getString("unifiedsocialcode"));
                    map.put("name", list.getString("taxpayer"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public static final String getTaxNoByOrgId(Long orgId) {
        if (orgId == null) {
            return null;
        }
        Map<String, String> map = TenantUtils.getCompanyNameAndTaxNoByOrgId(orgId);
        String taxNo = map.get("taxNo");
        logger.info("\u83b7\u53d6\u7ec4\u7ec7{}\u7a0e\u53f7{}", (Object)orgId, (Object)taxNo);
        return taxNo;
    }

    public static Map<String, String> getCompanyNameAndTaxNoByOrgId(Long orgId) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        String str = CacheHelper.get(cache_org_taxinfo + orgId);
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            JSONObject json = JSONObject.parseObject((String)str);
            map.put("taxNo", json.getString("taxNo"));
            map.put("name", json.getString("name"));
            map.put("dkType", json.getString("dkType"));
            return map;
        }
        QFilter filter = new QFilter("id", "=", (Object)orgId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdm_org", (String)"id,longnumber,epinfo.name as name,epinfo.number as tax_no,epinfo.authtype as authtype", (QFilter[])new QFilter[]{filter});
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            DynamicObject obj = (DynamicObject)collection.get(0);
            String taxNo = obj.getString("tax_no");
            if (StringUtils.isNotEmpty((CharSequence)taxNo)) {
                map.put("taxNo", taxNo);
                map.put("name", obj.getString("name"));
                map.put("dkType", obj.getString("authtype"));
            } else {
                String longnumber = obj.getString("longnumber");
                if (StringUtils.isNotEmpty((CharSequence)longnumber) && longnumber.indexOf(46) != -1) {
                    String[] orgs = longnumber.split("\\.");
                    Long[] longNumbers = new Long[orgs.length];
                    int i = 0;
                    for (String org : orgs) {
                        longNumbers[i++] = Long.parseLong(org);
                    }
                    QFilter filter2 = new QFilter("id", "in", (Object)longNumbers);
                    DynamicObjectCollection collection2 = QueryServiceHelper.query((String)"bdm_org", (String)"id,longnumber,epinfo.name as name,epinfo.number as tax_no,epinfo.authtype as authtype", (QFilter[])new QFilter[]{filter2}, (String)"longnumber");
                    int longNumberLength = 0;
                    taxNo = "";
                    String taxName = "";
                    String dkType = "";
                    for (DynamicObject obj2 : collection2) {
                        String taxNo2 = obj2.getString("tax_no");
                        int leng = obj2.getString("longnumber").length();
                        if (taxNo2 == null || leng <= longNumberLength) continue;
                        longNumberLength = leng;
                        taxNo = taxNo2;
                        taxName = obj2.getString("name");
                        dkType = obj2.getString("authtype");
                    }
                    map.put("taxNo", taxNo);
                    map.put("name", taxName);
                    map.put("dkType", dkType);
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)map.get("taxNo"))) && StringUtils.isNotEmpty((CharSequence)((CharSequence)map.get("name")))) {
            CacheHelper.put(cache_org_taxinfo + orgId, SerializationUtils.toJsonString(map), cache_time_out);
        }
        return map;
    }

    public static final List<Map<String, String>> queryChildOrgList(Long orgId) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>(16);
        Map<String, String> map = TenantUtils.getCompanyNameAndTaxNoByOrgId(orgId);
        map.put("orgId", orgId + "");
        if (!CollectionUtils.isEmpty(map)) {
            resultList.add(map);
            TenantUtils.child(orgId, map, resultList);
        }
        return resultList;
    }

    public static final List<Map<String, String>> queryChildOrgList(String taxNo) {
        QFilter filter = new QFilter("number", "=", (Object)taxNo);
        DynamicObject baseinfo = QueryServiceHelper.queryOne((String)"bdm_enterprise_baseinfo", (String)"id,org_id", (QFilter[])new QFilter[]{filter});
        if (ObjectUtils.isEmpty((Object)baseinfo)) {
            return Lists.newArrayList();
        }
        QFilter filterOrg = new QFilter("epinfo", "=", baseinfo.get("id"));
        DynamicObjectCollection orgObjects = QueryServiceHelper.query((String)"bdm_org", (String)"id", (QFilter[])filterOrg.toArray());
        if (CollectionUtils.isEmpty((Collection)orgObjects)) {
            return Lists.newArrayList();
        }
        ArrayList<Map> orgMap = new ArrayList<Map>(8);
        for (DynamicObject object : orgObjects) {
            orgMap.addAll(TenantUtils.queryChildOrgList(object.getLong("id")));
        }
        if (!CollectionUtils.isEmpty(orgMap) && StringUtils.isNotEmpty((CharSequence)taxNo)) {
            orgMap.removeIf(map -> !StringUtils.equals((CharSequence)((CharSequence)map.get("taxNo")), (CharSequence)taxNo));
        }
        return orgMap.stream().collect(Collectors.collectingAndThen(Collectors.toMap(map -> (String)map.get("orgId"), Function.identity(), (oldVal, newVal) -> oldVal), map -> new ArrayList(map.values())));
    }

    public static final List<Long> queryChildOrgIdList(String taxNo) {
        List<Map<String, String>> orgMap = TenantUtils.queryChildOrgList(taxNo);
        if (CollectionUtils.isEmpty(orgMap)) {
            return Lists.newArrayList();
        }
        return orgMap.stream().map(s -> (String)s.get("orgId")).filter(StringUtils::isNotEmpty).map(Long::parseLong).distinct().collect(Collectors.toList());
    }

    public static final List<Map<String, String>> queryChildOrgList(Long orgId, Long taxOrgId) {
        List<Map<String, String>> orgMap = TenantUtils.queryChildOrgList(orgId);
        String taxNo = TenantUtils.getTaxNoByTaxOrgId(taxOrgId);
        if (!CollectionUtils.isEmpty(orgMap) && StringUtils.isNotEmpty((CharSequence)taxNo)) {
            orgMap.removeIf(map -> !StringUtils.equals((CharSequence)((CharSequence)map.get("taxNo")), (CharSequence)taxNo));
        }
        return orgMap;
    }

    private static void child(Long parentId, Map<String, String> parentTaxInfo, List<Map<String, String>> resultList) {
        QFilter filter = new QFilter("parent", "=", (Object)String.valueOf(parentId));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdm_org", (String)"id,longnumber,epinfo.name as name,epinfo.number as tax_no", (QFilter[])new QFilter[]{filter}, (String)"longnumber");
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            for (DynamicObject obj : collection) {
                HashMap<String, String> map = new HashMap<String, String>(4);
                Long orgId = obj.getLong("id");
                map.put("orgId", orgId + "");
                String taxNo = obj.getString("tax_no");
                if (StringUtils.isNotEmpty((CharSequence)taxNo)) {
                    map.put("taxNo", taxNo);
                    map.put("name", obj.getString("name"));
                } else {
                    map.put("taxNo", parentTaxInfo.get("taxNo"));
                    map.put("name", parentTaxInfo.get("name"));
                }
                resultList.add(map);
                TenantUtils.child(orgId, map, resultList);
            }
        }
    }

    public static Map<String, String> getTaxInfo(String taxNo) {
        if (StringUtils.isNotEmpty((CharSequence)taxNo)) {
            try {
                QFilter filter = new QFilter("number", "=", (Object)taxNo);
                DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_enterprise_baseinfo", (String)"number,authtype,taxusername,taxpassword,company_property", (QFilter[])new QFilter[]{filter});
                if (obj != null) {
                    HashMap<String, String> result = new HashMap<String, String>(4);
                    result.put("taxNo", obj.getString("number"));
                    result.put("dkType", obj.getString("authtype"));
                    result.put("userName", obj.getString("taxusername"));
                    String taxusername = obj.getString("taxusername");
                    String taxpassword = obj.getString("taxpassword");
                    if (StringUtils.isNotEmpty((CharSequence)taxusername)) {
                        String userName = EncrypterFactory.getEncrypter().decode(taxusername);
                        result.put("userName", userName);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)taxpassword)) {
                        String passwd = EncrypterFactory.getEncrypter().decode(taxpassword);
                        result.put("passWord", passwd);
                    }
                    return result;
                }
            }
            catch (Exception e) {
                logger.info("\u83b7\u53d6\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25:" + taxNo + e.getMessage());
            }
        }
        return null;
    }

    public static String getCheckTypeByTaxNo(String taxNo) {
        logger.info("getCheckTypeByTaxNo:{}", (Object)taxNo);
        if (StringUtils.isNotEmpty((CharSequence)taxNo)) {
            try {
                QFilter filter = new QFilter("number", "=", (Object)taxNo);
                DynamicObject obj = QueryServiceHelper.queryOne((String)"bdm_enterprise_baseinfo", (String)"check_type", (QFilter[])new QFilter[]{filter});
                if (obj != null) {
                    String checkType = obj.getString("check_type");
                    if (StringUtils.isEmpty((CharSequence)checkType)) {
                        return "1";
                    }
                    return checkType;
                }
            }
            catch (Exception e) {
                logger.info("\u83b7\u53d6\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25:" + taxNo + e.getMessage());
            }
        }
        return "1";
    }

    public static String getCompanyNameByTaxNo(String taxNo) {
        if (StringUtils.isNotEmpty((CharSequence)taxNo)) {
            try {
                QFilter filter = new QFilter("number", "=", (Object)taxNo);
                DynamicObject obj = QueryServiceHelper.queryOne((String)"bdm_enterprise_baseinfo", (String)"number,name", (QFilter[])new QFilter[]{filter});
                if (obj != null) {
                    return obj.getString("name");
                }
            }
            catch (Exception e) {
                logger.info("\u83b7\u53d6\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25:" + taxNo + e.getMessage());
            }
        }
        return "";
    }

    public static DynamicObjectCollection getAllAddrPhoneAccoutByOrgId(long orgId) {
        return TenantUtils.getAllAddrPhoneAccoutByTaxNo(TenantUtils.getTaxNoByOrgId(orgId));
    }

    public static DynamicObjectCollection getAllAddrPhoneAccoutByTaxNo(String taxNo) {
        QFilter addrFilter = new QFilter("taxno", "=", (Object)taxNo);
        String fields = "id,taxno,invoiceaddr,openuserbank,ischeck";
        return QueryServiceHelper.query((String)"sim_invoice_setting", (String)fields, (QFilter[])addrFilter.toArray(), (String)" ischeck desc");
    }

    public static Map<String, String> getDefaultAddrPhoneAccoutByOrgId(long orgId) {
        return TenantUtils.getDefaultAddrPhoneAccoutByTaxNo(TenantUtils.getTaxNoByOrgId(orgId));
    }

    public static Map<String, String> getDefaultAddrPhoneAccoutByTaxNo(String taxNo) {
        DynamicObjectCollection allAddrPhoneAccoutByTaxNo = TenantUtils.getAllAddrPhoneAccoutByTaxNo(taxNo);
        for (DynamicObject dynamicObject : allAddrPhoneAccoutByTaxNo) {
            String ischeck = dynamicObject.getString("ischeck");
            if (!StringUtils.equals((CharSequence)ischeck, (CharSequence)"1")) continue;
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("invoiceaddr", dynamicObject.getString("invoiceaddr"));
            map.put("openuserbank", dynamicObject.getString("openuserbank"));
            return map;
        }
        return null;
    }

    public static Long getUserId(String name) {
        Long userId;
        QFilter nameFilter;
        DynamicObject receiverObj;
        if (StringUtils.isNotEmpty((CharSequence)name) && (receiverObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id", (QFilter[])(nameFilter = new QFilter("name", "=", (Object)name)).toArray())) != null && !ObjectUtils.isEmpty((Object)(userId = Long.valueOf(receiverObj.getLong("id")))) && userId > 0L) {
            return userId;
        }
        return 0L;
    }

    public static boolean isSmallScaleTaxpayer(String taxNo) {
        if (StringUtils.isNotEmpty((CharSequence)taxNo)) {
            try {
                QFilter filter = new QFilter("number", "=", (Object)taxNo);
                DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bdm_enterprise_baseinfo", (String)"number,authtype,taxusername,taxpassword,company_property", (QFilter[])new QFilter[]{filter});
                if (obj != null) {
                    return "2".equals(obj.getString("company_property"));
                }
            }
            catch (Exception e) {
                logger.info("\u83b7\u53d6\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25:" + taxNo + e.getMessage());
            }
        }
        return false;
    }
}

