/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.imc.rim.common.utils.ImcConfigUtil;

public class ViewUtil {
    private static Log LOGGER = LogFactory.getLog(ViewUtil.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static void openDialog(AbstractFormPlugin plugin, Map<String, Object> customParams, String formId, String callBackKey) {
        ViewUtil.openDialog(plugin, null, customParams, formId, callBackKey);
    }

    public static void openDialog(AbstractFormPlugin plugin, String titleName, Map<String, Object> customParams, String formId, String callBackKey) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        if (!StringUtils.isEmpty((CharSequence)titleName)) {
            formShowParameter.setCaption(titleName);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (customParams != null) {
            formShowParameter.setCustomParams(customParams);
        }
        if (StringUtils.isNotBlank((CharSequence)callBackKey)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, callBackKey);
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        plugin.getView().showForm(formShowParameter);
    }

    public static void openListPage(AbstractFormPlugin plugin, QFilter qFilter, String formId, String callBackKey, boolean lookUp, boolean isMultiSelect, Object[] pkIds) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect);
        parameter.setLookUp(lookUp);
        if (pkIds != null && pkIds.length > 0) {
            parameter.setSelectedRows(pkIds);
        }
        if (qFilter != null) {
            List filters = parameter.getListFilterParameter().getQFilters();
            filters.add(qFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)callBackKey)) {
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, callBackKey));
        }
        plugin.getView().showForm((FormShowParameter)parameter);
    }

    public static void setSummaryData(AbstractFormPlugin plugin, String entryentity, Map<String, Object> map) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)plugin.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(entryentity, "setFloatButtomData", new Object[]{map});
    }

    public static void hideToolbar(AbstractFormPlugin plugin, String ... button) {
        IFormView mainView = plugin.getView().getMainView();
        if (mainView == null) {
            plugin.getView().setVisible(Boolean.FALSE, button);
        }
    }

    public static void showMessage(AbstractFormPlugin plugin, String message) {
        String[] messages = message.split(LINE_SEPARATOR);
        if (messages.length == 1) {
            plugin.getView().showTipNotification(message);
        } else {
            plugin.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            operationResult.setMessage(message);
            plugin.getView().showOperationResult(operationResult);
        }
    }

    public static void showMessageRecorded(AbstractFormPlugin plugin, String title, String message, int successNum, int failNum) {
        if (StringUtils.isNotBlank((CharSequence)message)) {
            ViewUtil.showMessage(plugin, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4%1$s", (String)"DeductOperateService_202", (String)"imc-rim-formplugin", (Object[])new Object[0]), title), message, successNum, failNum);
            if (successNum > 0) {
                title = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u63d0\u4ea4\u5165\u8d26%1$s\u6761\uff0c\u63d0\u4ea4\u5165\u8d26\u6210\u529f%2$s\u6761\uff0c\u8bf7\u524d\u5f80\u201c\u8fdb\u9879\u62b5\u6263-\u7a0e\u5c40\u7528\u7968\u64cd\u4f5c\u65e5\u5fd7\u201d\u67e5\u770b\u72b6\u6001\uff0c\u6216\u7a0d\u540e\u5237\u65b0\u8be5\u9875\u9762\u67e5\u770b\u7ed3\u679c\uff1b\u63d0\u4ea4\u5165\u8d26\u5931\u8d25%3$s\u6761", (String)"DeductOperateService_201", (String)"imc-rim-formplugin", (Object[])new Object[0]), successNum + failNum, successNum, failNum);
                plugin.getView().showSuccessNotification(title, Integer.valueOf(3000));
                ViewUtil.refresh(plugin);
            }
        } else {
            plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u524d\u5f80\u201c\u8fdb\u9879\u62b5\u6263-\u7a0e\u5c40\u7528\u7968\u64cd\u4f5c\u65e5\u5fd7\u201d\u5217\u8868 \u67e5\u770b\u5904\u7406\u65e5\u5fd7\uff0c\u6216\u7a0d\u540e\u5237\u65b0\u5f53\u524d\u9875\u9762\u67e5\u770b\u7ed3\u679c", (String)"DeductOperateService_72", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            ViewUtil.refresh(plugin);
        }
    }

    public static void showMessageSelectConfirm(AbstractFormPlugin plugin, String title, String message, int successNum, int failNum) {
        String notAllowdProgressStr = ImcConfigUtil.getValue("rim_deduction", "not_allowd_progress");
        boolean notAllowdProgress = "1".equals(notAllowdProgressStr);
        if (StringUtils.isNotBlank((CharSequence)message)) {
            ViewUtil.showMessage(plugin, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4%1$s", (String)"DeductOperateService_202", (String)"imc-rim-formplugin", (Object[])new Object[0]), title), message, successNum, failNum);
            if (successNum > 0) {
                title = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u63d0\u4ea4\u9884\u52fe\u9009%1$s\u6761\uff0c\u63d0\u4ea4\u9884\u52fe\u9009\u6210\u529f%2$s\u6761\uff0c\u8bf7\u524d\u5f80\u201c\u8fdb\u9879\u62b5\u6263-\u7a0e\u5c40\u7528\u7968\u64cd\u4f5c\u65e5\u5fd7\u201d\u67e5\u770b\u72b6\u6001\uff0c\u6216\u7a0d\u540e\u5237\u65b0\u8be5\u9875\u9762\u67e5\u770b\u7ed3\u679c\uff1b\u63d0\u4ea4\u9884\u52fe\u9009\u5931\u8d25%3$s\u6761", (String)"DeductOperateService_203", (String)"imc-rim-formplugin", (Object[])new Object[0]), successNum + failNum, successNum, failNum);
                if (org.apache.commons.lang.StringUtils.isNotBlank((String)plugin.getPageCache().get("batchNolist")) && !notAllowdProgress) {
                    ViewUtil.showDealProgress(plugin);
                } else {
                    plugin.getView().showSuccessNotification(title, Integer.valueOf(3000));
                    ViewUtil.refresh(plugin);
                }
            }
        } else if (org.apache.commons.lang.StringUtils.isNotBlank((String)plugin.getPageCache().get("batchNolist")) && !notAllowdProgress) {
            ViewUtil.showDealProgress(plugin);
        } else {
            plugin.getView().showSuccessNotification(title, Integer.valueOf(3000));
        }
    }

    public static void showMessageSelect(AbstractFormPlugin plugin, String title, String message, int successNum, int failNum) {
        String notAllowdProgressStr = ImcConfigUtil.getValue("rim_deduction", "not_allowd_progress");
        boolean notAllowdProgress = "1".equals(notAllowdProgressStr);
        if (StringUtils.isNotBlank((CharSequence)message)) {
            ViewUtil.showMessage(plugin, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4%1$s", (String)"DeductOperateService_202", (String)"imc-rim-formplugin", (Object[])new Object[0]), title), message, successNum, failNum);
            if (successNum > 0) {
                title = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u63d0\u4ea4\u52fe\u9009%1$s\u6761\uff0c\u63d0\u4ea4\u52fe\u9009\u6210\u529f%2$s\u6761\uff0c\u8bf7\u524d\u5f80\u201c\u8fdb\u9879\u62b5\u6263-\u7a0e\u5c40\u7528\u7968\u64cd\u4f5c\u65e5\u5fd7\u201d\u67e5\u770b\u72b6\u6001\uff0c\u6216\u7a0d\u540e\u5237\u65b0\u8be5\u9875\u9762\u67e5\u770b\u7ed3\u679c\uff1b\u63d0\u4ea4\u52fe\u9009\u5931\u8d25%3$s\u6761", (String)"DeductOperateService_73", (String)"imc-rim-formplugin", (Object[])new Object[0]), successNum + failNum, successNum, failNum);
                if (org.apache.commons.lang.StringUtils.isNotBlank((String)plugin.getPageCache().get("batchNolist")) && !notAllowdProgress) {
                    ViewUtil.showDealProgress(plugin);
                } else {
                    plugin.getView().showSuccessNotification(title, Integer.valueOf(3000));
                    ViewUtil.refresh(plugin);
                }
            }
        } else if (org.apache.commons.lang.StringUtils.isNotBlank((String)plugin.getPageCache().get("batchNolist")) && !notAllowdProgress) {
            ViewUtil.showDealProgress(plugin);
        } else {
            plugin.getView().showSuccessNotification(title, Integer.valueOf(3000));
            ViewUtil.refresh(plugin);
        }
    }

    private static void showDealProgress(AbstractFormPlugin plugin) {
        IPageCache pageCache = plugin.getPageCache();
        if (org.apache.commons.lang.StringUtils.isBlank((String)pageCache.get("batchNolist"))) {
            LOGGER.info("viewUtil\u2014\u2014\u6279\u6b21\u53f7\u4e3a\u7a7a");
            return;
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        FormShowParameter showParameter = new FormShowParameter();
        String batchNoListStr = pageCache.get("batchNolist");
        LOGGER.info("view-util\uff0cbatchNolist--" + batchNoListStr);
        String entityName = pageCache.get("entityName");
        String statusFieldName = pageCache.get("statusFieldName");
        String queryFields = pageCache.get("queryFields");
        String handlingStatusListStr = pageCache.get("handlingStatusList");
        String filterFieldName = pageCache.get("filterFieldName");
        customParams.put("batchNolist", batchNoListStr);
        customParams.put("entityName", entityName);
        customParams.put("statusFieldName", statusFieldName);
        customParams.put("queryFields", queryFields);
        customParams.put("handlingStatusList", handlingStatusListStr);
        customParams.put("filterFieldName", filterFieldName);
        pageCache.remove("batchNolist");
        pageCache.remove("entityName");
        pageCache.remove("statusFieldName");
        pageCache.remove("queryFields");
        pageCache.remove("handlingStatusList");
        pageCache.remove("filterFieldName");
        LOGGER.info("viewUtil-customParams", customParams);
        showParameter.setCustomParams(customParams);
        showParameter.setShowTitle(true);
        showParameter.setFormId("rim_progress_window");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "rim_progress_window");
        showParameter.setCloseCallBack(closeCallBack);
        ViewUtil.remove(plugin);
        plugin.getView().showForm(showParameter);
        ViewUtil.refresh(plugin);
    }

    private static void remove(AbstractFormPlugin plugin) {
        plugin.getView().getPageCache().remove("batchNolist");
        plugin.getView().getPageCache().remove("entityName");
        plugin.getView().getPageCache().remove("statusFieldName");
        plugin.getView().getPageCache().remove("queryFields");
        plugin.getView().getPageCache().remove("handlingStatusList");
        plugin.getView().getPageCache().remove("filterFieldName");
    }

    private static void refresh(AbstractFormPlugin plugin) {
        BillList billlist = (BillList)plugin.getControl("billlistap");
        if (billlist != null) {
            billlist.clearSelection();
            billlist.refresh();
        }
    }

    public static void showMessage(AbstractFormPlugin plugin, String title, String message, int successNum, int failNum) {
        if (StringUtils.isEmpty((CharSequence)message)) {
            plugin.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f:%1$s\u6210\u529f%2$s\u4efd", (String)"ViewUtil_0", (String)"imc-rim-common", (Object[])new Object[0]), title, successNum), Integer.valueOf(3000));
            return;
        }
        String[] messages = message.split(LINE_SEPARATOR);
        if (successNum == 0 && messages.length == 1) {
            plugin.getView().showTipNotification(message);
        } else {
            plugin.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            operationResult.setMessage("");
            for (String msg : messages) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Warning);
                errorInfo.setMessage(msg);
                errorInfo.setTitle(title);
                operationResult.addErrorInfo(errorInfo);
            }
            operationResult.setShowMessage(false);
            operationResult.setBillCount(successNum + failNum);
            ArrayList<Integer> successPkIds = new ArrayList<Integer>(successNum);
            for (int i = 0; i < successNum; ++i) {
                successPkIds.add(i);
            }
            operationResult.setSuccessPkIds(successPkIds);
            plugin.getView().showOperationResult(operationResult, title);
        }
    }
}

