/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils.extract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XmlUtil {
    public static JSONObject xml2Json(String xmlStr) throws DocumentException {
        Document doc = DocumentHelper.parseText((String)xmlStr);
        JSONObject json = new JSONObject();
        XmlUtil.dom4j2Json(doc.getRootElement(), json);
        return json;
    }

    public static void dom4j2Json(Element element, JSONObject json) {
        for (Object o : element.attributes()) {
            Attribute attr = (Attribute)o;
            if (XmlUtil.isEmpty(attr.getValue())) continue;
            json.put("@" + attr.getName(), (Object)attr.getValue());
        }
        List chdEl = element.elements();
        if (chdEl.isEmpty() && !XmlUtil.isEmpty(element.getText())) {
            json.put(element.getName(), (Object)element.getText());
        }
        for (Element e : chdEl) {
            if (!e.elements().isEmpty()) {
                JSONObject chdjson = new JSONObject();
                XmlUtil.dom4j2Json(e, chdjson);
                Object o = json.get((Object)e.getName());
                if (o != null) {
                    JSONArray jsona = null;
                    if (o instanceof JSONObject) {
                        JSONObject jsono = (JSONObject)o;
                        json.remove((Object)e.getName());
                        jsona = new JSONArray();
                        jsona.add((Object)jsono);
                        jsona.add((Object)chdjson);
                    }
                    if (o instanceof JSONArray) {
                        jsona = (JSONArray)o;
                        jsona.add((Object)chdjson);
                    }
                    json.put(e.getName(), (Object)jsona);
                    continue;
                }
                if (chdjson.isEmpty()) continue;
                json.put(e.getName(), (Object)chdjson);
                continue;
            }
            for (Object o : element.attributes()) {
                Attribute attr = (Attribute)o;
                if (XmlUtil.isEmpty(attr.getValue())) continue;
                json.put("@" + attr.getName(), (Object)attr.getValue());
            }
            if (e.getText().isEmpty()) continue;
            json.put(e.getName(), (Object)e.getText());
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty() || "null".equals(str);
    }

    public static JSONObject readXml(byte[] fileByte) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileByte);
        JSONObject obj = new JSONObject();
        try {
            SAXReader sax = new SAXReader();
            sax.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document doc = sax.read((InputStream)byteArrayInputStream);
            XmlUtil.dom4j2Json(doc.getRootElement(), obj);
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }
}

