/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.common.utils.extract;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.FileUtils;

public class ZipExtractUtil {
    private static Log logger = LogFactory.getLog(ZipExtractUtil.class);
    private static final List<String> XBRLNAME_LIST = Stream.of("inv_ord_issuer", "inv_ord_receiver", "inv_spcl_issuer", "inv_spcl_receiver").collect(Collectors.toList());

    public static JSONObject extractXbrl(byte[] fileBytes, boolean verifySign) {
        JSONObject xbrlInfo = null;
        Map<String, String> zipResult = ZipExtractUtil.extractFile(fileBytes);
        logger.info("\u89e3\u6790\u51fa\u7684\u9644\u4ef6\uff1a{}", zipResult.keySet());
        String source = "";
        for (Map.Entry<String, String> zipItem : zipResult.entrySet()) {
            for (String xbrlName : XBRLNAME_LIST) {
                if (!zipItem.getKey().contains(xbrlName)) continue;
                if (zipItem.getKey().endsWith("xml")) {
                    source = zipItem.getValue();
                    xbrlInfo = new JSONObject();
                    xbrlInfo.put("name", (Object)zipItem.getKey());
                    xbrlInfo.put("message", (Object)source);
                    continue;
                }
                if (verifySign && !zipItem.getKey().endsWith("sign")) continue;
            }
        }
        if (verifySign) {
            // empty if block
        }
        logger.info("xbrl\u89e3\u6790\u7ed3\u679c\uff1a" + xbrlInfo);
        return xbrlInfo;
    }

    public static Map<String, String> extractFile(byte[] fileBytes) {
        HashMap<String, String> result = new HashMap<String, String>();
        try (ZipInputStream in = new ZipInputStream(new ByteArrayInputStream(fileBytes));
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "utf-8"));){
            ZipEntry ze;
            while ((ze = in.getNextEntry()) != null) {
                String line;
                if (ze.isDirectory()) continue;
                while ((line = br.readLine()) != null) {
                    result.put(ze.getName(), line);
                }
            }
        }
        catch (Exception e) {
            logger.error("zip\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    public static Map<String, String> extractFileForXml(byte[] fileBytes) {
        HashMap<String, String> result = new HashMap<String, String>(1);
        try (ZipInputStream in = new ZipInputStream(new ByteArrayInputStream(fileBytes));
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));){
            ZipEntry ze;
            StringBuilder sb = new StringBuilder();
            while ((ze = in.getNextEntry()) != null) {
                String line;
                if (ze.isDirectory()) continue;
                String fileType = FileUtils.getFileType(ze.getName());
                if (!"xml".equalsIgnoreCase(fileType) && !"sign".equalsIgnoreCase(fileType)) {
                    throw new MsgException(ResManager.loadKDString((String)"\u538b\u7f29\u5305\u5185\u6587\u4ef6\u683c\u5f0f\u9519\u8bef", (String)"ZipExtractUtil_1", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                int row = 0;
                boolean flag = false;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    if ("xml".equalsIgnoreCase(fileType)) {
                        if (!flag && line != null) {
                            boolean bl = flag = line.indexOf("xbrl") > 0 || line.indexOf("EInvoice") > 0;
                        }
                        if (row > 50 && !flag) {
                            throw new MsgException(ResManager.loadKDString((String)"\u538b\u7f29\u5305\u5185\u6587\u4ef6\u5185\u5bb9\u9519\u8bef", (String)"ZipExtractUtil_2", (String)"imc-rim-common", (Object[])new Object[0]));
                        }
                    }
                    ++row;
                }
                result.put(ze.getName(), sb.toString());
            }
        }
        catch (MsgException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("zip\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    public static JSONObject extractXml(byte[] fileBytes, boolean verifySign) {
        JSONObject xmlInfo = null;
        Map<String, String> zipResult = ZipExtractUtil.extractFileForXml(fileBytes);
        logger.info("\u89e3\u6790\u51fa\u7684\u9644\u4ef6\uff1a{}", zipResult.keySet());
        if (zipResult.size() > 1) {
            return null;
        }
        String source = "";
        for (Map.Entry<String, String> zipItem : zipResult.entrySet()) {
            if (zipItem.getKey().endsWith("xml")) {
                source = zipItem.getValue();
                xmlInfo = new JSONObject();
                xmlInfo.put("name", (Object)zipItem.getKey());
                xmlInfo.put("message", (Object)source);
                continue;
            }
            if (!verifySign || !zipItem.getKey().endsWith("sign")) continue;
            String string = zipItem.getValue();
        }
        if (verifySign) {
            // empty if block
        }
        logger.info("xml\u89e3\u6790\u7ed3\u679c\uff1a" + xmlInfo);
        return xmlInfo;
    }
}

