/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.invoice.collector.InvoiceHisDataSyncService;
import kd.imc.rim.common.invoice.recognitionnew.task.handle.FileHandleService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class HisSyncDataListPlugin
extends AbstractListPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(HisSyncDataListPlugin.class);
    private String type_bill = "1";
    private String type_invoice = "2";
    private String status0 = "0";
    private String status1 = "1";
    private String status2 = "2";

    public void afterCreateNewData(EventObject e) {
        this.showMsg();
    }

    public void registerListener(EventObject e) {
        Toolbar functionToolBarLeft = (Toolbar)this.getControl("toolbarap");
        functionToolBarLeft.addUploadListener((UploadListener)this);
        functionToolBarLeft.addItemClickListener((ItemClickListener)this);
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        byte[] byt = FileUtils.getAttachmentByte((String)urls[0].toString());
        String json = null;
        try {
            json = new String(byt, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        JSONArray array = JSONArray.parseArray(json);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(1000);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            String expenseid = obj.getString("expenseId");
            String clientid = obj.getString("clientId");
            String serialNo = obj.getString("serialNo");
            if (StringUtils.isEmpty((CharSequence)clientid) || StringUtils.isEmpty((CharSequence)expenseid) && StringUtils.isEmpty((CharSequence)serialNo)) continue;
            DynamicObject dobject = BusinessDataServiceHelper.newDynamicObject((String)"rim_his_sync_data");
            dobject.set("clientid", (Object)clientid);
            dobject.set("expenseid", (Object)expenseid);
            dobject.set("serialno", (Object)serialNo);
            dobject.set("status", (Object)this.status0);
            if (StringUtils.isEmpty((CharSequence)expenseid)) {
                dobject.set("type", (Object)this.type_invoice);
            } else {
                dobject.set("type", (Object)this.type_bill);
            }
            dobject.set("modifydatefield", (Object)new Date());
            list.add(dobject);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        FileService service = FileServiceFactory.getAttachmentFileService();
        service.delete(urls[0].toString());
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u529f", (String)"HisSyncDataListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
    }

    public void itemClick(ItemClickEvent evt) {
        ListSelectedRowCollection selectCollection;
        if ("start".startsWith(evt.getItemKey())) {
            try (DLock lock = DLock.create((String)"HisSyncDataListPlugin", (String)"HisSyncDataListPlugin");){
                if (lock.tryLock()) {
                    CacheHelper.remove((String)"HisSyncDataListPlugin");
                    int times = 0;
                    int count = 1;
                    while (times < 1000 && count > 0) {
                        count = this.sync(this.type_bill);
                    }
                    times = 0;
                    count = 1;
                    while (times < 1000 && count > 0) {
                        count = this.sync(this.type_invoice);
                    }
                    this.setMsg(ResManager.loadKDString((String)"\u5904\u7406\u5b8c\u6210", (String)"HisSyncDataListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
            }
            this.refresh();
        }
        if ("stop".startsWith(evt.getItemKey())) {
            this.setMsg(ResManager.loadKDString((String)"\u505c\u6b62\u64cd\u4f5c", (String)"HisSyncDataListPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            CacheHelper.put((String)"HisSyncDataListPlugin", (String)"stop", (int)600);
        }
        if ("showmsg".equals(evt.getItemKey())) {
            this.showMsg();
            this.refresh();
        }
        if ("reset".equals(evt.getItemKey()) && (selectCollection = ((IListView)this.getView()).getSelectedRows()).size() > 0) {
            DynamicObject[] dataList;
            for (DynamicObject obj : dataList = BusinessDataServiceHelper.load((Object[])selectCollection.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_his_sync_data"))) {
                if (this.status0.equals(obj.get("status"))) continue;
                obj.set("status", (Object)this.status0);
                obj.set("modifydatefield", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])dataList);
            this.refresh();
        }
    }

    private void refresh() {
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.clearSelection();
        billlist.refresh();
    }

    private int sync(String type) {
        DynamicObjectCollection collect = this.getData(type);
        if (collect == null || collect.isEmpty()) {
            return 0;
        }
        if (this.type_bill.equals(type)) {
            for (DynamicObject obj : collect) {
                this.syncBill(obj.getLong("id"));
            }
            FileHandleService.startDownAwsFile((String)"0");
        } else {
            ArrayList<Long> id = new ArrayList<Long>(10);
            for (DynamicObject obj : collect) {
                id.add(obj.getLong("id"));
            }
            this.syncSerial(id);
        }
        return collect.size();
    }

    private void syncBill(Long id) {
        if ("stop".equals(CacheHelper.get((String)"HisSyncDataListPlugin"))) {
            this.setMsg(ResManager.loadKDString((String)"\u5f3a\u5236\u505c\u6b62", (String)"HisSyncDataListPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            throw new KDException(new ErrorCode("1001", ResManager.loadKDString((String)"\u5f3a\u5236\u505c\u6b62", (String)"HisSyncDataListPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"rim_his_sync_data");
        if (this.isContinue(obj)) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    this.setMsg(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u5355\u636e%s", (String)"HisSyncDataListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), obj.getString("expenseid")));
                    int count = InvoiceHisDataSyncService.syncExpenseInfo(null, (String)obj.getString("clientid"), (String)obj.getString("expenseid"), null);
                    obj.set("count", (Object)count);
                    obj.set("status", (Object)this.status1);
                }
                catch (KDBizException e) {
                    if ("9996".equals(e.getErrorCode())) {
                        this.deleteExpense(obj.getString("expenseid"));
                        obj.set("count", (Object)0);
                        obj.set("status", (Object)this.status1);
                    } else {
                        obj.set("status", (Object)this.status2);
                    }
                }
                catch (Throwable e) {
                    logger.info("\u5355\u636e\u540c\u6b65\u5904\u7406\u5931\u8d25{}", (Object)obj.getString("expenseid"));
                    obj.set("status", (Object)this.status2);
                }
                obj.set("modifydatefield", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
        }
    }

    private void deleteExpense(String expenseId) {
        logger.info("\u5355\u636e\u540c\u6b65\u53d1\u7968\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u5355\u636e{}", (Object)expenseId);
        QFilter resourceFilet1 = new QFilter("resource", "=", (Object)"aws");
        QFilter resourceFilet2 = new QFilter("expense_id", "=", (Object)expenseId);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id,serial_no", (QFilter[])new QFilter[]{resourceFilet1, resourceFilet2});
        ArrayList<Object> deletList = new ArrayList<Object>(collect.size());
        ArrayList<String> serialList = new ArrayList<String>(collect.size());
        for (DynamicObject object : collect) {
            deletList.add(object.get("id"));
            serialList.add(object.getString("serial_no"));
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_expense_relation"), (Object[])deletList.toArray());
        ExpenseService expenseService = new ExpenseService();
        expenseService.updateInvoiceMain(serialList, null, InvoiceSaveConstant.INVOICE_SAVE_FROM_VALUE);
    }

    private void syncSerial(List<Long> idList) {
        if ("stop".equals(CacheHelper.get((String)"HisSyncDataListPlugin"))) {
            this.setMsg(ResManager.loadKDString((String)"\u5f3a\u5236\u505c\u6b62", (String)"HisSyncDataListPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            throw new KDException(new ErrorCode("1001", ResManager.loadKDString((String)"\u5f3a\u5236\u505c\u6b62", (String)"HisSyncDataListPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        try (TXHandle h = TX.requiresNew();){
            DynamicObject[] dataList = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_his_sync_data"));
            String clietId = dataList[0].getString("clientid");
            JSONArray array = new JSONArray();
            for (DynamicObject obj : dataList) {
                array.add(obj.get("serialno"));
                obj.set("status", (Object)this.status1);
                obj.set("count", (Object)1);
                obj.set("modifydatefield", (Object)new Date());
            }
            this.setMsg(ResManager.loadKDString((String)"\u6b63\u5728\u540c\u6b65\u53d1\u7968", (String)"HisSyncDataListPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            InvoiceHisDataSyncService.syncExpenseInfo(null, (String)clietId, null, (JSONArray)array);
            SaveServiceHelper.save((DynamicObject[])dataList);
        }
    }

    private boolean isContinue(DynamicObject obj) {
        return this.status0.equals(obj.get("status"));
    }

    private DynamicObjectCollection getData(String type) {
        QFilter filter1 = new QFilter("type", "=", (Object)type);
        QFilter filter2 = new QFilter("status", "=", (Object)this.status0);
        return QueryServiceHelper.query((String)"rim_his_sync_data", (String)"clientid,expenseid,serialno,id,status,type", (QFilter[])new QFilter[]{filter1, filter2}, (String)"modifydatefield", (int)300);
    }

    private void setMsg(String msg) {
        CacheHelper.put((String)"HisSyncDataListPlugin-msg", (String)(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + msg), (int)100);
    }

    private void showMsg() {
        String msg = CacheHelper.get((String)"HisSyncDataListPlugin-msg");
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            this.getView().showTipNotification(msg, Integer.valueOf(10000));
        }
    }
}

