/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.RimPermItemEnum;
import kd.imc.rim.common.invoice.collector.InvoiceHisDataSyncService;
import kd.imc.rim.common.utils.PermissionUtils;

public class HisSyncLogListPlugin
extends AbstractListPlugin {
    public void afterCreateNewData(EventObject e) {
        if (!InvoiceHisDataSyncService.needSync()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"addnew"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u672a\u5f00\u542f\u540c\u6b65\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4\uff01", (String)"HisSyncLogListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
    }

    public void itemClick(ItemClickEvent evt) {
        if ("retry".equals(evt.getItemKey())) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.RIM_FAIL_RETRY, (String)"retry");
            ListSelectedRowCollection selectCollection = this.getSelectedRows();
            Object[] pks = selectCollection.getBillListSelectedRowCollection().getPrimaryKeyValues();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_his_sync_log");
            DynamicObject[] logList = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)mainEntityType);
            int count = 0;
            HashSet<String> set = new HashSet<String>(8);
            for (DynamicObject log : logList) {
                String status = log.getString("status");
                String clientid = log.getString("clientid");
                String dataDate = log.getString("data_date");
                if (!"0".equals(status)) continue;
                if (set.add(clientid + dataDate)) {
                    log.set("status", (Object)"2");
                    log.set("deal_times", (Object)0);
                    log.set("start_time", null);
                    log.set("end_time", null);
                    log.set("page_no", (Object)0);
                    log.set("msg", (Object)"");
                }
                ++count;
            }
            if (count > 0) {
                SaveServiceHelper.save((DynamicObject[])logList);
                InvoiceHisDataSyncService.start();
                BillList billlist = (BillList)this.getControl("billlistap");
                billlist.refresh();
            }
        } else if ("addnew".equals(evt.getItemKey())) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.RIM_MANUAL_SYNC, (String)"addnew");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("rim_his_sync");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_his_sync");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else if ("delete".equals(evt.getItemKey())) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.ITEM_DELETE, (String)"delete");
        } else if ("stop".equals(evt.getItemKey())) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.RIM_SYNC_STOP, (String)"stop");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("rim_his_sync".equals(actionId)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refresh();
        }
    }
}

