/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.ExpenseStatusEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.license.LicenseFormPlugin;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.formplugin.collector.InputDataBoardPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.Lists;

public class InputDataBoardByDBPlugin
extends LicenseFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(InputDataBoardPlugin.class);
    private static final String PIECHARTAP = "piechartap";
    private static final String PIECHARTAP1 = "piechartap1";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap1"});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadData();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        try {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d", (String)"InputDataBoardByDBPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0])));
            this.loadData();
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void loadData() {
        this.getModel().setValue("org", (Object)new Long[]{RequestContext.get().getOrgId()});
        QFilter filters = this.getqFilter();
        String fields = MetadataUtil.getFields((String)"rim_idb_detail");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_idb_detail", (String)fields, (QFilter[])filters.toArray());
        this.setInputDataCount(collection);
        this.setInputInvoiceData(collection);
    }

    private void setInputInvoiceData(DynamicObjectCollection collection) {
        if (CollectionUtils.isEmpty((Collection)collection)) {
            BarChart barChart = (BarChart)this.getControl("barchartap");
            barChart.clearData();
            barChart.refresh();
            PieChart pieChart = (PieChart)this.getControl(PIECHARTAP);
            pieChart.clearData();
            pieChart.refresh();
            PieChart pieChart1 = (PieChart)this.getControl(PIECHARTAP1);
            pieChart1.clearData();
            pieChart1.refresh();
            BarChart barChart1 = (BarChart)this.getControl("barchartap1");
            barChart1.clearData();
            barChart1.refresh();
            BarChart barChart2 = (BarChart)this.getControl("barchartap2");
            barChart2.clearData();
            barChart2.refresh();
            PieChart ratePieChart = (PieChart)this.getControl("rate_piechartap");
            ratePieChart.clearData();
            ratePieChart.refresh();
            return;
        }
        this.createInvTypeBarChart(collection);
        this.createExpenseStatusPieChart(collection);
        this.createInputTaxPieChart(collection);
        this.createTaxRatePieChart(collection);
        this.createCollectTypeBarChart(collection);
        this.createInputDeductBarChart(collection);
    }

    private void createInputDeductBarChart(DynamicObjectCollection collection) {
        BarChart barChart = (BarChart)this.getControl("barchartap2");
        barChart.clearData();
        barChart.setMargin(Position.right, "10%");
        ArrayList deductedDatas = new ArrayList(2);
        ArrayList noDeductedDatas = new ArrayList(2);
        LinkedHashSet yNames = new LinkedHashSet(2);
        Map<Long, List<DynamicObject>> deductCollect = collection.stream().filter(f -> "input_tax_amount_deduct".equals(f.getString("parent_category"))).collect(Collectors.groupingBy(x -> x.getLong("sub_category")));
        Map<Long, List<DynamicObject>> unDeductCollect = collection.stream().filter(f -> "input_tax_amount_undeduct".equals(f.getString("parent_category"))).collect(Collectors.groupingBy(x -> x.getLong("sub_category")));
        if (MapUtils.isEmpty(deductCollect) && MapUtils.isEmpty(unDeductCollect)) {
            barChart.refresh();
            return;
        }
        Arrays.stream(InputInvoiceTypeEnum.values()).filter(type -> !CollectionUtils.isEmpty((Collection)((Collection)deductCollect.get(type.getCode())))).forEach(c -> {
            yNames.add(c.getName());
            List dynamicObjects = (List)deductCollect.get(c.getCode());
            BigDecimal category_sum = dynamicObjects.stream().map(m -> m.getBigDecimal("category_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            deductedDatas.add(category_sum);
        });
        Arrays.stream(InputInvoiceTypeEnum.values()).filter(type -> !CollectionUtils.isEmpty((Collection)((Collection)unDeductCollect.get(type.getCode())))).forEach(c -> {
            List dynamicObjects = (List)unDeductCollect.get(c.getCode());
            BigDecimal category_sum = dynamicObjects.stream().map(m -> m.getBigDecimal("category_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            noDeductedDatas.add(category_sum);
        });
        boolean isShowTitle = false;
        barChart.setShowTitle(isShowTitle);
        boolean isShowTooltip = true;
        barChart.setShowTooltip(isShowTooltip);
        boolean isShowLegend = true;
        barChart.setShowLegend(isShowLegend);
        Axis y = barChart.createYAxis(ResManager.loadKDString((String)"\u7968\u79cd", (String)"InputDataBoardByDBPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), AxisType.category);
        Axis x2 = barChart.createXAxis(ResManager.loadKDString((String)"\u7a0e\u989d(\u4e07\u5143)", (String)"InputDataBoardByDBPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), AxisType.value);
        y.setPropValue("data", (Object)yNames.toArray());
        HashMap<String, Object> yAxisLabel = new HashMap<String, Object>(2);
        yAxisLabel.put("show", Boolean.TRUE);
        yAxisLabel.put("color", "#666666");
        y.setPropValue("axisLabel", yAxisLabel);
        y.setPropValue("inverse", (Object)Boolean.TRUE);
        HashMap<String, String> xNameTextStyle = new HashMap<String, String>(1);
        xNameTextStyle.put("color", "#999999");
        x2.setPropValue("nameTextStyle", xNameTextStyle);
        HashMap<String, Object> xAxisLabel = new HashMap<String, Object>(2);
        xAxisLabel.put("show", Boolean.TRUE);
        xAxisLabel.put("color", "#999999");
        x2.setPropValue("axisLabel", xAxisLabel);
        BarSeries barSeries = barChart.createBarSeries(ResManager.loadKDString((String)"\u5df2\u62b5\u6263", (String)"InputDataBoardByDBPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        barSeries.setData(deductedDatas.toArray(new Number[deductedDatas.size()]));
        barSeries.setStack(ResManager.loadKDString((String)"\u91d1\u989d", (String)"InputDataBoardByDBPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        barSeries.setBarWidth("15");
        barSeries.setColor("#40A9FF");
        Label label = new Label();
        label.setShow(false);
        barSeries.setLabel(label);
        BarSeries barSeries1 = barChart.createBarSeries(ResManager.loadKDString((String)"\u672a\u62b5\u6263", (String)"InputDataBoardByDBPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        barSeries1.setData(noDeductedDatas.toArray(new Number[noDeductedDatas.size()]));
        barSeries1.setStack(ResManager.loadKDString((String)"\u91d1\u989d", (String)"InputDataBoardByDBPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        barSeries1.setBarWidth("15");
        barSeries1.setColor("#FFC53D");
        barSeries1.setLabel(label);
        HashMap<String, String> textStyle = new HashMap<String, String>(1);
        textStyle.put("color", "#666666");
        barChart.setLegendPropValue("textStyle", textStyle);
        barChart.setLegendPropValue("top", (Object)"42");
        Boolean show = Boolean.FALSE;
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(2);
        axisTick.put("show", show);
        y.setPropValue("axisTick", axisTick);
        HashMap<String, Boolean> splitLine = new HashMap<String, Boolean>(2);
        splitLine.put("show", show);
        y.setPropValue("splitLine", splitLine);
        barChart.refresh();
    }

    private void createTaxRatePieChart(DynamicObjectCollection collection) {
        Map<String, List<DynamicObject>> collect = collection.stream().filter(f -> "input_tax_rate".equals(f.getString("parent_category"))).collect(Collectors.groupingBy(x -> x.getString("sub_category")));
        ArrayList itemValueList = Lists.newArrayList();
        for (Map.Entry<String, List<DynamicObject>> entry : collect.entrySet()) {
            String rate = entry.getKey();
            String rateStr = "";
            BigDecimal rateDecimal = new BigDecimal(rate);
            if (!BigDecimal.ZERO.toString().equals(rate)) {
                rateStr = rateDecimal.multiply(new BigDecimal(100)).setScale(1, 4).toString();
                rateStr = "0.0".equals(rateStr) ? ResManager.loadKDString((String)"0\u7a0e\u7387", (String)"InputDataBoardByDBPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]) : rateStr.concat("%");
            }
            List<DynamicObject> numList = entry.getValue();
            BigDecimal rateNum = numList.stream().map(c -> c.getBigDecimal("category_sum")).reduce(BigDecimal.ZERO, BigDecimal::add);
            ItemValue itemValue = new ItemValue(rateStr, (Number)rateNum);
            itemValueList.add(itemValue);
        }
        if (!CollectionUtils.isEmpty((Collection)itemValueList)) {
            this.createPieChart("rate_piechartap", itemValueList.toArray(new ItemValue[0]), ResManager.loadKDString((String)"\u7a0e\u7387", (String)"InputDataBoardByDBPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    private void createInputTaxPieChart(DynamicObjectCollection collection) {
        List parentCategoryList = collection.stream().filter(f -> "input_tax_amount".equals(f.getString("parent_category"))).collect(Collectors.toList());
        BigDecimal vatInputTaxAmount = parentCategoryList.stream().filter(c -> "vat_tax_amount".equals(c.getString("sub_category"))).map(c -> c.getBigDecimal("category_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        ItemValue[] itemValues = new ItemValue[5];
        itemValues[0] = new ItemValue(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"InputDataBoardByDBPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), (Number)vatInputTaxAmount, "#40A9FF");
        BigDecimal transTaxAmount = parentCategoryList.stream().filter(c -> "trans_tax_amount".equals(c.getString("sub_category"))).map(c -> c.getBigDecimal("category_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        itemValues[2] = new ItemValue(ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93", (String)"InputDataBoardByDBPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), (Number)transTaxAmount, "#FFC53D");
        BigDecimal tollTaxAmount = parentCategoryList.stream().filter(c -> "toll_tax_amount".equals(c.getString("sub_category"))).map(c -> c.getBigDecimal("category_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        itemValues[1] = new ItemValue(ResManager.loadKDString((String)"\u901a\u884c\u8d39\u53d1\u7968", (String)"InputDataBoardByDBPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), (Number)tollTaxAmount, "#73D13D");
        BigDecimal motorTaxAmount = parentCategoryList.stream().filter(c -> "motor_tax_amount".equals(c.getString("sub_category"))).map(c -> c.getBigDecimal("category_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        itemValues[4] = new ItemValue(ResManager.loadKDString((String)"\u673a\u52a8\u8f66\u53d1\u7968", (String)"InputDataBoardByDBPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]), (Number)motorTaxAmount, "#45DAD1");
        BigDecimal hgjksTaxAmount = parentCategoryList.stream().filter(c -> "hgjks_tax_amount".equals(c.getString("sub_category"))).map(c -> c.getBigDecimal("category_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        itemValues[3] = new ItemValue(ResManager.loadKDString((String)"\u6d77\u5173\u7f34\u6b3e\u4e66", (String)"InputDataBoardByDBPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), (Number)hgjksTaxAmount, "#6682F5");
        this.createPieChart(PIECHARTAP1, itemValues, ResManager.loadKDString((String)"\u91d1\u989d\uff08\u4e07\u5143\uff09", (String)"InputDataBoardByDBPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
    }

    private void createExpenseStatusPieChart(DynamicObjectCollection collection) {
        Map<String, List<DynamicObject>> groupByExpenseStatus = collection.stream().filter(c -> "expense_status_count".equals(c.getString("parent_category"))).collect(Collectors.groupingBy(x -> x.getString("sub_category")));
        if (MapUtils.isEmpty(groupByExpenseStatus)) {
            return;
        }
        AtomicInteger notReimbursedCnt = new AtomicInteger(0);
        AtomicInteger underReviewCnt = new AtomicInteger(0);
        AtomicInteger reimbursedCnt = new AtomicInteger(0);
        AtomicInteger recordedCnt = new AtomicInteger(0);
        Arrays.stream(ExpenseStatusEnum.values()).forEach(c -> {
            int count = 0;
            List dynamicObjects = (List)groupByExpenseStatus.get(c.getCode());
            if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                BigDecimal categorySum = dynamicObjects.stream().map(m -> m.getBigDecimal("category_sum")).reduce(BigDecimal.ZERO, BigDecimal::add);
                count = categorySum.intValue();
            }
            if (StringUtils.equals((CharSequence)c.getCode(), (CharSequence)ExpenseStatusEnum.NOT_REIMBURSED.getCode())) {
                notReimbursedCnt.set(count);
            } else if (StringUtils.equals((CharSequence)c.getCode(), (CharSequence)ExpenseStatusEnum.UNDER_REVIEW.getCode())) {
                underReviewCnt.set(count);
            } else if (StringUtils.equals((CharSequence)c.getCode(), (CharSequence)ExpenseStatusEnum.REIMBURSED.getCode())) {
                reimbursedCnt.set(count);
            } else if (StringUtils.equals((CharSequence)c.getCode(), (CharSequence)ExpenseStatusEnum.RECORDED.getCode())) {
                recordedCnt.set(count);
            }
        });
        ItemValue[] itemValues = new ItemValue[]{new ItemValue(ExpenseStatusEnum.NOT_REIMBURSED.getName(), (Number)notReimbursedCnt.get(), "#40A9FF"), new ItemValue(ExpenseStatusEnum.UNDER_REVIEW.getName(), (Number)underReviewCnt.get(), "#73D13D"), new ItemValue(ExpenseStatusEnum.REIMBURSED.getName(), (Number)reimbursedCnt.get(), "#FFC53D"), new ItemValue(ExpenseStatusEnum.RECORDED.getName(), (Number)recordedCnt.get(), "#6682F5")};
        this.createPieChart(PIECHARTAP, itemValues, ResManager.loadKDString((String)"\u6570\u91cf\uff08\u5f20\uff09", (String)"InputDataBoardByDBPlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]));
    }

    private QFilter getqFilter() {
        List<String> orgList = this.getOrgList();
        QFilter filters = new QFilter("org", "in", orgList);
        String statisticsType = (String)this.getModel().getValue("statistics_type");
        String filed = "finvoice_date";
        switch (statisticsType) {
            case "1": {
                filed = "finvoice_date";
                break;
            }
            case "2": {
                filed = "fcreatetime";
                break;
            }
            case "3": {
                filed = "fauthenticate_time";
            }
        }
        filters.and("query_type", "=", (Object)filed);
        this.setDateRange(filters);
        return filters;
    }

    private void createCollectTypeBarChart(DynamicObjectCollection collection) {
        BarChart barChart = (BarChart)this.getControl("barchartap1");
        barChart.clearData();
        barChart.setMargin(Position.right, "8%");
        ArrayList invoiceDatas = new ArrayList(2);
        ArrayList yNames = new ArrayList(2);
        Map<String, List<DynamicObject>> groupByCollectType = collection.stream().filter(c -> "input_collect_type".equals(c.getString("parent_category"))).collect(Collectors.groupingBy(x -> x.getString("sub_category")));
        Arrays.stream(CollectTypeEnum.values()).forEach(c -> {
            if (CollectionUtils.isEmpty((Collection)((Collection)groupByCollectType.get(c.getCode())))) {
                return;
            }
            yNames.add(c.getName());
            List dynamicObjects = (List)groupByCollectType.get(c.getCode());
            BigDecimal category_sum = dynamicObjects.stream().map(m -> m.getBigDecimal("category_sum")).reduce(BigDecimal.ZERO, BigDecimal::add);
            invoiceDatas.add(category_sum);
        });
        boolean isShowTitle = false;
        barChart.setShowTitle(isShowTitle);
        boolean isShowTooltip = true;
        barChart.setShowTooltip(isShowTooltip);
        Axis y = barChart.createYAxis(ResManager.loadKDString((String)"\u91c7\u96c6\u65b9\u5f0f", (String)"InputDataBoardByDBPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), AxisType.category);
        Axis x2 = barChart.createXAxis(ResManager.loadKDString((String)"\u7968\u6b21(\u5f20)", (String)"InputDataBoardByDBPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]), AxisType.value);
        y.setPropValue("data", (Object)yNames.toArray());
        HashMap<String, Object> yAxisLabel = new HashMap<String, Object>(2);
        yAxisLabel.put("show", Boolean.TRUE);
        yAxisLabel.put("color", "#666666");
        y.setPropValue("axisLabel", yAxisLabel);
        y.setPropValue("inverse", (Object)Boolean.TRUE);
        HashMap<String, String> xNameTextStyle = new HashMap<String, String>(1);
        xNameTextStyle.put("color", "#999999");
        x2.setPropValue("nameTextStyle", xNameTextStyle);
        HashMap<String, Object> xAxisLabel = new HashMap<String, Object>(2);
        xAxisLabel.put("show", Boolean.TRUE);
        xAxisLabel.put("color", "#999999");
        x2.setPropValue("axisLabel", xAxisLabel);
        BarSeries barSeries = barChart.createBarSeries(ResManager.loadKDString((String)"\u6570\u91cf", (String)"InputDataBoardByDBPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        barSeries.setData(invoiceDatas.toArray(new Number[invoiceDatas.size()]));
        barSeries.setBarWidth("15");
        barSeries.setColor("#6682F5");
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.right);
        label.setColor("#666666");
        barSeries.setLabel(label);
        Boolean show = Boolean.FALSE;
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(2);
        axisTick.put("show", show);
        y.setPropValue("axisTick", axisTick);
        HashMap<String, Boolean> splitLine = new HashMap<String, Boolean>(2);
        splitLine.put("show", show);
        y.setPropValue("splitLine", splitLine);
        barChart.refresh();
    }

    private void createInvTypeBarChart(DynamicObjectCollection collection) {
        BarChart barChart = (BarChart)this.getControl("barchartap");
        barChart.clearData();
        ArrayList invoiceDatas = new ArrayList(2);
        ArrayList xNames = new ArrayList(2);
        Map<Long, List<DynamicObject>> groupByInvoiceType = collection.stream().filter(f -> "invoice_type_count".equals(f.getString("parent_category"))).collect(Collectors.groupingBy(x -> x.getLong("sub_category")));
        Arrays.stream(InputInvoiceTypeEnum.values()).forEach(c -> {
            if (CollectionUtils.isEmpty((Collection)((Collection)groupByInvoiceType.get(c.getCode())))) {
                return;
            }
            xNames.add(this.splitString(c.getName()));
            List dynamicObjects = (List)groupByInvoiceType.get(c.getCode());
            BigDecimal category_sum = dynamicObjects.stream().map(m -> m.getBigDecimal("category_sum")).reduce(BigDecimal.ZERO, BigDecimal::add);
            invoiceDatas.add(category_sum);
        });
        boolean isShowTitle = false;
        barChart.setShowTitle(isShowTitle);
        boolean isShowTooltip = true;
        barChart.setShowTooltip(isShowTooltip);
        Axis x2 = barChart.createXAxis(ResManager.loadKDString((String)"\u7968\u79cd", (String)"InputDataBoardByDBPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), AxisType.category);
        Axis y = barChart.createYAxis(ResManager.loadKDString((String)"\u6570\u91cf(\u5f20)", (String)"InputDataBoardByDBPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]), AxisType.value);
        x2.setPropValue("data", (Object)xNames.toArray());
        HashMap<String, Object> xAxisLabel = new HashMap<String, Object>(2);
        xAxisLabel.put("show", Boolean.TRUE);
        xAxisLabel.put("color", "#999999");
        x2.setPropValue("axisLabel", xAxisLabel);
        HashMap<String, String> yNameTextStyle = new HashMap<String, String>(1);
        yNameTextStyle.put("color", "#999999");
        y.setPropValue("nameTextStyle", yNameTextStyle);
        HashMap<String, Object> yAxisLabel = new HashMap<String, Object>(2);
        yAxisLabel.put("show", Boolean.TRUE);
        yAxisLabel.put("color", "#999999");
        y.setPropValue("axisLabel", yAxisLabel);
        BarSeries barSeries = barChart.createBarSeries(ResManager.loadKDString((String)"\u6570\u91cf", (String)"InputDataBoardByDBPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        barSeries.setData(invoiceDatas.toArray(new Number[invoiceDatas.size()]));
        barSeries.setBarWidth("30");
        Label label = new Label();
        label.setShow(false);
        barSeries.setLabel(label);
        Boolean show = Boolean.FALSE;
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(2);
        axisTick.put("show", show);
        x2.setPropValue("axisTick", axisTick);
        HashMap<String, Boolean> splitLine = new HashMap<String, Boolean>(2);
        splitLine.put("show", show);
        x2.setPropValue("splitLine", splitLine);
        barChart.refresh();
    }

    private void createPieChart(String pieFlag, ItemValue[] itemValues, String unit) {
        PieChart pieChart = (PieChart)this.getControl(pieFlag);
        pieChart.clearData();
        boolean isShowTitle = false;
        boolean isShowTooltip = true;
        pieChart.setShowTitle(isShowTitle);
        pieChart.setShowTooltip(isShowTooltip);
        pieChart.setShowLegend(isShowTooltip);
        pieChart.setLegendAlign(XAlign.right, YAlign.center);
        pieChart.setMargin(Position.right, "80px");
        pieChart.setMargin(Position.top, "60px");
        pieChart.setLegendPropValue("orient", (Object)"vertical");
        pieChart.setLegendPropValue("icon", (Object)"circle");
        pieChart.setLegendPropValue("left", (Object)"65%");
        HashMap<String, String> textStyle = new HashMap<String, String>(1);
        textStyle.put("color", "#666666");
        pieChart.setLegendPropValue("textStyle", textStyle);
        HashMap<String, String> itemStyle = new HashMap<String, String>(1);
        itemStyle.put("borderWidth", "5");
        pieChart.setLegendPropValue("itemStyle", itemStyle);
        PieSeries pieSeries = pieChart.createPieSeries(unit);
        pieSeries.setRadius("60%");
        pieSeries.setCenter("42%", "46%");
        pieSeries.setData(itemValues);
        Label pieLabel = new Label();
        pieLabel.setShow(true);
        pieLabel.setPosition(Position.top);
        pieLabel.setFormatter("{d}%");
        pieSeries.setLabel(pieLabel);
        pieChart.refresh();
    }

    private String splitString(String value) {
        StringBuilder ret = new StringBuilder();
        int maxLength = 4;
        double valLength = value.length();
        double rowN = valLength / (double)maxLength;
        if (rowN > 1.0) {
            int i = 0;
            while ((double)i < rowN) {
                String temp = "";
                int start = i * maxLength;
                int end = start + maxLength;
                if ((double)end > valLength) {
                    end = (int)valLength;
                }
                temp = value.substring(start, end) + "\n";
                ret.append(temp);
                ++i;
            }
            return ret.toString();
        }
        return value;
    }

    private void setDateRange(QFilter filters) {
        String radioGroup = (String)this.getModel().getValue("radiogroup");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)radioGroup)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            filters.and("deal_time", ">=", (Object)calendar.getTime());
            filters.and("deal_time", "<=", (Object)new Date());
        } else if (StringUtils.equals((CharSequence)"2", (CharSequence)radioGroup)) {
            filters.and("deal_time", ">=", (Object)DateUtils.getFirstDayOfWeek());
            filters.and("deal_time", "<=", (Object)DateUtils.getLastDayOfWeek());
        } else if (StringUtils.equals((CharSequence)"3", (CharSequence)radioGroup)) {
            filters.and("deal_time", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)new Date()));
            filters.and("deal_time", "<=", (Object)DateUtils.getLastDateOfMonth((Date)new Date()));
        } else if (StringUtils.equals((CharSequence)"4", (CharSequence)radioGroup)) {
            filters.and("deal_time", ">=", (Object)DateUtils.getFirstDateOfThreeMonth((Date)new Date()));
            filters.and("deal_time", "<=", (Object)new Date());
        } else if (StringUtils.equals((CharSequence)"5", (CharSequence)radioGroup)) {
            Date beginDate = (Date)this.getModel().getValue("begin_date");
            Date endDate = (Date)this.getModel().getValue("end_date");
            Calendar calendar = Calendar.getInstance();
            if (endDate != null) {
                calendar.setTime(endDate);
            }
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 59);
            filters.and("deal_time", ">=", (Object)beginDate);
            filters.and("deal_time", "<=", (Object)calendar.getTime());
        }
    }

    private void setInputDataCount(DynamicObjectCollection collection) {
        if (CollectionUtils.isEmpty((Collection)collection)) {
            this.setInputDataCountZero();
            return;
        }
        BigDecimal invoiceSum = collection.stream().filter(f -> "invoice_sum".equals(f.getString("sub_category"))).map(c -> c.getBigDecimal("category_sum")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("total_inv_count", (Object)invoiceSum.longValue());
        BigDecimal attachSum = collection.stream().filter(f -> "attach_sum".equals(f.getString("sub_category"))).map(c -> c.getBigDecimal("category_sum")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("total_attach_count", (Object)attachSum.longValue());
        BigDecimal totalVatCount = collection.stream().filter(f -> "vat_sum".equals(f.getString("sub_category"))).map(c -> c.getBigDecimal("category_sum")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("total_vat_count", (Object)totalVatCount.longValue());
        BigDecimal totalNonVatCount = collection.stream().filter(f -> "un_vat_sum".equals(f.getString("sub_category"))).map(c -> c.getBigDecimal("category_sum")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("total_non_vat_count", (Object)totalNonVatCount.longValue());
        BigDecimal totalAmount = collection.stream().filter(f -> "total_amount_sum".equals(f.getString("sub_category"))).map(c -> c.getBigDecimal("category_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("total_amount", (Object)this.formatAmount(totalAmount, 2));
        BigDecimal totalDeductionAmount = collection.stream().filter(f -> "total_tax_amount_sum".equals(f.getString("sub_category"))).map(c -> c.getBigDecimal("category_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("total_deduction_amount", (Object)this.formatAmount(totalDeductionAmount, 2));
    }

    private List<String> getOrgList() {
        ArrayList<String> orgList = new ArrayList<String>();
        DynamicObjectCollection orgCollection = (DynamicObjectCollection)this.getModel().getValue("org");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orgCollection)) {
            for (int i = 0; i < orgCollection.size(); ++i) {
                orgList.add(((DynamicObject)orgCollection.get(i)).getLong("fbasedataid_id") + "");
            }
        } else {
            orgList.add(RequestContext.get().getOrgId() + "");
        }
        return orgList;
    }

    private List<String> queryAttachIds(List<Long> orgIds, List<String> serialNos) {
        QFilter expFilter = new QFilter("orgid", "in", orgIds);
        DynamicObjectCollection expCollection = QueryServiceHelper.query((String)"rim_expense", (String)"expense_id", (QFilter[])expFilter.toArray());
        List expenseIds = expCollection.stream().map(c -> c.getString("expense_id")).collect(Collectors.toList());
        QFilter relFilter1 = new QFilter("expense_id", "in", expenseIds);
        relFilter1.and("relation_type", "in", Arrays.asList("1", "2"));
        DynamicObjectCollection relCollection1 = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id", (QFilter[])relFilter1.toArray());
        QFilter relFilter2 = new QFilter("relation_id", "in", serialNos);
        relFilter2.and("relation_type", "in", Arrays.asList("1", "2"));
        DynamicObjectCollection relCollection2 = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id", (QFilter[])relFilter2.toArray());
        List attachIds1 = relCollection1.stream().map(c -> c.getString("attach_id")).collect(Collectors.toList());
        List attachIds2 = relCollection2.stream().map(c -> c.getString("attach_id")).collect(Collectors.toList());
        attachIds1.addAll(attachIds2);
        return attachIds1.stream().distinct().collect(Collectors.toList());
    }

    private void setInputDataCountZero() {
        this.getModel().setValue("total_inv_count", (Object)0);
        this.getModel().setValue("total_attach_count", (Object)0);
        this.getModel().setValue("total_vat_count", (Object)0);
        this.getModel().setValue("total_non_vat_count", (Object)0);
        this.getModel().setValue("total_amount", (Object)BigDecimal.ZERO);
        this.getModel().setValue("total_deduction_amount", (Object)BigDecimal.ZERO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        String radioGroup = (String)this.getModel().getValue("radiogroup");
        Date beginDate = (Date)this.getModel().getValue("begin_date");
        Date endDate = (Date)this.getModel().getValue("end_date");
        QFilter filters = this.getqFilter();
        String fields = MetadataUtil.getFields((String)"rim_idb_detail");
        try {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d", (String)"InputDataBoardByDBPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0])));
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_idb_detail", (String)fields, (QFilter[])filters.toArray());
            if (StringUtils.equals((CharSequence)"org", (CharSequence)fieldKey)) {
                DynamicObjectCollection orgCollection = (DynamicObjectCollection)this.getModel().getValue("org");
                if (orgCollection == null || orgCollection.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InputDataBoardByDBPlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.setInputDataCount(collection);
                this.setInputInvoiceData(collection);
                return;
            } else if (StringUtils.equals((CharSequence)"radiogroup", (CharSequence)fieldKey)) {
                if (StringUtils.equals((CharSequence)"5", (CharSequence)radioGroup)) return;
                this.getModel().setValue("begin_date", null);
                this.getModel().setValue("end_date", null);
                this.setInputDataCount(collection);
                this.setInputInvoiceData(collection);
                return;
            } else if (Arrays.asList("begin_date", "end_date").contains(fieldKey) && beginDate != null && endDate != null) {
                this.getModel().setValue("radiogroup", (Object)"5");
                this.setInputDataCount(collection);
                this.setInputInvoiceData(collection);
                return;
            } else {
                if (!StringUtils.equals((CharSequence)"statistics_type", (CharSequence)fieldKey)) return;
                this.setInputDataCount(collection);
                this.setInputInvoiceData(collection);
            }
            return;
        }
        finally {
            this.getView().hideLoading();
        }
    }

    public BigDecimal formatAmount(BigDecimal amount, int scaleLength) {
        if (amount == null) {
            return BigDecimal.ZERO;
        }
        return amount.divide(new BigDecimal(10000), scaleLength, 4);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"rim_input_data_board", (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            QFilter idQFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            ListShowParameter formShowParameter = (ListShowParameter)arg0.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(idQFilter);
        }
    }
}

