/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.cache.PageCache;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.verify.VerifyUtil;

public class InvoiceCollectCheckFailPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String invoiceEditPage = "rim_inv_collect_edit";
    private static final String checkfailList = "checkfail_list";
    private static final String OPERATE_EDIT = "edit";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(checkfailList);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        Toolbar toolbarap = (Toolbar)this.getControl("toolbarap");
        toolbarap.addItemClickListener((ItemClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getEntryEntity(checkfailList).get(arg0.getRowIndex());
        String invoice = dynamicObject.getString("invoice_json");
        FormShowParameter showParameter = this.newEditPage(invoice, arg0.getRowIndex(), "editCallback");
        this.getView().showForm(showParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        if ("invoice_edit".equals(evt.getItemKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(checkfailList);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e!", (String)"InvoiceCollectCheckFailPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getEntryEntity(checkfailList).get(selectRows[0]);
            String invoice = dynamicObject.getString("invoice_json");
            FormShowParameter showParameter = this.newEditPage(invoice, selectRows[0], "editCallback");
            this.getView().showForm(showParameter);
        } else if ("invoice_del".equals(evt.getItemKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(checkfailList);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e!", (String)"InvoiceCollectCheckFailPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            this.getModel().deleteEntryRows(checkfailList, selectRows);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u529f\u80fd\u5f00\u53d1\u4e2d\u3002\u3002\u3002", (String)"InvoiceCollectCheckFailPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map callBackData = (Map)closedCallBackEvent.getReturnData();
        if (null != callBackData && "editCallback".equals(closedCallBackEvent.getActionId())) {
            Map customParams;
            int row = (Integer)callBackData.get("row");
            JSONObject invoice = (JSONObject)callBackData.get("invoice");
            Long invoiceType = invoice.getLong("invoiceType");
            String serialNo = invoice.getString("serialNo");
            ArrayList serialNos = Lists.newArrayList();
            serialNos.add(serialNo);
            JSONObject customParam = new JSONObject();
            PageCache pageCache = new PageCache(this.getView().getParentView().getPageId());
            String businessParamCache = pageCache.get("customParam");
            if (businessParamCache != null) {
                customParam = JSON.parseObject((String)businessParamCache);
            }
            boolean needUserRelation = !"0".equals((customParams = this.getView().getFormShowParameter().getCustomParams()).get("needUserRelation") + "");
            JSONArray verifyInvoiceArray = VerifyUtil.verifyBySerialNos((Map)customParam, (List)serialNos, (boolean)true);
            for (int i = 0; i < verifyInvoiceArray.size(); ++i) {
                String level = verifyInvoiceArray.getJSONObject(i).getString("errorLevel");
                VerifyUtil.updateDataStatus((String)level, (String)serialNo, (Long)invoiceType, (Boolean)Boolean.TRUE, (boolean)needUserRelation);
            }
            if (InputInvoiceTypeEnum.needCheck((Long)invoiceType).booleanValue()) {
                if ("1".equals(invoice.getString("checkStatus"))) {
                    this.getModel().deleteEntryRow(checkfailList, row);
                    this.handleSuccessInvoice(invoice);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25", (String)"InvoiceCollectCheckFailPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    String oldSerialNo = "";
                    Object oldSerialNoObj = callBackData.get("oldSerialNo");
                    if (oldSerialNoObj != null) {
                        oldSerialNo = oldSerialNoObj.toString();
                    }
                    this.refreshInvoice(invoice, row);
                }
            } else {
                this.getModel().deleteEntryRow(checkfailList, row);
                this.handleSuccessInvoice(invoice);
            }
        }
    }

    private void handleSuccessInvoice(JSONObject invoice) {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"InvoiceCollectCheckFailPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        JSONArray successInvoiceArray = new JSONArray();
        if (null != this.getPageCache().get("successInvoiceArray")) {
            successInvoiceArray = JSON.parseArray((String)this.getPageCache().get("successInvoiceArray"));
        }
        boolean successRepeat = false;
        for (int i = 0; i < successInvoiceArray.size(); ++i) {
            if (!invoice.getString("serialNo").equals(successInvoiceArray.getJSONObject(i).getString("serialNo"))) continue;
            successRepeat = true;
            break;
        }
        if (!successRepeat) {
            successInvoiceArray.add((Object)invoice);
        }
        this.getPageCache().put("successInvoiceArray", successInvoiceArray.toJSONString());
    }

    public void afterCreateNewData(EventObject e) {
        this.initView();
    }

    private void initView() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray checkFailArray = JSONObject.parseArray((String)customParams.get("checkFailArray").toString());
        int size = checkFailArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject checkFail = checkFailArray.getJSONObject(i);
            int row = this.getModel().createNewEntryRow(checkfailList);
            this.getModel().setValue("invoicetype", (Object)InputInvoiceTypeEnum.getInvoiceType((Long)checkFail.getLong("invoiceType")).getName(), row);
            if (checkFail.getString("invoiceCode") == null) {
                this.getModel().setValue("invoicecode", (Object)"", row);
            } else {
                this.getModel().setValue("invoicecode", (Object)checkFail.getString("invoiceCode"), row);
            }
            this.getModel().setValue("invoiceno", (Object)checkFail.getString("invoiceNo"), row);
            this.getModel().setValue("invoicedate", (Object)checkFail.getDate("invoiceDate"), row);
            this.getModel().setValue("invoiceamount", (Object)checkFail.getString("invoiceAmount"), row);
            this.getModel().setValue("checkcode", (Object)checkFail.getString("checkCode"), row);
            String desc = CheckContant.getCheckResultDesc((String)checkFail.getString("errcode"));
            if (StringUtils.isEmpty((String)desc)) {
                desc = checkFail.getString("description");
            }
            this.getModel().setValue("checkdescription", (Object)desc, row);
            if (StringUtils.isEmpty((String)checkFail.getString("serialNo"))) {
                this.getModel().setValue("checkdescription", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u5fc5\u8981\u5b57\u6bb5\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvoiceCollectCheckFailPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), row);
            }
            checkFail.put("resource", (Object)"\u6536\u7968\u7ba1\u7406");
            this.getModel().setValue("invoice_json", (Object)checkFail.toJSONString(), row);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        HashMap<String, JSONArray> customParams = new HashMap<String, JSONArray>(1);
        JSONArray checkFailArray = new JSONArray();
        int count = this.getModel().getEntryRowCount(checkfailList);
        for (int i = 0; i < count; ++i) {
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getEntryEntity(checkfailList).get(i);
            JSONObject checkfailInvoice = JSONObject.parseObject((String)dynamicObject.getString("invoice_json"));
            checkFailArray.add((Object)checkfailInvoice);
        }
        customParams.put("checkFailArray", checkFailArray);
        JSONArray successInvoiceArray = new JSONArray();
        if (null != this.getPageCache().get("successInvoiceArray")) {
            successInvoiceArray = JSON.parseArray((String)this.getPageCache().get("successInvoiceArray"));
        }
        customParams.put("successInvoiceArray", successInvoiceArray);
        this.getView().returnDataToParent(customParams);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (OPERATE_EDIT.equals(operateKey)) {
            int index = this.getModel().getEntryCurrentRowIndex(checkfailList);
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(checkfailList, index);
            String invoice = dynamicObject.getString("invoice_json");
            FormShowParameter showParameter = this.newEditPage(invoice, index, "editCallback");
            this.getView().showForm(showParameter);
        }
    }

    private FormShowParameter newEditPage(String invoice, int row, String callBackId) {
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("invoice", invoice);
        customParams.put("row", row);
        customParams.put("editAllow", Boolean.TRUE);
        showParameter.setShowTitle(true);
        showParameter.setCustomParams(customParams);
        showParameter.setFormId(invoiceEditPage);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotEmpty((String)callBackId)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, callBackId);
            showParameter.setCloseCallBack(closeCallBack);
        }
        return showParameter;
    }

    private void refreshInvoice(JSONObject invoice, int row) {
        this.getModel().setValue("invoicetype", (Object)InputInvoiceTypeEnum.getInvoiceType((Long)invoice.getLong("invoiceType")).getName(), row);
        this.getModel().setValue("invoicecode", (Object)invoice.getString("invoiceCode"), row);
        this.getModel().setValue("invoiceno", (Object)invoice.getString("invoiceNo"), row);
        this.getModel().setValue("invoicedate", (Object)invoice.getDate("invoiceDate"), row);
        this.getModel().setValue("invoiceamount", (Object)invoice.getString("invoiceAmount"), row);
        this.getModel().setValue("checkcode", (Object)invoice.getString("checkCode"), row);
        this.getModel().setValue("checkdescription", (Object)CheckContant.getCheckResultDesc((String)invoice.getString("errcode")), row);
        if (StringUtils.isEmpty((String)invoice.getString("serialNo"))) {
            this.getModel().setValue("checkdescription", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u5fc5\u8981\u5b57\u6bb5\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvoiceCollectCheckFailPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), row);
        }
        invoice.put("resource", (Object)"\u6536\u7968\u7ba1\u7406");
        this.getModel().setValue("invoice_json", (Object)invoice.toJSONString(), row);
    }
}

