/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.multitenant.service.impl.InvoiceCollectServiceAdapter;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.InvoiceConvertUtils;

public class InvoiceCollectEnterPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(InvoiceCollectEnterPlugin.class);
    private static final String submitButton = "submitbutton";
    private static final String cancelButton = "cancelbutton";
    private InvoiceCollectServiceAdapter invoiceCollectService = new InvoiceCollectServiceAdapter();

    public void registerListener(EventObject e) {
        Button submitbutton = (Button)this.getControl(submitButton);
        submitbutton.addClickListener((ClickListener)this);
        Button cancelbutton = (Button)this.getControl(cancelButton);
        cancelbutton.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initView();
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (cancelButton.equals(control.getKey())) {
            this.getView().close();
        } else if (submitButton.equals(control.getKey())) {
            JSONObject checkResult = this.checkInvoice();
            if (!"0000".equals(checkResult.getString("errcode"))) {
                String desc = checkResult.getString("description");
                if (desc.contains("\u7f16\u8f91\u6309\u94ae")) {
                    desc = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u5b57\u6bb5\u662f\u5426\u6b63\u786e", (String)"InvoiceCollectEnterPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25\uff01%1$s", (String)"InvoiceCollectEnterPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), desc));
            } else {
                HashMap<String, Object> customParams = new HashMap<String, Object>(1);
                JSONObject invoice = checkResult.getJSONObject("data");
                ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
                if (StringUtils.isNotEmpty((CharSequence)checkResult.getString("mainId"))) {
                    invoiceIds.add(checkResult.getLong("mainId"));
                    invoice.put("mainId", (Object)checkResult.getString("mainId"));
                }
                customParams.put("invoice", invoice);
                customParams.put("invoiceIds", invoiceIds);
                customParams.put("repeat", checkResult.getBoolean("repeat"));
                this.getView().returnDataToParent(customParams);
                this.getView().close();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (("invoicecode".equals(propertyName) || "invoiceno".equals(propertyName)) && this.getModel().getValue("invoicecode") != null && this.getModel().getValue("invoiceno") != null) {
            String invoiceCode = this.getModel().getValue("invoicecode").toString();
            String invoiceNo = this.getModel().getValue("invoiceno").toString();
            if (invoiceNo.length() == 20) {
                this.initElectricView();
            } else {
                String invoiceType = InvoiceConvertUtils.checkInvoiceType((String)invoiceCode, (String)invoiceNo);
                if ("1".equals(invoiceType) || "3".equals(invoiceType) || "5".equals(invoiceType) || "15".equals(invoiceType)) {
                    if (InvoiceConvertUtils.isBlockChainType((String)invoiceCode, (String)invoiceNo) || InvoiceConvertUtils.isYunNanBlockchain((String)invoiceCode, (String)invoiceNo)) {
                        this.initBlockChainView();
                    } else {
                        this.initOrdinaryView();
                    }
                } else if ("2".equals(invoiceType) || "4".equals(invoiceType)) {
                    this.initSpecialView();
                } else if ("12".equals(invoiceType)) {
                    this.initMotorView();
                } else if ("13".equals(invoiceType)) {
                    this.initUsedcarView();
                }
            }
        }
    }

    private void initElectricView() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"totalamount1"});
        this.getModel().setValue("totalamount1", (Object)"");
        this.getModel().setValue("invoicecode", (Object)"");
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoicecode"});
        this.getModel().setValue("invoicecode", (Object)"");
        this.getView().setVisible(Boolean.FALSE, new String[]{"motorinvoiceamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"totalamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoiceamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"checkcode5"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"checkcode6"});
        this.getModel().setValue("motorinvoiceamount", (Object)"");
        this.getModel().setValue("totalamount", (Object)"");
        this.getModel().setValue("invoiceamount", (Object)"");
        this.getModel().setValue("checkcode5", (Object)"");
        this.getModel().setValue("checkcode6", (Object)"");
    }

    private void initView() {
        this.getModel().setValue("invoicecode", (Object)"");
        this.getModel().setValue("invoiceno", (Object)"");
        this.getView().setVisible(Boolean.TRUE, new String[]{"invoiceamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"motorinvoiceamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"totalamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"totalamount1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"checkcode5"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"checkcode6"});
        this.getModel().setValue("invoiceamount", (Object)"");
        this.getModel().setValue("motorinvoiceamount", (Object)"");
        this.getModel().setValue("totalamount", (Object)"");
        this.getModel().setValue("totalamount1", (Object)"");
        this.getModel().setValue("checkcode5", (Object)"");
        this.getModel().setValue("checkcode6", (Object)"");
    }

    private void initOrdinaryView() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"checkcode6"});
        this.getModel().setValue("checkcode6", (Object)"");
        this.getView().setVisible(Boolean.TRUE, new String[]{"invoicecode"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"motorinvoiceamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"totalamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"totalamount1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoiceamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"checkcode5"});
        this.getModel().setValue("motorinvoiceamount", (Object)"");
        this.getModel().setValue("totalamount", (Object)"");
        this.getModel().setValue("totalamount", (Object)"");
        this.getModel().setValue("invoiceamount", (Object)"");
        this.getModel().setValue("checkcode5", (Object)"");
    }

    private void initBlockChainView() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"checkcode5"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"invoiceamount"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"invoicecode"});
        this.getModel().setValue("checkcode5", (Object)"");
        this.getModel().setValue("invoiceamount", (Object)"");
        this.getView().setVisible(Boolean.FALSE, new String[]{"totalamount1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"motorinvoiceamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"totalamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"checkcode6"});
        this.getModel().setValue("motorinvoiceamount", (Object)"");
        this.getModel().setValue("totalamount", (Object)"");
        this.getModel().setValue("totalamount1", (Object)"");
        this.getModel().setValue("checkcode6", (Object)"");
    }

    private void initSpecialView() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"invoiceamount"});
        this.getModel().setValue("invoiceamount", (Object)"");
        this.getView().setVisible(Boolean.TRUE, new String[]{"invoicecode"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"motorinvoiceamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"totalamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"totalamount1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"checkcode5"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"checkcode6"});
        this.getModel().setValue("motorinvoiceamount", (Object)"");
        this.getModel().setValue("totalamount", (Object)"");
        this.getModel().setValue("totalamount1", (Object)"");
        this.getModel().setValue("checkcode5", (Object)"");
        this.getModel().setValue("checkcode6", (Object)"");
    }

    private void initMotorView() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"motorinvoiceamount"});
        this.getModel().setValue("motorinvoiceamount", (Object)"");
        this.getView().setVisible(Boolean.TRUE, new String[]{"invoicecode"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"totalamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"totalamount1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoiceamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"checkcode5"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"checkcode6"});
        this.getModel().setValue("totalamount", (Object)"");
        this.getModel().setValue("totalamount1", (Object)"");
        this.getModel().setValue("invoiceamount", (Object)"");
        this.getModel().setValue("checkcode5", (Object)"");
        this.getModel().setValue("checkcode6", (Object)"");
    }

    private void initUsedcarView() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"totalamount"});
        this.getModel().setValue("totalamount", (Object)"");
        this.getView().setVisible(Boolean.TRUE, new String[]{"invoicecode"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"totalamount1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"motorinvoiceamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoiceamount"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"checkcode5"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"checkcode6"});
        this.getModel().setValue("motorinvoiceamount", (Object)"");
        this.getModel().setValue("invoiceamount", (Object)"");
        this.getModel().setValue("checkcode5", (Object)"");
        this.getModel().setValue("checkcode6", (Object)"");
        this.getModel().setValue("totalamount", (Object)"");
    }

    private JSONObject checkInvoice() {
        JSONObject result = new JSONObject();
        String invoiceCode = this.getModel().getValue("invoicecode").toString();
        String invoiceNo = this.getModel().getValue("invoiceno").toString();
        String invoiceDate = "";
        Object invoiceDateValue = this.getModel().getValue("invoicedate");
        if (invoiceDateValue instanceof Date) {
            invoiceDate = DateUtils.format((Date)((Date)invoiceDateValue), (String)"yyyyMMdd");
        }
        JSONObject businessParam = null;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("businessParam") != null) {
            businessParam = JSON.parseObject((String)customParams.get("businessParam").toString());
        }
        logger.info("\u624b\u5de5\u5f55\u5165\u91c7\u96c6\u53c2\u6570\uff1a" + businessParam);
        if (invoiceNo.length() == 20) {
            result = this.invoiceCollectService.checkInvoice("", invoiceNo, null, invoiceDate, (BigDecimal)this.getModel().getValue("totalamount1"), "", businessParam);
        } else {
            String invoiceType = InvoiceConvertUtils.checkInvoiceType((String)invoiceCode, (String)invoiceNo);
            Long invoice_type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoiceType);
            if ("1".equals(invoiceType) || "3".equals(invoiceType) || "5".equals(invoiceType) || "15".equals(invoiceType)) {
                result = InvoiceConvertUtils.isBlockChainType((String)invoiceCode, (String)invoiceNo) || InvoiceConvertUtils.isYunNanBlockchain((String)invoiceCode, (String)invoiceNo) ? this.invoiceCollectService.checkInvoice(invoiceCode, invoiceNo, invoice_type, invoiceDate, (BigDecimal)this.getModel().getValue("invoiceamount"), this.getModel().getValue("checkcode5").toString(), businessParam) : this.invoiceCollectService.checkInvoice(invoiceCode, invoiceNo, invoice_type, invoiceDate, null, this.getModel().getValue("checkcode6").toString(), businessParam);
            } else if ("2".equals(invoiceType) || "4".equals(invoiceType)) {
                result = this.invoiceCollectService.checkInvoice(invoiceCode, invoiceNo, invoice_type, invoiceDate, (BigDecimal)this.getModel().getValue("invoiceamount"), null, businessParam);
            } else if ("12".equals(invoiceType)) {
                result = this.invoiceCollectService.checkInvoice(invoiceCode, invoiceNo, invoice_type, invoiceDate, (BigDecimal)this.getModel().getValue("motorinvoiceamount"), null, businessParam);
            } else if ("13".equals(invoiceType)) {
                result = this.invoiceCollectService.checkInvoice(invoiceCode, invoiceNo, invoice_type, invoiceDate, (BigDecimal)this.getModel().getValue("totalamount"), null, businessParam);
            }
        }
        return result;
    }
}

