/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.RimPermItemEnum;
import kd.imc.rim.common.invoice.collector.InvoiceMainInfoDownService;
import kd.imc.rim.common.invoice.deduction.DealInputTableTask;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.plugin.ProgressFormPlugin;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.ViewUtil;

public class InvoiceDownPlugin
extends ProgressFormPlugin
implements BeforeF7SelectListener,
ProgresssListener {
    private static Log LOGGER = LogFactory.getLog(InvoiceDownPlugin.class);
    public static final String BILL_LIST_AP = "billlistap";
    private static ThreadPool checkAuthThreadPool = ThreadPools.newFixedThreadPool((String)"check_auth_period_thread", (int)6);
    private static final String BTN_DOWN = "btn_down";
    private static final String BTN_RESET = "btn_reset";
    private static final String ENTRYENTITY = "entryentity";
    private static final String toolBarExit = "baritemap2";
    private static final String PARAM_INVOICE_START_DATE = "invoice_date_start";
    private static final String PARAM_INVOICE_END_DATE = "invoice_date_end";
    private static final String PERIOD_START_DATE = "period_start_date";
    private static final String PERIOD_END_DATE = "period_end_date";
    private static final String PARAM_INVOICE_TYPE = "invoice_type_group";
    private static final String PARAM_DEDUCT_FLAG = "deduct_flag_group";
    private static final String PARAM_MANAGE_STATUS = "manage_status_group";
    private static final String PARAM_INVOICE_STATUS = "invoice_status_group";
    private static final String PARAM_BILL_TYPE = "billtype_group";
    private static final String DOWN_ORG = "org";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String BATCH_NO = "batch_no";
    private static final String RESULT_CACHE = "result_cache:";
    private static final String FINISH_FLAG = "finish";
    private static final String TAX_PERIOD_SET = "taxPeriodSet";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit base = (BasedataEdit)this.getView().getControl(DOWN_ORG);
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ProgressBar progressbar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Label label = (Label)this.getControl("label_remark");
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"1\u3001\u4e0b\u8f7d\u8fdb\u9879\u53d1\u7968\u8868\u5934\u4fe1\u606f\uff0c\u8be5\u529f\u80fd\u4e0d\u9650\u5236\u4e0b\u8f7d\u6b21\u6570\u3002\u4e0b\u8f7d\u7ed3\u679c\u4e0e\u7a0e\u5c40\u6570\u636e\u67091\u5c0f\u65f6\u65f6\u5dee\u3002", (String)"InvoiceDownPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0])).append("\n");
        sb.append(ResManager.loadKDString((String)"2\u3001\u7531\u4e8e\u5168\u7968\u9762\u4fe1\u606f\u9700\u8981\u901a\u8fc7\u67e5\u9a8c\u83b7\u53d6\uff0c\u5f53\u4e0b\u8f7d\u7684\u53d1\u7968\u6570\u636e\u8f83\u591a\u65f6\uff0c\u6570\u636e\u540c\u6b65\u81f3\u5168\u7968\u6c60\u53ef\u80fd\u5b58\u5728\u65f6\u5dee\uff0c\u8bf7\u60a8\u8010\u5fc3\u7b49\u5019\uff01", (String)"InvoiceDownPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        label.setText(sb.toString());
        this.setVisibleFlex();
        this.initCondition();
        ViewUtil.hideToolbar((AbstractFormPlugin)this, (String[])new String[]{toolBarExit});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PROGRESSBAR});
    }

    private void setVisibleFlex() {
        String taxNo = TenantUtils.getTaxNoByOrgId((Long)this.getCurrentOrgId());
        String dkType = this.getDkType(taxNo);
        this.getModel().setValue("dk_type", (Object)dkType);
        this.loadData(UUID.randomUUID());
    }

    private void initCondition() {
        DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getControl("invoice_date_field");
        dateRangeEdit.setMinDate(DateUtils.stringToDate((String)"2017-01-01"));
        dateRangeEdit.setMaxDate(new Date());
        this.getModel().setValue(PARAM_INVOICE_START_DATE, (Object)DateUtils.getFirstDateOfMonth((Date)new Date()));
        this.getModel().setValue(PARAM_INVOICE_END_DATE, (Object)new Date());
        this.getModel().setValue(DOWN_ORG, (Object)RequestContext.get().getOrgId());
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.getModel().setValue("invoice_code1", null);
        this.getModel().setValue("invoice_no1", null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (DOWN_ORG.equals(fieldKey)) {
            this.setVisibleFlex();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTN_DOWN.equals(itemKey)) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.BTN_DOWNLOAD, (String)BTN_DOWN);
            String checkMsg = this.checkParam();
            if (StringUtils.isNotEmpty((CharSequence)checkMsg)) {
                this.getView().showErrorNotification(checkMsg);
                return;
            }
            this.getModel().deleteEntryData(ENTRYENTITY);
            Long orgId = this.getCurrentOrgId();
            String taxNo = TenantUtils.getTaxNoByOrgId((Long)orgId);
            if (TenantUtils.isSmallScaleTaxpayer((String)taxNo)) {
                this.getView().showTipNotification(ErrorType.SMALL_SCALE_TAXPAYER_DOWN.getName(), Integer.valueOf(2000));
                return;
            }
            String dkType = this.getDkType(taxNo);
            if ("5".equals(dkType) || "6".equals(dkType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6536\u7968\u901a\u9053\u6682\u4e0d\u652f\u6301\u6b64\u529f\u80fd\uff0c\u8bf7\u524d\u5f80\u3010\u5168\u91cf\u53d1\u7968\u6570\u636e\u540c\u6b65\u8bbe\u7f6e\u3011\u914d\u7f6e\u5f52\u96c6\u4efb\u52a1", (String)"InvoiceDownPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            DeductService service = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)orgId);
            JSONObject loginResult = service.login(taxNo, BTN_DOWN, (AbstractFormPlugin)this);
            if (ResultContant.isSuccess((JSONObject)loginResult).booleanValue()) {
                this.downInvoice(orgId, taxNo);
            } else if (!ErrorType.NEED_LOGIN.getCode().equals(loginResult.getString("errcode")) || !ErrorType.NEED_LOGIN.getName().equals(loginResult.getString("description"))) {
                this.getView().showErrorNotification(loginResult.getString("description"));
            }
        }
    }

    private String checkParam() {
        Date startDate = (Date)this.getModel().getValue(PARAM_INVOICE_START_DATE);
        Date endDate = (Date)this.getModel().getValue(PARAM_INVOICE_END_DATE);
        Date taxperiod = (Date)this.getModel().getValue("taxperiod_date");
        Date periodStartDate = (Date)this.getModel().getValue(PERIOD_START_DATE);
        Date periodEndDate = (Date)this.getModel().getValue(PERIOD_END_DATE);
        String deductFlag = (String)this.getModel().getValue(PARAM_DEDUCT_FLAG);
        if ("-1".equals(deductFlag) || "0".equals(deductFlag)) {
            if (startDate == null || endDate == null) {
                return ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceDownPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
        } else if ("1".equals(deductFlag)) {
            if (periodStartDate == null) {
                return ResManager.loadKDString((String)"\u8d77\u59cb\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceDownPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if (periodEndDate == null) {
                return ResManager.loadKDString((String)"\u7ed3\u675f\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceDownPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if (DateUtils.compare((Date)(periodStartDate = InvoiceDownPlugin.setFirstDayOfMonth(periodStartDate)), (Date)(periodEndDate = InvoiceDownPlugin.setFirstDayOfMonth(periodEndDate))) > 0) {
                return ResManager.loadKDString((String)"\u8d77\u59cb\u5c5e\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u5c5e\u671f", (String)"InvoiceDownPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if (DateUtils.compare((Date)DateUtils.addMonth((Date)periodEndDate, (int)-5), (Date)periodStartDate) > 0) {
                return ResManager.loadKDString((String)"\u591a\u5c5e\u671f\u6700\u591a\u652f\u6301\u8de8\u5ea66\u4e2a\u6708\uff0c\u4f8b\uff1a2024-01~2024-06", (String)"InvoiceDownPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
        } else if ("2".equals(deductFlag) && taxperiod == null) {
            return ResManager.loadKDString((String)"\u7a0e\u6b3e\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceDownPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private void downInvoice(Long orgId, String taxNo) {
        this.getPageCache().remove(RESULT_CACHE);
        this.startProcess(new String[]{ResManager.loadKDString((String)"\u53d1\u7968\u4e0b\u8f7d\u4e2d", (String)"InvoiceDownPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0])});
        RequestContext requestContext = RequestContext.get();
        ThreadPools.executeOnceIncludeRequestContext((String)"AsyncDownInvoiceRun", () -> this.downByPage(orgId, taxNo, requestContext));
    }

    private void downByPage(Long orgId, String taxNo, RequestContext requestContext) {
        RequestContext.copyAndSet((RequestContext)requestContext);
        String dkType = this.getDkType(taxNo);
        InvoiceMainInfoDownService downService = DeductServiceFactory.newInstanceForInvoiceMainInfoDown((String)dkType, (Long)orgId, (AbstractFormPlugin)this);
        JSONObject param = this.getPageParam();
        param.put("taxNo", (Object)taxNo);
        JSONObject result = null;
        String batchNo = UUID.randomUUID();
        Object taxPeriodObject = param.get((Object)TAX_PERIOD_SET);
        if (taxPeriodObject != null) {
            long startTime = System.currentTimeMillis();
            LOGGER.info("InvoiceDownPlugin-\u591a\u5c5e\u671f\u4e0b\u8f7d\u5f00\u59cb");
            boolean successFlag = false;
            JSONObject totalResult = new JSONObject();
            Set taxPeriodSet = (Set)taxPeriodObject;
            ArrayList<Future> futureList = new ArrayList<Future>(6);
            for (Date taxPeriod : taxPeriodSet) {
                JSONObject paramCheckAuth = new JSONObject();
                paramCheckAuth.putAll((Map)param);
                paramCheckAuth.put("taxPeriod", (Object)taxPeriod);
                Future future = checkAuthThreadPool.submit(() -> this.getDownResult(orgId, taxNo, downService, paramCheckAuth, batchNo));
                futureList.add(future);
            }
            for (Future future : futureList) {
                try {
                    result = (JSONObject)future.get();
                    if (!ResultContant.isSuccess((JSONObject)result).booleanValue() || successFlag) continue;
                    successFlag = true;
                    totalResult = result;
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.error("\u5f02\u6b65\u8c03\u7528\u5f02\u5e38" + e);
                }
            }
            if (!successFlag) {
                totalResult = result;
            }
            if (totalResult == null) {
                totalResult = new JSONObject();
            }
            totalResult.put("batchNo", (Object)batchNo);
            LOGGER.info("\u4e0b\u8f7d\u7ed3\u679c\uff1a{}", (Object)SerializationUtils.toJsonString((Object)totalResult));
            this.getPageCache().put(RESULT_CACHE, SerializationUtils.toJsonString((Object)totalResult));
            LOGGER.info("InvoiceDownPlugin-\u591a\u5c5e\u671f\u4e0b\u8f7d\u8017\u65f6: {}", (Object)(System.currentTimeMillis() - startTime));
        } else {
            result = this.getDownResult(orgId, taxNo, downService, param, batchNo);
            result.put("batchNo", (Object)batchNo);
            LOGGER.info("\u4e0b\u8f7d\u7ed3\u679c\uff1a{}", (Object)SerializationUtils.toJsonString((Object)result));
            this.getPageCache().put(RESULT_CACHE, SerializationUtils.toJsonString((Object)result));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject getDownResult(Long orgId, String taxNo, InvoiceMainInfoDownService downService, JSONObject param, String batchNo) {
        JSONObject result;
        LOGGER.info("\u5f53\u524d\u7ebf\u7a0b\uff0c {}" + Thread.currentThread().getName());
        try {
            result = downService.downInvoice(param);
            if (ResultContant.isSuccess((JSONObject)result).booleanValue()) {
                JSONArray invoiceArray = result.getJSONArray("data");
                DeductionUtils.saveInvoiceToInputTable((JSONArray)invoiceArray, (Long)orgId, (String)taxNo, (String)batchNo);
                if (!this.downSurplusInvoice(result, downService, param, orgId, batchNo)) {
                    // empty if block
                }
            }
        }
        catch (MsgException msg) {
            result = ResultContant.createJSONObject((String)msg.getErrorCode(), (String)msg.getErrorMsg());
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u53d1\u7968:" + taxNo, (Throwable)e);
            result = ResultContant.createJSONObject((String)ErrorType.PARAM_NULL.getCode(), (String)e.getMessage());
        }
        if (result == null) return new JSONObject();
        result.remove((Object)"data");
        return result;
    }

    private boolean downSurplusInvoice(JSONObject result, InvoiceMainInfoDownService downService, JSONObject param, Long orgId, String batchNo) {
        boolean flag;
        block4: {
            block3: {
                if (result == null || downService == null || param == null) {
                    return true;
                }
                if (!"true".equals(result.getString("continueFlag"))) {
                    return true;
                }
                flag = true;
                do {
                    param.put("requestId", (Object)UUID.randomUUID());
                    param.put("serialNo", (Object)result.getString("serialNo"));
                    param.put("dataFromIndex", result.get((Object)"nextDataFromIndex"));
                    param.put("dataIndex", result.get((Object)"nextDataIndex"));
                    result = downService.downInvoice(param);
                    if (!ResultContant.isSuccess((JSONObject)result).booleanValue()) break block3;
                    JSONArray invoiceArray = result.getJSONArray("data");
                    DeductionUtils.saveInvoiceToInputTable((JSONArray)invoiceArray, (Long)orgId, (String)param.getString("taxNo"), (String)batchNo);
                } while ("true".equals(result.getString("continueFlag")));
                break block4;
            }
            flag = false;
        }
        return flag;
    }

    private void saveInvoiceAndShow(JSONArray invoiceArray, Long orgId, String taxNo, String batchNo) {
        if (!CollectionUtils.isEmpty((Collection)invoiceArray)) {
            for (int i = 0; i < invoiceArray.size(); ++i) {
                JSONObject invoice = invoiceArray.getJSONObject(i);
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_input_table");
            }
        }
    }

    private JSONObject getPageParam() {
        String invoiceCode;
        Date startDate = (Date)this.getModel().getValue(PARAM_INVOICE_START_DATE);
        Date endDate = (Date)this.getModel().getValue(PARAM_INVOICE_END_DATE);
        Date taxperiod = (Date)this.getModel().getValue("taxperiod_date");
        String deductFlag = (String)this.getModel().getValue(PARAM_DEDUCT_FLAG);
        String invoiceType = (String)this.getModel().getValue(PARAM_INVOICE_TYPE);
        String manageStatus = (String)this.getModel().getValue(PARAM_MANAGE_STATUS);
        String invoiceStatus = (String)this.getModel().getValue(PARAM_INVOICE_STATUS);
        String billType = (String)this.getModel().getValue(PARAM_BILL_TYPE);
        Date periodStartDate = (Date)this.getModel().getValue(PERIOD_START_DATE);
        Date periodEndDate = (Date)this.getModel().getValue(PERIOD_END_DATE);
        if ("1".equals(billType)) {
            invoiceType = InputInvoiceTypeEnum.HGJKS.getAwsType();
        }
        Set<Date> taxPeriodSet = null;
        if ("1".equals(deductFlag)) {
            periodStartDate = InvoiceDownPlugin.setFirstDayOfMonth(periodStartDate);
            periodEndDate = InvoiceDownPlugin.setFirstDayOfMonth(periodEndDate);
            taxPeriodSet = this.calculateTaxPeriod(periodStartDate, periodEndDate);
        }
        invoiceCode = StringUtils.isNotEmpty((CharSequence)(invoiceCode = (String)this.getModel().getValue("invoice_code1"))) ? invoiceCode.trim() : "";
        String invoiceNo = (String)this.getModel().getValue("invoice_no1");
        invoiceNo = StringUtils.isNotEmpty((CharSequence)invoiceNo) ? invoiceNo.trim() : "";
        JSONObject param = new JSONObject();
        param.put("deductFlag", (Object)deductFlag);
        param.put("billType", (Object)billType);
        param.put("invoiceType", (Object)invoiceType);
        param.put("manageStatus", (Object)manageStatus);
        param.put("invoiceStatus", (Object)invoiceStatus);
        param.put("startDate", (Object)startDate);
        param.put("endDate", (Object)endDate);
        param.put("taxPeriod", (Object)taxperiod);
        param.put("invoiceCode", (Object)invoiceCode);
        param.put("invoiceNo", (Object)invoiceNo);
        param.put("notQueryPage", (Object)"1");
        if (!CollectionUtils.isEmpty(taxPeriodSet)) {
            param.put(TAX_PERIOD_SET, taxPeriodSet);
        }
        return param;
    }

    private Set<Date> calculateTaxPeriod(Date periodStartDate, Date periodEndDate) {
        HashSet<Date> taxPeriodSet = new HashSet<Date>();
        this.getTaxPeriodSet(periodStartDate, periodEndDate, taxPeriodSet);
        return taxPeriodSet;
    }

    private void getTaxPeriodSet(Date periodStartDate, Date periodEndDate, Set<Date> taxPeriodSet) {
        if (DateUtils.compare((Date)periodStartDate, (Date)periodEndDate) <= 0) {
            taxPeriodSet.add(periodStartDate);
            Date nextMontyDate = DateUtils.addMonth((Date)periodStartDate, (int)1);
            this.getTaxPeriodSet(nextMontyDate, periodEndDate, taxPeriodSet);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId != null && actionId.startsWith("loginAfter") && !StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
            Long orgId = this.getCurrentOrgId();
            String taxNo = TenantUtils.getTaxNoByOrgId((Long)orgId);
            this.downInvoice(orgId, taxNo);
        }
    }

    private Long getCurrentOrgId() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(DOWN_ORG);
        Long orgId = RequestContext.get().getOrgId();
        if (org != null) {
            orgId = org.getLong("id");
        }
        return orgId;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"rim_invoice_down_shuipan", (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            QFilter idQFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            ListShowParameter formShowParameter = (ListShowParameter)arg0.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(idQFilter);
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
    }

    private void loadData(String batchNo) {
        QFilter filter = new QFilter(BATCH_NO, "=", (Object)batchNo);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        FilterParameter fp = new FilterParameter();
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        billList.refresh();
    }

    private static Date setFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public void dialogProcess(String eventArgs) {
        String resultString = this.getPageCache().get(RESULT_CACHE);
        if (!StringUtils.isEmpty((CharSequence)resultString)) {
            JSONObject result = JSONObject.parseObject((String)resultString);
            if (ResultContant.isSuccess((JSONObject)result).booleanValue()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6210\u529f", (String)"InvoiceDownPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else {
                String description = ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25", (String)"InvoiceDownPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                if (result != null) {
                    description = String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25:%1$s", (String)"InvoiceDownPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), result.getString("description"));
                } else {
                    result = new JSONObject();
                }
                this.getView().showTipNotification(description, Integer.valueOf(5000));
            }
            String batchNo = result.getString("batchNo");
            this.loadData(batchNo);
            DealInputTableTask dealInputTableTask = new DealInputTableTask(RequestContext.get(), batchNo);
            ThreadPools.executeOnce((String)"InvoiceDownProgressPool", (Runnable)dealInputTableTask);
            this.stopProcess();
        }
    }

    private String getDkType(String taxNo) {
        String dkType = DeductionConstant.getDkType((String)taxNo);
        return InvoiceDownloadConstant.lqTaxNoConvertRpa((String)taxNo, (String)dkType);
    }
}

