/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.invoice.collector.InvoiceHisDataSyncService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;

public class InvoiceHisDataSyncPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab detailTab = (Tab)this.getView().getControl("tabap");
        detailTab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.loadSyncList();
    }

    private void loadUnSyncList() {
        this.getPageCache().put("sync", "0");
        this.getView().setVisible(Boolean.FALSE, new String[]{"update", "submit"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"delete"});
        QFilter filter = new QFilter("status", "=", (Object)"0");
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_his_sync_config", (String)"tax_no,company_name,clientid", (QFilter[])new QFilter[]{filter});
        this.getModel().deleteEntryData("entryentity1");
        for (DynamicObject map : collect) {
            int index = this.getModel().createNewEntryRow("entryentity1");
            this.getModel().setValue("tax_no1", map.get("tax_no"), index);
            this.getModel().setValue("clientid1", map.get("clientid"), index);
            this.getModel().setValue("company_name1", map.get("company_name"), index);
        }
    }

    private void loadSyncList() {
        this.getPageCache().put("sync", "1");
        this.getView().setVisible(Boolean.FALSE, new String[]{"delete"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"update", "submit"});
        List clientList = InvoiceHisDataSyncService.queryClients();
        this.getModel().deleteEntryData("entryentity");
        for (Map map : clientList) {
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("org", map.get("org"), index);
            this.getModel().setValue("tax_no", map.get("tax_no"), index);
            this.getModel().setValue("clientid", map.get("clientid"), index);
            this.getModel().setValue("company_name", map.get("company_name"), index);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("submit".equals(evt.getItemKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u8bb0\u5f55", (String)"InvoiceHisDataSyncPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
                return;
            }
            ArrayList<String> clientIdList = new ArrayList<String>(selectRows.length);
            for (int rowId : selectRows) {
                clientIdList.add((String)this.getModel().getValue("clientid", rowId));
            }
            QFilter clientidFilter = new QFilter("clientid", "in", clientIdList);
            QFilter filter = new QFilter("status", "=", (Object)"2");
            QFilter filter2 = new QFilter("appid", "=", (Object)"rim");
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_his_sync_log", (String)"clientid", (QFilter[])new QFilter[]{clientidFilter, filter, filter2});
            HashSet<String> existsSet = new HashSet<String>();
            for (DynamicObject object : collect) {
                existsSet.add(object.getString("clientid"));
            }
            int failCount = 0;
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(selectRows.length);
            for (int rowId : selectRows) {
                String clientid = (String)this.getModel().getValue("clientid", rowId);
                String taxNo = (String)this.getModel().getValue("tax_no", rowId);
                String companyName = (String)this.getModel().getValue("company_name", rowId);
                DynamicObject org = (DynamicObject)this.getModel().getValue("org", rowId);
                Date date = (Date)this.getModel().getValue("data_start_time", rowId);
                Long orgId = org.getLong("id");
                if (existsSet.contains(clientid)) {
                    ++failCount;
                    continue;
                }
                DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"rim_his_sync_log");
                logObj.set("deal_times", (Object)0);
                logObj.set("start_time", (Object)new Date());
                logObj.set("org", (Object)orgId);
                logObj.set("success", (Object)0);
                logObj.set("page_no", (Object)0);
                logObj.set("tax_no", (Object)taxNo);
                logObj.set("company_name", (Object)companyName);
                logObj.set("clientid", (Object)clientid);
                logObj.set("appid", (Object)"rim");
                logObj.set("creater", (Object)Long.parseLong(RequestContext.get().getUserId()));
                String dateStr = DateUtils.format((Date)date);
                if (date != null) {
                    logObj.set("data_date", (Object)DateUtils.format((Date)date));
                    logObj.set("data_date_start", (Object)DateUtils.trunc((Date)date));
                    logObj.set("data_date_end", (Object)DateUtils.stringToDate((String)(dateStr + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                logObj.set("sync_type", (Object)"1");
                logObj.set("status", (Object)"2");
                saveList.add(logObj);
            }
            if (!saveList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            }
            InvoiceHisDataSyncService.start();
            if (failCount > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u589e\u52a0%1$s\u4e2a\u540c\u6b65\u4efb\u52a1,%2$s\u4e2a\u5728\u6d41\u7a0b\u4e2d\u4e0d\u80fd\u91cd\u590d\u589e\u52a0", (String)"InvoiceHisDataSyncPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]), saveList.size(), failCount), Integer.valueOf(4000));
            } else {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u589e\u52a0%1$s\u4e2a\u540c\u6b65\u4efb\u52a1", (String)"InvoiceHisDataSyncPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]), saveList.size()), Integer.valueOf(4000));
            }
        } else if ("delete".equals(evt.getItemKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity1");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u8bb0\u5f55", (String)"InvoiceHisDataSyncPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
                return;
            }
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceHisDataSyncPlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InvoiceHisDataSyncPlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u5220\u9664\u540e\u5c06\u5b9a\u65f6\u540c\u6b65\u516c\u6709\u4e91\u6570\u636e\uff1f", (String)"InvoiceHisDataSyncPlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("deleteCallBack"), btnNameMaps);
        } else if ("update".equals(evt.getItemKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u8bb0\u5f55", (String)"InvoiceHisDataSyncPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
                return;
            }
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceHisDataSyncPlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InvoiceHisDataSyncPlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u5c06\u4e0d\u4f1a\u5b9a\u65f6\u540c\u6b65\u516c\u6709\u4e91\u6570\u636e\uff1f", (String)"InvoiceHisDataSyncPlugin_22", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("updateCallBack"), btnNameMaps);
        } else if ("expense".equals(evt.getItemKey())) {
            EntryGrid entryGrid;
            int[] selectRows;
            String entry = "entryentity";
            String clientid = "clientid";
            if (!"1".equals(this.getPageCache().get("sync"))) {
                entry = "entryentity1";
                clientid = "clientid1";
            }
            if ((selectRows = (entryGrid = (EntryGrid)this.getControl(entry)).getSelectRows()).length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u8bb0\u5f55", (String)"InvoiceHisDataSyncPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
                return;
            }
            Long org = 0L;
            if ("entryentity".equals(entry)) {
                org = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org", selectRows[0]));
            }
            String clientId = (String)this.getModel().getValue(clientid, selectRows[0]);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("rim_his_sync_bill");
            showParameter.setCustomParam("clientId", (Object)clientId);
            showParameter.setCustomParam("org", (Object)org);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_his_sync_bill");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            if ("deleteCallBack".equals(callBackId)) {
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity1");
                int[] selectRows = entryGrid.getSelectRows();
                ArrayList<String> clientids = new ArrayList<String>(selectRows.length);
                for (int row : selectRows) {
                    clientids.add((String)this.getModel().getValue("clientid1", row));
                }
                DeleteServiceHelper.delete((String)"rim_his_sync_config", (QFilter[])new QFilter[]{new QFilter("clientid", "in", clientids)});
                this.loadUnSyncList();
            } else if ("updateCallBack".equals(callBackId)) {
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                DynamicObject[] configs = new DynamicObject[selectRows.length];
                RequestContext req = RequestContext.get();
                int i = 0;
                for (int row : selectRows) {
                    DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"rim_his_sync_config");
                    object.set("creater", (Object)req.getUserId());
                    object.set("clientid", this.getModel().getValue("clientid", row));
                    object.set("tax_no", this.getModel().getValue("tax_no", row));
                    object.set("company_name", this.getModel().getValue("company_name", row));
                    object.set("create_time", (Object)new Date());
                    object.set("status", (Object)"0");
                    configs[i++] = object;
                }
                SaveServiceHelper.save((DynamicObject[])configs);
                this.loadSyncList();
            }
        }
    }

    public void tabSelected(TabSelectEvent paramTabSelectEvent) {
        String tabKey = paramTabSelectEvent.getTabKey();
        if ("tabpageap".equals(tabKey)) {
            this.loadSyncList();
        } else if ("tabpageap1".equals(tabKey)) {
            this.loadUnSyncList();
        }
    }
}

