/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionCheckRemoteTask;
import kd.imc.rim.common.multitenant.service.MultiTenantService;
import kd.imc.rim.common.service.EInvoiceZipXmlDealService;
import kd.imc.rim.common.service.ElectAccVoucherService;
import kd.imc.rim.common.service.ExcelInvoiceUploadService;
import kd.imc.rim.common.service.RecognitionCheckService;
import kd.imc.rim.common.utils.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceRecognitionRetryPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(InvoiceRecognitionRetryPlugin.class);
    private static final String retryList = "retry_list";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(retryList);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        if ("retry".equals(evt.getItemKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(retryList);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e!", (String)"InvoiceRecognitionRetryPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(retryList);
            if (entryEntity.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6", (String)"InvoiceRecognitionRetryPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            for (int index : selectRows) {
                try {
                    this.retry(index);
                }
                catch (IOException e) {
                    logger.info("InvoiceRecognitionRetryPlugin IOException:{}", (Object)e);
                }
            }
            this.removeEntryList(this.getPageCache().get("remove_index"));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getEntryEntity(retryList).get(arg0.getRowIndex());
        String fileName = dynamicObject.getString("file_name");
        if (FileUtils.isExcel((String)fileName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"excel\u6587\u4ef6\u4e0d\u652f\u6301\u9884\u89c8", (String)"InvoiceRecognitionRetryPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String fileUrl = dynamicObject.getString("file_url");
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("fileUrl", fileUrl);
        FormShowParameter showParameter = this.newPage("rim_inv_file_preview", customParams, null);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6587\u4ef6\u9884\u89c8", (String)"InvoiceRecognitionRetryPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("retry_recognition".equals(afterDoOperationEventArgs.getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(retryList);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e!", (String)"InvoiceRecognitionRetryPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            try {
                this.retry(selectRows[0]);
            }
            catch (IOException e) {
                logger.info("InvoiceRecognitionRetryPlugin IOException:{}", (Object)e);
            }
            this.removeEntryList(this.getPageCache().get("remove_index"));
        }
    }

    private void removeEntryList(String removeIndex) {
        if (StringUtils.isEmpty((CharSequence)removeIndex)) {
            return;
        }
        String[] split = removeIndex.split(",");
        int[] target = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            target[i] = Integer.parseInt(split[i]);
        }
        this.getModel().deleteEntryRows(retryList, target);
        this.getPageCache().remove("remove_index");
    }

    private void retry(int index) throws IOException {
        DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getEntryEntity(retryList).get(index);
        String fileUrl = dynamicObject.getString("file_url");
        String fileName = dynamicObject.getString("file_name");
        if (StringUtils.isNotEmpty((CharSequence)fileUrl)) {
            boolean attachFlag;
            JSONObject invoiceResult = new JSONObject();
            Long orgId = RequestContext.get().getOrgId();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            JSONObject businessParam = JSONObject.parseObject((String)customParams.get("businessParam").toString());
            if (new MultiTenantService().isMultiTenant()) {
                businessParam.put("noDealFlag", (Object)"1");
                RecognitionCheckRemoteTask task = new RecognitionCheckRemoteTask(RequestContext.get(), "fpzs", this.getView().getPageId(), businessParam, null, fileUrl, fileName);
                invoiceResult = task.execute();
            } else {
                boolean isZipXmlEI;
                boolean isNeedDeal = FileUtils.checkFileType((String)fileName, (String[])new String[]{"zip", "ofd", "pdf"});
                if (isNeedDeal) {
                    ElectAccVoucherService electAccVoucherService = new ElectAccVoucherService();
                    invoiceResult = electAccVoucherService.dealVoucher(fileUrl, fileName, (Object)orgId, businessParam, null);
                }
                if ((isZipXmlEI = FileUtils.checkFileType((String)fileName, (String[])new String[]{"zip", "xml"})) && !"0000".equals(invoiceResult.getString("errcode"))) {
                    invoiceResult = EInvoiceZipXmlDealService.analysisAndCheckSave((String)fileUrl, (String)fileName, (Long)orgId, (JSONObject)businessParam, null);
                }
                if (!"0000".equals(invoiceResult.getString("errcode"))) {
                    invoiceResult = FileUtils.isExcel((String)fileName) ? ExcelInvoiceUploadService.getInstance().uploadExcelInvoice(fileUrl, fileName, null, businessParam) : RecognitionCheckService.getInstance().recognitionCheckInvoice(fileUrl, fileName, null, businessParam);
                }
            }
            logger.info(fileUrl + "\u91cd\u8bd5\u8bc6\u522b\u7ed3\u679c\uff1a" + invoiceResult);
            boolean dataFlag = null != invoiceResult.get((Object)"data") && invoiceResult.getJSONArray("data").size() > 0;
            boolean bl = attachFlag = null != invoiceResult.get((Object)"attach") && invoiceResult.getJSONArray("attach").size() > 0;
            if (ResultContant.isSuccess((JSONObject)invoiceResult).booleanValue() && (dataFlag || attachFlag)) {
                int i;
                JSONArray invoiceData = invoiceResult.getJSONArray("data");
                JSONArray attachData = invoiceResult.getJSONArray("attach");
                JSONArray successData = new JSONArray();
                if (null != this.getPageCache().get("successData")) {
                    JSONArray successDataCache = JSONArray.parseArray((String)this.getPageCache().get("successData"));
                    successData.addAll((Collection)successDataCache);
                }
                HashSet<String> serialNo = new HashSet<String>();
                for (i = 0; i < successData.size(); ++i) {
                    JSONObject successInvoice = successData.getJSONObject(i);
                    if (!StringUtils.isNotEmpty((CharSequence)successInvoice.getString("serialNo"))) continue;
                    serialNo.add(successInvoice.getString("serialNo"));
                }
                for (i = 0; i < invoiceData.size(); ++i) {
                    JSONObject invoice = invoiceData.getJSONObject(i);
                    if (!StringUtils.isEmpty((CharSequence)invoice.getString("serialNo")) && !serialNo.add(invoice.getString("serialNo"))) continue;
                    successData.add((Object)invoice);
                }
                if (attachData != null) {
                    for (i = 0; i < attachData.size(); ++i) {
                        JSONObject attach = attachData.getJSONObject(i);
                        successData.add((Object)attach);
                    }
                }
                this.getPageCache().put("successData", successData.toJSONString());
                String postResult = this.getPageCache().get("remove_index");
                if (StringUtils.isEmpty((CharSequence)postResult)) {
                    postResult = String.valueOf(index);
                    this.getPageCache().put("remove_index", postResult);
                } else {
                    String removeIndex = String.join((CharSequence)",", postResult, String.valueOf(index));
                    this.getPageCache().put("remove_index", removeIndex);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bc6\u522b\u6210\u529f", (String)"InvoiceRecognitionRetryPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            } else if (null != invoiceResult && StringUtils.isNotEmpty((CharSequence)invoiceResult.getString("description"))) {
                this.getModel().setValue("fail_description", (Object)invoiceResult.getString("description"), index);
                this.getView().showErrorNotification(invoiceResult.getString("description"));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (null != this.getPageCache().get("successData")) {
            HashMap<String, String> customParams = new HashMap<String, String>(1);
            customParams.put("successData", this.getPageCache().get("successData"));
            this.getView().returnDataToParent(customParams);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initView();
    }

    private void initView() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray retryArray = JSONObject.parseArray((String)customParams.get("retryArray").toString());
        int size = retryArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject retry = retryArray.getJSONObject(i);
            String fileName = retry.getString("fileName");
            int row = this.getModel().createNewEntryRow(retryList);
            this.getModel().setValue("file_url", (Object)retry.getString("fileUrl"), row);
            this.getModel().setValue("file_name", (Object)fileName, row);
            this.getModel().setValue("fail_description", (Object)retry.getString("failDescription"), row);
        }
    }

    private FormShowParameter newPage(String formId, Map<String, Object> customParams, String callBackId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setShowTitle(true);
        showParameter.setCustomParams(customParams);
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotEmpty((CharSequence)callBackId)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, callBackId);
            showParameter.setCloseCallBack(closeCallBack);
        }
        return showParameter;
    }
}

