/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.ExpenseConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.RimPermItemEnum;
import kd.imc.rim.common.invoice.check.UnCheckListCheckTask;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.license.LicenseListPlugin;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.ViewUtil;
import org.apache.commons.collections.CollectionUtils;

public class InvoiceUncheckListPlugin
extends LicenseListPlugin {
    private static Log logger = LogFactory.getLog(InvoiceUncheckListPlugin.class);
    private static ThreadPool checkThreadPool = ThreadPools.newFixedThreadPool((String)"Invoice_check_thread", (int)6);
    private static final String BTN_EDIT = "btn_edit";
    private static final String BTN_CHECK = "btn_check";
    private static final String BTN_DELETE = "btn_del";
    private static final String BTN_EXIT = "baritemap3";

    public void afterCreateNewData(EventObject e) {
        ViewUtil.hideToolbar((AbstractFormPlugin)this, (String[])new String[]{BTN_EXIT});
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (BTN_EDIT.equals(key)) {
            ListSelectedRowCollection selectCollection = this.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u7f16\u8f91\u7684\u53d1\u7968", (String)"InvoiceUncheckListPlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            this.openEditInvoicePage(selectCollection.getPrimaryKeyValues()[0]);
        } else if (BTN_CHECK.equals(key)) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.RIM_BATCH_CHECK, (String)BTN_CHECK);
            ListSelectedRowCollection selectCollection = this.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u9a8c\u7684\u53d1\u7968", (String)"InvoiceUncheckListPlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])selectCollection.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice_uncheck"));
            ArrayList<Future> futureList = new ArrayList<Future>(objects.length);
            for (DynamicObject obj : objects) {
                UnCheckListCheckTask task = new UnCheckListCheckTask(RequestContext.get(), obj);
                Future future = checkThreadPool.submit((Callable)task);
                futureList.add(future);
            }
            int total = objects.length;
            int success = 0;
            for (Future future : futureList) {
                try {
                    JSONObject obj = (JSONObject)future.get();
                    logger.info("\u67e5\u9a8c\u7ed3\u679c:" + obj);
                    if (!ResultContant.isSuccess((JSONObject)obj).booleanValue()) continue;
                    ++success;
                }
                catch (Exception exception) {}
            }
            if (success > 0 && success == total) {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u9009\u62e9%1$s\u4e2a\u53d1\u7968\uff0c\u67e5\u9a8c\u6210\u529f%2$s", (String)"InvoiceUncheckListPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]), total, success), Integer.valueOf(15000));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u62e9%1$s\u4e2a\u53d1\u7968\uff0c\u67e5\u9a8c\u6210\u529f%2$s", (String)"InvoiceUncheckListPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]), total, success), Integer.valueOf(15000));
            }
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refresh();
        } else if (BTN_DELETE.equals(key)) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.ITEM_DELETE, (String)BTN_DELETE);
            ListSelectedRowCollection selectCollection = this.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u9a8c\u7684\u53d1\u7968", (String)"InvoiceUncheckListPlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%1$s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\n \u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"InvoiceUncheckListPlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]), selectCollection.size()), "", MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(BTN_DELETE), null);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (BTN_DELETE.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.delete();
        }
    }

    private void delete() {
        ListSelectedRowCollection selectCollection = this.getSelectedRows();
        Object[] pKs = selectCollection.getPrimaryKeyValues();
        QFilter idFilter = new QFilter("id", "in", (Object)pKs);
        DynamicObject[] uncheckObjects = BusinessDataServiceHelper.load((String)"rim_invoice_uncheck", (String)"id,serial_no,expense_status,delete,update_time", (QFilter[])new QFilter[]{idFilter});
        ArrayList<String> serialNos = new ArrayList<String>(8);
        ArrayList<Object> deleteIds = new ArrayList<Object>(8);
        ArrayList<DynamicObject> updateUncheckObjects = new ArrayList<DynamicObject>(8);
        for (DynamicObject dynamicObject : uncheckObjects) {
            serialNos.add(dynamicObject.getString("serial_no"));
            String expenseStatus = dynamicObject.getString("expense_status");
            if (ExpenseConstant.isUsed((Object)expenseStatus).booleanValue()) {
                dynamicObject.set("delete", (Object)"3");
                dynamicObject.set("update_time", (Object)new Date());
                updateUncheckObjects.add(dynamicObject);
                continue;
            }
            deleteIds.add(dynamicObject.get("id"));
        }
        QFilter serialNoFilter = new QFilter("serial_no", "in", (Object)serialNos.toArray());
        Object[] mainObjects = BusinessDataServiceHelper.load((String)"rim_invoice", (String)"id,serial_no,expense_status,delete,modifytime,check_status", (QFilter[])new QFilter[]{serialNoFilter});
        ArrayList<Object> updateMainObjects = new ArrayList<Object>(8);
        if (!ObjectUtils.isEmpty((Object[])mainObjects)) {
            for (Object mainObject : mainObjects) {
                String checkStatus = mainObject.getString("check_status");
                if ("1".equals(checkStatus)) continue;
                mainObject.set("delete", (Object)"3");
                mainObject.set("modifytime", (Object)new Date());
                updateMainObjects.add(mainObject);
            }
        }
        try (TXHandle tXHandle = TX.required();){
            try {
                if (CollectionUtils.isNotEmpty(deleteIds)) {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"rim_invoice_uncheck"), (Object[])deleteIds.toArray());
                }
                if (CollectionUtils.isNotEmpty(updateUncheckObjects)) {
                    SaveServiceHelper.save((DynamicObject[])updateUncheckObjects.toArray(new DynamicObject[updateUncheckObjects.size()]));
                }
                if (CollectionUtils.isNotEmpty(updateMainObjects)) {
                    SaveServiceHelper.save((DynamicObject[])updateMainObjects.toArray(new DynamicObject[updateMainObjects.size()]));
                }
            }
            catch (Throwable e) {
                tXHandle.markRollback();
                throw e;
            }
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"InvoiceUncheckListPlugin_22", (String)"imc-rim-formplugin", (Object[])new Object[0]));
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("delete", "!=", (Object)"3"));
        String showNotCheckConfig = RimConfigUtils.getConfig((String)"show_notcheck");
        if ("0".equals(showNotCheckConfig)) {
            qFilters.add(new QFilter("check_status", "!=", (Object)"3"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map callBackData;
        if (BTN_EDIT.equals(closedCallBackEvent.getActionId()) && null != (callBackData = (Map)closedCallBackEvent.getReturnData())) {
            JSONObject invoice = (JSONObject)callBackData.get("invoice");
            if ("1".equals(invoice.getString("checkStatus"))) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u67e5\u9a8c\u6210\u529f", (String)"InvoiceUncheckListPlugin_23", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25", (String)"InvoiceUncheckListPlugin_24", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refresh();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = event.getCurrentRow();
        this.openEditInvoicePage(currentRow.getPrimaryKeyValue());
    }

    private void openEditInvoicePage(Object primaryKey) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKey, (String)"rim_invoice_uncheck");
        Map map = VerifyUtil.getUncheckDetail((DynamicObject)dynamicObject);
        Map mainMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)((DynamicObject)map.get("main")));
        DynamicObject file = (DynamicObject)map.get("file");
        if (file == null) {
            file = InvoiceQueryService.queryInvoiceFile((String)dynamicObject.getString("tenant_no"), (String)dynamicObject.getString("serial_no"));
        }
        Map fileMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)file);
        InvoiceConvertService.putAll((Map)mainMap, (Map)fileMap);
        Object typeObject = dynamicObject.get("invoice_type");
        Long invoiceType = null;
        invoiceType = typeObject instanceof DynamicObject ? Long.valueOf(((DynamicObject)typeObject).getLong("id")) : Long.valueOf(dynamicObject.getLong("invoice_type"));
        Object invoiceCodeObj = mainMap.get("invoice_code");
        Object invoiceNoObj = mainMap.get("invoice_no");
        String invoiceCodeStr = null;
        String invoicenoStr = null;
        if (invoiceCodeObj != null && invoiceNoObj != null) {
            invoiceCodeStr = String.valueOf(invoiceCodeObj);
            invoicenoStr = String.valueOf(invoiceNoObj);
        }
        if (ObjectUtils.isEmpty((Object)invoiceType)) {
            String awsType = InvoiceConvertUtils.checkInvoiceType((String)invoiceCodeStr, invoicenoStr);
            invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)awsType);
        }
        InvoiceConvertService convertService = InvoiceConvertService.newInstance((Long)invoiceType);
        JSONObject result = convertService.convert(mainMap);
        result.put("resource", (Object)dynamicObject.getString("resource"));
        result.put("collect_type", (Object)dynamicObject.getString("collect_type"));
        result.put("authenticateFlag", dynamicObject.get("authenticate_flag"));
        result.put("authenticateTime", dynamicObject.get("authenticate_time"));
        result.put("selectTime", dynamicObject.get("select_time"));
        result.put("taxPeriod", dynamicObject.get("tax_period"));
        result.put("deductionPurpose", dynamicObject.get("deduction_purpose"));
        result.put("effectiveTaxAmount", dynamicObject.get("effective_tax_amount"));
        result.put("manageStatus", dynamicObject.get("manage_status"));
        result.put("fileName", dynamicObject.get("file_name"));
        result.put("pageNo", dynamicObject.get("page_no"));
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("invoiceId", primaryKey);
        customParams.put("invoice", result);
        customParams.put("editAllow", Boolean.TRUE);
        customParams.put("uncheckListFlag", "1");
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("rim_inv_collect_edit");
        showParameter.setCaption(ResManager.loadKDString((String)"\u53d1\u7968\u7f16\u8f91\u67e5\u9a8c", (String)"InvoiceUncheckListPlugin_25", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_EDIT);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }
}

