/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.OpenVoucherDetailService;
import org.apache.commons.collections.CollectionUtils;

public class InvoiceVouchListPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String CALL_BACK_KEY = "vouch_list";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List vouchList = (List)customParams.get("vouch");
        this.viewList(vouchList);
    }

    private void viewList(List<Map<String, Object>> vouchList) {
        this.getModel().deleteEntryData("entryentity");
        if (!CollectionUtils.isEmpty(vouchList)) {
            for (Map<String, Object> map : vouchList) {
                int index = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("serial_no", map.get("serial_no"), index);
                this.getModel().setValue("vouch_no", map.get("vouch_no"), index);
                this.getModel().setValue("invoice_code", map.get("invoice_code"), index);
                this.getModel().setValue("invoice_no", map.get("invoice_no"), index);
                this.getModel().setValue("invoice_type", map.get("invoice_type"), index);
                this.getModel().setValue("total_amount", map.get("total_amount"), index);
                this.getModel().setValue("id", map.get("id"), index);
            }
        }
    }

    private void addVouch() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            HashSet<Long> ids = new HashSet<Long>(selectRows.length);
            for (int selectRow : selectRows) {
                ids.add((Long)this.getModel().getValue("id", selectRow));
            }
            OpenVoucherDetailService.openAddVouch(this, CALL_BACK_KEY, ids.toArray());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"InvoiceVouchListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("close".equals(itemKey)) {
            this.getView().close();
        } else if ("add_vouch".equals(itemKey)) {
            this.addVouch();
        }
    }

    private void refreshList() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.selectRows(new int[0], 0);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String serials = (String)customParams.get("serials");
        List serialNos = CommonUtils.getMultiValues((String)serials);
        QFilter serialFilter = new QFilter("serial_no", "in", (Object)serialNos);
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,vouch_no,total_amount", (QFilter[])serialFilter.toArray());
        List vouchList = DynamicObjectUtil.dynamicObjectColletction2ListMap((DynamicObjectCollection)invoices);
        this.viewList(vouchList);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CALL_BACK_KEY.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            HashMap<String, String> customParams = new HashMap<String, String>(1);
            String serials = this.getPageCache().get("add_vouch_serials");
            String isVouchSerials = this.getPageCache().get("is_vouch_serials");
            customParams.put("serials", serials);
            customParams.put("isVouchSerials", isVouchSerials);
            ViewUtil.openDialog((AbstractFormPlugin)this, null, customParams, (String)"rim_add_vouch", (String)CALL_BACK_KEY);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map data = (Map)closedCallBackEvent.getReturnData();
        if (data == null) {
            if (CALL_BACK_KEY.equals(closedCallBackEvent.getActionId())) {
                this.refreshList();
            }
            return;
        }
        if (CALL_BACK_KEY.equals(closedCallBackEvent.getActionId())) {
            if ("1".equals(data.get("updateBillList"))) {
                this.refreshList();
                return;
            }
            String serials = (String)data.get("serials");
            List serialnos = CommonUtils.getMultiValues((String)serials);
            if (!ObjectUtils.isEmpty((Object)serialnos)) {
                OpenVoucherDetailService.updateVouch(data);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"InvoiceVouchListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                this.refreshList();
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (StringUtils.contains((CharSequence)fieldName, (CharSequence)"vouch_no")) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            String serialNo = (String)this.getModel().getValue("serial_no", rowIndex);
            OpenVoucherDetailService.openVoucherViewBySerialNo(this, serialNo, CALL_BACK_KEY);
        }
    }
}

