/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.formplugin.fpzs.FpzsMainPlugin;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateFactory;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;

public class InvoiceWarningListPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(FpzsMainPlugin.class);
    public static final String BILL_LIST_AP = "billlistap";
    private static final String RIM_WARNING_DETAIL = "rim_inv_warning_detail";
    private static final String CREATE_TIME = "createtime";
    private String[] ALL_RISK_TYPE = new String[]{"1", "2", "3", "5", "9", "10", "11", "12", "13", "14"};
    private static final String SELECT_FIELDS = "id, invoice_info,saler_name, buyer_name,invoice_code,invoice_no,total_amount,expense_num,createtime,org,vouch_no,authenticate_flag,resource,serial_no";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
    }

    public void afterCreateNewData(EventObject e) {
        this.loadData();
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        InvoiceOperateService service = InvoiceOperateFactory.newInstance(fieldName, null, this);
        int currentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        String idObject = this.getModel().getValue("main_id", currentIndex).toString();
        if (ObjectUtils.isEmpty((Object)idObject)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5f53\u524d\u53d1\u7968\u7684\u4e3b\u952e", (String)"InvoiceWarningListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = Long.valueOf(idObject.toString());
        ListSelectedRow currentSelectedRowInfo = new ListSelectedRow();
        currentSelectedRowInfo.setPrimaryKeyValue((Object)id);
        service.operate(currentSelectedRowInfo);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        InvoiceOperateService operateService = InvoiceOperateFactory.newInstance(key, null, this);
        if (operateService != null) {
            operateService.closedCallBack(closedCallBackEvent);
        }
    }

    private void loadData() {
        Date firstDateOfTheMonth = DateUtils.getFirstDateOfMonth((Date)new Date());
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean isShowTips = (Boolean)customParams.get("isShowTips");
        String dataPeriod = (String)customParams.get("dataPeriod");
        if (isShowTips || "1".equals(dataPeriod)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"startdatefield"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"midword"});
            this.getModel().setValue("createdatefield", customParams.get("endTime"));
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap5"});
        } else {
            this.getModel().setValue("startdatefield", (Object)firstDateOfTheMonth);
            this.getView().setVisible(Boolean.TRUE, new String[]{"startdatefield"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"midword"});
            this.getModel().setValue("createdatefield", customParams.get("endTime"));
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap5"});
        }
        Date warningExecuteDate = null;
        String warningDateStr = CacheHelper.get((String)"rim_warning_execute_time");
        if (!ObjectUtils.isEmpty((Object)warningDateStr)) {
            warningExecuteDate = DateUtils.stringToDate((String)warningDateStr, (String)"yyyy-MM-dd HH:mm:ss");
        }
        String warningType = (String)customParams.get("warningType");
        List orgList = (List)customParams.get("orgList");
        QFilter warningDetailCommonFilter = new QFilter("detail_period", "=", (Object)dataPeriod);
        QFilter invoiceCommonFilter = "0".equals(dataPeriod) ? new QFilter("delete", "=", (Object)"1").and(CREATE_TIME, ">=", (Object)firstDateOfTheMonth) : new QFilter("delete", "=", (Object)"1");
        if (!ObjectUtils.isEmpty((Object)warningExecuteDate)) {
            invoiceCommonFilter.and(CREATE_TIME, "<=", (Object)warningExecuteDate);
        }
        if (!CollectionUtils.isEmpty((Collection)orgList)) {
            invoiceCommonFilter.and("org", "in", (Object)orgList);
            warningDetailCommonFilter.and("org", "in", (Object)orgList);
        } else {
            invoiceCommonFilter.and("org", "=", (Object)RequestContext.get().getOrgId());
            warningDetailCommonFilter.and("org", "=", (Object)RequestContext.get().getOrgId());
        }
        String invoiceStatus = "0";
        if (ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"InvoiceWarningListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(warningType)) {
            this.getSerialNoResult(warningDetailCommonFilter, "10");
        } else if (ResManager.loadKDString((String)"\u7ea2\u51b2", (String)"InvoiceWarningListPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(warningType)) {
            this.getSerialNoResult(warningDetailCommonFilter, "11");
        } else if (ResManager.loadKDString((String)"\u5f02\u5e38", (String)"InvoiceWarningListPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(warningType)) {
            this.getSerialNoResult(warningDetailCommonFilter, "12");
        } else if (ResManager.loadKDString((String)"\u5931\u63a7", (String)"InvoiceWarningListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(warningType)) {
            this.getSerialNoResult(warningDetailCommonFilter, "9");
        }
        if (ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25", (String)"InvoiceWarningListPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(warningType)) {
            this.getSerialNoResult(warningDetailCommonFilter, "13");
        }
        if (ResManager.loadKDString((String)"\u9ed1\u540d\u5355", (String)"InvoiceWarningListPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(warningType)) {
            this.getSerialNoResult(warningDetailCommonFilter, "1");
        }
        if (ResManager.loadKDString((String)"\u654f\u611f\u8bcd\u53d1\u7968", (String)"InvoiceWarningListPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(warningType)) {
            this.getSerialNoResult(warningDetailCommonFilter, "2");
        }
        if (ResManager.loadKDString((String)"\u7535\u7968\u975e\u6e90\u6587\u4ef6", (String)"InvoiceWarningListPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(warningType)) {
            this.getSerialNoResult(warningDetailCommonFilter, "14");
        }
        if (ResManager.loadKDString((String)"\u4e13\u7968\u8d2d\u65b9\u4fe1\u606f\u4e0d\u5b8c\u6574", (String)"InvoiceWarningListPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(warningType)) {
            this.getSerialNoResult(warningDetailCommonFilter, "3");
        }
        if (ResManager.loadKDString((String)"\u8282\u5047\u65e5\u53d1\u7968\u62a5\u9500", (String)"InvoiceWarningListPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(warningType)) {
            this.getSerialNoResult(warningDetailCommonFilter, "4");
        }
        if (ResManager.loadKDString((String)"\u8d85\u671f\u9650\u62a5\u9500\u53d1\u7968", (String)"InvoiceWarningListPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(warningType)) {
            this.getSerialNoResult(warningDetailCommonFilter, "5");
        }
        if ("new_risk".equals(warningType) || "exception_num".equals(warningType)) {
            this.getAllRiskSerialNo(warningDetailCommonFilter);
        }
        QFilter qFilter = !CollectionUtils.isEmpty((Collection)orgList) ? new QFilter("org", "in", (Object)orgList) : new QFilter("org", "=", (Object)RequestContext.get().getOrgId());
        if ("big_amount".equals(warningType)) {
            this.getSerialNoResult(qFilter, "21");
        }
        if ("beyond60".equals(warningType)) {
            this.getSerialNoResult(warningDetailCommonFilter, "6");
        }
        if ("beyond90".equals(warningType)) {
            this.getSerialNoResult(warningDetailCommonFilter, "7");
        }
        if ("undeduction".equals(warningType)) {
            this.getSerialNoResult(qFilter, "20");
        }
        if ("selected".equals(warningType)) {
            this.getSerialNoResult(qFilter, "22");
        }
    }

    private void getSerialNoResult(QFilter warningDetailCommonFilter, String warning_type) {
        ArrayList<String> serialNos = new ArrayList<String>(16);
        warningDetailCommonFilter.and("warning_type", "=", (Object)warning_type);
        QFilter warningTypeFilter = warningDetailCommonFilter.copy().and("warning_type", "=", (Object)warning_type);
        logger.info("\u8fdb\u9879\u7edf\u8ba1\u660e\u7ec6\u53c2\u6570:" + warningTypeFilter);
        DynamicObjectCollection serialNoCollection = QueryServiceHelper.query((String)RIM_WARNING_DETAIL, (String)"serial_no, warning_type", (QFilter[])warningTypeFilter.toArray());
        if (!serialNoCollection.isEmpty()) {
            for (DynamicObject dynamicObject : serialNoCollection) {
                if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
                serialNos.add(dynamicObject.getString("serial_no"));
            }
            if (CollectionUtils.isEmpty(serialNos)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u53d1\u7968", (String)"InvoiceWarningListPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter invoiceFilter = new QFilter("serial_no", "in", serialNos);
            this.freshBillList(invoiceFilter);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u53d1\u7968", (String)"InvoiceWarningListPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    private void getAllRiskSerialNo(QFilter warningDetailCommonFilter) {
        warningDetailCommonFilter.and("warning_type", "in", (Object)this.ALL_RISK_TYPE);
        DynamicObjectCollection serialNoCollection = QueryServiceHelper.query((String)RIM_WARNING_DETAIL, (String)"serial_no, warning_type", (QFilter[])warningDetailCommonFilter.toArray());
        HashMap<String, String> serialWarnType = new HashMap<String, String>(16);
        if (serialNoCollection == null || serialNoCollection.size() == 0) {
            return;
        }
        for (DynamicObject dynamicObject : serialNoCollection) {
            String warningType;
            if (dynamicObject == null) continue;
            String serialNo = dynamicObject.getString("serial_no");
            switch (warningType = dynamicObject.getString("warning_type")) {
                case "1": {
                    warningType = ResManager.loadKDString((String)"\u9ed1\u540d\u5355\u53d1\u7968", (String)"InvoiceWarningListPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "2": {
                    warningType = ResManager.loadKDString((String)"\u654f\u611f\u8bcd\u53d1\u7968", (String)"InvoiceWarningListPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "3": {
                    warningType = ResManager.loadKDString((String)"\u4e13\u7968\u4fe1\u606f\u4e0d\u5b8c\u6574\u53d1\u7968", (String)"InvoiceWarningListPlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "5": {
                    warningType = ResManager.loadKDString((String)"\u8d85\u671f\u9650\u62a5\u9500\u53d1\u7968", (String)"InvoiceWarningListPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "9": {
                    warningType = ResManager.loadKDString((String)"\u5931\u63a7\u53d1\u7968", (String)"InvoiceWarningListPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "10": {
                    warningType = ResManager.loadKDString((String)"\u4f5c\u5e9f\u53d1\u7968", (String)"InvoiceWarningListPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "11": {
                    warningType = ResManager.loadKDString((String)"\u7ea2\u51b2\u53d1\u7968", (String)"InvoiceWarningListPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "12": {
                    warningType = ResManager.loadKDString((String)"\u5f02\u5e38\u53d1\u7968", (String)"InvoiceWarningListPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "13": {
                    warningType = ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25\u53d1\u7968", (String)"InvoiceWarningListPlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "14": {
                    warningType = ResManager.loadKDString((String)"\u7535\u7968\u975e\u6e90\u6587\u4ef6", (String)"InvoiceWarningListPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
            }
            String allWarnType = (String)serialWarnType.get(serialNo);
            allWarnType = StringUtils.isEmpty((CharSequence)allWarnType) ? warningType : allWarnType.concat(",").concat(warningType);
            serialWarnType.put(serialNo, allWarnType);
        }
        QFilter invoiceFilter = new QFilter("serial_no", "in", serialWarnType.keySet());
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"rim_invoice", (String)SELECT_FIELDS, (QFilter[])invoiceFilter.toArray());
        this.updateModel(invoices, serialWarnType);
        serialWarnType.clear();
    }

    private void freshBillList(QFilter filter) {
        DynamicObjectCollection invoices;
        if (ObjectUtils.isEmpty((Object)filter)) {
            filter = new QFilter("invoice_no", "=", (Object)"0").and("invoice_code", "=", (Object)"0");
        }
        if ((invoices = QueryServiceHelper.query((String)"rim_invoice", (String)SELECT_FIELDS, (QFilter[])filter.toArray())) == null || invoices.size() == 0) {
            return;
        }
        this.updateModel(invoices, null);
    }

    private void updateModel(DynamicObjectCollection invoices, Map<String, String> serialWarnType) {
        IDataModel model = this.getModel();
        if (serialWarnType != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"risk_describe"});
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String warningType = (String)customParams.get("warningType");
        BigDecimal totalAmountSum = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (invoices == null || invoices.size() == 0) {
            return;
        }
        int[] entryentities = model.batchCreateNewEntryRow("entryentity", invoices.size());
        int row = 0;
        for (DynamicObject dynamicObject : invoices) {
            if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
            int index = entryentities[row];
            if (serialWarnType != null) {
                String serialNo = dynamicObject.getString("serial_no");
                model.setValue("risk_describe", (Object)serialWarnType.get(serialNo), index);
            }
            totalAmount = dynamicObject.getBigDecimal("total_amount");
            model.setValue("main_id", dynamicObject.get("id"), index);
            model.setValue("invoice_info", dynamicObject.get("invoice_info"), index);
            model.setValue("saler_name", dynamicObject.get("saler_name"), index);
            model.setValue("buyer_name", dynamicObject.get("buyer_name"), index);
            model.setValue("invoice_code", dynamicObject.get("invoice_code"), index);
            model.setValue("invoice_no", dynamicObject.get("invoice_no"), index);
            model.setValue("total_amount", (Object)totalAmount, index);
            model.setValue("expense_num", dynamicObject.get("expense_num"), index);
            model.setValue("org", dynamicObject.get("org"), index);
            model.setValue(CREATE_TIME, dynamicObject.get(CREATE_TIME), index);
            model.setValue("vouch_no", dynamicObject.get("vouch_no"), index);
            model.setValue("authenticate_flag", dynamicObject.get("authenticate_flag"), index);
            model.setValue("resource", dynamicObject.get("resource"), index);
            totalAmountSum = totalAmountSum.add(totalAmount);
            ++row;
        }
        int invoiceCount = model.getEntryRowCount("entryentity");
        Label label = (Label)this.getControl("labelap");
        if ("big_amount".equals(warningType)) {
            BigDecimal largeAmount = BigDecimal.valueOf(100000L);
            String largeAmountStr = RimConfigUtils.getConfig((String)"rim_config", (String)"large_amount");
            if (!StringUtils.isEmpty((CharSequence)largeAmountStr)) {
                largeAmount = new BigDecimal(largeAmountStr);
            }
            Label attentionlabel = (Label)this.getControl("attention_label");
            attentionlabel.setText(ResManager.loadKDString((String)"\u6ce8\uff1a\u5355\u5f20\u7968\u9762\u91d1\u989d\u2265\u00a5", (String)"InvoiceWarningListPlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]).concat(largeAmount.setScale(2, 4).toEngineeringString()).concat(ResManager.loadKDString((String)"\u5143\u4e3a\u5927\u989d\u53d1\u7968", (String)"InvoiceWarningListPlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        }
        DecimalFormat df = new DecimalFormat("###,###");
        String format = df.format(totalAmountSum.setScale(2, 4));
        label.setText(ResManager.loadKDString((String)"\u5171", (String)"InvoiceWarningListPlugin_22", (String)"imc-rim-formplugin", (Object[])new Object[0]).concat(String.valueOf(invoiceCount)).concat(ResManager.loadKDString((String)"\u6761\u6570\u636e\uff0c\u5408\u8ba1\u91d1\u989d \u00a5", (String)"InvoiceWarningListPlugin_23", (String)"imc-rim-formplugin", (Object[])new Object[0])).concat(format));
    }
}

