/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.license.LicenseFormPlugin;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.collections.CollectionUtils;

public class InvoiceWarningPlugin
extends LicenseFormPlugin
implements TabSelectListener {
    private static final String TOP_TOOL_BARAP = "toolbarap1";
    private static final String CHART_TOOL_BARAP = "toolbarap";
    private static final String RIM_INV_WARNING_TABLE = "rim_inv_warning_data";

    private static List<String> getNames() {
        ArrayList<String> list = new ArrayList<String>(16);
        list.add(ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"InvoiceWarningPlugin_36", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u7ea2\u51b2", (String)"InvoiceWarningPlugin_37", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u5f02\u5e38", (String)"InvoiceWarningPlugin_38", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u5931\u63a7", (String)"InvoiceWarningPlugin_39", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25", (String)"InvoiceWarningPlugin_40", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u9ed1\u540d\u5355", (String)"InvoiceWarningPlugin_41", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u654f\u611f\u8bcd\u53d1\u7968", (String)"InvoiceWarningPlugin_42", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u7535\u7968\u975e\u6e90\u6587\u4ef6", (String)"InvoiceWarningPlugin_43", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u4e13\u7968\u8d2d\u65b9\u4fe1\u606f\u4e0d\u5b8c\u6574", (String)"InvoiceWarningPlugin_44", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u8d85\u671f\u9650\u62a5\u9500\u53d1\u7968", (String)"InvoiceWarningPlugin_45", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        return list;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addItemClickListeners(new String[]{TOP_TOOL_BARAP});
        this.addItemClickListeners(new String[]{CHART_TOOL_BARAP});
        this.addClickListeners(new String[]{"histogramchartap", "new_risk", "big_amount", "beyond60", "beyond90", "undeduction", "selected", "exception_num"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        List<Long> orgList = this.getOrgList();
        String currentTab = this.getView().getPageCache().get("current_tab");
        if (StringUtils.isEmpty((CharSequence)currentTab)) {
            currentTab = "monthly";
        }
        if ("query".equals(evt.getItemKey()) && "monthly".equals(currentTab)) {
            this.showData(orgList, Boolean.FALSE);
        } else if ("query".equals(evt.getItemKey()) && "all".equals(currentTab)) {
            this.showData(orgList, Boolean.TRUE);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        List<Long> orgList = this.getOrgList();
        if ("all".equals(tabKey)) {
            this.showData(orgList, Boolean.TRUE);
            this.getView().getPageCache().put("current_tab", "all");
            this.getView().setVisible(Boolean.FALSE, new String[]{"startdatefield"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"midword"});
        }
        if ("monthly".equals(tabKey)) {
            this.showData(orgList, Boolean.FALSE);
            this.getView().getPageCache().put("current_tab", "monthly");
            this.getView().setVisible(Boolean.TRUE, new String[]{"startdatefield"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"midword"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("org", (Object)new Long[]{RequestContext.get().getOrgId()});
        Date warningExecuteDate = new Date();
        String warningDateStr = CacheHelper.get((String)"rim_warning_execute_time");
        if (!ObjectUtils.isEmpty((Object)warningDateStr)) {
            warningExecuteDate = DateUtils.stringToDate((String)warningDateStr, (String)"yyyy-MM-dd HH:mm:ss");
        }
        this.getModel().setValue("createdatefield", (Object)warningExecuteDate);
        Date firstDateOfTheMonth = DateUtils.getFirstDateOfMonth((Date)new Date());
        this.getModel().setValue("startdatefield", (Object)firstDateOfTheMonth);
        ((Image)this.getControl("imageap")).setUrl("/icons/pc/label/fpy_warning.png");
        List<Long> orgList = this.getOrgList();
        this.showData(orgList, Boolean.FALSE);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt instanceof ChartClickEvent) {
            ChartClickEvent chartClickEvent = (ChartClickEvent)evt;
            String clickName = chartClickEvent.getName();
            if (StringUtils.isBlank((CharSequence)clickName)) {
                return;
            }
            this.showWarningList(clickName, false);
            return;
        }
        Control control = (Control)evt.getSource();
        if ("new_risk".equals(control.getKey())) {
            this.showWarningList("new_risk", true);
            return;
        }
        if ("exception_num".equals(control.getKey())) {
            this.showWarningList("new_risk", false);
            return;
        }
        if ("big_amount".equals(control.getKey())) {
            this.showWarningList("big_amount", true);
            return;
        }
        if ("beyond60".equals(control.getKey())) {
            this.showWarningList("beyond60", true);
            return;
        }
        if ("beyond90".equals(control.getKey())) {
            this.showWarningList("beyond90", true);
            return;
        }
        if ("undeduction".equals(control.getKey())) {
            this.showWarningList("undeduction", true);
            return;
        }
        if ("selected".equals(control.getKey())) {
            this.showWarningList("selected", true);
            return;
        }
    }

    private List<Long> getOrgList() {
        ArrayList<Long> orgList = new ArrayList<Long>();
        DynamicObjectCollection orgCollection = (DynamicObjectCollection)this.getModel().getValue("org");
        if (CollectionUtils.isNotEmpty((Collection)orgCollection)) {
            for (int i = 0; i < orgCollection.size(); ++i) {
                orgList.add(((DynamicObject)orgCollection.get(i)).getLong("fbasedataid_id"));
            }
        } else {
            orgList.add(RequestContext.get().getOrgId());
        }
        return orgList;
    }

    private void showWarningList(String warningType, boolean isShowTips) {
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("warningType", warningType);
        if ("beyond60".equals(warningType) || "beyond90".equals(warningType) || "big_amount".equals(warningType) || "undeduction".equals(warningType) || "selected".equals(warningType)) {
            customParams.put("dataPeriod", "1");
        } else {
            customParams.put("dataPeriod", this.getView().getPageCache().get("data_period"));
        }
        List<Long> orgList = this.getOrgList();
        customParams.put("orgList", orgList);
        customParams.put("startTime", this.getModel().getValue("startdatefield"));
        customParams.put("endTime", this.getModel().getValue("createdatefield"));
        customParams.put("isShowTips", isShowTips);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("rim_inv_warning_list");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_inv_warning_list");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private int countInvoiceNum(QFilter dataFilter, String data_type) {
        QFilter numCountFilter = dataFilter.copy();
        numCountFilter.and("data_type", "=", (Object)data_type);
        String selectFields = "data_value as ".concat(data_type);
        DynamicObjectCollection data = QueryServiceHelper.query((String)RIM_INV_WARNING_TABLE, (String)selectFields, (QFilter[])numCountFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)data)) {
            return 0;
        }
        int countAll = 0;
        int singleOrgCount = 0;
        for (DynamicObject dynamicObject : data) {
            if (dynamicObject == null) continue;
            singleOrgCount = dynamicObject.getInt(data_type);
            countAll += singleOrgCount;
        }
        return countAll;
    }

    private BigDecimal sumInvoiceAmount(QFilter dataFilter, String data_type) {
        QFilter numCountFilter = dataFilter.copy();
        numCountFilter.and("data_type", "=", (Object)data_type);
        String selectFields = "data_value as ".concat(data_type);
        DynamicObjectCollection data = QueryServiceHelper.query((String)RIM_INV_WARNING_TABLE, (String)selectFields, (QFilter[])numCountFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)data)) {
            return BigDecimal.ZERO;
        }
        BigDecimal sumAll = BigDecimal.ZERO;
        BigDecimal singleOrgAmount = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : data) {
            if (dynamicObject == null) continue;
            singleOrgAmount = dynamicObject.getBigDecimal(data_type);
            sumAll = sumAll.add(singleOrgAmount);
        }
        return sumAll.divide(new BigDecimal(10000)).setScale(2, 1);
    }

    private void showData(List<Long> orgList, Boolean isAll) {
        int sumCount;
        Date warningExecuteDate;
        if (CollectionUtils.isEmpty(orgList)) {
            orgList = new ArrayList<Long>(1);
            orgList.add(RequestContext.get().getOrgId());
        }
        String dataPeriod = isAll != false ? "1" : "0";
        this.getView().getPageCache().put("data_period", dataPeriod);
        QFilter chartDataFilter = new QFilter("org", "in", orgList).and("data_period", "=", (Object)dataPeriod);
        QFilter cardDataFilter = new QFilter("org", "in", orgList).and("data_period", "=", (Object)"1");
        int abounded_num = this.countInvoiceNum(chartDataFilter, "abounded_num");
        int red_num = this.countInvoiceNum(chartDataFilter, "red_num");
        int abnormal_num = this.countInvoiceNum(chartDataFilter, "abnormal_num");
        int lost_control_num = this.countInvoiceNum(chartDataFilter, "lost_control_num");
        int check_fail_num = this.countInvoiceNum(chartDataFilter, "check_fail_num");
        int black_list = this.countInvoiceNum(chartDataFilter, "black_list");
        int sensitive_words = this.countInvoiceNum(chartDataFilter, "sensitive_words");
        int unoriginal_einvoice = this.countInvoiceNum(chartDataFilter, "unoriginal_einvoice");
        int special_uncompelete = this.countInvoiceNum(chartDataFilter, "special_uncompelete");
        int beyond_expense_date = this.countInvoiceNum(chartDataFilter, "beyond_expense_date");
        int exceptionCount = this.countInvoiceNum(chartDataFilter, "exception_count");
        BigDecimal exceptionAmount = this.sumInvoiceAmount(chartDataFilter, "exception_amount");
        Label numTag = (Label)this.getControl("exception_num");
        Label sumTag = (Label)this.getControl("exception_sum");
        numTag.setText(String.valueOf(exceptionCount));
        sumTag.setText(String.valueOf(exceptionAmount));
        QFilter mainInvoiceFilter = new QFilter("delete", "=", (Object)Character.valueOf('1')).and("org", "in", orgList);
        if ("0".equals(dataPeriod)) {
            Date firstDateOfTheMonth = DateUtils.getFirstDateOfMonth((Date)new Date());
            mainInvoiceFilter.and("createtime", ">=", (Object)firstDateOfTheMonth);
        }
        if (!ObjectUtils.isEmpty((Object)(warningExecuteDate = new Date()))) {
            mainInvoiceFilter.and("createtime", "<=", (Object)warningExecuteDate);
        }
        DynamicObject invoiceResult = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"sum(total_amount) as amount, count(serial_no) as num", (QFilter[])mainInvoiceFilter.toArray());
        int normalCount = sumCount = invoiceResult.getInt("num");
        if (sumCount >= exceptionCount) {
            normalCount = sumCount - exceptionCount;
        }
        int big_amount_num = this.countInvoiceNum(cardDataFilter, "big_amount_num");
        BigDecimal big_amount_sum = this.sumInvoiceAmount(cardDataFilter, "big_amount_sum");
        int beyond_60days = this.countInvoiceNum(cardDataFilter, "beyond_60days");
        int beyond_90days = this.countInvoiceNum(cardDataFilter, "beyond_90days");
        int undeduction_num = this.countInvoiceNum(cardDataFilter, "undeduction_num");
        BigDecimal undeduction_amount = this.sumInvoiceAmount(cardDataFilter, "undeduction_amount");
        int selected_unsigned_num = this.countInvoiceNum(cardDataFilter, "selected_unsigned_num");
        BigDecimal selected_unsigned_amount = this.sumInvoiceAmount(cardDataFilter, "selected_unsigned_amount");
        this.getModel().setValue("exception_count", (Object)exceptionCount);
        this.getModel().setValue("exception_amount", (Object)exceptionAmount);
        BigDecimal largeAmount = BigDecimal.valueOf(100000L);
        String largeAmountStr = RimConfigUtils.getConfig((String)"rim_config", (String)"large_amount");
        if (!StringUtils.isEmpty((CharSequence)largeAmountStr)) {
            largeAmount = new BigDecimal(largeAmountStr);
        }
        Label label = (Label)this.getControl("label_amount");
        largeAmount = largeAmount.divide(new BigDecimal(10000), 2, 4);
        label.setText(String.format(ResManager.loadKDString((String)"\uff08\u4ef7\u7a0e\u5408\u8ba1\u2265%1$s\u4e07\uff09", (String)"InvoiceWarningPlugin_35", (String)"imc-rim-formplugin", (Object[])new Object[0]), largeAmount));
        this.getModel().setValue("big_amount_num", (Object)big_amount_num);
        this.getModel().setValue("big_amount_sum", (Object)big_amount_sum);
        this.getModel().setValue("beyond_60days", (Object)beyond_60days);
        this.getModel().setValue("beyond_90days", (Object)beyond_90days);
        this.getModel().setValue("undeduction_num", (Object)undeduction_num);
        this.getModel().setValue("undeduction_amount", (Object)undeduction_amount);
        this.getModel().setValue("selected_unsigned_num", (Object)selected_unsigned_num);
        this.getModel().setValue("selected_unsigned_amount", (Object)selected_unsigned_amount);
        if (isAll.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"all"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"monthly"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"all"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"monthly"});
        }
        ItemValue[] itemValues = new ItemValue[]{new ItemValue(ResManager.loadKDString((String)"\u6b63\u5e38\u53d1\u7968", (String)"InvoiceWarningPlugin_46", (String)"imc-rim-formplugin", (Object[])new Object[0]), (Number)normalCount, "#40A9FF"), new ItemValue(ResManager.loadKDString((String)"\u5f02\u5e38\u53d1\u7968", (String)"InvoiceWarningPlugin_47", (String)"imc-rim-formplugin", (Object[])new Object[0]), (Number)exceptionCount, "#FFA940")};
        this.createPieChart("piechartap", itemValues, ResManager.loadKDString((String)"\u53d1\u7968\u6570\u91cf(\u5f20)", (String)"InvoiceWarningPlugin_48", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        HistogramChart barChart = this.getMainChart();
        if (!ObjectUtils.isEmpty((Object)barChart)) {
            barChart.clearData();
        }
        ArrayList<Number> invoiceDatas = new ArrayList<Number>(11);
        invoiceDatas.add(abounded_num);
        invoiceDatas.add(red_num);
        invoiceDatas.add(abnormal_num);
        invoiceDatas.add(lost_control_num);
        invoiceDatas.add(check_fail_num);
        invoiceDatas.add(black_list);
        invoiceDatas.add(sensitive_words);
        invoiceDatas.add(unoriginal_einvoice);
        invoiceDatas.add(special_uncompelete);
        invoiceDatas.add(beyond_expense_date);
        Axis categoryAxis = this.createCategoryAxis(ResManager.loadKDString((String)"\u5f02\u5e38\u5bf9\u8c61", (String)"InvoiceWarningPlugin_49", (String)"imc-rim-formplugin", (Object[])new Object[0]), true);
        categoryAxis.setCategorys(InvoiceWarningPlugin.getNames());
        this.createValueAxis(ResManager.loadKDString((String)"\u4efd", (String)"InvoiceWarningPlugin_50", (String)"imc-rim-formplugin", (Object[])new Object[0]), false);
        BarSeries countSeries = this.createBarSeries(ResManager.loadKDString((String)"\u4efd\u6570", (String)"InvoiceWarningPlugin_51", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceDatas, "#40A9FF");
        countSeries.setBarWidth("50%");
        barChart.setMargin(Position.right, "65px");
        barChart.setMargin(Position.top, "15px");
        barChart.refresh();
    }

    private void createPieChart(String pieFlag, ItemValue[] itemValues, String unit) {
        PieChart pieChart = (PieChart)this.getControl(pieFlag);
        pieChart.clearData();
        boolean isShowTitle = false;
        boolean isShowTooltip = true;
        pieChart.setShowTitle(isShowTitle);
        pieChart.setShowTooltip(isShowTooltip);
        pieChart.setShowLegend(isShowTooltip);
        pieChart.setMargin(Position.right, "80px");
        pieChart.setMargin(Position.top, "60px");
        pieChart.setLegendPropValue("orient", (Object)"vertical");
        pieChart.setLegendPropValue("icon", (Object)"circle");
        pieChart.setLegendPropValue("left", (Object)"65%");
        HashMap<String, String> textStyle = new HashMap<String, String>(1);
        textStyle.put("color", "#666666");
        pieChart.setLegendPropValue("textStyle", textStyle);
        HashMap<String, String> itemStyle = new HashMap<String, String>(1);
        itemStyle.put("borderWidth", "5");
        pieChart.setLegendPropValue("itemStyle", itemStyle);
        PieSeries pieSeries = pieChart.createPieSeries(unit);
        pieSeries.setRadius("40%", "70%");
        pieSeries.setCenter("42%", "46%");
        pieSeries.setData(itemValues);
        kd.bos.form.chart.Label pieLabel = new kd.bos.form.chart.Label();
        pieLabel.setShow(true);
        pieLabel.setPosition(Position.top);
        pieLabel.setFormatter("{d}%");
        pieSeries.setLabel(pieLabel);
        pieChart.refresh();
    }

    private Axis createCategoryAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.category) : this.getMainChart().createYAxis(name, AxisType.category);
        HashMap<String, Integer> axisTick = new HashMap<String, Integer>();
        axisTick.put("interval", 0);
        HashMap<String, Object> axisLabel = new HashMap<String, Object>();
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("rotate", 15);
        axisLabel.put("interval", 0);
        axisLabel.put("color", "black");
        axis.setPropValue("axisTick", axisTick);
        axis.setPropValue("axisLabel", axisLabel);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private Axis createValueAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.value) : this.getMainChart().createYAxis(name, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(8);
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap(8);
        HashMap<String, String> lineStyle = new HashMap<String, String>(8);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        this.getMainChart().setShowTooltip(true);
        axis.setPropValue("minInterval", (Object)1);
        return axis;
    }

    private HistogramChart getMainChart() {
        return (HistogramChart)this.getControl("histogramchartap");
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap(4);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(4);
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private BarSeries createBarSeries(String name, List<Number> values, String color) {
        BarSeries barSeries = this.getMainChart().createBarSeries(name);
        barSeries.setItemColor(color);
        barSeries.setAnimationDuration(2000);
        barSeries.setData(values.toArray(new Number[0]));
        return barSeries;
    }
}

