/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.CheckContant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;

public class PersonTicketCheckListPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("check_list");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("edit".equals(operateKey)) {
            int index = this.getModel().getEntryCurrentRowIndex("check_list");
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("check_list", index);
            String invoice = dynamicObject.getString("invoice_json");
            FormShowParameter showParameter = this.newEditPage(invoice, index);
            this.getView().showForm(showParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object personTicketInvoices = customParams.get("personTicketInvoices");
        if (personTicketInvoices == null) {
            return;
        }
        JSONArray invoiceArray = JSONObject.parseArray((String)personTicketInvoices.toString());
        for (int i = 0; i < invoiceArray.size(); ++i) {
            JSONObject invoice = invoiceArray.getJSONObject(i);
            int row = this.getModel().createNewEntryRow("check_list");
            this.setEntityRowInfo(invoice, row);
        }
    }

    private void setEntityRowInfo(JSONObject invoice, int row) {
        Long typeLong = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoice.getString("invoiceType"));
        InputInvoiceTypeEnum invoiceType = InputInvoiceTypeEnum.getInvoiceType((Long)typeLong);
        String type = invoiceType == null ? "" : invoiceType.getName();
        this.getModel().setValue("invoicetype", (Object)type, row);
        String invoiceCode = invoice.getString("invoiceCode");
        this.getModel().setValue("invoicecode", (Object)(StringUtils.isEmpty((String)invoiceCode) ? "" : invoiceCode), row);
        this.getModel().setValue("invoiceno", (Object)invoice.getString("invoiceNo"), row);
        this.getModel().setValue("invoicedate", (Object)invoice.getDate("invoiceDate"), row);
        this.getModel().setValue("invoiceamount", (Object)invoice.getString("invoiceAmount"), row);
        this.getModel().setValue("checkcode", (Object)invoice.getString("checkCode"), row);
        String checkStatus = invoice.getString("checkStatus");
        if ("1".equals(checkStatus)) {
            this.getModel().setValue("check_status", (Object)ResManager.loadKDString((String)"\u6210\u529f", (String)"InvoiceEditOpenService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), row);
            this.getModel().setValue("checkdesc", (Object)"", row);
        } else {
            this.getModel().setValue("check_status", (Object)ResManager.loadKDString((String)"\u5931\u8d25", (String)"SelectInvoiceExcelService_52", (String)"imc-rim-formplugin", (Object[])new Object[0]), row);
            String desc = CheckContant.getCheckResultDesc((String)invoice.getString("errcode"));
            if (StringUtils.isEmpty((String)desc)) {
                desc = invoice.getString("description");
            }
            this.getModel().setValue("checkdesc", (Object)desc, row);
        }
        this.getModel().setValue("invoice_json", (Object)invoice, row);
        if (StringUtils.isEmpty((String)invoice.getString("serialNo"))) {
            this.getModel().setValue("checkdesc", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u5fc5\u8981\u5b57\u6bb5\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvoiceCollectCheckFailPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), row);
        }
    }

    private FormShowParameter newEditPage(String invoice, int row) {
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("invoice", invoice);
        customParams.put("row", row);
        showParameter.setShowTitle(true);
        showParameter.setCustomParams(customParams);
        showParameter.setFormId("rim_inv_collect_edit");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "editCallback");
        showParameter.setCloseCallBack(closeCallBack);
        return showParameter;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getEntryEntity("check_list").get(hyperLinkClickEvent.getRowIndex());
        String invoice = dynamicObject.getString("invoice_json");
        FormShowParameter showParameter = this.newEditPage(invoice, hyperLinkClickEvent.getRowIndex());
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && "editCallback".equals(actionId)) {
            HashMap result = (HashMap)returnData;
            int row = (Integer)result.get("row");
            JSONObject invoice = (JSONObject)result.get("invoice");
            this.setEntityRowInfo(invoice, row);
        }
    }
}

