/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.config;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import org.apache.commons.lang3.StringUtils;

public class RimConfigEditPlugin
extends AbstractFormPlugin {
    private static final Set<String> ENCRYPT_FIELDS = new HashSet<String>(8){
        private static final long serialVersionUID = -2012333430055776732L;
        {
            this.add("aisino_secret");
            this.add("aisino_encrypt_key");
            this.add("aisino_3des_key");
            this.add("rappkey");
            this.add("rappsecret");
            this.add("customappkey");
            this.add("customappsecret");
            this.add("financialappkey");
            this.add("financialappsecret");
            this.add("salelistappkey");
            this.add("salelistappsecret");
        }
    };

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        Boolean endable = Boolean.TRUE;
        Boolean disable = Boolean.FALSE;
        this.enable(disable);
        this.getView().setVisible(disable, new String[]{"save"});
        this.getView().setVisible(endable, new String[]{"edit"});
        this.getView().setVisible(disable, new String[]{"cancel"});
        this.loadData();
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        Boolean endable = Boolean.TRUE;
        Boolean disable = Boolean.FALSE;
        IPageCache page = this.getPageCache();
        if ("save".equals(key)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String configType = (String)customParams.get("config_type");
            MainEntityType entityType = this.getModel().getDataEntityType();
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ArrayList<String> keyList = new ArrayList<String>(8);
            for (IDataEntityProperty property : entityType.getProperties()) {
                String name = property.getName();
                Object value = this.getModel().getValue(name);
                if (value == null) continue;
                String valueStr = null;
                valueStr = value instanceof Date ? sdf.format(value) : (ENCRYPT_FIELDS.contains(name) ? page.get(name) : value.toString());
                String config_key = configType + "_" + property.getName();
                keyList.add(config_key);
                keyList.add(property.getName());
                if (StringUtils.isEmpty((CharSequence)valueStr)) continue;
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"invsm_param_configuration");
                object.set("config_type", (Object)configType);
                object.set("config_key", (Object)config_key);
                object.set("config_value", (Object)valueStr);
                list.add(object);
            }
            QFilter filter = new QFilter("config_type", "=", (Object)configType);
            QFilter keyfilter = new QFilter("config_key", "in", keyList);
            DeleteServiceHelper.delete((String)"invsm_param_configuration", (QFilter[])new QFilter[]{filter, keyfilter});
            if (!list.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            }
            CacheHelper.remove((String)configType);
            this.getView().setVisible(disable, new String[]{"save"});
            this.getView().setVisible(endable, new String[]{"edit"});
            this.getView().setVisible(disable, new String[]{"cancel"});
            this.enable(disable);
            this.loadData();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"RimConfigEditPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else if ("cancel".equals(key)) {
            this.getView().setVisible(disable, new String[]{"save"});
            this.getView().setVisible(endable, new String[]{"edit"});
            this.getView().setVisible(disable, new String[]{"cancel"});
            this.enable(disable);
            this.loadData();
        } else if ("edit".equals(key)) {
            this.enable(endable);
            this.getView().setVisible(endable, new String[]{"save"});
            this.getView().setVisible(disable, new String[]{"edit"});
            this.getView().setVisible(endable, new String[]{"cancel"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData;
        ChangeData data;
        Object newData;
        String name = e.getProperty().getName();
        if (ENCRYPT_FIELDS.contains(name) && (newData = (data = (changeData = e.getChangeSet())[0]).getNewValue()) != null) {
            String val = newData.toString();
            IPageCache page = this.getPageCache();
            if (val.length() > 4 && !val.contains("**")) {
                page.put(name, val);
                this.getModel().setValue(name, CommonUtils.encrypt((Object)val));
            } else if (val.length() <= 4) {
                page.put(name, newData.toString());
            }
        }
    }

    private void loadData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String config_type = (String)customParams.get("config_type");
        QFilter filter = new QFilter("config_type", "=", (Object)config_type);
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"invsm_param_configuration", (String)"config_type,config_key,config_value", (QFilter[])new QFilter[]{filter});
        int length = config_type.length() + 1;
        IPageCache page = this.getPageCache();
        this.getModel().beginInit();
        for (DynamicObject object : collection) {
            Control control;
            String type = object.getString("config_key");
            String value = object.getString("config_value");
            String controlKey = type;
            if (type != null && type.contains(config_type)) {
                controlKey = type.substring(length);
            }
            if ((control = this.getView().getControl(controlKey)) == null || value == null) continue;
            if (ENCRYPT_FIELDS.contains(controlKey)) {
                page.put(controlKey, value);
                this.getModel().setValue(controlKey, CommonUtils.encrypt((Object)value));
                continue;
            }
            this.getModel().setValue(controlKey, (Object)value);
        }
        this.getModel().endInit();
    }

    private void enable(boolean flag) {
        MainEntityType entityType = this.getModel().getDataEntityType();
        for (IDataEntityProperty property : entityType.getProperties()) {
            this.getView().setEnable(Boolean.valueOf(flag), new String[]{property.getName()});
        }
    }
}

