/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.TenantUtils;

public class AddLeqiInvoicePlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getControl("invoicedate");
        Date nowdate = new Date();
        dateRangeEdit.setMaxDate(nowdate);
        this.getModel().setValue("startdate", (Object)DateUtils.addMonth((Date)nowdate, (int)-3));
        this.getModel().setValue("enddate", (Object)nowdate);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            String taxNo;
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org"));
            if (orgId <= 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"AddLeqiInvoicePlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            Date startDate = (Date)this.getModel().getValue("startdate");
            Date endDate = (Date)this.getModel().getValue("enddate");
            Date taxperiod = (Date)this.getModel().getValue("taxperiod");
            String invoiceNo = (String)this.getModel().getValue("invoice_no");
            String invoiceCode = (String)this.getModel().getValue("invoice_code");
            if ((startDate == null || endDate == null) && StringUtils.isEmpty((CharSequence)invoiceNo) && taxperiod == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u8303\u56f4\u548c\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"AddLeqiInvoicePlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (startDate != null && endDate != null) {
                if (startDate.compareTo(endDate) > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f", (String)"AddLeqiInvoicePlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return;
                }
                long days = DateUtils.daysBetween((Date)endDate, (Date)startDate);
                if (days > 180L) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u5927\u4e8e180\u5929", (String)"AddLeqiInvoicePlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (StringUtils.isEmpty((CharSequence)(taxNo = (String)this.getModel().getValue("taxno"))) && StringUtils.isEmpty((CharSequence)(taxNo = TenantUtils.getTaxNoByOrgId((Long)orgId)))) {
                this.getView().showErrorNotification(ErrorType.TAX_NO_NULL.getName());
                return;
            }
            String dkType = DeductionConstant.getDkType((String)taxNo);
            if (!"5".equals(dkType = InvoiceDownloadConstant.convertLqCollect((String)taxNo, (String)dkType))) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%1$s]\u6536\u7968\u901a\u9053\u975e\u4e50\u4f01\u5e73\u53f0,\u8bf7\u786e\u8ba4\u8be5\u7a0e\u53f7\u662f\u5426\u4f7f\u7528\u4e50\u4f01\u6536\u7968\u901a\u9053", (String)"AddLeqiInvoicePlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxNo));
                return;
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>(3);
            returnData.put("startDate", DateUtils.format((Date)startDate));
            returnData.put("endDate", DateUtils.format((Date)endDate));
            returnData.put("orgId", orgId);
            returnData.put("invoiceNo", invoiceNo);
            returnData.put("invoiceCode", invoiceCode);
            returnData.put("taxno", this.getModel().getValue("taxno"));
            if (taxperiod != null) {
                returnData.put("taxperiod", DateUtils.getFirstDateOfMonth((Date)taxperiod));
            }
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if ("btncancel".equals(control.getKey())) {
            this.getView().close();
        }
    }
}

