/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ViewUtil;
import org.apache.commons.lang3.tuple.Pair;

public class AgricHandleEditPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_GRID = "entryentity";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray invoiceList = JSONObject.parseArray((String)SerializationUtils.toJsonString(customParams.get("invoices")));
        String querytype = (String)customParams.get("querytype");
        this.getModel().beginInit();
        for (int i = 0; i < invoiceList.size(); ++i) {
            JSONObject object = invoiceList.getJSONObject(i);
            int row = this.getModel().createNewEntryRow(ENTRY_GRID);
            this.getModel().setValue("id", (Object)object.getString("id"), row);
            this.getModel().setValue("invoice_code", (Object)object.getString("invoice_code"), row);
            this.getModel().setValue("invoice_no", (Object)object.getString("invoice_no"), row);
            this.getModel().setValue("electronic_no", (Object)object.getString("electronic_no"), row);
            this.getModel().setValue("serial_no", (Object)object.getString("serial_no"), row);
            Long itemInvoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get((Object)"invoice_type"));
            this.getModel().setValue("invoice_type", (Object)itemInvoiceType, row);
            this.getModel().setValue("invoice_date", (Object)object.getString("invoice_date"), row);
            this.getModel().setValue("invoice_amount", (Object)object.getString("invoice_amount"), row);
            this.getModel().setValue("total_tax_amount", (Object)object.getString("total_tax_amount"), row);
            BigDecimal effectiveTaxAmount = object.getBigDecimal("effective_tax_amount");
            if (effectiveTaxAmount == null || effectiveTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue("effective_tax_amount", (Object)object.getString("total_tax_amount"), row);
            } else {
                this.getModel().setValue("effective_tax_amount", (Object)effectiveTaxAmount, row);
            }
            this.getModel().setValue("buyer_tax_no", (Object)object.getString("buyer_tax_no"), row);
            this.getModel().setValue("deduction_purpose", (Object)"1", row);
            this.getModel().setValue("org", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get((Object)"org")), row);
            this.getModel().setValue("saler_name", (Object)object.getString("saler_name"), row);
            this.getModel().setValue("saler_tax_no", (Object)object.getString("saler_tax_no"), row);
            this.getModel().setValue("invoice_risk_level", (Object)object.getString("invoice_risk_level"), row);
            this.getModel().setValue("agric_handle_status", (Object)object.getString("agric_handle_status"), row);
        }
        this.getModel().endInit();
        this.getView().updateView();
        if ("agric_handle_selfproduced".equals(querytype)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"agric_prehandletype2"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"agric_prehandletype1"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object agricPrehandletype1;
        String fieldKey = e.getProperty().getName();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_GRID);
        int[] selectRows = entryGrid.getSelectRows();
        if ("agric_prehandletype1".equals(fieldKey)) {
            Object agricPrehandletype12 = this.getModel().getValue("agric_prehandletype1", selectRows[0]);
            if ("14".equals(agricPrehandletype12)) {
                this.getModel().setValue("deduction_purpose", (Object)"2", selectRows[0]);
                this.getView().setEnable(Boolean.FALSE, selectRows[0], new String[]{"deduction_purpose"});
                this.getModel().setValue("effective_tax_amount", (Object)BigDecimal.ZERO, selectRows[0]);
                this.getModel().setValue("agric_partial_amount", (Object)BigDecimal.ZERO, selectRows[0]);
            } else if ("15".equals(agricPrehandletype12)) {
                this.getModel().setValue("deduction_purpose", (Object)"1", selectRows[0]);
                this.getView().setEnable(Boolean.TRUE, selectRows[0], new String[]{"deduction_purpose"});
            } else {
                this.getModel().setValue("deduction_purpose", (Object)"1", selectRows[0]);
                BigDecimal effectiveTaxAmount = BigDecimalUtil.transDecimal((Object)this.getModel().getValue("invoice_amount", selectRows[0])).multiply(new BigDecimal("0.09"));
                this.getModel().setValue("effective_tax_amount", (Object)effectiveTaxAmount, selectRows[0]);
                this.getModel().setValue("agric_partial_amount", (Object)BigDecimal.ZERO, selectRows[0]);
                this.getView().setEnable(Boolean.TRUE, selectRows[0], new String[]{"deduction_purpose"});
            }
        } else if ("agric_prehandletype2".equals(fieldKey)) {
            Object agricPrehandletype2 = this.getModel().getValue("agric_prehandletype2", selectRows[0]);
            if ("17".equals(agricPrehandletype2)) {
                this.getModel().setValue("effective_tax_amount", this.getModel().getValue("total_tax_amount", selectRows[0]), selectRows[0]);
            } else {
                Pair<BigDecimal, BigDecimal> partialItemsAmount = this.getPartialItemsAmount(selectRows[0]);
                BigDecimal agricPartialAmount = (BigDecimal)partialItemsAmount.getLeft();
                this.getModel().setValue("agric_partial_amount", (Object)agricPartialAmount, selectRows[0]);
                BigDecimal effectiveTaxAmount = (BigDecimal)partialItemsAmount.getRight();
                effectiveTaxAmount = effectiveTaxAmount.add(agricPartialAmount.multiply(new BigDecimal("0.09")));
                this.getModel().setValue("effective_tax_amount", (Object)BigDecimalUtil.format((BigDecimal)effectiveTaxAmount), selectRows[0]);
            }
        } else if ("agric_partial_amount".equals(fieldKey) && "15".equals(agricPrehandletype1 = this.getModel().getValue("agric_prehandletype1", selectRows[0]))) {
            BigDecimal effectiveTaxAmount = BigDecimalUtil.transDecimal((Object)this.getModel().getValue("agric_partial_amount", selectRows[0])).multiply(new BigDecimal("0.09"));
            this.getModel().setValue("effective_tax_amount", (Object)BigDecimalUtil.format((BigDecimal)effectiveTaxAmount), selectRows[0]);
        }
    }

    private Pair<BigDecimal, BigDecimal> getPartialItemsAmount(int selectRow) {
        JSONObject invoice;
        BigDecimal agricAmount = BigDecimal.ZERO;
        BigDecimal otherTaxAmount = BigDecimal.ZERO;
        String serialNo = (String)this.getModel().getValue("serial_no", selectRow);
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("invoice_type", selectRow));
        String datajsonTag = (String)this.getModel().getValue("datajson_tag", selectRow);
        if (StringUtils.isNotBlank((CharSequence)datajsonTag)) {
            invoice = JSONObject.parseObject((String)datajsonTag);
        } else {
            DynamicObjectCollection items;
            invoice = new JSONObject();
            invoice.put("serialNo", (Object)serialNo);
            String entity = InputInvoiceTypeEnum.getEntity((Long)invoiceType);
            QFilter qFilter = new QFilter("serial_no", "=", (Object)serialNo);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"id,items.goods_code,items.tax_rate,items.detail_amount,items.tax_amount", (QFilter[])new QFilter[]{qFilter});
            if (dynamicObject != null && CollectionUtils.isNotEmpty((Collection)(items = dynamicObject.getDynamicObjectCollection("items")))) {
                List maps = DynamicObjectUtil.dynamicObjectColletction2ListMap((DynamicObjectCollection)items);
                invoice.put("items", (Object)maps);
            }
            this.getModel().setValue("datajson_tag", (Object)invoice.toJSONString(), selectRow);
        }
        JSONArray invItems = invoice.getJSONArray("items");
        if (CollectionUtils.isNotEmpty((Collection)invItems)) {
            for (int i = 0; i < invItems.size(); ++i) {
                JSONObject item = invItems.getJSONObject(i);
                boolean isAgricItems = DeductionUtils.isAgricItems((String)item.getString("goods_code"), (String)item.getString("tax_rate"));
                if (isAgricItems) {
                    agricAmount = agricAmount.add(BigDecimalUtil.transDecimal((Object)item.get((Object)"detail_amount")));
                    continue;
                }
                otherTaxAmount = otherTaxAmount.add(BigDecimalUtil.transDecimal((Object)item.get((Object)"tax_amount")));
            }
        }
        return Pair.of((Object)agricAmount, (Object)otherTaxAmount);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_GRID);
            Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
            Object queryType = parentCustomParams.get("querytype");
            Object operatetype = parentCustomParams.get("operatetype");
            Object invoicetype = parentCustomParams.get("invoicetype");
            String deductName = (String)parentCustomParams.get("deductName");
            Long invoiceType = Long.parseLong(String.valueOf(invoicetype));
            JSONArray invoices = new JSONArray();
            JSONObject param = DeductionConstant.getSelectParamJson(queryType, operatetype, (Long)invoiceType);
            StringBuilder message = new StringBuilder();
            if ("agric_handle_selfproduced".equals(queryType)) {
                param.put("purchaseTicket", (Object)"1");
            } else {
                param.put("purchaseTicket", (Object)"2");
            }
            entryEntity.forEach(object -> {
                String dkType;
                String format;
                String taxNo = object.getString("buyer_tax_no");
                String agricPrehandleType = "agric_handle_selfproduced".equals(queryType) ? object.getString("agric_prehandletype1") : object.getString("agric_prehandletype2");
                if (StringUtils.isEmpty((CharSequence)agricPrehandleType)) {
                    String format2 = ResManager.loadKDString((String)"\u53d1\u7968\uff1a%s \u9884\u5904\u7406\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgricHandleEditPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    message.append(String.format(format2, CommonUtils.getInvoiceCodeNoGroup((String)object.getString("invoice_code"), (String)object.getString("invoice_no"))));
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                String agricPartialAmount = object.getString("agric_partial_amount");
                if ("15".equals(agricPrehandleType) && new BigDecimal(agricPartialAmount).compareTo(BigDecimal.ZERO) <= 0) {
                    format = ResManager.loadKDString((String)"\u53d1\u7968\uff1a%s \u90e8\u5206\u5c5e\u4e8e\u81ea\u4ea7\uff0c\u519c\u4ea7\u54c1\u90e8\u5206\u91d1\u989d\u4e0d\u80fd\u4e3a\u96f6\u3002", (String)"AgricHandleEditPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    message.append(String.format(format, CommonUtils.getInvoiceCodeNoGroup((String)object.getString("invoice_code"), (String)object.getString("invoice_no"))));
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if ("15".equals(agricPrehandleType) && new BigDecimal(agricPartialAmount).compareTo(object.getBigDecimal("invoice_amount")) > 0) {
                    format = ResManager.loadKDString((String)"\u53d1\u7968\uff1a%s \u519c\u4ea7\u54c1\u90e8\u5206\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53d1\u7968\u91d1\u989d\u3002", (String)"AgricHandleEditPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    message.append(String.format(format, CommonUtils.getInvoiceCodeNoGroup((String)object.getString("invoice_code"), (String)object.getString("invoice_no"))));
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if ("16".equals(agricPrehandleType) && new BigDecimal(agricPartialAmount).compareTo(BigDecimal.ZERO) <= 0 && "5".equals(dkType = DeductionConstant.getDkType((String)taxNo))) {
                    String format3 = ResManager.loadKDString((String)"\u53d1\u7968\uff1a%s \u519c\u4ea7\u54c1\u90e8\u5206\u91d1\u989d\u4e0d\u80fd\u4e3a\u96f6\uff0c\u8bf7\u68c0\u67e5\u8be5\u53d1\u7968\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u519c\u4ea7\u54c1\u786e\u8ba4\u3002", (String)"AgricHandleEditPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    message.append(String.format(format3, CommonUtils.getInvoiceCodeNoGroup((String)object.getString("invoice_code"), (String)object.getString("invoice_no"))));
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                JSONObject json = DeductionConstant.createSelectJson((DynamicObject)object);
                json.put("agricPrehandleType", (Object)agricPrehandleType);
                json.put("agricPartialAmount", (Object)agricPartialAmount);
                json.put("effectiveTaxAmount", object.get("effective_tax_amount"));
                json.put("invoiceRiskLevel", object.get("invoice_risk_level"));
                String agricHandleStatus = object.getString("agric_handle_status");
                json.put("agricHandleStatus", (Object)agricHandleStatus);
                json.put("preAuthenticateFlag", (Object)agricHandleStatus);
                invoices.add((Object)json);
            });
            if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                ViewUtil.showMessage((AbstractFormPlugin)this, (String)deductName, (String)message.toString(), (int)0, (int)entryEntity.size());
                return;
            }
            param.put("invoices", (Object)invoices);
            this.getView().returnDataToParent((Object)param);
            this.getView().close();
        }
        if ("btncancel".equals(control.getKey())) {
            this.getView().close();
        }
    }
}

