/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.DateRangeEdit;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.collector.InvoiceHeaderDownService;
import kd.imc.rim.common.license.LicenseFormPlugin;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.TenantUtils;

public class AgricInvoiceDownPlugin
extends LicenseFormPlugin {
    private static final String BTN_DOWN = "down_invoice";
    private static final String DOWN_ORG = "org";
    private static final String PARAM_INVOICE_START_DATE = "invoice_date_start";
    private static final String PARAM_INVOICE_END_DATE = "invoice_date_end";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(DOWN_ORG, (Object)RequestContext.get().getOrgId());
        this.initCondition();
    }

    private void initCondition() {
        Date nowDate = new Date();
        Date dataMin = DateUtils.addDay((Date)nowDate, (int)-365);
        DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getControl("invoice_date");
        dateRangeEdit.setMinDate(dataMin);
        dateRangeEdit.setMaxDate(nowDate);
        this.getModel().setValue(PARAM_INVOICE_START_DATE, (Object)DateUtils.getFirstDateOfMonth((Date)nowDate));
        this.getModel().setValue(PARAM_INVOICE_END_DATE, (Object)nowDate);
        this.getModel().setValue(DOWN_ORG, (Object)RequestContext.get().getOrgId());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperationResult() == null || !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (BTN_DOWN.equals(operateKey)) {
            this.applyDown();
        }
    }

    private void applyDown() {
        Long orgId = this.getCurrentOrgId();
        String taxNo = TenantUtils.getTaxNoByOrgId((Long)orgId);
        String dkType = DeductionConstant.getDkType((String)taxNo);
        if (!"4".equals(dkType)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u671f\u7ec4\u7ec7\u7a0e\u53f7[%1$s]\u4e0d\u652f\u6301\u4e0b\u8f7d\u5f85\u5904\u7406\u519c\u4ea7\u54c1", (String)"AgricInvoiceDownPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxNo));
            return;
        }
        if (TenantUtils.isSmallScaleTaxpayer((String)taxNo)) {
            this.getView().showTipNotification(ErrorType.SMALL_SCALE_TAXPAYER_DOWN.getName(), Integer.valueOf(2000));
            return;
        }
        JSONObject param = new JSONObject();
        Date startDate = (Date)this.getModel().getValue(PARAM_INVOICE_START_DATE);
        Date endDate = (Date)this.getModel().getValue(PARAM_INVOICE_END_DATE);
        String agriceType = (String)this.getModel().getValue("purchase_ticket");
        String invoiceStatus = (String)this.getModel().getValue("invoice_status");
        String processingStatus = (String)this.getModel().getValue("agric_handle_status");
        param.put("taxNo", (Object)taxNo);
        param.put("farmProductType", (Object)agriceType);
        param.put("invoiceStatus", (Object)invoiceStatus);
        param.put("processingStatus", (Object)processingStatus);
        param.put("startDate", (Object)DateUtils.format((Date)startDate));
        param.put("endDate", (Object)DateUtils.format((Date)endDate));
        InvoiceHeaderDownService invoiceHeaderDownService = new InvoiceHeaderDownService(orgId);
        JSONObject result = invoiceHeaderDownService.downAgricInvoice(taxNo, orgId, param);
        if (ResultContant.isSuccess((JSONObject)result).booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u4e0b\u8f7d\u8bb0\u5f55\u8bf7\u5230\u201c\u53d1\u7968\u5f52\u96c6\u7ba1\u7406-\u6570\u636e\u540c\u6b65\u65e5\u5fd7\u67e5\u8be2\u201d\u5217\u8868\u4e2d\u67e5\u770b", (String)"AgricInvoiceDownPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a%1$s", (String)"AgricInvoiceDownPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), result.getString("description")));
        }
    }

    private Long getCurrentOrgId() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(DOWN_ORG);
        Long orgId = RequestContext.get().getOrgId();
        if (org != null) {
            orgId = org.getLong("id");
        }
        return orgId;
    }
}

