/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.StatisticsStatusEnum;
import kd.imc.rim.common.invoice.deduction.DeductStatisticsService;
import kd.imc.rim.common.license.LicenseListPlugin;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.formplugin.deduction.BatchDeductService;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BatchDeductLogListPlugin
extends LicenseListPlugin {
    private static Log LOGGER = LogFactory.getLog(BatchDeductLogListPlugin.class);

    private static List<String> getITEMS_HEADERS() {
        ArrayList<String> list = new ArrayList<String>(8);
        list.add(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"BatchDeductLogListPlugin_32", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f", (String)"BatchDeductLogListPlugin_33", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0", (String)"BatchDeductLogListPlugin_34", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u7a0e\u53f7", (String)"BatchDeductLogListPlugin_35", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"BatchDeductLogListPlugin_36", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        list.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u5f53\u524d\u72b6\u6001", (String)"BatchDeductLogListPlugin_37", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        return list;
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void exportSelectResult() {
        block48: {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectCollection = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"BatchDeductLogListPlugin_38", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            QFilter idFilter = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
            DynamicObjectCollection logs = QueryServiceHelper.query((String)"rim_select_log", (String)"tax_period,org.id AS orgId,org.name AS orgName,tax_no,handle_status,statistics_status,result_json_tag", (QFilter[])new QFilter[]{idFilter});
            try (XSSFWorkbook wb = new XSSFWorkbook();){
                Throwable throwable;
                XSSFSheet itemsSheet = wb.createSheet(ResManager.loadKDString((String)"\u6279\u91cf\u62b5\u6263\u64cd\u4f5c\u7ed3\u679c", (String)"BatchDeductLogListPlugin_39", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                XSSFRow itemsRow = itemsSheet.createRow(0);
                List<String> heads = BatchDeductLogListPlugin.getITEMS_HEADERS();
                for (int i = 0; i < heads.size(); ++i) {
                    XSSFCell cell = itemsRow.createCell(i);
                    XSSFRichTextString text = new XSSFRichTextString(heads.get(i));
                    cell.setCellValue((RichTextString)text);
                    itemsSheet.setColumnWidth(i, heads.get(i).getBytes().length * 256);
                }
                int itemRowId = 1;
                for (DynamicObject log : logs) {
                    JSONObject statisticsData;
                    XSSFRow row = itemsSheet.createRow(itemRowId);
                    row.createCell(0).setCellValue((double)itemRowId);
                    Date taxPeriod = log.getDate("tax_period");
                    if (taxPeriod != null) {
                        row.createCell(1).setCellValue(DateUtils.format((Date)taxPeriod, (String)"yyyyMM"));
                    } else {
                        row.createCell(1).setCellValue("");
                    }
                    ++itemRowId;
                    String orgName = log.getString("orgName");
                    row.createCell(2).setCellValue(orgName);
                    row.createCell(3).setCellValue(log.getString("tax_no"));
                    String handleStatus = MetadataUtil.getComboItemName((String)"rim_select_log", (String)"handle_status", (String)log.getString("handle_status"));
                    String statisticsStatus = log.getString("statistics_status");
                    row.createCell(4).setCellValue(handleStatus);
                    row.createCell(5).setCellValue(MetadataUtil.getComboItemName((String)"rim_select_log", (String)"statistics_status", (String)statisticsStatus));
                    String statisticsTag = log.getString("result_json_tag");
                    if (!StringUtils.isNotEmpty((CharSequence)statisticsTag) || !StatisticsStatusEnum.CONFIRMED.getCode().equals(statisticsStatus) && !StatisticsStatusEnum.PRE_CREATED.getCode().equals(statisticsStatus) && !StatisticsStatusEnum.CREATED_UNCONFIRM.getCode().equals(statisticsStatus) && !StatisticsStatusEnum.CREATED_CONFIRM.getCode().equals(statisticsStatus) || ObjectUtils.isEmpty((Object)(statisticsData = JSON.parseObject((String)statisticsTag)))) continue;
                    JSONArray statisticsArray = statisticsData.getJSONArray("tjxx");
                    if (CollectionUtils.isEmpty((Collection)statisticsArray)) {
                        statisticsArray = statisticsData.getJSONArray("tjInfoArr");
                    }
                    if (CollectionUtils.isEmpty((Collection)statisticsArray)) continue;
                    Date updateTime = statisticsData.getDate("updateTime");
                    DeductStatisticsService.createStatisticsSheet((XSSFWorkbook)wb, (String)String.format(ResManager.loadKDString((String)"%1$s\u7edf\u8ba1\u8868%2$s", (String)"BatchDeductLogListPlugin_30", (String)"imc-rim-formplugin", (Object[])new Object[0]), orgName, itemRowId - 1), (Date)updateTime, (String)orgName, (String)log.getString("tax_no"), (String)statisticsData.getString("taxPeriod"), (JSONArray)statisticsArray);
                }
                byte[] bytes = null;
                try {
                    throwable = null;
                    try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                        wb.write((OutputStream)os);
                        bytes = os.toByteArray();
                    }
                    catch (Throwable taxPeriod) {
                        throwable = taxPeriod;
                        throw taxPeriod;
                    }
                }
                catch (IOException e1) {
                    LOGGER.error("\u5bfc\u51faExcel\u5931\u8d25", (Throwable)e1);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51faExcel\u5931\u8d25\u3002", (String)"BatchDeductLogListPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
                if (bytes != null) {
                    throwable = null;
                    try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                        String fileName = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u62b5\u6263\u7edf\u8ba1_%1$s.xlsx", (String)"BatchDeductLogListPlugin_31", (String)"imc-rim-formplugin", (Object[])new Object[0]), DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
                        String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
                        PermissionUtils.addTempFilePermission((String)urls, (String)this.getView().getEntityId(), (String)"2Y17078UQ9EJ", (int)5000);
                        this.getView().openUrl(urls);
                        break block48;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51faExcel\u5931\u8d25\u3002", (String)"BatchDeductLogListPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51faExcel\u5931\u8d25\u3002", (String)"BatchDeductLogListPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        QFilter qFilter = new QFilter("operate_type", "=", (Object)"9");
        e.getQFilters().add(qFilter);
    }

    public void itemClick(ItemClickEvent evt) {
        if ("retry".equals(evt.getItemKey())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectCollection = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"BatchDeductLogListPlugin_38", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if (BatchDeductService.batchDeduct(selectCollection.getPrimaryKeyValues(), (AbstractFormPlugin)this)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5904\u7406\u5b8c\u6210", (String)"BatchDeductLogListPlugin_40", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                billList.refresh();
            }
        } else if ("stop".equals(evt.getItemKey())) {
            BatchDeductService.stop();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"BatchDeductLogListPlugin_41", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("deduct_login_batch_deduct".equals(closedCallBackEvent.getActionId())) {
            Long logId = BigDecimalUtil.transDecimal((Object)this.getPageCache().get("loginTaxNo")).longValue();
            if (StringUtils.isNotBlank((Object)closedCallBackEvent.getReturnData())) {
                BatchDeductService.deduct(logId, (AbstractFormPlugin)this, true);
            } else {
                DynamicObject logObject = BusinessDataServiceHelper.loadSingle((Object)logId, (String)"rim_select_log");
                BatchDeductService.setHandleStatus(logObject, "2", ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25", (String)"BatchDeductLogListPlugin_42", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                SaveServiceHelper.update((DynamicObject)logObject);
            }
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectCollection = billList.getSelectedRows();
            Object[] pkList = selectCollection.getPrimaryKeyValues();
            boolean start = false;
            ArrayList<Object> list = new ArrayList<Object>(pkList.length);
            for (Object pk : pkList) {
                if (logId.equals(pk)) {
                    start = true;
                    continue;
                }
                if (!start) continue;
                list.add(pk);
            }
            if (!list.isEmpty() || BatchDeductService.batchDeduct(list.toArray(), (AbstractFormPlugin)this)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5904\u7406\u5b8c\u6210", (String)"BatchDeductLogListPlugin_40", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                billList.refresh();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("export_batch_deduct".equals(operateKey)) {
            this.exportSelectResult();
        }
    }
}

