/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.ViewUtil;

public class DeductEditPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_GRID = "entryentity";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"drawbacktip"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"isselect"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray invoiceList = JSONObject.parseArray((String)SerializationUtils.toJsonString(customParams.get("invoices")));
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_GRID);
        String deductionPurpose = (String)customParams.get("deductionPurpose");
        List fieldEdits = entryGrid.getFieldEdits();
        boolean showCell = false;
        for (int i = 0; i < invoiceList.size(); ++i) {
            JSONObject object = invoiceList.getJSONObject(i);
            int row = this.getModel().createNewEntryRow(ENTRY_GRID);
            this.getModel().setValue("id", (Object)object.getString("id"), row);
            String operateType = object.getString("operateType");
            if (!StringUtils.isEmpty((CharSequence)operateType)) {
                showCell = true;
            }
            if ("deduction_unselect".equals(operateType)) {
                this.getModel().setValue("isselect", (Object)"0", row);
            } else if ("deduction_select".equals(operateType)) {
                this.getModel().setValue("isselect", (Object)"1", row);
            }
            this.getModel().setValue("invoice_code", (Object)object.getString("invoice_code"), row);
            this.getModel().setValue("serial_no", (Object)object.getString("serial_no"), row);
            Long itemInvoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get((Object)"invoice_type"));
            this.getModel().setValue("invoice_type", (Object)itemInvoiceType, row);
            String electronicNo = object.getString("electronic_no");
            if (InputInvoiceTypeEnum.isExistEtaxInvoiceNo((Long)itemInvoiceType) && InvoiceConvertUtils.checkElectronicNo((String)electronicNo)) {
                this.getModel().setValue("electronic_no", (Object)electronicNo, row);
            }
            this.getModel().setValue("invoice_no", (Object)object.getString("invoice_no"), row);
            this.getModel().setValue("invoice_date", (Object)object.getString("invoice_date"), row);
            this.getModel().setValue("saler_name", (Object)object.getString("saler_name"), row);
            this.getModel().setValue("saler_tax_no", (Object)object.getString("saler_tax_no"), row);
            this.getModel().setValue("invoice_amount", (Object)object.getString("invoice_amount"), row);
            this.getModel().setValue("total_tax_amount", (Object)object.getString("total_tax_amount"), row);
            this.getModel().setValue("buyer_tax_no", (Object)object.getString("buyer_tax_no"), row);
            this.getModel().setValue("authenticate_flag", (Object)object.getString("authenticate_flag"), row);
            this.getModel().setValue("org", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get((Object)"org")), row);
            BigDecimal effectiveTaxAmount = object.getBigDecimal("effective_tax_amount");
            if (effectiveTaxAmount == null || effectiveTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue("effective_tax_amount", (Object)object.getString("total_tax_amount"), row);
            } else {
                this.getModel().setValue("effective_tax_amount", (Object)effectiveTaxAmount, row);
            }
            if ("2".equals(deductionPurpose)) {
                String notDeductibleType = object.getString("not_deductible_type");
                if (StringUtils.isNotEmpty((CharSequence)notDeductibleType)) {
                    this.getModel().setValue("not_deductible_type", (Object)notDeductibleType, row);
                } else {
                    this.getModel().setValue("not_deductible_type", (Object)"0", row);
                }
            }
            if (StringUtils.isEmpty((CharSequence)operateType)) continue;
            this.getModel().setValue("not_deductible_type", (Object)object.getString("undeductReason"), row);
        }
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(customParams.get("invoicetype"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_code", "invoice_amount", "electronic_no"});
            for (FieldEdit fieldEdit : fieldEdits) {
                String fieldKey = fieldEdit.getFieldKey();
                if ("invoice_no".equals(fieldKey)) {
                    fieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6d77\u5173\u7f34\u6b3e\u4e66\u53f7\u7801", (String)"DeductEditPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0])));
                }
                if ("total_tax_amount".equals(fieldKey)) {
                    fieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7a0e\u6b3e\u91d1\u989d", (String)"DeductEditPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0])));
                }
                if ("invoice_date".equals(fieldKey)) {
                    fieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u586b\u53d1\u65e5\u671f", (String)"DeductEditPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0])));
                }
                if (!"effective_tax_amount".equals(fieldKey)) continue;
                fieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6709\u6548\u7a0e\u6b3e\u91d1\u989d", (String)"DeductEditPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0])));
            }
        } else if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(customParams.get("invoicetype"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_amount", "electronic_no"});
            for (FieldEdit fieldEdit : fieldEdits) {
                String fieldKey = fieldEdit.getFieldKey();
                if ("invoice_code".equals(fieldKey)) {
                    fieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u88ab\u6263\u7f34\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"DeductEditPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0])));
                }
                if ("invoice_no".equals(fieldKey)) {
                    fieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4ee3\u6263\u4ee3\u7f34\u5b8c\u7a0e\u51ed\u8bc1\u53f7", (String)"DeductEditPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0])));
                }
                if ("total_tax_amount".equals(fieldKey)) {
                    fieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b9e\u7f34\u91d1\u989d", (String)"DeductEditPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0])));
                }
                if (!"invoice_date".equals(fieldKey)) continue;
                fieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u586b\u53d1\u65e5\u671f", (String)"DeductEditPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0])));
            }
        }
        if (!"2".equals(deductionPurpose)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"not_deductible_type"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"effective_tax_amount"});
        }
        if (showCell) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"isselect"});
        }
        if ("3".equals(deductionPurpose)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"drawbacktip"});
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_GRID);
            Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
            Object queryType = parentCustomParams.get("querytype");
            Object operatetype = parentCustomParams.get("operatetype");
            Object invoicetype = parentCustomParams.get("invoicetype");
            String deductionPurpose = (String)parentCustomParams.get("deductionPurpose");
            String deductName = (String)parentCustomParams.get("deductName");
            Long invoiceType = Long.parseLong(String.valueOf(invoicetype));
            JSONArray invoices = new JSONArray();
            JSONObject param = DeductionConstant.getSelectParamJson(queryType, operatetype, (Long)invoiceType);
            StringBuilder message = new StringBuilder();
            entryEntity.forEach(object -> {
                String totalTaxAmount = object.getString("total_tax_amount");
                if (new BigDecimal(totalTaxAmount).compareTo(BigDecimal.ZERO) < 0) {
                    String format = ResManager.loadKDString((String)"\u53d1\u7968\uff1a%s \u7ea2\u5b57\u53d1\u7968\u4e0d\u80fd\u62b5\u6263\u3002", (String)"DeductEditPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    message.append(String.format(format, CommonUtils.getInvoiceCodeNoGroup((String)object.getString("invoice_code"), (String)object.getString("invoice_no"))));
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                String notDeductibleType = object.getString("not_deductible_type");
                if ("2".equals(deductionPurpose) && (StringUtils.isEmpty((CharSequence)notDeductibleType) || "0".equals(notDeductibleType))) {
                    String format = ResManager.loadKDString((String)"\u53d1\u7968\uff1a%s \u672a\u9009\u62e9\u4e0d\u62b5\u6263\u539f\u56e0\u3002", (String)"DeductEditPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    message.append(String.format(format, CommonUtils.getInvoiceCodeNoGroup((String)object.getString("invoice_code"), (String)object.getString("invoice_no"))));
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                invoices.add((Object)DeductionConstant.createSelectJson((DynamicObject)object, (String)deductionPurpose));
            });
            if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                ViewUtil.showMessage((AbstractFormPlugin)this, (String)deductName, (String)message.toString(), (int)0, (int)entryEntity.size());
                return;
            }
            param.put("invoices", (Object)invoices);
            this.getView().returnDataToParent((Object)param);
            this.getView().close();
        }
        if ("btncancel".equals(control.getKey())) {
            this.getView().close();
        }
    }
}

