/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.utils.DateUtils;

public class DeductTaxAddPlugin
extends AbstractFormPlugin {
    private static final String RIM_CURRENT_TAX_INFO = "rim_current_tax_info";

    public void initialize() {
        super.initialize();
        Button submitButton = (Button)this.getView().getControl("submitbutton");
        submitButton.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObject obj = this.getUserTaxInfo(customParams);
        if (ObjectUtils.isEmpty((Object)obj)) {
            return;
        }
        this.getModel().setValue("sale_amount", (Object)obj.getBigDecimal("sale_amount"));
        this.getModel().setValue("sale_tax_amount", (Object)obj.getBigDecimal("sale_tax_amount"));
        this.getModel().setValue("surplus_tax_amount", (Object)obj.getBigDecimal("surplus_tax_amount"));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("submitbutton".equals(key)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String orgIdStr = customParams.get("orgId").toString();
            Long orgId = Long.parseLong(orgIdStr);
            Date taxPriod = DateUtils.stringToDate((String)customParams.get("tax_period").toString());
            DynamicObject obj = this.getUserTaxInfo(customParams);
            if (obj == null) {
                obj = BusinessDataServiceHelper.newDynamicObject((String)RIM_CURRENT_TAX_INFO);
                obj.set("createtime", (Object)new Date());
                obj.set("org", (Object)orgId);
                obj.set("tax_period", (Object)taxPriod);
            } else {
                obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)RIM_CURRENT_TAX_INFO);
            }
            obj.set("sale_amount", this.getModel().getValue("sale_amount"));
            obj.set("sale_tax_amount", this.getModel().getValue("sale_tax_amount"));
            obj.set("surplus_tax_amount", this.getModel().getValue("surplus_tax_amount"));
            obj.set("updatetime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            HashMap<String, BigDecimal> returnCustomParams = new HashMap<String, BigDecimal>(3);
            returnCustomParams.put("sale_tax_amount", (BigDecimal)this.getModel().getValue("sale_tax_amount"));
            returnCustomParams.put("surplus_tax_amount", (BigDecimal)this.getModel().getValue("surplus_tax_amount"));
            returnCustomParams.put("sale_amount", (BigDecimal)this.getModel().getValue("sale_amount"));
            this.getView().returnDataToParent(returnCustomParams);
            this.getView().close();
        }
    }

    private DynamicObject getUserTaxInfo(Map<String, Object> customParams) {
        String orgIdStr = customParams.get("orgId").toString();
        Long orgId = Long.parseLong(orgIdStr);
        Date taxPriod = DateUtils.stringToDate((String)((String)customParams.get("tax_period")));
        QFilter dateFilter = new QFilter("tax_period", "=", (Object)taxPriod).and("org", "=", (Object)orgId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)RIM_CURRENT_TAX_INFO, (String)"id,sale_amount,sale_tax_amount,surplus_tax_amount", (QFilter[])dateFilter.toArray());
        return obj;
    }
}

