/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.download.impl.InputInvoiceDealService;
import kd.imc.rim.common.invoice.download.impl.OutputInvoiceDealService;
import kd.imc.rim.common.license.LicenseListPlugin;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.PermissionUtils;

public class DownAccountListPlugin
extends LicenseListPlugin {
    private static final int THREADPOOL_SIZE = 5;
    private static final ThreadPool inputThreadPool = ThreadPools.newFixedThreadPool((String)"DownAccountListPlugin_input", (int)5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchHandleInvoice() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectCollection = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"DownAccountListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
        DynamicObjectCollection accountCollection = QueryServiceHelper.query((String)"rim_down_account", (String)"id,status,serial_no,data_type_tb", (QFilter[])new QFilter[]{filter});
        accountCollection.removeIf(s -> "1".equals(s.getString("status")) || "11".equals(s.getString("status")));
        if (CollectionUtils.isEmpty((Collection)accountCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u672a\u5904\u7406\u6210\u529f\u7684\u53d1\u7968", (String)"DownAccountListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        try {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"DownAccountListPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0])));
            ArrayList<Future> futureList = new ArrayList<Future>(8);
            int index = 0;
            RequestContext requestContext = RequestContext.get();
            Map<String, List<DynamicObject>> dataTypeTb = accountCollection.stream().collect(Collectors.groupingBy(s -> s.getString("data_type_tb")));
            for (Map.Entry<String, List<DynamicObject>> entry : dataTypeTb.entrySet()) {
                String dataType = entry.getKey();
                List<Object> serialNoList = entry.getValue().stream().map(s -> s.get("serial_no")).collect(Collectors.toList());
                List<Object> downInputIds = this.getDownInputIds(dataType, serialNoList);
                for (Object downInputId : downInputIds) {
                    OutputInvoiceDealService invoiceDealService;
                    if (InvoiceDownloadConstant.OUTPUT_TYPE_LIST.contains(dataType)) {
                        invoiceDealService = new OutputInvoiceDealService(requestContext, downInputId);
                        futureList.add(inputThreadPool.submit((Callable)invoiceDealService));
                    } else {
                        invoiceDealService = new InputInvoiceDealService(requestContext, downInputId);
                        futureList.add(inputThreadPool.submit((Callable)invoiceDealService));
                    }
                    CommonUtils.futureWait(futureList, (int)5, (int)(++index));
                }
            }
            CommonUtils.futureWait(futureList, (int)5, (int)5);
        }
        finally {
            this.getView().hideLoading();
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"DownAccountListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        billList.refresh();
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (args.getFieldName().startsWith("org")) {
            HasPermOrgResult result = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"rim_down_account", (String)"47150e89000000ac");
            if (result == null || result.hasAllOrgPerm()) {
                return;
            }
            QFilter idsFilter = new QFilter("id", "in", (Object)result.getHasPermOrgs());
            args.addCustomQFilter(idsFilter);
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        QFilter id = new QFilter("id", "=", currentListSelectedRow.getPrimaryKeyValue());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"rim_down_account", (String)"serial_no,data_type_tb", (QFilter[])id.toArray());
        if (dynamicObject == null) {
            return;
        }
        QFilter serialNoFilter = new QFilter("serial_no", "=", dynamicObject.get("serial_no"));
        QFilter infilter = new QFilter("inout", "=", dynamicObject.get("data_type_tb"));
        DynamicObject inputObj = QueryServiceHelper.queryOne((String)"rim_down_input", (String)"id", (QFilter[])new QFilter[]{serialNoFilter, infilter});
        if (inputObj == null) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(inputObj.get("id"));
        showParameter.setFormId("rim_down_input");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String operateKey = eventArgs.getOperateKey();
        if ("batch_handle".equals(operateKey)) {
            this.batchHandleInvoice();
        }
    }

    private List<Object> getDownInputIds(String dataType, List<Object> serialNoList) {
        QFilter serialNoFilter = new QFilter("serial_no", "in", serialNoList);
        QFilter infilter = new QFilter("inout", "=", (Object)dataType);
        DynamicObjectCollection inputCollection = QueryServiceHelper.query((String)"rim_down_input", (String)"id", (QFilter[])new QFilter[]{serialNoFilter, infilter});
        if (CollectionUtils.isEmpty((Collection)inputCollection)) {
            return Lists.newArrayList();
        }
        return inputCollection.stream().map(s -> s.get("id")).collect(Collectors.toList());
    }
}

