/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.invoice.download.InputOutInvoiceApplyService;
import kd.imc.rim.common.invoice.download.InvoiceApplyLogService;
import kd.imc.rim.common.invoice.download.InvoiceDownServiceFactory;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.StringUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;

public class DownInitBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(DownInitBillPlugin.class);
    private static final String CACHE_KEY = "DownInitBillPluginNumber";
    private static final String ORG = "org";
    private static final String TAXNO = "taxNo";
    private static final String BF_TAXNO = "bf_taxNo";
    private static final String BEGIN = "begin";
    private static final String INIT_FLAG_CACHE = "init_flag";
    private static final String[] INIT_FILEDS = new String[]{"output_download", "invoice_type", "begin"};

    public void registerListener(EventObject e) {
        BasedataEdit base = (BasedataEdit)this.getView().getControl("taxpayer_org");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Label openflex = (Label)this.getControl("openflex");
        openflex.addClickListener((ClickListener)this);
        Label closeflex = (Label)this.getControl("closeflex");
        closeflex.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Long orgId = RequestContext.get().getOrgId();
        this.getModel().setValue(ORG, (Object)orgId);
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) - 12);
        date = calendar.getTime();
        this.getModel().setValue(BEGIN, (Object)date);
        this.getModel().setValue("down_frequency", (Object)"5;10;15;20;26");
    }

    private void setNumber() {
        String numberPre = "FPYDW" + DateUtils.format((Date)new Date(), (String)"yyyyMMdd");
        String number = UUID.getNumber((String)numberPre, (String)CACHE_KEY, (String)this.getView().getEntityId());
        this.getModel().setValue("number", (Object)number);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("openflex".equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"text_tips", "closeflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"openflex"});
        } else if ("closeflex".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"text_tips", "closeflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"openflex"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"rim_down_init", (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            QFilter idQFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            ListShowParameter formShowParameter = (ListShowParameter)arg0.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(idQFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("taxpayer_org".equals(name)) {
            ChangeData[] changeData = e.getChangeSet();
            ChangeData changeDatum = changeData[0];
            int rowIndex = changeDatum.getRowIndex();
            DynamicObject newValue = (DynamicObject)changeDatum.getNewValue();
            if (newValue != null) {
                this.setOrgTaxNo(newValue, rowIndex);
            }
        } else if ("output_download".equals(name)) {
            this.setMustInput();
        }
        if ("taxpayer_tax_no".equals(name) && StringUtils.isEmpty((CharSequence)this.getPageCache().get(INIT_FLAG_CACHE))) {
            this.getPageCache().put(INIT_FLAG_CACHE, "2");
        }
        if (Arrays.asList(INIT_FILEDS).contains(name)) {
            this.getPageCache().put(INIT_FLAG_CACHE, "1");
        }
    }

    private void setMustInput() {
        ComboEdit control;
        String outputDownload = (String)this.getModel().getValue("output_download");
        if (StringUtils.isNotEmpty((CharSequence)outputDownload) && outputDownload.contains("3") && (control = (ComboEdit)this.getControl("is_check")) != null) {
            control.setMustInput(true);
        }
    }

    private void setOrgTaxNo(DynamicObject org, int rowIndex) {
        long orgId = org.getLong("id");
        Map companyNameAndTaxNo = TenantUtils.getCompanyNameAndTaxNoByOrgId((Long)orgId);
        if (companyNameAndTaxNo != null && !StringUtils.isEmpty((CharSequence)((CharSequence)companyNameAndTaxNo.get(TAXNO)))) {
            this.getModel().setValue("taxpayer_name", companyNameAndTaxNo.get("name"), rowIndex);
            this.getModel().setValue("taxpayer_tax_no", companyNameAndTaxNo.get(TAXNO), rowIndex);
        } else {
            this.getModel().setValue("taxpayer_name", null, rowIndex);
            this.getModel().setValue("taxpayer_tax_no", null, rowIndex);
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long pkValue = (Long)dataEntity.getPkValue();
        if (pkValue <= 0L) {
            this.setNumber();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"1\u3001\u4e0b\u8f7d\u9891\u7387\u8bf7\u67e5\u770b\u5e2e\u52a9\u9875\u9762\u3002", (String)"DownInitBillPlugin_26", (String)"imc-rim-formplugin", (Object[])new Object[0])).append("\n");
        this.getView().setVisible(Boolean.FALSE, new String[]{"openflex"});
        Label label = (Label)this.getControl("text_tips");
        label.setText(sb.toString());
        this.setMustInput();
        this.cacheTaxnos();
    }

    private void cacheTaxnos() {
        DynamicObject entity = this.getModel().getDataEntity();
        DynamicObjectCollection taxNosItems = entity.getDynamicObjectCollection("userorg");
        if (!CollectionUtils.isEmpty((Collection)taxNosItems)) {
            String taxNos = taxNosItems.stream().map(s -> s.getString("taxpayer_tax_no")).collect(Collectors.joining(","));
            this.getPageCache().put(BF_TAXNO, taxNos);
        } else {
            this.getPageCache().remove(BF_TAXNO);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String outputDownload;
        FormOperate operate = (FormOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("save".equals(operationKey) && StringUtils.isNotEmpty((CharSequence)(outputDownload = (String)this.getModel().getValue("output_download"))) && outputDownload.contains("3") && ObjectUtils.isEmpty((Object)this.getModel().getValue("is_check"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\"\u8fdb\u9879\u72b6\u6001\u66f4\u65b0\u662f\u5426\u67e5\u9a8c\"\u3002", (String)"DownInitBillPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("save".equals(operateKey) && operationResult.isSuccess()) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            this.dealDate(dynamicObject);
            DynamicObjectCollection orgList = dynamicObject.getDynamicObjectCollection("userorg");
            for (DynamicObject object : orgList) {
                CacheHelper.remove((String)("down_check_config_key" + DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get("taxpayer_org"))));
                CacheHelper.remove((String)("down_org_taxno_key" + object.getString("taxpayer_tax_no")));
                CacheHelper.remove((String)("down_file_taxno_key" + object.getString("taxpayer_tax_no")));
            }
        }
    }

    private void dealDate(DynamicObject dynamicObject) {
        boolean usestate = dynamicObject.getBoolean("usestate");
        if (!usestate) {
            return;
        }
        String flag = this.getPageCache().get(INIT_FLAG_CACHE);
        String bfTaxNos = this.getPageCache().get(BF_TAXNO);
        this.cacheTaxnos();
        this.getPageCache().remove(INIT_FLAG_CACHE);
        if (StringUtils.isNotEmpty((CharSequence)flag)) {
            ThreadPools.executeOnceIncludeRequestContext((String)"DownInitBillPlugin.dealDate", () -> {
                Date oneYearDate;
                DynamicObjectCollection orgList = dynamicObject.getDynamicObjectCollection("userorg");
                ArrayList initDateList = Lists.newArrayList();
                List outputDownloads = CommonUtils.getMultiValues((String)dynamicObject.getString("output_download"));
                List invoiceTypes = CommonUtils.getMultiValues((String)dynamicObject.getString("invoice_type"));
                Date begin = dynamicObject.getDate(BEGIN);
                if (begin.compareTo(oneYearDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-12))) < 0) {
                    begin = oneYearDate;
                }
                InvoiceApplyLogService service = new InvoiceApplyLogService();
                for (DynamicObject orgObj : orgList) {
                    Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)orgObj.get("taxpayer_org"));
                    String taxNo = orgObj.getString("taxpayer_tax_no");
                    String dkType = DeductionConstant.getDkType((String)taxNo);
                    if ("2".equals(flag) && StringUtils.contains((CharSequence)bfTaxNos, (CharSequence)taxNo)) continue;
                    InputOutInvoiceApplyService applyService = InvoiceDownServiceFactory.newInstanceForApply((String)taxNo);
                    if (CollectionUtils.isEmpty((Collection)initDateList)) {
                        DateUtils.getMonthGroup((Date)begin, (List)initDateList);
                    }
                    for (String outputDownload : outputDownloads) {
                        ArrayList<String> checkInvoiceTypeList = new ArrayList<String>(invoiceTypes.size());
                        for (String invoiceType : invoiceTypes) {
                            if (!applyService.checkDownCustom(outputDownload, invoiceType, taxNo)) continue;
                            if ("4".equals(dkType)) {
                                checkInvoiceTypeList.add(invoiceType);
                                continue;
                            }
                            service.saveInitApplyLog(orgId, taxNo, outputDownload, invoiceType, (List)initDateList);
                        }
                        if (!CollectionUtils.isNotEmpty(checkInvoiceTypeList)) continue;
                        service.saveInitApplyLog(orgId, taxNo, outputDownload, String.join((CharSequence)",", checkInvoiceTypeList), (List)initDateList);
                    }
                }
                service.executeApply();
            });
        }
    }
}

