/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.DeductEntityEnum;
import kd.imc.rim.common.license.LicenseFormPlugin;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.PermissionUtils;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReadyDudectSelectExportPlugin
extends LicenseFormPlugin {
    private static Log logger = LogFactory.getLog(ReadyDudectSelectExportPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)"export", (CharSequence)operateKey)) {
            this.exportInvoice();
        }
    }

    private void exportInvoice() {
        block51: {
            String selectCount = this.getPageCache().get("select_count");
            int totalSelectRows = 0;
            if (StringUtils.isNotEmpty((CharSequence)selectCount)) {
                totalSelectRows = Integer.parseInt(selectCount);
            }
            boolean exportSelectd = totalSelectRows > 0;
            try (XSSFWorkbook wb = new XSSFWorkbook();){
                boolean isNotEmpty = false;
                for (DeductEntityEnum entityEnum : DeductEntityEnum.values()) {
                    String entryentity = entityEnum.getName();
                    String awsType = DeductEntityEnum.getCodeByName((String)entryentity);
                    EntryGrid entryGrid = (EntryGrid)this.getControl(entryentity);
                    List fieldEdits = entryGrid.getFieldEdits();
                    DataEntityPropertyCollection entityProperties = this.getModel().getEntryEntity(entryentity).getDynamicObjectType().getProperties();
                    XSSFSheet sheet = null;
                    int[] selectRows = entryGrid.getSelectRows();
                    if (exportSelectd) {
                        if (ObjectUtils.isEmpty((Object)selectRows)) continue;
                        isNotEmpty = true;
                        sheet = wb.createSheet(entityEnum.getInvoiceTypeName());
                        this.addSheetHeader(sheet, entityProperties, fieldEdits);
                        int index = 1;
                        for (int selectRow : selectRows) {
                            DynamicObject invoice = this.getModel().getEntryRowEntity(entryentity, selectRow);
                            this.exportDataToSheet(sheet, entryGrid, fieldEdits, invoice, index);
                            ++index;
                        }
                        continue;
                    }
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryentity);
                    if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
                    isNotEmpty = true;
                    sheet = wb.createSheet(entityEnum.getInvoiceTypeName());
                    this.addSheetHeader(sheet, entityProperties, fieldEdits);
                    int indexAll = 1;
                    for (DynamicObject invoiceAll : entryEntity) {
                        this.exportDataToSheet(sheet, entryGrid, fieldEdits, invoiceAll, indexAll);
                        ++indexAll;
                    }
                }
                if (!isNotEmpty) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4e3a\u7a7a", (String)"ReadyDudectSelectExportPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return;
                }
                byte[] bytes = null;
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    wb.write((OutputStream)os);
                    bytes = os.toByteArray();
                }
                catch (IOException e1) {
                    logger.error("\u5bfc\u51faExcel\u5931\u8d25", (Throwable)e1);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfcE\u51faxcel\u5931\u8d25", (String)"ReadyDudectSelectExportPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
                if (bytes != null) {
                    try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                        String fileName = String.format(ResManager.loadKDString((String)"\u9884\u52fe\u9009\u5bfc\u51fa\u53d1\u7968\u6570\u636e_%1$s.xlsx", (String)"ReadyDudectSelectExportPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
                        String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
                        PermissionUtils.addTempFilePermission((String)urls, (String)this.getView().getEntityId(), (String)"23/JLKKTE6R/", (int)5000);
                        this.getView().openUrl(urls);
                        break block51;
                    }
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfcE\u51faxcel\u5931\u8d25", (String)"ReadyDudectSelectExportPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            catch (IOException e) {
                logger.error("\u5bfc\u51fa\u9884\u52fe\u9009\u53d1\u7968\u5931\u8d25", (Throwable)e);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u9884\u52fe\u9009\u53d1\u7968\u5931\u8d25:%1$s", (String)"ReadyDudectSelectExportPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    private void addSheetHeader(XSSFSheet sheet, DataEntityPropertyCollection entityProperties, List<FieldEdit> fieldEdits) {
        XSSFRow row = sheet.createRow(0);
        row.createCell(0).setCellValue(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"ReadyDudectSelectExportPlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        int index = 1;
        for (FieldEdit fieldEdit : fieldEdits) {
            String fieldKey = fieldEdit.getFieldKey();
            if (StringUtils.contains((CharSequence)fieldKey, (CharSequence)"serial_no")) continue;
            IDataEntityProperty property = (IDataEntityProperty)entityProperties.get((Object)fieldKey);
            String name = property.getDisplayName().getLocaleValue();
            row.createCell(index).setCellValue(name);
            ++index;
        }
    }

    private void exportDataToSheet(XSSFSheet sheet, EntryGrid entryGrid, List<FieldEdit> fieldEdits, DynamicObject invoice, int index) {
        XSSFRow row = sheet.createRow(index);
        row.createCell(0).setCellValue((double)index);
        int indexCell = 1;
        for (FieldEdit fieldEdit : fieldEdits) {
            String fieldKey = fieldEdit.getFieldKey();
            if (StringUtils.contains((CharSequence)fieldKey, (CharSequence)"serial_no")) continue;
            Object val = invoice.get(fieldKey);
            IDataEntityProperty prop = this.getModel().getProperty(fieldKey);
            Object name = MetadataUtil.getRealValue((EntryGrid)entryGrid, (IDataEntityProperty)prop, (Object)val);
            row.createCell(indexCell).setCellValue(Optional.ofNullable(name).map(Object::toString).orElse(""));
            ++indexCell;
        }
    }
}

