/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.RimPermItemEnum;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxAsyncDeductSelectService;
import kd.imc.rim.common.invoice.download.InvoiceDownHelper;
import kd.imc.rim.common.license.LicenseListPlugin;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateFactory;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import kd.imc.rim.formplugin.query.operate.impl.ReapplySelectLoginOperateService;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;

public class SelectLogListPlugin
extends LicenseListPlugin {
    private static Log logger = LogFactory.getLog(SelectLogListPlugin.class);
    public static String DISCARD_TASK = "discard_task";
    private static String REAPPLY = "reapply";
    private static Set<String> allow_abandon = Sets.newHashSet((Object[])new String[]{"2", "7", "8"});

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void getSelectResult() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectCollection = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"SelectLogListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        QFilter idFilter = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
        ArrayList status = Lists.newArrayList();
        status.add("3");
        status.add("2");
        QFilter handleStatusFilter = new QFilter("handle_status", "in", (Object)status);
        DynamicObjectCollection logs = QueryServiceHelper.query((String)"rim_select_log", (String)"tax_no,id, select_type", (QFilter[])new QFilter[]{idFilter, handleStatusFilter});
        if (!ObjectUtils.isEmpty((Object)logs)) {
            JSONObject cacheJson = new JSONObject();
            Map<String, List<DynamicObject>> groupMap = logs.stream().filter(s -> !StringUtils.isEmpty((CharSequence)s.getString("tax_no"))).collect(Collectors.groupingBy(s -> s.getString("tax_no")));
            for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
                List<DynamicObject> values = entry.getValue();
                ArrayList<Map> list = new ArrayList<Map>(values.size());
                for (DynamicObject value : values) {
                    list.add(DynamicObjectUtil.dynamicObjectToMap((DynamicObject)value));
                }
                JSONObject data = new JSONObject();
                data.put("data", list);
                cacheJson.put(entry.getKey(), (Object)data);
            }
            this.getPageCache().put("deduct_tax_no", cacheJson.toJSONString());
            this.getPageCache().put("deduct_title", ResManager.loadKDString((String)"\u83b7\u53d6\u5f02\u6b65\u8bf7\u6c42\u7ed3\u679c", (String)"SelectLogListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            InvoiceOperateService service = InvoiceOperateFactory.newInstance("deduct_login_get_async_result", 0L, (AbstractFormPlugin)this);
            service.operate();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5904\u7406\u72b6\u6001\u4e3a'\u5904\u7406\u4e2d\u6216\u5931\u8d25'\u7684\u6570\u636e", (String)"SelectLogListPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
        DynamicObject logDynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"rim_select_log", (String)"batch_no");
        QFilter batchNoFilter = new QFilter("batch_no", "=", (Object)logDynamicObject.getString("batch_no"));
        DynamicObjectCollection accountCollection = QueryServiceHelper.query((String)"rim_select_account", (String)"id", (QFilter[])new QFilter[]{batchNoFilter});
        if (CollectionUtils.isEmpty((Collection)accountCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u6ca1\u6709\u5173\u8054\u53f0\u8d26\u6570\u636e", (String)"SelectLogListPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else {
            List idList = accountCollection.stream().map(s -> s.get("id")).collect(Collectors.toList());
            ListShowParameter showParameter = new ListShowParameter();
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            showParameter.setFormId("bos_list");
            showParameter.setBillFormId("rim_select_account_layout");
            QFilter filter = new QFilter("id", "in", idList);
            listFilterParameter.setFilter(filter);
            showParameter.setCustomParam("goupanddown", (Object)"1");
            showParameter.setListFilterParameter(listFilterParameter);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        InvoiceOperateService service;
        if ("deduct_login_get_async_result".equals(closedCallBackEvent.getActionId())) {
            service = InvoiceOperateFactory.newInstance("deduct_login_get_async_result", 0L, (AbstractFormPlugin)this);
            service.closedCallBack(closedCallBackEvent);
        }
        if ("select_reapply_login".equals(closedCallBackEvent.getActionId())) {
            service = InvoiceOperateFactory.newInstance("select_reapply_login", 0L, (AbstractFormPlugin)this);
            service.closedCallBack(closedCallBackEvent);
        }
    }

    public void startAbandonTask() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectCollection = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"SelectLogListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (selectCollection.size() > 500) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u6b21\u6700\u5927\u5141\u8bb8\u7684\u4f5c\u5e9f\u4efb\u52a1\u6570\u91cf\u4e3a500", (String)"SelectLogListPlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        QFilter idFilter = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
        StringBuilder message = new StringBuilder();
        DynamicObjectCollection logs = QueryServiceHelper.query((String)"rim_select_log", (String)"id, batch_no, tax_no, handle_status, select_type", (QFilter[])new QFilter[]{idFilter});
        if (!ObjectUtils.isEmpty((Object)logs)) {
            HashMap<String, List<String>> param = new HashMap<String, List<String>>();
            HashMap<String, String> failMap = new HashMap<String, String>(logs.size());
            for (DynamicObject log : logs) {
                String tip;
                String tip2;
                String taxNo = log.getString("tax_no");
                String batchNo = log.getString("batch_no");
                String handleStatus = log.getString("handle_status");
                String selectType = log.getString("select_type");
                if (StringUtils.isBlank((CharSequence)batchNo)) {
                    tip2 = ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e3a\u7a7a", (String)"SelectLogListPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                    message.append(tip2);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    failMap.put(batchNo, tip2);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)taxNo)) {
                    tip2 = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u7a0e\u53f7\u4e3a\u7a7a", (String)"SelectLogListPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip2);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    failMap.put(batchNo, tip2);
                    continue;
                }
                String dkType = DeductionConstant.getDkType((String)taxNo);
                if (!"4".equals(dkType)) {
                    tip = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u7a0e\u53f7\u5bf9\u5e94\u7684\u6536\u7968\u901a\u9053\u975e\u65b0\u7535\u5b50\u5e73\u53f0\uff0c\u6682\u4e0d\u652f\u6301\u4f5c\u5e9f\u64cd\u4f5c", (String)"SelectLogListPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    failMap.put(batchNo, tip);
                    continue;
                }
                if (!"3".equals(handleStatus)) {
                    tip = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u975e\u5904\u7406\u4e2d\u7684\u72b6\u6001\u4e0d\u652f\u6301\u4f5c\u5e9f", (String)"SelectLogListPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    failMap.put(batchNo, tip);
                    continue;
                }
                if (!allow_abandon.contains(selectType)) {
                    tip = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u5f53\u524d\u53ea\u652f\u6301\u5f02\u6b65\u52fe\u9009\u3001\u5165\u8d26\u3001\u519c\u4ea7\u54c1\u5904\u7406\u4e1a\u52a1\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c", (String)"SelectLogListPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    failMap.put(batchNo, tip);
                    continue;
                }
                List batchNoList = param.getOrDefault(taxNo, new ArrayList());
                batchNoList.add(batchNo);
                param.put(taxNo, batchNoList);
            }
            if (MapUtils.isEmpty(param)) {
                failMap.clear();
                String title = ResManager.loadKDString((String)"\u4f5c\u5e9f\u4efb\u52a1", (String)"SelectLogListPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                ViewUtil.showMessage((AbstractFormPlugin)this, (String)title, (String)message.toString(), (int)0, (int)selectCollection.size());
                return;
            }
            this.discardTask(param, failMap);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5728\u6570\u636e\u5e93\u91cc\u4e0d\u5b58\u5728", (String)"SelectLogListPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    private void discardTask(Map<String, List<String>> param, Map<String, String> failMap) {
        if (param == null) {
            logger.info("\u4f5c\u5e9f\u4efb\u52a1-\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        NewEtaxAsyncDeductSelectService newEtaxAsyncDeductSelectService = new NewEtaxAsyncDeductSelectService();
        newEtaxAsyncDeductSelectService.discardTask(param, (AbstractFormPlugin)this, "1", failMap);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (DISCARD_TASK.equals(key)) {
            PermissionUtils.checkPermissionNew((String)"rim_select_log", (AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.ITEM_SELECT_DISCARD_TASK, (String)DISCARD_TASK);
            this.startAbandonTask();
        } else if (REAPPLY.equals(key)) {
            PermissionUtils.checkPermissionNew((String)"rim_select_log", (AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.ITEM_SELECT_REAPPLY, (String)REAPPLY);
            this.startReapply();
        }
    }

    private void startReapply() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectCollection = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"DownLogListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if (selectCollection.size() > 500) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u6b21\u6700\u5927\u5141\u8bb8\u7684\u624b\u5de5\u91cd\u8bd5\u4efb\u52a1\u6570\u91cf\u4e3a500", (String)"SelectLogListPlugin_26", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
        DynamicObjectCollection selectLogCollection = QueryServiceHelper.query((String)"rim_select_log", (String)"id,batch_no,tax_no,select_type,operate_type,handle_status,fail_num,bill_type, org", (QFilter[])new QFilter[]{filter});
        if (!ObjectUtils.isEmpty((Object)selectLogCollection)) {
            StringBuilder message = new StringBuilder();
            ArrayList<DynamicObject> successLogList = new ArrayList<DynamicObject>(selectLogCollection.size());
            ReapplySelectLoginOperateService service = new ReapplySelectLoginOperateService("select_reapply_login", 0L, (AbstractFormPlugin)this);
            for (DynamicObject dynamicObject : selectLogCollection) {
                JSONArray jsonArray;
                Map map;
                String tip;
                String taxNo = dynamicObject.getString("tax_no");
                String batchNo = dynamicObject.getString("batch_no");
                String handleStatus = dynamicObject.getString("handle_status");
                String selectType = dynamicObject.getString("select_type");
                int failNum = dynamicObject.getInt("fail_num");
                if (StringUtils.isBlank((CharSequence)taxNo)) {
                    tip = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u7a0e\u53f7\u4e3a\u7a7a", (String)"DownLogListPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    map = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)dynamicObject);
                    jsonArray = new JSONArray(1);
                    jsonArray.add((Object)map);
                    service.setCacheTip(taxNo, ResManager.loadKDString((String)"\u7a0e\u53f7\u4e3a\u7a7a", (String)"DownLogListPlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
                    continue;
                }
                if (!"2".equals(handleStatus)) {
                    tip = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u5f53\u524d\u53ea\u652f\u6301\u5931\u8d25\u7c7b\u578b\u7684\u6570\u636e\u8fdb\u884c\u91cd\u8bd5", (String)"DownLogListPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    map = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)dynamicObject);
                    jsonArray = new JSONArray(1);
                    jsonArray.add((Object)map);
                    service.setCacheTip(taxNo, ResManager.loadKDString((String)"\u5f53\u524d\u53ea\u652f\u6301\u5931\u8d25\u7c7b\u578b\u7684\u6570\u636e\u8fdb\u884c\u91cd\u8bd5", (String)"DownLogListPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
                    continue;
                }
                if (!InvoiceDownHelper.ALLOW_REAPPLY_SELECT_TYPE.contains(selectType)) {
                    tip = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u5f53\u524d\u53ea\u652f\u6301\u52fe\u9009\u3001\u5165\u8d26\u4e1a\u52a1\u8fdb\u884c\u624b\u5de5\u91cd\u8bd5", (String)"SelectLogListPlugin_27", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    map = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)dynamicObject);
                    jsonArray = new JSONArray(1);
                    jsonArray.add((Object)map);
                    service.setCacheTip(taxNo, ResManager.loadKDString((String)"\u5f53\u524d\u53ea\u652f\u6301\u52fe\u9009\u3001\u5165\u8d26\u4e1a\u52a1\u8fdb\u884c\u624b\u5de5\u91cd\u8bd5", (String)"SelectLogListPlugin_28", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
                    continue;
                }
                if (failNum <= 0) {
                    tip = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u53ea\u652f\u6301\u5931\u8d25\u4efd\u6570>0\u7684\u4efb\u52a1\u8fdb\u884c\u624b\u5de5\u91cd\u8bd5", (String)"SelectLogListPlugin_29", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    map = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)dynamicObject);
                    jsonArray = new JSONArray(1);
                    jsonArray.add((Object)map);
                    service.setCacheTip(taxNo, ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5931\u8d25\u4efd\u6570>0\u7684\u4efb\u52a1\u8fdb\u884c\u624b\u5de5\u91cd\u8bd5", (String)"SelectLogListPlugin_30", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
                    continue;
                }
                String dkType = DeductionConstant.getDkType((String)taxNo);
                if (!"4".equals(dkType) && !"5".equals(dkType)) {
                    String tip2 = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u6536\u7968\u901a\u9053\u53ea\u6709\u4e50\u4f01\u548c\u65b0\u7535\u5b50\u7a0e\u52a1\u5e73\u53f0\u652f\u6301\u91cd\u8bd5\u64cd\u4f5c", (String)"SelectLogListPlugin_31", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo);
                    message.append(tip2);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    Map map2 = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)dynamicObject);
                    JSONArray jsonArray2 = new JSONArray(1);
                    jsonArray2.add((Object)map2);
                    service.setCacheTip(taxNo, ResManager.loadKDString((String)"\u6536\u7968\u901a\u9053\u53ea\u6709\u4e50\u4f01\u548c\u65b0\u7535\u5b50\u7a0e\u52a1\u5e73\u53f0\u652f\u6301\u91cd\u8bd5\u64cd\u4f5c", (String)"SelectLogListPlugin_32", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray2, 0);
                    continue;
                }
                successLogList.add(dynamicObject);
            }
            if (CollectionUtils.isEmpty(successLogList)) {
                DeductionConstant.removeLoopLoginCache((IPageCache)this.getPageCache());
                String title = ResManager.loadKDString((String)"\u624b\u5de5\u91cd\u8bd5", (String)"DownLogListPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                ViewUtil.showMessage((AbstractFormPlugin)this, (String)title, (String)message.toString(), (int)0, (int)selectCollection.size());
                return;
            }
            Map<String, List<DynamicObject>> groupMap = successLogList.stream().filter(s -> !kd.bos.orm.util.StringUtils.isEmpty((Object)s.getString("tax_no"))).collect(Collectors.groupingBy(s -> s.getString("tax_no")));
            JSONObject cacheJson = new JSONObject();
            for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
                List<DynamicObject> values = entry.getValue();
                ArrayList<Map> list = new ArrayList<Map>(values.size());
                for (DynamicObject value : values) {
                    list.add(DynamicObjectUtil.dynamicObjectToMap((DynamicObject)value));
                }
                JSONObject data = new JSONObject();
                data.put("data", list);
                cacheJson.put(entry.getKey(), (Object)data);
            }
            this.getPageCache().put("deduct_tax_no", cacheJson.toJSONString());
            this.getPageCache().put("deduct_title", ResManager.loadKDString((String)"\u624b\u5de5\u91cd\u8bd5", (String)"DownLogListPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            service.operate();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5728\u6570\u636e\u5e93\u91cc\u4e0d\u5b58\u5728", (String)"SelectLogListPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        if ("get_select_result".equals(operateKey)) {
            this.getSelectResult();
        } else if ("reset_status".equals(operateKey)) {
            this.resetStatus();
        }
    }

    private void resetStatus() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectCollection = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"SelectLogListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        QFilter idFilter = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
        Object[] logs = BusinessDataServiceHelper.load((String)"rim_select_log", (String)"id,handle_status,update_time", (QFilter[])new QFilter[]{idFilter});
        if (!ObjectUtils.isEmpty((Object[])logs)) {
            for (Object log : logs) {
                log.set("handle_status", (Object)"3");
                log.set("update_time", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])logs);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u72b6\u6001\u64cd\u4f5c\u6210\u529f", (String)"SelectLogListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            billList.clearSelection();
            billList.refresh();
        }
    }

    public void afterBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String flag = this.getPageCache().get("flag");
        if (Boolean.TRUE.toString().equals(flag)) {
            return;
        }
        if (customParams != null && "1".equals(customParams.get("rim_latest_task_status"))) {
            Toolbar bar = (Toolbar)this.getView().getControl("toolbarap");
            bar.addItemClickListener((ItemClickListener)this);
            this.addItemClickListeners(new String[]{"toolbarap"});
            this.getPageCache().put("flag", Boolean.TRUE.toString());
            bar.itemClick("get_select_result", "get_select_result");
        }
    }
}

