/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.TaxExcelImportConstant;
import kd.imc.rim.common.helper.ExcelInvoiceImportUtil;
import kd.imc.rim.common.invoice.deduction.DealInputTableTask;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class TaxInvoiceImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(TaxInvoiceImportPlugin.class);
    public static final String EXCEL_TYPE = "excelType";
    public static final String ORG = "org";
    public static final String TAX_PERIOD = "tax_period";
    public static final String BTN_RESET_FILE = "btn_reset_file";
    public static final String BTN_UPLOAD = "btnok";
    public static final String BTN_FILE_UPLOAD = "btn_file_upload";
    public static final String BTN_CANCEL = "btncancel";
    public static final String UPLOAD_FILEPATH = "filepath";
    public static final String UPLOAD_FILENAME = "filename";
    public static final String UPLOAD_FILEPANEL = "filepanel";
    public static final String UPLOAD_PANEL = "uploadpanel";
    private static Set<String> deductCheckSet = Sets.newHashSet((Object[])new String[]{"checkFlag", "invoiceDate", "invoiceAmount", "totalTaxAmount", "effectiveTaxAmount", "buyerTaxNo", "invoiceType"});
    private static Set<String> hgjkDeductCheckSet = Sets.newHashSet((Object[])new String[]{"checkFlag", "invoiceNo", "invoiceDate", "totalAmount", "effectiveTaxAmount"});
    private static Set<String> dkdjDeductCheckSet = Sets.newHashSet((Object[])new String[]{"checkFlag", "invoiceNo", "invoiceDate", "salerTaxNo", "salerName", "totalTaxAmount", "invoiceAmount", "effectiveTaxAmount"});
    private static Set<String> notDeductCheckSet = Sets.newHashSet((Object[])new String[]{"checkFlag", "invoiceDate", "salerName", "salerTaxNo", "invoiceAmount", "totalTaxAmount", "effectiveTaxAmount", "invoiceType"});
    private static Set<String> mustFirstSheetSet = Sets.newHashSet((Object[])new String[]{"invoiceDate", "invoiceAmount", "totalTaxAmount", "invoiceType"});
    private static Set<String> mustSecondSheetSet = Sets.newHashSet((Object[])new String[]{"invoiceNo", "invoiceDate", "totalTaxAmount"});
    private static Set<String> mustThirdSheetSet = Sets.newHashSet((Object[])new String[]{"invoiceNo", "invoiceDate", "salerTaxNo"});

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String excelType = (String)customParams.get(EXCEL_TYPE);
        if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)excelType)) {
            throw new MsgException("0001", ResManager.loadKDString((String)"\u5bfc\u5165Excel\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeductInvoiceImportPlugin_12", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        this.getModel().setValue(ORG, (Object)RequestContext.get().getOrgId());
        this.getPageCache().put(EXCEL_TYPE, excelType);
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{UPLOAD_FILEPANEL});
        if ("import_authenticate_excel".equals(this.getPageCache().get(EXCEL_TYPE))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TAX_PERIOD});
        }
        super.afterBindData(e);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_RESET_FILE, BTN_UPLOAD, BTN_CANCEL});
        Image label = (Image)this.getControl(BTN_FILE_UPLOAD);
        label.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btn_reset_file": 
            case "btncancel": {
                this.resetFile();
                break;
            }
            case "btnok": {
                this.excelUpload();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void excelUpload() {
        long taskStart = System.currentTimeMillis();
        JSONObject fileParam = new JSONObject();
        String excelType = this.getPageCache().get(EXCEL_TYPE);
        Date tax_periodDate = (Date)this.getModel().getValue(TAX_PERIOD);
        String taxPeriod = null;
        InputStream inputStream = null;
        JSONObject resultObject = new JSONObject();
        try {
            if (TaxExcelImportConstant.isDeductTaxExcelImport((String)excelType).booleanValue()) {
                if (Objects.isNull(tax_periodDate)) {
                    throw new MsgException("0001", ResManager.loadKDString((String)"\u7a0e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeductInvoiceImportPlugin_13", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                taxPeriod = DateUtils.format((Date)tax_periodDate, (String)"yyyyMM");
                fileParam.put("taxPeriod", (Object)taxPeriod);
            }
            fileParam.put(EXCEL_TYPE, (Object)excelType);
            String filepath = (String)this.getModel().getValue(UPLOAD_FILEPATH);
            if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)filepath)) {
                throw new MsgException("0001", ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c", (String)"DeductInvoiceImportPlugin_14", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (Objects.isNull(org)) {
                throw new MsgException("0001", ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeductInvoiceImportPlugin_15", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            long orgId = org.getLong("id");
            fileParam.put("orgId", (Object)orgId);
            fileParam.put("filePath", (Object)filepath);
            String taxNoByOrgId = TenantUtils.getTaxNoByOrgId((Long)orgId);
            if (kd.imc.rim.common.utils.StringUtils.isBlank((CharSequence)taxNoByOrgId)) {
                throw new MsgException("0001", ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u65e0\u7a0e\u53f7\u4fe1\u606f", (String)"DeductInvoiceImportPlugin_16", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            fileParam.put("taxNoInput", (Object)taxNoByOrgId);
            fileParam.put("fileName", this.getView().getModel().getValue(UPLOAD_FILENAME));
            FileService service = FileServiceFactory.getAttachmentFileService();
            resultObject.put("code", (Object)"0000");
            inputStream = service.getInputStream(filepath);
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            this.resolveExcel(workbook, fileParam, resultObject);
            IOUtils.closeQuietly((AutoCloseable)inputStream);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790excel\u5f02\u5e38\uff0cmessage: " + e.getMessage(), (Throwable)e);
            resultObject.put("code", (Object)"0001");
            resultObject.put("message", (Object)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        logger.info(String.format("%s\u62b5\u6263\u3001\u4e0d\u62b5\u6263\uff0cexcel\u89e3\u6790\u5bfc\u5165\uff0c\u603b\u8017\u65f6%s", RequestContext.get().getTraceId(), System.currentTimeMillis() - taskStart));
        this.getView().returnDataToParent((Object)resultObject);
        this.getView().close();
    }

    private JSONObject resolveExcel(Workbook workbook, JSONObject fileParam, JSONObject resultObject) {
        try {
            Row firstRow;
            if (workbook == null) {
                throw new MsgException("0001", ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20", (String)"DeductInvoiceImportPlugin_0", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            int sheetCounts = workbook.getNumberOfSheets();
            Sheet firstSheet = workbook.getSheetAt(0);
            if (firstSheet == null) {
                throw new MsgException("0001", ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef(sheet\u4fe1\u606f\u4e3a\u7a7a)\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684excel\u6a21\u677f\u586b\u5199", (String)"DeductInvoiceImportPlugin_1", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            String excelType = fileParam.getString(EXCEL_TYPE);
            int invoiceStart = 1;
            int fieldNameRowNo = 0;
            Sheet secondSheet = null;
            Sheet thirdSheet = null;
            String type = "deduct";
            if ("import_hkjk_deduct".equals(excelType) || "import_hkjk_not_deduct".equals(excelType)) {
                type = "hkjk_deduct";
            }
            if ("import_dkdj_deduct".equals(excelType) || "import_dkdj_not_deduct".equals(excelType)) {
                type = "dkdj_deduct";
            }
            if ("import_authenticate_excel".equals(excelType)) {
                String sheetName;
                invoiceStart = 3;
                fieldNameRowNo = 2;
                type = "auth";
                if (sheetCounts >= 2) {
                    secondSheet = workbook.getSheetAt(1);
                    if (secondSheet == null) {
                        throw new MsgException("0001", ResManager.loadKDString((String)"\u8bfb\u53d6\u7b2c\u4e8c\u4e2asheet\u5931\u8d25", (String)"DeductInvoiceImportPlugin_7", (String)"imc-rim-common", (Object[])new Object[0]));
                    }
                    sheetName = secondSheet.getSheetName();
                    Row firstRowSecond = secondSheet.getRow(fieldNameRowNo);
                    if (firstRowSecond == null || firstRowSecond.getCell(0) == null || !"\u6d77\u5173\u7f34\u6b3e\u4e66".equals(sheetName)) {
                        throw new MsgException("0001", ResManager.loadKDString((String)"\u7b2c\u4e8c\u4e2asheet\uff0c\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef\uff08%1$s\u7684\u9996\u884c\u4fe1\u606f\u4e3a\u7a7a\uff09\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684excel\u6a21\u677f\u586b\u5199", (String)"DeductInvoiceImportPlugin_8", (String)"imc-rim-common", (Object[])new Object[0]));
                    }
                }
                if (sheetCounts >= 3) {
                    thirdSheet = workbook.getSheetAt(2);
                    if (thirdSheet == null) {
                        throw new MsgException("0001", ResManager.loadKDString((String)"\u8bfb\u53d6\u7b2c\u4e09\u4e2asheet\u5931\u8d25", (String)"DeductInvoiceImportPlugin_22", (String)"imc-rim-common", (Object[])new Object[0]));
                    }
                    sheetName = thirdSheet.getSheetName();
                    Row firstRowThird = thirdSheet.getRow(fieldNameRowNo);
                    if (firstRowThird == null || firstRowThird.getCell(0) == null || !"\u4ee3\u6263\u4ee3\u7f34".equals(sheetName)) {
                        throw new MsgException("0001", ResManager.loadKDString((String)"\u7b2c\u4e09\u4e2asheet\uff0c\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef\uff08%1$s\u7684\u9996\u884c\u4fe1\u606f\u4e3a\u7a7a\uff09\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684excel\u6a21\u677f\u586b\u5199", (String)"DeductInvoiceImportPlugin_23", (String)"imc-rim-common", (Object[])new Object[0]));
                    }
                }
            }
            if ((firstRow = firstSheet.getRow(fieldNameRowNo)) == null || firstRow.getCell(0) == null) {
                throw new MsgException("0001", String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef\uff08%1$s\u7684\u9996\u884c\u4fe1\u606f\u4e3a\u7a7a\uff09\uff0c\u8bf7\u6309\u7167\u4e0b\u8f7d\u7684excel\u6a21\u677f\u586b\u5199", (String)"DeductInvoiceImportPlugin_11", (String)"imc-rim-common", (Object[])new Object[0]), firstSheet));
            }
            Object[] invoiceArray = this.analyzeTaxExcelDeduct(firstSheet, fileParam, invoiceStart, fieldNameRowNo, type);
            Object[] customsInvoiceArray = null;
            Object[] withHoldRemitInvoiceArray = null;
            if (secondSheet != null) {
                customsInvoiceArray = this.analyzeTaxExcelDeduct(secondSheet, fileParam, invoiceStart, fieldNameRowNo, "customs");
            }
            if (thirdSheet != null) {
                withHoldRemitInvoiceArray = this.analyzeTaxExcelDeduct(thirdSheet, fileParam, invoiceStart, fieldNameRowNo, "withholdremit");
            }
            Set<String> checkFiledSet = null;
            HashMap<Integer, Object[]> checkDataParam = new HashMap<Integer, Object[]>();
            HashMap<Integer, Set<String>> checkFieldMap = new HashMap<Integer, Set<String>>();
            if (TaxExcelImportConstant.isDeductTaxExcelImport((String)excelType).booleanValue()) {
                if (ObjectUtils.isEmpty((Object[])invoiceArray)) {
                    throw new MsgException("0002", ResManager.loadKDString((String)"\u5173\u952e\u5b57\u6bb5\u7f3a\u5931\uff01\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u6709\u53d1\u7968\u6570\u636e", (String)"DeductInvoiceImportPlugin_6", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                if ("import_deduct_excel".equals(excelType)) {
                    checkFiledSet = deductCheckSet;
                } else if ("import_not_deduct_excel".equals(excelType)) {
                    checkFiledSet = notDeductCheckSet;
                } else if ("import_hkjk_deduct".equals(excelType) || "import_hkjk_not_deduct".equals(excelType)) {
                    checkFiledSet = hgjkDeductCheckSet;
                } else if ("import_dkdj_deduct".equals(excelType) || "import_dkdj_not_deduct".equals(excelType)) {
                    checkFiledSet = dkdjDeductCheckSet;
                }
                checkDataParam.put(0, invoiceArray);
                checkFieldMap.put(0, checkFiledSet);
            } else if ("import_authenticate_excel".equals(excelType)) {
                if (ObjectUtils.isEmpty((Object[])invoiceArray) && ObjectUtils.isEmpty((Object[])customsInvoiceArray) && ObjectUtils.isEmpty((Object[])withHoldRemitInvoiceArray)) {
                    throw new MsgException("0002", ResManager.loadKDString((String)"\u5173\u952e\u5b57\u6bb5\u7f3a\u5931\uff01\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u6709\u53d1\u7968\u6570\u636e", (String)"DeductInvoiceImportPlugin_6", (String)"imc-rim-common", (Object[])new Object[0]));
                }
                if (!ObjectUtils.isEmpty((Object[])invoiceArray)) {
                    checkDataParam.put(0, invoiceArray);
                    checkFieldMap.put(0, mustFirstSheetSet);
                }
                if (!ObjectUtils.isEmpty((Object[])customsInvoiceArray)) {
                    checkDataParam.put(1, customsInvoiceArray);
                    checkFieldMap.put(1, mustSecondSheetSet);
                }
                if (!ObjectUtils.isEmpty((Object[])withHoldRemitInvoiceArray)) {
                    checkDataParam.put(2, withHoldRemitInvoiceArray);
                    checkFieldMap.put(2, mustThirdSheetSet);
                }
            } else {
                throw new MsgException("0001", ResManager.loadKDString((String)"\u8bf7\u4ece\u62b5\u6263\u52fe\u9009/\u4e0d\u62b5\u6263\u3001\u7edf\u8ba1\u786e\u8ba4\uff0c\u8fdb\u884c\u5bfc\u5165\u53d1\u7968\u6587\u4ef6", (String)"DeductInvoiceImportPlugin_4", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            invoiceArray = ExcelInvoiceImportUtil.checkInvoice((Workbook)workbook, (JSONObject)fileParam, checkFieldMap, (int)fieldNameRowNo, checkDataParam);
            if (ObjectUtils.isEmpty((Object[])invoiceArray)) {
                throw new MsgException("0005", ResManager.loadKDString((String)"\u9700\u8981\u5bfc\u5165\u7684\u53d1\u7968\u6570\u636e\u4e3a\u7a7a\uff01\u8bf7\u5230'\u67e5\u770b\u53d1\u7968\u5f15\u5165\u7ed3\u679c'\uff0c\u67e5\u770b\u7ed3\u679c", (String)"DeductInvoiceImportPlugin_2", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            String buyerTaxNo = invoiceArray[0].getString("buyerTaxNo");
            String batchNo = TaxInvoiceImportPlugin.randomUUID();
            JSONArray jsonArray = JSONArray.parseArray((String)JSONObject.toJSONString((Object)invoiceArray));
            Long orgId = (Long)fileParam.get((Object)"orgId");
            DeductionUtils.saveInvoiceToInputTable((JSONArray)jsonArray, (Long)orgId, (String)buyerTaxNo, (String)batchNo, (String)CollectTypeEnum.TAX_EXCEL_IMPORT.getName(), (String)CollectTypeEnum.TAX_EXCEL_IMPORT.getCode(), (String)"1");
            DealInputTableTask dealInputTableTask = new DealInputTableTask(RequestContext.get(), batchNo);
            ThreadPools.executeOnce((String)"InvoiceDownProgressPool-deduct", (Runnable)dealInputTableTask);
            logger.info("\u62b5\u6263/\u975e\u62b5\u6263\u8f6c\u6362\u5b8c\u6210\uff0c\u5df2\u8f93\u51fa\u5230 \u53d1\u7968\u5f15\u5165\u7ed3\u679c");
            return resultObject;
        }
        catch (Exception e) {
            MsgException msgException;
            String errorCode;
            logger.error("\u89e3\u6790excel\u5f02\u5e38\uff1a", (Throwable)e);
            if (e instanceof MsgException && ("0003".equals(errorCode = (msgException = (MsgException)((Object)e)).getErrorCode()) || "0002".equals(errorCode) || "0005".equals(errorCode))) {
                throw new MsgException(e.getMessage());
            }
            throw new MsgException((Throwable)e, ResManager.loadKDString((String)"\u89e3\u6790\u5931\u8d25\uff0c\u7a0e\u5c40\u6a21\u677f\u53ef\u80fd\u5df2\u7ecf\u53d8\u5316\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (String)"DeductInvoiceImportPlugin_3", (String)"imc-rim-common", (Object[])new Object[0]));
        }
    }

    public static synchronized String randomUUID() {
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        return uuid.toLowerCase();
    }

    private JSONObject[] analyzeTaxExcelDeduct(Sheet sheet, JSONObject fileParam, int invoiceStart, int fieldNameRowNo, String type) {
        if (sheet == null) {
            return new JSONObject[0];
        }
        logger.info("\u62b5\u6263/\u4e0d\u62b5\u6263\u3001\u7edf\u8ba1\u786e\u8ba4\uff0c \u89e3\u6790excel\u5f00\u59cb");
        long startTime = System.currentTimeMillis();
        int invoiceLast = sheet.getLastRowNum();
        String taxNoInput = fileParam.getString("taxNoInput");
        String excelType = fileParam.getString(EXCEL_TYPE);
        String deductionPurpose = null;
        boolean checkNotDeductibleType = false;
        JSONObject defaultInvoice = new JSONObject();
        if (TaxExcelImportConstant.isDeductTaxExcelImport((String)excelType).booleanValue()) {
            if ("import_deduct_excel".equals(excelType) || "import_hkjk_deduct".equals(excelType) || "import_dkdj_deduct".equals(excelType)) {
                deductionPurpose = "1";
            } else {
                deductionPurpose = "2";
                if ("import_not_deduct_excel".equals(excelType)) {
                    checkNotDeductibleType = true;
                }
            }
            defaultInvoice.put("deductionPurpose", (Object)deductionPurpose);
            defaultInvoice.put("checkAuthenticateFlag", (Object)"0");
            defaultInvoice.put("manageStatus", (Object)"0");
            defaultInvoice.put("taxPeriod", (Object)fileParam.getString("taxPeriod"));
        } else if ("import_authenticate_excel".equals(excelType)) {
            deductionPurpose = "1";
            defaultInvoice.put("deductionPurpose", (Object)deductionPurpose);
            defaultInvoice.put("manageStatus", (Object)"0");
            defaultInvoice.put("checkFlag", (Object)"1");
            defaultInvoice.put("authenticateFlag", (Object)"2");
            defaultInvoice.put("checkAuthenticateFlag", (Object)"1");
            TaxInvoiceImportPlugin.getBuyerInfo(sheet, type, defaultInvoice);
            String buyerTaxNo = defaultInvoice.getString("buyerTaxNo");
            if (!taxNoInput.equals(buyerTaxNo)) {
                throw new MsgException("0003", ResManager.loadKDString((String)"\u8d2d\u65b9\u7a0e\u53f7\u548c\u6240\u9009\u7ec4\u7ec7\u7a0e\u53f7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"DeductInvoiceImportPlugin_10", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            invoiceStart = 3;
            fieldNameRowNo = 2;
        } else {
            throw new MsgException("0001", ResManager.loadKDString((String)"\u8bf7\u4ece\u62b5\u6263\u52fe\u9009/\u4e0d\u62b5\u6263\u3001\u7edf\u8ba1\u786e\u8ba4\uff0c\u8fdb\u884c\u5bfc\u5165\u53d1\u7968\u6587\u4ef6", (String)"DeductInvoiceImportPlugin_4", (String)"imc-rim-common", (Object[])new Object[0]));
        }
        Row fieldRow = sheet.getRow(fieldNameRowNo);
        JSONObject[] invoiceArray = ExcelInvoiceImportUtil.getInvoiceObjectArray((Sheet)sheet, (String)type, (int)invoiceStart, (int)invoiceLast, (Row)fieldRow, (JSONObject)defaultInvoice, (boolean)checkNotDeductibleType, (String)taxNoInput);
        logger.info("\u62b5\u6263/\u4e0d\u62b5\u6263\u3001\u7edf\u8ba1\u786e\u8ba4\uff0c \u89e3\u6790excel\u5b8c\u6210");
        logger.info("\u62b5\u6263/\u4e0d\u62b5\u6263\u3001\u7edf\u8ba1\u786e\u8ba4, \u89e3\u6790excel\u8017\u65f6: {}", (Object)(System.currentTimeMillis() - startTime));
        return invoiceArray;
    }

    private static void getBuyerInfo(Sheet sheet, String type, JSONObject mainInvoice) {
        Row headRow = sheet.getRow(1);
        for (int i = 0; i < headRow.getLastCellNum(); ++i) {
            String key;
            Cell keyCell = headRow.getCell(i);
            if (keyCell == null || StringUtils.isBlank((CharSequence)(key = keyCell.getStringCellValue()))) continue;
            Cell valueCell = headRow.getCell(i + 1);
            String value = valueCell.getStringCellValue();
            if (StringUtils.isBlank((CharSequence)key)) {
                throw new MsgException("0001", ResManager.loadKDString((String)"\u7edf\u8ba1\u786e\u8ba4\u53d1\u7968\u6570\u636e\u5bfc\u5165--\u7eb3\u7a0e\u4eba\u4fe1\u606f\u6ca1\u6709\u5bf9\u5e94", (String)"ExcelInvoiceUploadHelper_23", (String)"imc-rim-common", (Object[])new Object[0]));
            }
            String fieldName = ExcelInvoiceImportUtil.invoiceCell2Name((String)key, (String)type);
            mainInvoice.put(fieldName, (Object)value);
            ++i;
        }
    }

    protected void resetFile() {
        String filePath = (String)this.getView().getModel().getValue(UPLOAD_FILEPATH);
        FileUploadUtils.delete((String)filePath);
        this.getView().getModel().setValue(UPLOAD_FILENAME, (Object)"");
        this.getView().getModel().setValue(UPLOAD_FILEPATH, (Object)"");
        this.getView().setVisible(Boolean.FALSE, new String[]{UPLOAD_FILEPANEL});
        this.getView().setVisible(Boolean.TRUE, new String[]{UPLOAD_PANEL});
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String url = (String)urls[0];
            this.getView().setVisible(Boolean.TRUE, new String[]{UPLOAD_FILEPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{UPLOAD_PANEL});
            this.getModel().setValue(UPLOAD_FILENAME, (Object)url.substring(url.lastIndexOf(47) + 1));
            this.getModel().setValue(UPLOAD_FILEPATH, (Object)url);
        }
    }
}

