/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction.operate;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.utils.ListUtils;

public class AutoDeductTaskOPPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("businessbill");
        e.getFieldKeys().add("taxno");
        e.getFieldKeys().add("userorg");
        e.getFieldKeys().add("userorg.taxpayer_tax_no");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] extDataEntityArr = this.getDataEntities();
                HashMap enableCheckRepeatMap = Maps.newHashMapWithExpectedSize((int)extDataEntityArr.length);
                for (ExtendedDataEntity extDataEntity : extDataEntityArr) {
                    List repeatList;
                    DynamicObject dataEntity = extDataEntity.getDataEntity();
                    DynamicObjectCollection userorgs = dataEntity.getDynamicObjectCollection("userorg");
                    List taxNos = userorgs.stream().map(s -> s.getString("taxpayer_tax_no")).collect(Collectors.toList());
                    if ("save".equals(this.getOperateKey()) && !CollectionUtils.isEmpty((Collection)(repeatList = ListUtils.checkRepeat(taxNos)))) {
                        for (String taxno : repeatList) {
                            this.addMessage(extDataEntity, String.format(ResManager.loadKDString((String)"\u201c\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u201d \u503c \u201c%s\u201d \u91cd\u590d\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"AutoDeductTaskOPPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxno));
                        }
                        continue;
                    }
                    boolean enable = dataEntity.getBoolean("enable");
                    if (!enable && !"enable".contentEquals(this.getOperateKey())) continue;
                    DynamicObjectCollection businessbill = dataEntity.getDynamicObjectCollection("businessbill");
                    Set businessbillId = businessbill.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                    int idSize = businessbillId.size();
                    QFilter taxnoQFilter = new QFilter("userorg.taxpayer_tax_no", "in", taxNos);
                    if ("enable".contentEquals(this.getOperateKey())) {
                        for (String taxNo : taxNos) {
                            Set enableCheckRepeatSet = (Set)enableCheckRepeatMap.get(taxNo);
                            if (enableCheckRepeatSet == null) {
                                enableCheckRepeatSet = Sets.newHashSet();
                                enableCheckRepeatSet.addAll(businessbillId);
                                enableCheckRepeatMap.put(taxNo, enableCheckRepeatSet);
                                continue;
                            }
                            int checkRepeatSize = enableCheckRepeatSet.size();
                            enableCheckRepeatSet.addAll(businessbillId);
                            if (enableCheckRepeatSet.size() == checkRepeatSize + idSize && checkRepeatSize != 0 && idSize != 0) continue;
                            this.addErrorMessage(extDataEntity, String.format(ResManager.loadKDString((String)"\u540c\u4e00\u5355\u636e\u540c\u4e00\u7a0e\u53f7%s\u4e0d\u80fd\u51fa\u73b0\u4e24\u4e2a\u542f\u7528\u7684\u65b9\u6848", (String)"AutoDeductTaskOPPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxNo));
                        }
                    }
                    QFilter enableQFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                    Object currentId = dataEntity.getPkValue();
                    QFilter[] qfArr = new QFilter[]{enableQFilter, taxnoQFilter};
                    if (currentId != null) {
                        QFilter idQFilter = new QFilter("id", "!=", currentId);
                        qfArr = new QFilter[]{enableQFilter, taxnoQFilter, idQFilter};
                    }
                    Map reaptMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)dataEntity.getDynamicObjectType(), (QFilter[])qfArr);
                    boolean isRepeat = false;
                    for (Map.Entry entry : reaptMap.entrySet()) {
                        DynamicObject temp = (DynamicObject)entry.getValue();
                        DynamicObjectCollection tempBusinessbill = temp.getDynamicObjectCollection("businessbill");
                        Set tempBusinessbillId = tempBusinessbill.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                        int tempSize = tempBusinessbillId.size();
                        tempBusinessbillId.addAll(businessbillId);
                        if (tempBusinessbillId.size() == tempSize + idSize && tempSize != 0 && idSize != 0) continue;
                        isRepeat = true;
                        break;
                    }
                    if (!isRepeat) continue;
                    this.addErrorMessage(extDataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u5355\u636e\u540c\u4e00\u7a0e\u53f7\u4e0d\u80fd\u51fa\u73b0\u4e24\u4e2a\u542f\u7528\u7684\u65b9\u6848", (String)"AutoDeductTaskOPPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }
}

