/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction.operate;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.utils.ListUtils;

public class DownInitSaveOperationPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("userorg");
        e.getFieldKeys().add("userorg.taxpayer_tax_no");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] extDataEntityArr;
                for (ExtendedDataEntity extDataEntity : extDataEntityArr = this.getDataEntities()) {
                    DynamicObject dataEntity = extDataEntity.getDataEntity();
                    DynamicObjectCollection userorgs = dataEntity.getDynamicObjectCollection("userorg");
                    List taxNos = userorgs.stream().map(s -> s.getString("taxpayer_tax_no")).collect(Collectors.toList());
                    List repeatList = ListUtils.checkRepeat(taxNos);
                    if (!CollectionUtils.isEmpty((Collection)repeatList)) {
                        for (String taxno : repeatList) {
                            this.addMessage(extDataEntity, String.format(ResManager.loadKDString((String)"\u201c\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u201d \u503c \u201c%s\u201d \u91cd\u590d\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"DownInitSaveOperationPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxno));
                        }
                        continue;
                    }
                    QFilter qFilter = new QFilter("userorg.taxpayer_tax_no", "in", taxNos);
                    Object currentId = dataEntity.getPkValue();
                    if (currentId != null) {
                        qFilter.and("id", "!=", currentId);
                    }
                    Map reaptMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)dataEntity.getDynamicObjectType(), (QFilter[])qFilter.toArray());
                    for (Map.Entry entry : reaptMap.entrySet()) {
                        DynamicObject temp = (DynamicObject)entry.getValue();
                        DynamicObjectCollection queryUserorgs = temp.getDynamicObjectCollection("userorg");
                        for (DynamicObject orgObj : queryUserorgs) {
                            String taxNo = orgObj.getString("taxpayer_tax_no");
                            if (!taxNos.contains(taxNo)) continue;
                            repeatList.add(taxNo);
                        }
                    }
                    if (CollectionUtils.isEmpty((Collection)repeatList)) continue;
                    for (String taxno : repeatList) {
                        this.addMessage(extDataEntity, String.format(ResManager.loadKDString((String)"\u201c\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u201d \u503c \u201c%s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"DownInitSaveOperationPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxno));
                    }
                }
            }
        });
    }
}

