/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.downloadcenter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.downloadcenter.DownLoadService;
import kd.imc.rim.formplugin.downloadcenter.InvoiceFileDownloadService;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AttachFileDownloadService
extends DownLoadService {
    public static String ATTACH_URL = "attachUrl";
    public static String ATTACH_NAME = "attachName";
    private static Log LOGGER = LogFactory.getLog(AttachFileDownloadService.class);

    public void downloadAttachFile(Map<String, String> map, AbstractFormPlugin plugin) {
        if (MapUtils.isEmpty(map)) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u53c2\u6570\u4e3a\u7a7a", (String)"FpzsViewAttachPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String attachUrl = map.get(ATTACH_URL);
        String attachName = map.get(ATTACH_NAME);
        if (StringUtils.isBlank((CharSequence)attachUrl)) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u5730\u5740\u4e3a\u7a7a", (String)"FpzsViewAttachPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        attachUrl = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(attachUrl);
        Pair fileContent = FileUtils.getFileContent((String)attachUrl);
        if (fileContent != null && fileContent.getRight() != null) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)attachName)) {
                attachName = UUID.randomUUID();
            }
            boolean isSuccess = false;
            InvoiceFileDownloadService downloadService = new InvoiceFileDownloadService();
            String downloadUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(AttachFileDownloadService.getFileName(attachName, (String)fileContent.getLeft()), (InputStream)new ByteArrayInputStream((byte[])fileContent.getRight()), 30000);
            if (StringUtils.isNotEmpty((CharSequence)downloadUrl)) {
                isSuccess = true;
                plugin.getView().openUrl(downloadUrl);
            }
            if (!isSuccess) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6587\u4ef6\uff0c\u6216\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (String)"InvoiceCollectEditPlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        } else {
            LOGGER.info("downloadFiles-" + attachUrl + "\u4e0b\u8f7d\u5185\u5bb9\u4e3a\u7a7a");
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5185\u5bb9\u4e3a\u7a7a", (String)"FpzsViewAttachPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public static String getFileName(String defaultFile, String fileType) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fileType) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)defaultFile)) {
            return defaultFile;
        }
        int index = defaultFile.lastIndexOf(46);
        if (index < 0) {
            return defaultFile + "." + fileType;
        }
        return defaultFile.substring(0, index + 1) + fileType;
    }
}

