/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.downloadcenter;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;

public class BatchDownloadFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"download_btn", "cancel_btn"});
        EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
        entryEntity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object type = customParams.get("type");
        Object src = evt.getSource();
        if (!(src instanceof Button)) {
            return;
        }
        Button btn = (Button)src;
        String key = btn.getKey();
        if ("download_btn".equals(key)) {
            EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryEntity.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u4efb\u52a1\u8fdb\u884c\u4e0b\u8f7d\uff01", (String)"BatchDownloadFormPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            IDataModel model = entryEntity.getModel();
            for (int selectRow : selectRows) {
                DynamicObject entry = model.getEntryRowEntity("entryentity", selectRow);
                String service_url = entry.getString("service_url");
                if ("excel".equals(type)) {
                    this.getView().openUrl(service_url);
                    continue;
                }
                this.getView().openUrl(UrlServiceUtils.getAttachmentFullUrl((String)service_url));
            }
        } else if ("cancel_btn".equals(key)) {
            this.getView().close();
        }
    }

    public void beforeBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.size() >= 1) {
            entryEntity.remove(0);
        }
        JSONObject fileDetail = (JSONObject)customParams.get("fileDetail");
        for (String fileName : fileDetail.keySet()) {
            DynamicObject dynamicObject = entryEntity.addNew();
            dynamicObject.set("filename", (Object)fileName);
            dynamicObject.set("service_url", fileDetail.get((Object)fileName));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent paramHyperLinkClickEvent) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object type = customParams.get("type");
        String fieldName = paramHyperLinkClickEvent.getFieldName();
        if (fieldName.equals("filename")) {
            int row = paramHyperLinkClickEvent.getRowIndex();
            EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
            IDataModel model = entryEntity.getModel();
            DynamicObject entry = model.getEntryRowEntity("entryentity", row);
            String service_url = entry.getString("service_url");
            if ("excel".equals(type)) {
                this.getView().openUrl(service_url);
            } else {
                this.getView().openUrl(UrlServiceUtils.getAttachmentFullUrl((String)service_url));
            }
        }
    }
}

