/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.downloadcenter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.formplugin.downloadcenter.InvoiceExportService;
import kd.imc.rim.formplugin.downloadcenter.InvoiceFileDownloadService;
import org.apache.commons.lang3.StringUtils;

public class DownLoadService {
    private static Log logger = LogFactory.getLog(DownLoadService.class);

    public void dealSync() {
        ThreadPools.executeOnce((String)"DownLoadService_deal", () -> new InvoiceFileDownloadService().deal());
        ThreadPools.executeOnce((String)"DownLoadService_export", () -> new InvoiceExportService().deal());
    }

    public void clearSync() {
        ThreadPools.executeOnce((String)"DownLoadService_clear", () -> this.clear());
    }

    public void deal() {
    }

    public void clear() {
        try (DLock lock = DLock.create((String)"downFile_clear");){
            if (lock.tryLock()) {
                this.deleteRimFile();
                this.deleteBdmFile();
            }
        }
    }

    private void deleteBdmFile() {
        try {
            Date lastDate = DateUtils.addDay((Date)new Date(), (int)-7);
            QFilter filter1 = new QFilter("applytime", "<", (Object)lastDate);
            QFilter filter2 = new QFilter("handlestate", "=", (Object)"2");
            QFilter filter3 = new QFilter("delstate", "=", (Object)"1");
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_download_center", (String)"id", (QFilter[])new QFilter[]{filter1, filter2, filter3});
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(8);
            for (DynamicObject object : collect) {
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)object.get("id"), (String)"bdm_download_center");
                DynamicObjectCollection fileDetail = obj.getDynamicObjectCollection("file_detail");
                String fileurl = obj.getString("fileurl");
                boolean flag = true;
                if (!StringUtils.isEmpty((CharSequence)fileurl)) {
                    try {
                        fileService.delete(fileurl);
                    }
                    catch (Exception e) {
                        flag = false;
                        continue;
                    }
                }
                for (DynamicObject file : fileDetail) {
                    try {
                        fileService.delete(file.getString("detail_url"));
                    }
                    catch (Exception e) {
                        flag = false;
                    }
                }
                if (!flag) continue;
                obj.set("delstate", (Object)"2");
                updateList.add(obj);
            }
            if (!updateList.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u4e0b\u8f7d\u6587\u4ef6\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
        }
    }

    private void deleteRimFile() {
        try {
            Date lastDate = DateUtils.addDay((Date)new Date(), (int)-7);
            QFilter filter1 = new QFilter("applytime", "<", (Object)lastDate);
            QFilter filter2 = new QFilter("state", "=", (Object)"2");
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_download_center", (String)"id", (QFilter[])new QFilter[]{filter1, filter2});
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(8);
            for (DynamicObject object : collect) {
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)object.get("id"), (String)"rim_download_center");
                DynamicObjectCollection fileDetail = obj.getDynamicObjectCollection("upload_detail");
                DynamicObjectCollection detail = obj.getDynamicObjectCollection("detail");
                detail.clear();
                boolean flag = true;
                for (DynamicObject file : fileDetail) {
                    try {
                        fileService.delete(file.getString("service_url"));
                    }
                    catch (Exception e) {
                        flag = false;
                    }
                }
                if (!flag) continue;
                obj.set("state", (Object)"4");
                updateList.add(obj);
            }
            if (!updateList.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u4e0b\u8f7d\u6587\u4ef6\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
        }
    }

    public String upload(String fileName, byte[] zipByte) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        String storePath = FileUploadUtils.getInvoiceDir((String)"temp") + fileName;
        FileItem fileItem = new FileItem(fileName, storePath, (InputStream)new ByteArrayInputStream(zipByte));
        if (fileService.exists(storePath)) {
            fileService.delete(storePath);
        }
        return fileService.upload(fileItem);
    }

    public void doZip(byte[] buffer, ZipOutputStream out, String dir, String entryName) throws IOException {
        if (!"".equals(dir)) {
            entryName = dir + "/" + entryName;
        }
        logger.info("\u6587\u4ef6\u7c7b\u578b-\u538b\u7f29\u5305{}", (Object)entryName);
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        out.write(buffer);
        out.closeEntry();
    }
}

