/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.downloadcenter;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.downloadcenter.DownLoadService;
import kd.imc.rim.formplugin.downloadcenter.DownloadCenterHelper;
import kd.imc.rim.formplugin.query.operate.DownloadInvoiceAttachOperateService;
import kd.imc.rim.formplugin.query.operate.DownloadOperateService;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceFileDownloadService
extends DownLoadService {
    private static Log LOGGER = LogFactory.getLog(InvoiceFileDownloadService.class);
    private static final String lockId = UUID.randomUUIDZero();
    private static final int zipSize = 0x3200000;
    private static final String success = "10";

    /*
     * Exception decompiling
     */
    @Override
    public void deal() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean downloadByTaskId(Object pk) {
        LOGGER.info("BatchDownloadHelper-" + pk);
        try (DLock lock = DLock.create((String)("downFile" + pk));){
            if (lock.tryLock()) {
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bdm_download_center");
                String state = obj.getString("handlestate");
                if ("1".equals(state)) {
                    boolean finish = false;
                    DynamicObjectCollection serialNos = obj.getDynamicObjectCollection("invoice_detail");
                    ArrayList<Long> pkList = new ArrayList<Long>(8);
                    HashMap<Long, DynamicObject> fileMap = new HashMap<Long, DynamicObject>(8);
                    for (DynamicObject entry : serialNos) {
                        String dealresult = entry.getString("deal_result");
                        if (!"0".equals(dealresult)) continue;
                        String serial = entry.getString("serial_no");
                        Long pkId = BigDecimalUtil.transDecimal((Object)serial).longValue();
                        if (pkId > 0L) {
                            pkList.add(pkId);
                        }
                        fileMap.put(pkId, entry);
                    }
                    if (pkList.isEmpty()) {
                        obj.set("handlestate", (Object)"2");
                        finish = true;
                    } else {
                        String url;
                        DynamicObjectCollection uploaddetail = obj.getDynamicObjectCollection("file_detail");
                        int index = uploaddetail.size() + 1;
                        String fileName = obj.getString("filename");
                        String billno = fileName.replace(".zip", "") + index + ".zip";
                        LOGGER.info("BatchDownloadHelper-" + pk + billno + "\u9700\u8981\u5904\u7406" + pkList.size());
                        String downOriginalTypes = obj.getString("down_original_types");
                        if (StringUtils.isBlank((CharSequence)downOriginalTypes)) {
                            downOriginalTypes = obj.getString("original_type");
                        }
                        Map<Object, Object> result = new HashMap<String, String>(8);
                        if ("4".equals(obj.getString("file_type"))) {
                            DownloadInvoiceAttachOperateService downloadInvoiceAttachOperateService = new DownloadInvoiceAttachOperateService();
                            url = null;
                            try {
                                url = downloadInvoiceAttachOperateService.getInvoiceAndAttachList(pkList.toArray(new Long[0]), billno);
                                result.put("url", url);
                                result.put("ids", pkList);
                            }
                            catch (Exception e) {
                                LOGGER.error("\u4e0b\u8f7d\u4e2d\u5fc3\u4e0b\u8f7d\u53d1\u7968\u9644\u4ef6\u5f02\u5e38", (Throwable)e);
                            }
                        } else if ("3".equals(obj.getString("file_type"))) {
                            DownloadOperateService downloadOperateService = new DownloadOperateService();
                            url = null;
                            try {
                                String typeData = obj.getString("qfilter_tag");
                                String[] types = typeData.split(",");
                                types = (String[])Arrays.stream(types).filter(s -> !s.isEmpty()).toArray(String[]::new);
                                url = downloadOperateService.getAllTypeInvoice(pkList.toArray(new Long[0]), billno, types);
                                result.put("url", url);
                                result.put("ids", pkList);
                            }
                            catch (Exception e) {
                                LOGGER.error("\u4e0b\u8f7d\u4e2d\u5fc3\u4e0b\u8f7d\u53d1\u7968\u5f02\u5e38", (Throwable)e);
                            }
                        } else {
                            result = this.download(pkList.toArray(new Long[0]), billno, downOriginalTypes);
                        }
                        String url2 = (String)result.get("url");
                        List dealList = (List)result.get("ids");
                        if (StringUtils.isNotEmpty((CharSequence)url2)) {
                            LOGGER.info("BatchDownloadHelper-" + pk + billno + "\u5904\u7406\u6210\u529f" + dealList.size());
                            for (Long id : dealList) {
                                DynamicObject entry = (DynamicObject)fileMap.get(id);
                                entry.set("deal_result", (Object)success);
                            }
                            DynamicObject upDetail = uploaddetail.addNew();
                            upDetail.set("detail_url", (Object)url2);
                            upDetail.set("detail_file_name", (Object)billno);
                            if (dealList.size() == pkList.size()) {
                                obj.set("handlestate", (Object)"2");
                                finish = true;
                            }
                        } else if ("4".equals(obj.getString("file_type")) || "3".equals(obj.getString("file_type"))) {
                            obj.set("handlestate", (Object)"3");
                            finish = true;
                        } else {
                            obj.set("handlestate", (Object)"2");
                            finish = true;
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                    LOGGER.info("BatchDownloadHelper-" + pk + "\u5df2\u7ecf\u5904\u74061");
                    boolean bl = finish;
                    return bl;
                }
                LOGGER.info("BatchDownloadHelper-" + pk + "\u5df2\u7ecf\u5904\u74062");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Map<String, Object> download(Long[] pkList, String zipName, String originalType) {
        void var11_18;
        ArrayList<Long> list = new ArrayList<Long>(4);
        List<Map<String, String>> fileList = InvoiceFileDownloadService.getInvoiceList(pkList, originalType);
        ArrayList existsId = new ArrayList(4);
        fileList.stream().forEach(map -> existsId.add(Long.valueOf((String)map.get("id"))));
        for (Long id : pkList) {
            if (existsId.contains(id)) continue;
            list.add(id);
        }
        int total = 0;
        ByteArrayOutputStream out = null;
        DeflaterOutputStream zipOut = null;
        try {
            for (Map map2 : fileList) {
                if (zipOut == null) {
                    out = new ByteArrayOutputStream();
                    zipOut = new ZipOutputStream(out);
                }
                String url = (String)map2.get("url");
                Pair fileContent = FileUtils.getFileContent((String)((String)map2.get("url")));
                if (fileContent != null) {
                    total += ((byte[])fileContent.getRight()).length;
                    try {
                        this.doZip((byte[])fileContent.getRight(), (ZipOutputStream)zipOut, "", InvoiceFileDownloadService.getFileName((String)map2.get("fileName"), (String)fileContent.getLeft()));
                        list.add(Long.valueOf((String)map2.get("id")));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (total <= 0x3200000) continue;
                    break;
                }
                LOGGER.info("BatchDownloadHelper-" + url + "\u4e0b\u8f7d\u5185\u5bb9\u4e3a\u7a7a");
                list.add(Long.valueOf((String)map2.get("id")));
            }
        }
        finally {
            if (zipOut != null) {
                try {
                    zipOut.flush();
                    ((ZipOutputStream)zipOut).close();
                }
                catch (IOException id) {}
            }
        }
        HashMap<String, Object> downResult = new HashMap<String, Object>(8);
        Object var11_16 = null;
        if (zipOut != null && out != null) {
            String string = this.upload(zipName + ".zip", out.toByteArray());
        }
        downResult.put("size", total / 1024);
        downResult.put("url", var11_18);
        downResult.put("ids", list);
        return downResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String downloadTemp(List<Map<String, String>> fileList, String zipName) {
        ByteArrayOutputStream out = null;
        DeflaterOutputStream zipOut = null;
        for (Map<String, String> map : fileList) {
            Pair fileContent;
            if (zipOut == null) {
                out = new ByteArrayOutputStream();
                zipOut = new ZipOutputStream(out);
            }
            if ((fileContent = FileUtils.getFileContent((String)map.get("url"))) == null || fileContent.getRight() == null) continue;
            try {
                this.doZip((byte[])fileContent.getRight(), (ZipOutputStream)zipOut, "", InvoiceFileDownloadService.getFileName(map.get("fileName"), (String)fileContent.getLeft()));
            }
            catch (IOException iOException) {}
        }
        if (zipOut == null) return null;
        try {
            zipOut.flush();
            ((ZipOutputStream)zipOut).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (out == null) return null;
        try (ByteArrayInputStream bytein = new ByteArrayInputStream(out.toByteArray());){
            String urls;
            String string = urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipName + ".zip", (InputStream)bytein, CommonUtils.getTempFileMaxTimeout());
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static void downloadFile(AbstractFormPlugin plugin, String type, Object[] pkList, String taxOriginalTypes, String selectType) {
        List<Map<String, String>> map = null;
        map = InvoiceFileDownloadService.getInvoiceList(pkList, taxOriginalTypes);
        if (map == null || map.isEmpty()) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u6587\u4ef6", (String)"InvoiceFileDownloadService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        Object invoiceType = plugin.getView().getFormShowParameter().getCustomParam("invoicetype");
        if (pkList.length > 10) {
            if ("download_invoice".equals(type)) {
                DownloadCenterHelper.dispatch(map, invoiceType.toString(), taxOriginalTypes, "3", selectType);
                DownloadCenterHelper.skipDownloadCenterNotify(plugin, type);
            } else if ("download_inv_attach".equals(type)) {
                DownloadCenterHelper.dispatch(map, invoiceType.toString(), taxOriginalTypes, "4", "");
                DownloadCenterHelper.skipDownloadCenterNotify(plugin, type);
            } else {
                DownloadCenterHelper.dispatch(map, invoiceType.toString(), taxOriginalTypes);
                DownloadCenterHelper.skipDownloadCenterNotify(plugin, type);
            }
        } else {
            String name = InputInvoiceTypeEnum.getInvoiceType((Long)Long.parseLong(String.valueOf(invoiceType))).getName();
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            String download = new InvoiceFileDownloadService().downloadTemp(map, name + format.format(new Date()));
            PermissionUtils.addTempFilePermission((String)download, (String)"rim_invoice", (String)"23+Y3P5F6LEE", (int)CommonUtils.getTempFileMaxTimeout());
            plugin.getView().openUrl(download);
        }
    }

    public static List<Map<String, String>> getInvoiceList(Object[] pkList) {
        return InvoiceFileDownloadService.getInvoiceList(pkList, null);
    }

    public static List<Map<String, String>> getInvoiceList(Object[] pkList, String taxOriginalTypes) {
        QFilter filter = new QFilter("id", "in", (Object)pkList);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_code,invoice_no", (QFilter[])new QFilter[]{filter});
        ArrayList<String> serialNoList = new ArrayList<String>(collect.size());
        HashMap invoiceMap = new HashMap(pkList.length);
        ArrayList<String> repetKey = new ArrayList<String>();
        for (DynamicObject invoice : collect) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", invoice.get("id").toString());
            map.put("serialNo", invoice.getString("serial_no"));
            String serialNo = invoice.getString("serial_no");
            String invoice_code = invoice.getString("invoice_code");
            String invocie_no = invoice.getString("invoice_no");
            String key = invoice_code + "_" + invocie_no;
            if (StringUtils.isEmpty((CharSequence)invoice_code) && StringUtils.isEmpty((CharSequence)invocie_no)) {
                key = serialNo;
            }
            int i = 0;
            if (repetKey.contains(key)) {
                for (String str : repetKey) {
                    if (!key.equals(str)) continue;
                    ++i;
                }
            }
            repetKey.add(key);
            if (i > 0) {
                key = key + "(" + i + ")";
            }
            map.put("fileName", key);
            invoiceMap.put(serialNo, map);
            serialNoList.add(invoice.getString("serial_no"));
        }
        QFilter serialFilter = new QFilter("serial_no", "in", serialNoList);
        DynamicObjectCollection fileCollect = QueryServiceHelper.query((String)"rim_invoice_file", (String)"pdf_url,ofd_url,image_url,snapshot_url,xml_url,serial_no,tax_pdf_url,tax_ofd_url,tax_xml_url", (QFilter[])new QFilter[]{serialFilter});
        ArrayList<Map<String, String>> fileList = new ArrayList<Map<String, String>>(pkList.length);
        ArrayList<String> urlSet = new ArrayList<String>(8);
        for (DynamicObject invoice : fileCollect) {
            String serialNo = invoice.getString("serial_no");
            Map map = (Map)invoiceMap.get(serialNo);
            if (StringUtils.isBlank((CharSequence)taxOriginalTypes)) {
                InvoiceFileDownloadService.getFileUrl(fileList, urlSet, invoice, map, taxOriginalTypes);
                continue;
            }
            List list = CommonUtils.getMultiValues((String)taxOriginalTypes);
            for (String type : list) {
                HashMap<String, String> map2 = new HashMap<String, String>(map);
                InvoiceFileDownloadService.getFileUrl(fileList, urlSet, invoice, map2, type);
            }
        }
        return fileList;
    }

    private static void getFileUrl(List<Map<String, String>> fileList, List<String> urlList, DynamicObject invoice, Map<String, String> map, String type) {
        if (fileList == null || urlList == null || invoice == null) {
            return;
        }
        Pair<String, String> urlFile = InvoiceFileDownloadService.getDownUrl(invoice, type);
        if (urlFile != null) {
            String url = (String)urlFile.getLeft();
            map.put("fileName", map.get("fileName") + '.' + (String)urlFile.getRight());
            map.put("url", url);
            fileList.add(map);
        }
    }

    private static Pair<String, String> getDownUrl(DynamicObject fileObject, String taxOriginalType) {
        String ofdUrl = fileObject.getString("ofd_url");
        String pdf_url = fileObject.getString("pdf_url");
        String image_url = fileObject.getString("image_url");
        String snapshot_url = fileObject.getString("snapshot_url");
        String xml_url = fileObject.getString("xml_url");
        String taxXmlUrl = fileObject.getString("tax_xml_url");
        String taxOfdUrl = fileObject.getString("tax_ofd_url");
        String taxPdfUrl = fileObject.getString("tax_pdf_url");
        if (StringUtils.isEmpty((CharSequence)taxOriginalType)) {
            if (StringUtils.isNotEmpty((CharSequence)ofdUrl)) {
                return Pair.of((Object)ofdUrl, (Object)"ofd");
            }
            if (StringUtils.isNotEmpty((CharSequence)pdf_url)) {
                return Pair.of((Object)pdf_url, (Object)"pdf");
            }
            if (StringUtils.isNotEmpty((CharSequence)image_url)) {
                return Pair.of((Object)image_url, (Object)"jpg");
            }
            if (StringUtils.isNotEmpty((CharSequence)snapshot_url)) {
                return Pair.of((Object)snapshot_url, (Object)"jpg");
            }
            if (StringUtils.isNotEmpty((CharSequence)xml_url)) {
                return Pair.of((Object)xml_url, (Object)"xml");
            }
            return null;
        }
        if ("4".equals(taxOriginalType)) {
            return Optional.ofNullable(taxOfdUrl).filter(StringUtils::isNotEmpty).map(s -> Pair.of((Object)s, (Object)"ofd")).orElse(null);
        }
        if ("1".equals(taxOriginalType)) {
            return Optional.ofNullable(taxPdfUrl).filter(StringUtils::isNotEmpty).map(s -> Pair.of((Object)s, (Object)"pdf")).orElse(null);
        }
        if ("2".equals(taxOriginalType)) {
            if (StringUtils.isNotEmpty((CharSequence)image_url)) {
                return Pair.of((Object)image_url, (Object)"jpg");
            }
            if (StringUtils.isNotEmpty((CharSequence)snapshot_url)) {
                return Pair.of((Object)snapshot_url, (Object)"jpg");
            }
            return null;
        }
        if ("9".equals(taxOriginalType)) {
            return Optional.ofNullable(taxXmlUrl).filter(StringUtils::isNotEmpty).map(s -> Pair.of((Object)s, (Object)"xml")).orElse(null);
        }
        return null;
    }

    private static String getFileName(String defaultFile, String fileType) {
        if (StringUtils.isEmpty((CharSequence)fileType) || StringUtils.isEmpty((CharSequence)defaultFile)) {
            return defaultFile;
        }
        int index = defaultFile.lastIndexOf(46);
        if (index < 0) {
            return defaultFile;
        }
        return defaultFile.substring(0, index + 1) + fileType;
    }

    public String downloadInvoiceFile(String serialNo) {
        if (StringUtils.isEmpty((CharSequence)serialNo)) {
            return null;
        }
        QFilter filter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObject fileObj = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"pdf_url,ofd_url,image_url,xml_url,tax_pdf_url,tax_ofd_url,tax_xml_url", (QFilter[])new QFilter[]{filter});
        if (fileObj != null) {
            DynamicObject object;
            HashMap urlInfos = Maps.newHashMap();
            Map fileMap = DynamicObjectUtil.dynamicObject2Map((DynamicObject)fileObj);
            for (Map.Entry entry : fileMap.entrySet()) {
                if (entry.getValue() == null) continue;
                urlInfos.put(entry.getValue() + "", "");
            }
            String fileName = this.getDownloadInvoiceFiLeNameByConfig(serialNo);
            if (StringUtils.isEmpty((CharSequence)fileName) && (object = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"invoice_code, invoice_no", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)serialNo)})) != null) {
                String invoiceCode = object.getString("invoice_code");
                String invoiceNo = object.getString("invoice_no");
                fileName = StringUtils.isEmpty((CharSequence)invoiceCode) ? invoiceNo : invoiceCode + "_" + invoiceNo;
            }
            return this.downloadFilesToZip(urlInfos, fileName);
        }
        return null;
    }

    public InputStream downloadInvoiceOneFilesUrl(String serialNo) {
        if (StringUtils.isEmpty((CharSequence)serialNo)) {
            return null;
        }
        QFilter filter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObject fileObj = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"pdf_url,ofd_url,image_url,xml_url,tax_pdf_url,tax_ofd_url,tax_xml_url,original_type", (QFilter[])new QFilter[]{filter});
        if (fileObj == null) {
            return null;
        }
        Map map = DynamicObjectUtil.dynamicObject2Map((DynamicObject)fileObj);
        if (map == null || map.size() == 0) {
            return null;
        }
        try {
            String originType = (String)CommonUtils.getJsonValue((Map)map, String.class, (String[])new String[]{"original_type"});
            String originUrl = "";
            if (StringUtils.isNotEmpty((CharSequence)originType)) {
                if ("4".equals(originType)) {
                    originUrl = (String)CommonUtils.getJsonValue((Map)map, String.class, (String[])new String[]{"ofd_url"});
                }
                if ("1".equals(originType)) {
                    originUrl = (String)CommonUtils.getJsonValue((Map)map, String.class, (String[])new String[]{"pdf_url"});
                }
                if ("2".equals(originType)) {
                    originUrl = (String)CommonUtils.getJsonValue((Map)map, String.class, (String[])new String[]{"image_url"});
                }
                if ("9".equals(originType)) {
                    originUrl = (String)CommonUtils.getJsonValue((Map)map, String.class, (String[])new String[]{"xml_url"});
                }
            }
            if (StringUtils.isEmpty((CharSequence)originUrl)) {
                originUrl = (String)CommonUtils.getJsonValue((Map)map, String.class, (String[])new String[]{"tax_pdf_url"});
            }
            if (!StringUtils.isEmpty((CharSequence)originUrl)) {
                Pair fileContent = FileUtils.getFileContent((String)originUrl);
                byte[] bytes = (byte[])fileContent.getRight();
                return new ByteArrayInputStream(bytes);
            }
        }
        catch (Exception e) {
            LOGGER.info("\u53d1\u7968\u5bfc\u51fa\u5931\u8d25\uff1a{}", (Object)serialNo);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Boolean, InputStream> downloadFilesZip(Map<String, String> downloadInfos) {
        if (downloadInfos == null || downloadInfos.isEmpty()) {
            return null;
        }
        int total = 0;
        boolean isFullMax = false;
        ByteArrayOutputStream out = null;
        DeflaterOutputStream zipOut = null;
        try {
            Iterator<Map.Entry<String, String>> iterator = downloadInfos.entrySet().iterator();
            while (true) {
                Pair fileContent;
                if (!iterator.hasNext()) break;
                Map.Entry<String, String> downloadInfo = iterator.next();
                if (StringUtils.isEmpty((CharSequence)downloadInfo.getKey())) continue;
                if (zipOut == null) {
                    out = new ByteArrayOutputStream();
                    zipOut = new ZipOutputStream(out);
                }
                if ((fileContent = FileUtils.getFileContent((String)downloadInfo.getKey())) != null) {
                    total += ((byte[])fileContent.getRight()).length;
                    try {
                        String fileName = downloadInfo.getValue();
                        if (StringUtils.isEmpty((CharSequence)fileName)) {
                            fileName = UUID.randomUUID();
                        }
                        this.doZip((byte[])fileContent.getRight(), (ZipOutputStream)zipOut, "", fileName + "." + (String)fileContent.getLeft());
                    }
                    catch (IOException e) {
                        LOGGER.info("downloadFilesToZip-IOException:{},{}", downloadInfo, (Object)e);
                    }
                    if (total <= 0x3200000) continue;
                    isFullMax = true;
                    break;
                }
                LOGGER.info("downloadFilesToZip-" + downloadInfo + "\u4e0b\u8f7d\u5185\u5bb9\u4e3a\u7a7a");
                Pair<Boolean, InputStream> pair = null;
                return pair;
            }
        }
        finally {
            if (zipOut != null) {
                try {
                    zipOut.flush();
                    ((ZipOutputStream)zipOut).close();
                }
                catch (IOException iOException) {}
            }
        }
        if (out != null) {
            return Pair.of((Object)isFullMax, (Object)new ByteArrayInputStream(out.toByteArray()));
        }
        return null;
    }

    public String downloadFilesToZip(Map<String, String> urlInfos, String zipName) {
        Pair<Boolean, InputStream> zipStream;
        String url = null;
        if (StringUtils.isEmpty((CharSequence)zipName)) {
            zipName = UUID.randomUUID();
        }
        if ((zipStream = this.downloadFilesZip(urlInfos)) == null) {
            return null;
        }
        if (((Boolean)zipStream.getLeft()).booleanValue()) {
            return "fullMax";
        }
        try (InputStream in = (InputStream)zipStream.getRight();){
            url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipName + ".zip", in, 5000);
        }
        catch (Exception e) {
            LOGGER.info("downloadFilesToZip-download exception:{}", (Object)e);
        }
        return url;
    }

    public void addZipEntry(ZipOutputStream zos, String entryName, InputStream zipInputStream) throws IOException {
        int bytesRead;
        if (zos == null || StringUtils.isEmpty((CharSequence)entryName) || zipInputStream == null) {
            return;
        }
        ZipEntry entry = new ZipEntry(entryName);
        zos.putNextEntry(entry);
        byte[] buffer = new byte[8192];
        while ((bytesRead = zipInputStream.read(buffer)) != -1) {
            zos.write(buffer, 0, bytesRead);
        }
        zos.closeEntry();
    }

    public InputStream downloadInvoiceFileInputStream(String serialNo, String invoiceNameRule, DynamicObjectCollection attachs, DynamicObject fileObj) {
        if (StringUtils.isEmpty((CharSequence)serialNo)) {
            return null;
        }
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        if (attachs != null) {
            int i = 0;
            for (DynamicObject attach : attachs) {
                if (attach == null) continue;
                HashMap<String, String> attachmap = new HashMap<String, String>();
                attachmap.put("attach_url", attach.getString("attach_url"));
                attachmap.put("original_name", attach.getString("original_name"));
                attachmap.put("file_extension", attach.getString("file_extension"));
                attachmap.put("attach_type", attach.getString("attach_type"));
                map.put("attach" + i, attachmap);
                ++i;
            }
        }
        if (fileObj != null) {
            Map fileMap = DynamicObjectUtil.dynamicObject2Map((DynamicObject)fileObj);
            map.put("invoice", fileMap);
            return this.downloadFilesZip(serialNo, map, invoiceNameRule);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream downloadFilesZip(String serialNo, Map<String, Map<String, Object>> map, String invoiceNameRule) {
        if (map == null || map.size() == 0) {
            return null;
        }
        int total = 0;
        ByteArrayOutputStream out = null;
        DeflaterOutputStream zipOut = null;
        HashMap<String, Integer> fileNameIndexMap = new HashMap<String, Integer>(map.size());
        try {
            for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
                String key = entry.getKey();
                Map<String, Object> value = entry.getValue();
                if (key.contains("attach")) {
                    Pair fileContent;
                    String attchurl = (String)value.get("attach_url");
                    if (StringUtils.isEmpty((CharSequence)attchurl)) continue;
                    String attachname = (String)value.get("original_name");
                    if (StringUtils.isNotEmpty((CharSequence)attachname)) {
                        Integer index = (Integer)fileNameIndexMap.get(attachname);
                        if (index == null) {
                            index = 1;
                        } else {
                            Integer n = index;
                            Integer n2 = index = Integer.valueOf(index + 1);
                            attachname = this.retryName(attachname, index);
                        }
                        fileNameIndexMap.put(attachname, index);
                        attachname = FilenameUtils.removeExtension((String)attachname);
                    } else {
                        attachname = serialNo;
                    }
                    if (zipOut == null) {
                        out = new ByteArrayOutputStream();
                        zipOut = new ZipOutputStream(out);
                    }
                    if ((fileContent = FileUtils.getFileContent((String)attchurl)) != null) {
                        LOGGER.info("\u6587\u4ef6\u7c7b\u578b{},{}", fileContent.getLeft(), (Object)attchurl);
                        total += ((byte[])fileContent.getRight()).length;
                        try {
                            this.doZip((byte[])fileContent.getRight(), (ZipOutputStream)zipOut, "", attachname + "." + (String)fileContent.getLeft());
                        }
                        catch (IOException e) {
                            LOGGER.info("downloadFilesToZip-IOException:{},{}", (Object)attchurl, (Object)e);
                        }
                        if (total <= 0x3200000) continue;
                        throw new MsgException(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u53d1\u7968\u6587\u4ef6\u53ca\u9644\u4ef6\u5927\u5c0f\u8d85\u8fc750m\u3002", (String)"DownloadInvoiceAttachOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), serialNo));
                    }
                    LOGGER.info("downloadFilesToZip-" + attchurl + "\u4e0b\u8f7d\u5185\u5bb9\u4e3a\u7a7a");
                    continue;
                }
                Map<String, Object> invoice = map.get(key);
                String pdfurl = (String)CommonUtils.getJsonValue(invoice, String.class, (String[])new String[]{"pdf_url", "tax_pdf_url"});
                String orfurl = (String)CommonUtils.getJsonValue(invoice, String.class, (String[])new String[]{"ofd_url", "tax_ofd_url"});
                String imageurl = (String)CommonUtils.getJsonValue(invoice, String.class, (String[])new String[]{"image_url"});
                String xmleurl = (String)CommonUtils.getJsonValue(invoice, String.class, (String[])new String[]{"xml_url", "tax_xml_url"});
                if (zipOut == null) {
                    out = new ByteArrayOutputStream();
                    zipOut = new ZipOutputStream(out);
                }
                total += this.getInvoiceUrl(pdfurl, invoiceNameRule, "pdf", (ZipOutputStream)zipOut);
                total += this.getInvoiceUrl(orfurl, invoiceNameRule, "ofd", (ZipOutputStream)zipOut);
                total += this.getInvoiceUrl(imageurl, invoiceNameRule, "jpg", (ZipOutputStream)zipOut);
                if ((total += this.getInvoiceUrl(xmleurl, invoiceNameRule, "xml", (ZipOutputStream)zipOut)) <= 0x3200000) continue;
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u53d1\u7968\u6587\u4ef6\u53ca\u9644\u4ef6\u5927\u5c0f\u8d85\u8fc750m\u3002", (String)"DownloadInvoiceAttachOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), serialNo));
            }
        }
        finally {
            if (zipOut != null) {
                try {
                    zipOut.flush();
                    ((ZipOutputStream)zipOut).close();
                }
                catch (IOException iOException) {}
            }
        }
        if (out != null) {
            return new ByteArrayInputStream(out.toByteArray());
        }
        return null;
    }

    private int getInvoiceUrl(String pdfurl, String invoiceNameRule, String fileType, ZipOutputStream zipOut) {
        if (StringUtils.isEmpty((CharSequence)pdfurl)) {
            return 0;
        }
        Pair fileContent = FileUtils.getFileContent((String)pdfurl);
        if (fileContent != null) {
            LOGGER.info("\u6587\u4ef6\u7c7b\u578b{},{}", fileContent.getLeft(), (Object)pdfurl);
            int length = ((byte[])fileContent.getRight()).length;
            try {
                this.doZip((byte[])fileContent.getRight(), zipOut, "", invoiceNameRule + "." + (String)fileContent.getLeft());
            }
            catch (IOException e) {
                LOGGER.info("downloadFilesToZip-IOException:{},{}", (Object)pdfurl, (Object)e);
            }
            return length;
        }
        LOGGER.info("downloadFilesToZip-" + pdfurl + "\u4e0b\u8f7d\u5185\u5bb9\u4e3a\u7a7a");
        return 0;
    }

    public String getDownloadInvoiceFiLeNameByConfig(String serialNo) {
        String nowinvoicenamerule = (String)SysParamUtil.getParamValue((Long)RequestContext.get().getOrgId(), (String)"nowinvoicenamerule");
        String invoicenameseparator = (String)SysParamUtil.getParamValue((Long)RequestContext.get().getOrgId(), (String)"invoicenameseparator");
        if (StringUtils.isEmpty((CharSequence)invoicenameseparator)) {
            invoicenameseparator = "_";
        }
        if (nowinvoicenamerule == null) {
            nowinvoicenamerule = "invoice_no,invoice_code";
        }
        if ("".equals(nowinvoicenamerule)) {
            String fileName = "";
            QFilter serialFilter = new QFilter("serial_no", "=", (Object)serialNo);
            DynamicObject obtainFileName = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"original_filename", (QFilter[])new QFilter[]{serialFilter});
            if (obtainFileName != null && StringUtils.isNotEmpty((CharSequence)obtainFileName.getString("original_filename"))) {
                fileName = FilenameUtils.removeExtension((String)obtainFileName.getString("original_filename"));
            }
            return fileName;
        }
        QFilter filter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObject invoice = QueryServiceHelper.queryOne((String)"rim_invoice", (String)nowinvoicenamerule, (QFilter[])new QFilter[]{filter});
        if (invoice == null) {
            return "";
        }
        String[] items = nowinvoicenamerule.split(",");
        ArrayList<String> itemList = new ArrayList<String>(Arrays.asList(items));
        boolean isAllEmpty = true;
        for (String field : itemList) {
            if (StringUtils.isEmpty((CharSequence)invoice.getString(field))) continue;
            isAllEmpty = false;
            break;
        }
        StringBuilder fileNameSb = new StringBuilder();
        if (!isAllEmpty) {
            for (int i = 0; i < itemList.size(); ++i) {
                Object val = invoice.get((String)itemList.get(i));
                String fieldvalue = "";
                if (val instanceof Date) {
                    fieldvalue = DateUtils.format((Date)((Date)val));
                } else if (val instanceof BigDecimal) {
                    DecimalFormat decimalFormat = new DecimalFormat("#.00");
                    fieldvalue = decimalFormat.format(val);
                } else if (val != null) {
                    fieldvalue = val.toString();
                }
                if (!StringUtils.isNotEmpty((CharSequence)fieldvalue)) continue;
                if (fileNameSb.length() > 0) {
                    fileNameSb.append(invoicenameseparator);
                }
                fileNameSb.append(fieldvalue);
            }
        }
        if (fileNameSb.length() < 1) {
            fileNameSb.append(serialNo);
        }
        return fileNameSb.toString();
    }

    private String retryName(String attachname, Integer index) {
        int lastIndex = attachname.lastIndexOf(".");
        if (lastIndex > 0) {
            String extension = attachname.substring(lastIndex + 1);
            return attachname.substring(0, lastIndex) + "_" + index + "." + extension;
        }
        return "";
    }

    public InputStream downloadAllTypeInvoiceInputStream(String serialNo, String invoiceNameRule, DynamicObject fileObj, boolean noZipFlag) {
        if (StringUtils.isEmpty((CharSequence)serialNo)) {
            return null;
        }
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        if (fileObj != null) {
            Map fileMap = DynamicObjectUtil.dynamicObject2Map((DynamicObject)fileObj);
            map.put("invoice", fileMap);
            if (noZipFlag) {
                return this.downloadOneFilesUrl(serialNo, map);
            }
            return this.downloadFilesZipUrl(serialNo, map, invoiceNameRule);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream downloadFilesZipUrl(String serialNo, Map<String, Map<String, Object>> map, String invoiceNameRule) {
        if (map == null || map.size() == 0) {
            return null;
        }
        int total = 0;
        ByteArrayOutputStream out = null;
        DeflaterOutputStream zipOut = null;
        try {
            Map<String, Object> invoice = map.get("invoice");
            String pdfurl = (String)CommonUtils.getJsonValue(invoice, String.class, (String[])new String[]{"pdf_url", "tax_pdf_url"});
            String orfurl = (String)CommonUtils.getJsonValue(invoice, String.class, (String[])new String[]{"ofd_url", "tax_ofd_url"});
            String imageurl = (String)CommonUtils.getJsonValue(invoice, String.class, (String[])new String[]{"image_url"});
            String xmleurl = (String)CommonUtils.getJsonValue(invoice, String.class, (String[])new String[]{"xml_url", "tax_xml_url"});
            if (zipOut == null) {
                out = new ByteArrayOutputStream();
                zipOut = new ZipOutputStream(out);
            }
            total += this.getInvoiceUrl(pdfurl, invoiceNameRule, "pdf", (ZipOutputStream)zipOut);
            total += this.getInvoiceUrl(orfurl, invoiceNameRule, "ofd", (ZipOutputStream)zipOut);
            total += this.getInvoiceUrl(imageurl, invoiceNameRule, "jpg", (ZipOutputStream)zipOut);
            if ((total += this.getInvoiceUrl(xmleurl, invoiceNameRule, "xml", (ZipOutputStream)zipOut)) > 0x3200000) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u53d1\u7968\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc750m\u3002", (String)"DownloadInvoiceAttachOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), serialNo));
            }
        }
        finally {
            if (zipOut != null) {
                try {
                    zipOut.flush();
                    ((ZipOutputStream)zipOut).close();
                }
                catch (IOException iOException) {}
            }
        }
        if (out != null) {
            return new ByteArrayInputStream(out.toByteArray());
        }
        return null;
    }

    public InputStream downloadOneFilesUrl(String serialNo, Map<String, Map<String, Object>> map) {
        if (map == null || map.size() == 0) {
            return null;
        }
        int total = 0;
        try {
            Map<String, Object> invoice = map.get("invoice");
            String pdfurl = (String)CommonUtils.getJsonValue(invoice, String.class, (String[])new String[]{"pdf_url", "tax_pdf_url"});
            String orfurl = (String)CommonUtils.getJsonValue(invoice, String.class, (String[])new String[]{"ofd_url", "tax_ofd_url"});
            String imageurl = (String)CommonUtils.getJsonValue(invoice, String.class, (String[])new String[]{"image_url"});
            String xmleurl = (String)CommonUtils.getJsonValue(invoice, String.class, (String[])new String[]{"xml_url", "tax_xml_url"});
            Optional<String> firstNonEmpty = Arrays.asList(pdfurl, orfurl, imageurl, xmleurl).stream().filter(s -> s != null && !s.isEmpty()).findFirst();
            if (firstNonEmpty.isPresent()) {
                String trueUrl = firstNonEmpty.get();
                Pair fileContent = FileUtils.getFileContent((String)trueUrl);
                byte[] bytes = (byte[])fileContent.getRight();
                total = bytes.length;
                if (total > 0x3200000) {
                    throw new MsgException(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%1$s\u53d1\u7968\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc750m\u3002", (String)"DownloadInvoiceAttachOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), serialNo));
                }
                return new ByteArrayInputStream(bytes);
            }
        }
        catch (Exception e) {
            LOGGER.info("\u53d1\u7968\u5bfc\u51fa\u5931\u8d25\uff1a{}", (Object)serialNo);
        }
        return null;
    }
}

