/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.expense;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.license.LicenseListPlugin;
import kd.imc.rim.common.utils.DynamicObjectUtil;

public class ExpenseManageListPlugin
extends LicenseListPlugin {
    private static Log logger = LogFactory.getLog(ExpenseManageListPlugin.class);

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"scan_expense_detail"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("scan_gun".equals(key)) {
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("rim_san_gun");
            HashMap<String, String> customParam = new HashMap<String, String>(1);
            customParam.put("resource", "expense_manage");
            param.setCustomParams(customParam);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_san_gun");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        if ("delete_selected".equals(operateKey)) {
            DynamicObject[] load;
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u5355\u636e", (String)"ExpenseManageListPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            ExpenseService expenseService = new ExpenseService();
            for (ListSelectedRow selectedRow : selectedRows) {
                if (selectedRow == null) continue;
                DynamicObject[] deletedExpenseId = selectedRow.getPrimaryKeyValue();
                String expenseId = deletedExpenseId.toString();
                ExpenseDTO param = new ExpenseDTO();
                param.setExpenseId(expenseId);
                List delteSerialList = expenseService.deleteExpense(param, true);
                if (CollectionUtils.isEmpty((Collection)delteSerialList)) continue;
                expenseService.updateInvoiceMain(delteSerialList, null);
            }
            BillList billList = (BillList)this.getControl("billlistap");
            for (DynamicObject object : load = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType())) {
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get("org"));
                CodeRuleServiceHelper.recycleNumber((String)billList.getEntityId(), (DynamicObject)object, (String)String.valueOf(orgId), (String)object.getString("billno"));
            }
            QFilter deleteFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
            DeleteServiceHelper.delete((String)"rim_expense_manage", (QFilter[])deleteFilter.toArray());
            IListView view = (IListView)this.getView();
            view.clearSelection();
            view.refresh();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        String expenseNo = "";
        if (returnData != null && "rim_san_gun".equals(actionId)) {
            Map data = (Map)returnData;
            expenseNo = (String)data.get("expenseNo");
            logger.info("\u62a5\u9500\u5355\u7ba1\u7406\u5217\u8868-\u62a5\u9500\u5355\u7f16\u53f7:" + expenseNo);
            BillShowParameter param = new BillShowParameter();
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId("rim_expense_manage");
            QFilter expenseNoFilter = new QFilter("billno", "=", (Object)expenseNo);
            DynamicObject expenseObj = QueryServiceHelper.queryOne((String)"rim_expense_manage", (String)"id", (QFilter[])expenseNoFilter.toArray());
            if (expenseObj != null) {
                param.setPkId(expenseObj.get("id"));
                param.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)param);
                return;
            }
        } else if (returnData == null && "rim_san_gun".equals(actionId)) {
            return;
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5355\u636e%1$s", (String)"ExpenseManageListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), expenseNo));
    }
}

