/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.expense;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.expense.domain.ExpenseAttachDTO;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.domain.ExpenseInvoiceDTO;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.license.LicenseBillPlugin;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.RimUserService;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.StringUtils;

public class ExpenseManagePlugin
extends LicenseBillPlugin {
    private static Log logger = LogFactory.getLog(ExpenseManagePlugin.class);
    private static final String CACHED_INVOICE = "cached_invoice";
    private static final String AWS_REDIRECT_URL = "m4-web/thirdApp/wap/register";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"view_invoice_btn", "tbmain", "audit_receive", "bar_del"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        int currentStatus = this.getView().getFormShowParameter().getStatusValue();
        if (OperationStatus.ADDNEW.getValue() != currentStatus) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.initInvoiceView();
            this.initAttachView();
            return;
        }
        this.initCompanyInfo();
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if ("datagrid_click".equals(eventName)) {
            JSONObject json = JSON.parseObject((String)eventArgs);
            String clickkey = json.getString("clickkey");
            String rowkey = json.getString("rowkey");
            if ("viewInvoice".equals(clickkey)) {
                this.showInvoiceEdit(rowkey);
            }
        } else if ("datagrid_deleteRow".equals(e.getEventName())) {
            this.deleteInvoiceRow(eventArgs);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        String expenseId = String.valueOf(this.getModel().getDataEntity().getPkValue());
        QFilter expenseFilter = new QFilter("expense_id", "=", (Object)expenseId);
        if ("audit_receive".equals(key)) {
            DynamicObjectCollection serialNosObj = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])expenseFilter.toArray());
            if (serialNosObj == null || serialNosObj.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9700\u8981\u7b7e\u6536\u7684\u53d1\u7968\u4fe1\u606f", (String)"ExpenseManagePlugin_23", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        } else if ("open_fpzs".equals(key)) {
            this.openFpzs();
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        List datas = e.getSourceDataList();
        String redirectUrl = this.getRedirectUrl();
        for (Map data : datas) {
            String expenseNo = (String)data.get("billno");
            data.put("qrcode", redirectUrl + "&type=expense&expenseNo=" + expenseNo);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("view_invoice_btn".equals(key)) {
            this.viewInvoice();
        } else if ("scan_expense_detail".equals(key)) {
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("rim_san_gun");
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_san_gun");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            int currentStatus = this.getView().getFormShowParameter().getStatusValue();
            DynamicObject currentExpense = this.getModel().getDataEntity();
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)currentExpense.get("org"));
            String billNo = (String)this.getModel().getValue("billno");
            if (OperationStatus.ADDNEW.getValue() == currentStatus) {
                billNo = CodeRuleServiceHelper.getNumber((String)this.getView().getEntityId(), (DynamicObject)currentExpense, (String)String.valueOf(orgId));
                if (StringUtils.isEmpty((CharSequence)billNo)) {
                    String dateStr = DateUtils.format((Date)new Date(), (String)"yyyyMMdd");
                    String randomId = UUID.getRandomNum((int)8);
                    billNo = "FPQSD-".concat(dateStr).concat("-").concat(randomId);
                }
                this.getModel().setValue("billno", (Object)billNo);
            }
            String redirectUrl = this.getRedirectUrl();
            this.getModel().setValue("qrcode", (Object)(redirectUrl + "&type=expense&expenseNo=" + billNo));
            this.saveExpense(operateKey);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        String expenseId = String.valueOf(this.getModel().getDataEntity().getPkValue());
        QFilter expenseFilter = new QFilter("expense_id", "=", (Object)expenseId);
        if ("audit_receive".equals(operateKey)) {
            this.saveExpense(operateKey);
            DynamicObjectCollection serialNosObj = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])expenseFilter.toArray());
            ArrayList<String> serialNos = new ArrayList<String>(serialNosObj.size());
            for (DynamicObject serialNoObj : serialNosObj) {
                serialNos.add(serialNoObj.getString("serial_no"));
            }
            InvoiceCollectService invoiceCollectService = new InvoiceCollectService();
            invoiceCollectService.signInvoice(serialNos, "1");
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit", "bar_reject"});
            this.updateExpenseStatus("60");
        } else if ("audit".equals(operateKey)) {
            this.saveExpense(operateKey);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit", "bar_reject"});
            this.updateExpenseStatus("60");
        } else if ("delete_form".equals(operateKey)) {
            ExpenseService expenseService = new ExpenseService();
            ExpenseDTO param = new ExpenseDTO();
            param.setExpenseId(expenseId);
            List delteSerialList = expenseService.deleteExpense(param, true);
            if (!CollectionUtils.isEmpty((Collection)delteSerialList)) {
                expenseService.updateInvoiceMain(delteSerialList, null);
            }
            DynamicObject currentExpense = this.getModel().getDataEntity();
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)currentExpense.get("org"));
            CodeRuleServiceHelper.recycleNumber((String)this.getView().getEntityId(), (DynamicObject)currentExpense, (String)String.valueOf(orgId), (String)((String)this.getModel().getValue("billno")));
            QFilter idFilter = new QFilter("id", "=", this.getModel().getDataEntity().getPkValue());
            DeleteServiceHelper.delete((String)"rim_expense_manage", (QFilter[])idFilter.toArray());
            IFormView parentView = this.getView().getParentView();
            if (parentView instanceof IListView) {
                ((IListView)parentView).clearSelection();
                ((IListView)parentView).refresh();
            }
        } else if ("delete_selected".equals(operateKey)) {
            this.operateCustomTable("deleteRow");
        } else if ("reject".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("rim_fpzs_main".equals(key) && returnData != null) {
            JSONObject data = (JSONObject)returnData;
            JSONArray invoiceArray = data.getJSONArray("invoiceData");
            JSONArray attachArray = data.getJSONArray("attachData");
            JSONObject newInvoices = this.handleInvoice(invoiceArray);
            this.handleAttach(attachArray, newInvoices);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    private void operateCustomTable(String operate) {
        CustomControl control = (CustomControl)this.getControl("customcontrol_import");
        JSONObject map = new JSONObject();
        map.put("operate", (Object)operate);
        map.put("tableId", (Object)(this.getView().getPageId() + "import"));
        map.put("time", (Object)System.currentTimeMillis());
        control.setData((Object)map);
    }

    private void deleteInvoiceRow(String eventArgs) {
        JSONObject json = JSON.parseObject((String)eventArgs);
        JSONArray array = json.getJSONArray("rows");
        if (CollectionUtils.isEmpty((Collection)array)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u53d1\u7968", (String)"ExpenseManagePlugin_24", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String cachedInvoiceStr = this.getPageCache().get(CACHED_INVOICE);
        if (StringUtils.isEmpty((CharSequence)cachedInvoiceStr)) {
            return;
        }
        JSONObject cachedInvoice = JSON.parseObject((String)cachedInvoiceStr);
        for (int i = 0; i < array.size(); ++i) {
            String serialNo = array.getString(i);
            cachedInvoice.remove((Object)serialNo);
        }
        String leftCachedInvoice = cachedInvoice.toJSONString();
        this.getPageCache().put(CACHED_INVOICE, leftCachedInvoice);
    }

    private String getRedirectUrl() {
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject config = service.getGlobalConfig();
        String redirectUrl = RimConfigUtils.getConfig((String)"redirectUrl");
        if (StringUtils.isEmpty((CharSequence)redirectUrl)) {
            redirectUrl = config.getString("baseUrl");
            if (!redirectUrl.endsWith("/")) {
                redirectUrl = redirectUrl.concat("/");
            }
            if (redirectUrl.contains("api-sit")) {
                redirectUrl = redirectUrl.concat("test/");
            }
        }
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        logger.info("\u62a5\u9500\u5355\u7ba1\u7406accountId\uff1a" + accountId + ",tenantId:" + tenantId);
        String companyKey = MD5.md5Hex((String)(tenantId + accountId));
        redirectUrl = redirectUrl.concat(AWS_REDIRECT_URL).concat("?companyKey=" + companyKey);
        return redirectUrl;
    }

    private void openFpzs() {
        FormShowParameter param = new FormShowParameter();
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue == null || pkValue == 0L) {
            ORM orm = ORM.create();
            pkValue = orm.genLongId(this.getModel().getDataEntity().getDataEntityType());
            this.getModel().setValue("id", (Object)pkValue);
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("billId", pkValue.toString());
        customParams.put("billNo", this.getModel().getValue("billno"));
        String resource = "expense_pc";
        customParams.put("resource", resource);
        customParams.put("sourceSys", resource);
        customParams.put("viewPage", resource);
        DynamicObject typeObject = (DynamicObject)this.getModel().getValue("expense_type");
        String billType = null;
        if (typeObject != null) {
            billType = typeObject.getString("number");
            customParams.put("billType", billType);
        }
        customParams.put("entityId", billType);
        customParams.put("orgId", DynamicObjectUtil.getDynamicObjectLongValue((Object)this.getModel().getValue("org")));
        ArrayList companyInfoList = new ArrayList(8);
        HashMap<String, String> companyInfoMaps = new HashMap<String, String>(2);
        companyInfoMaps.put("taxNo", (String)this.getModel().getValue("company_tax_no"));
        companyInfoMaps.put("name", (String)this.getModel().getValue("company_name"));
        companyInfoList.add(companyInfoMaps);
        customParams.put("companyInfo", companyInfoList);
        Long userId = BigDecimalUtil.transDecimal((Object)this.getModel().getValue("reimburser")).longValue();
        String openId = MD5.md5Hex((String)(RequestContext.get().getTenantId() + resource + userId));
        Long rimUser = RimUserService.createRimUser((String)userId.toString(), (String)resource, (String)"third", (String)openId, (String)"");
        customParams.put("reimburser", userId);
        customParams.put("reimburserName", ((DynamicObject)this.getModel().getValue("reimburser")).getString("name"));
        customParams.put("rim_user", rimUser);
        customParams.put("bill_user", this.getModel().getValue("creator"));
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("rim_fpzs_main");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_fpzs_main");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private void initCompanyInfo() {
        DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
        if (orgObj == null) {
            return;
        }
        Long orgId = (Long)orgObj.getPkValue();
        if (orgId == null || orgId == 0L) {
            return;
        }
        Map companyNameAndTaxNo = TenantUtils.getCompanyNameAndTaxNoByOrgId((Long)orgId);
        this.getModel().setValue("company_name", companyNameAndTaxNo.get("name"));
        this.getModel().setValue("company_tax_no", companyNameAndTaxNo.get("taxNo"));
    }

    private void saveExpense(String operateType) {
        int currentStatus = this.getView().getFormShowParameter().getStatusValue();
        boolean isAddNew = false;
        if (OperationStatus.ADDNEW.getValue() == currentStatus) {
            DynamicObject currentExpense = this.getModel().getDataEntity();
            Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)currentExpense.get("org"));
            String billNo = (String)this.getModel().getValue("billno");
            Long id = currentExpense.getLong("id");
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{currentExpense});
            }
            catch (Throwable throwable) {
                CodeRuleServiceHelper.recycleNumber((String)this.getView().getEntityId(), (DynamicObject)currentExpense, (String)String.valueOf(orgId), (String)billNo);
                throw throwable;
            }
            this.getView().setStatus(OperationStatus.VIEW);
            isAddNew = true;
        }
        String invoiceStr = this.getPageCache().get(CACHED_INVOICE);
        JSONObject invoiceObject = null;
        if (!StringUtils.isEmpty((CharSequence)invoiceStr)) {
            invoiceObject = new JSONObject((Map)JSONObject.parseObject((String)invoiceStr, LinkedHashMap.class));
        }
        DynamicObjectCollection existedAttaches = this.getModel().getEntryEntity("attach_entity");
        LinkedHashSet<Long> existedAttachIds = new LinkedHashSet<Long>(8);
        DynamicObject[] attachObjs = null;
        if (existedAttaches != null && existedAttaches.size() > 0) {
            for (DynamicObject existedAttach : existedAttaches) {
                existedAttachIds.add(existedAttach.getLong("attach_id"));
            }
            attachObjs = BusinessDataServiceHelper.load((Object[])existedAttachIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_attach"));
        }
        String billType = ((DynamicObject)this.getModel().getValue("expense_type")).getString("number");
        String expenseId = String.valueOf(this.getModel().getDataEntity().getPkValue());
        String entityId = String.valueOf(billType);
        if (CollectionUtils.isEmpty((Map)invoiceObject) && CollectionUtils.isEmpty(existedAttachIds)) {
            if (isAddNew) {
                this.getView().invokeOperation("refresh");
                return;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u53d1\u7968\u6216\u9644\u4ef6", (String)"ExpenseManagePlugin_25", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)expenseId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u62a5\u9500\u5355id", (String)"ExpenseManagePlugin_26", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        Long costOrg = BigDecimalUtil.transDecimal((Object)((DynamicObject)this.getModel().getValue("org")).getPkValue()).longValue();
        ExpenseService expenseService = new ExpenseService();
        ExpenseDTO expenseDTO = new ExpenseDTO();
        String expenseNum = (String)this.getModel().getValue("billno");
        expenseDTO.setExpenseId(expenseId);
        expenseDTO.setExpenseNum(expenseNum);
        expenseDTO.setEntityId(entityId);
        expenseDTO.setReimbursingId(String.valueOf(((DynamicObject)this.getModel().getValue("reimburser")).getPkValue()));
        expenseDTO.setBillUser(String.valueOf(((DynamicObject)this.getModel().getValue("creator")).getPkValue()));
        expenseDTO.setOrgId(costOrg);
        expenseDTO.setExpenseType(billType);
        ArrayList<ExpenseInvoiceDTO> invoiceList = new ArrayList<ExpenseInvoiceDTO>(8);
        ArrayList<ExpenseAttachDTO> attachList = new ArrayList<ExpenseAttachDTO>(8);
        BigDecimal expenseAmount = BigDecimal.ZERO;
        if (invoiceObject != null) {
            for (Map.Entry entry : invoiceObject.entrySet()) {
                ExpenseInvoiceDTO invoiceDTO = new ExpenseInvoiceDTO();
                String serialNo = (String)entry.getKey();
                JSONObject invoiceObj = (JSONObject)JSON.toJSON(entry.getValue());
                invoiceDTO.setSerialNo(serialNo);
                invoiceDTO.setExpenseAmount(invoiceObj.getBigDecimal("totalAmount"));
                if (invoiceObj.getBigDecimal("totalAmount") != null) {
                    expenseAmount = expenseAmount.add(invoiceObj.getBigDecimal("totalAmount"));
                }
                invoiceDTO.setDeductionFlag(invoiceObj.getString("deductionFlag"));
                invoiceDTO.setDeductionPurpose(invoiceObj.getString("deductionPurpose"));
                invoiceDTO.setOrgId(invoiceObj.getLong("org"));
                invoiceDTO.setOriginalState(invoiceObj.getString("originalState"));
                invoiceList.add(invoiceDTO);
            }
            expenseDTO.setInvoiceList(invoiceList);
        }
        if (attachObjs != null && attachObjs.length > 0) {
            for (int j = 0; j < attachObjs.length; ++j) {
                DynamicObject attach = attachObjs[j];
                ExpenseAttachDTO attachDTO = new ExpenseAttachDTO();
                attachDTO.setAttachId(attach.getString("id"));
                attachDTO.setAttachName(attach.getString("attach_name"));
                attachDTO.setAttachNo(attach.getString("attach_no"));
                attachDTO.setAttachRemark(attach.getString("remark"));
                attachDTO.setAttachType(attach.getString("attach_type"));
                attachDTO.setAttachUrl(attach.getString("attach_url"));
                attachList.add(attachDTO);
            }
        }
        expenseDTO.setAttachDTOList(attachList);
        expenseDTO.setStatus("30");
        expenseDTO.setUpdateAttachRelation("1");
        logger.info("\u4fdd\u5b58PC\u62a5\u9500\u5355\u8bf7\u6c42\u53c2\u6570:" + SerializationUtils.toJsonString((Object)expenseDTO));
        expenseService.save(expenseDTO);
        QFilter expenseFilter = new QFilter("id", "=", (Object)BigDecimalUtil.transDecimal((Object)expenseId).longValue());
        DynamicObject expenseObj = BusinessDataServiceHelper.loadSingle((String)"rim_expense_manage", (String)"id, invoice_num, invoice_total_amount, billstatus, modifytime, org, company_name, company_tax_no", (QFilter[])expenseFilter.toArray());
        if (expenseObj == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u62a5\u9500\u5355:%1$s", (String)"ExpenseManagePlugin_22", (String)"imc-rim-formplugin", (Object[])new Object[0]), expenseId));
            return;
        }
        expenseObj.set("invoice_num", (Object)invoiceList.size());
        expenseObj.set("invoice_total_amount", (Object)expenseAmount);
        expenseObj.set("org", (Object)costOrg);
        expenseObj.set("company_name", this.getModel().getValue("company_name"));
        expenseObj.set("company_tax_no", this.getModel().getValue("company_tax_no"));
        if ("submit".equals(operateType)) {
            expenseObj.set("billstatus", (Object)"B");
        }
        expenseObj.set("modifytime", (Object)new Date());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{expenseObj});
        if ("submit".equals(operateType)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"ExpenseManagePlugin_27", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else if ("save".equals(operateType)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ExpenseManagePlugin_28", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        this.getView().invokeOperation("refresh");
    }

    private JSONObject handleInvoice(JSONArray invoiceArray) {
        String cachedInvoiceStr = this.getView().getPageCache().get(CACHED_INVOICE);
        JSONObject cachedInvoices = new JSONObject(true);
        if (!StringUtils.isEmpty((CharSequence)cachedInvoiceStr)) {
            cachedInvoices = new JSONObject((Map)JSONObject.parseObject((String)cachedInvoiceStr, LinkedHashMap.class));
        }
        JSONObject newInvoices = new JSONObject(true);
        if (invoiceArray != null && invoiceArray.size() > 0) {
            boolean isRepeat = false;
            for (int i = 0; i < invoiceArray.size(); ++i) {
                JSONObject invoice = invoiceArray.getJSONObject(i);
                String serialNo = invoice.getString("serialNo");
                newInvoices.put(serialNo, (Object)invoice);
                if (!cachedInvoices.containsKey((Object)serialNo)) continue;
                isRepeat = true;
            }
            if (isRepeat) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5305\u542b\u91cd\u590d\u7684\u53d1\u7968\uff0c\u5df2\u81ea\u52a8\u5254\u9664\u91cd\u590d\u53d1\u7968", (String)"ExpenseManagePlugin_29", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            cachedInvoices.putAll((Map)newInvoices);
            FpzsMainService.updateInvoiceGrid((AbstractFormPlugin)this, (JSONObject)cachedInvoices, (Boolean)Boolean.FALSE);
            this.getPageCache().put(CACHED_INVOICE, cachedInvoices.toJSONString());
        }
        if (newInvoices.size() > 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"expense_type", "org", "reimburser"});
        }
        return newInvoices;
    }

    private void handleAttach(JSONArray attachArray, JSONObject newInvoices) {
        DynamicObjectCollection existedAttaches = this.getModel().getEntryEntity("attach_entity");
        HashSet<Long> existedAttachIds = new HashSet<Long>(8);
        for (DynamicObject existedAttach : existedAttaches) {
            existedAttachIds.add(existedAttach.getLong("attach_id"));
        }
        if (attachArray != null && attachArray.size() > 0) {
            boolean isRepeat = false;
            for (int j = 0; j < attachArray.size(); ++j) {
                JSONObject attach = attachArray.getJSONObject(j);
                Long attachId = attach.getLong("attachId");
                if (existedAttachIds.contains(attachId)) {
                    isRepeat = true;
                    continue;
                }
                int index = this.getModel().createNewEntryRow("attach_entity");
                this.getModel().setValue("attach_name", (Object)attach.getString("attachName"), index);
                this.getModel().setValue("attach_type", attach.get((Object)"attachType"), index);
                this.getModel().setValue("upload_date", (Object)attach.getDate("uploadDate"), index);
                this.getModel().setValue("remark", (Object)attach.getString("remark"), index);
                this.getModel().setValue("attach_id", (Object)attach.getLong("attachId"), index);
                existedAttachIds.add(attachId);
            }
            if (isRepeat) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5305\u542b\u91cd\u590d\u7684\u9644\u4ef6\uff0c\u5df2\u81ea\u52a8\u5254\u9664\u91cd\u590d\u9644\u4ef6", (String)"ExpenseManagePlugin_30", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void initInvoiceView() {
        String expenseId = this.getModel().getDataEntity().getPkValue().toString();
        if (StringUtils.isEmpty((CharSequence)expenseId) || "0".equals(expenseId)) {
            this.initCompanyInfo();
        }
        QFilter expenseRelationFilter = new QFilter("expense_id", "=", (Object)expenseId);
        DynamicObjectCollection existedInvoiceRelation = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])expenseRelationFilter.toArray());
        String billStatus = (String)this.getModel().getValue("billstatus");
        if ("A".equals(billStatus) || "C".equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_reject"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"view_invoice_btn"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"view_invoice_btn"});
        } else if ("B".equals(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_audit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_reject"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"view_invoice_btn"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_reject"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_del"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"attach_del"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"open_fpzs"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"view_invoice_btn"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"operationcolumnap"});
        }
        if (existedInvoiceRelation == null || existedInvoiceRelation.size() <= 0) {
            return;
        }
        ArrayList<String> serialNoList = new ArrayList<String>(existedInvoiceRelation.size());
        for (DynamicObject existedInvoice : existedInvoiceRelation) {
            serialNoList.add(existedInvoice.getString("serial_no"));
        }
        if (CollectionUtils.isEmpty(serialNoList)) {
            return;
        }
        this.updateInvoiceGrid(serialNoList);
    }

    private void updateInvoiceGrid(List<String> serialNoList) {
        String expenseId = this.getModel().getDataEntity().getPkValue().toString();
        QFilter invoiceFilter = new QFilter("serial_no", "in", serialNoList);
        List invoiceIdsObj = QueryServiceHelper.queryPrimaryKeys((String)"rim_invoice", (QFilter[])invoiceFilter.toArray(), null, (int)10000);
        if (invoiceIdsObj.size() <= 0) {
            return;
        }
        ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
        for (Object invoiceObj : invoiceIdsObj) {
            if (invoiceObj == null) continue;
            invoiceIds.add((Long)invoiceObj);
        }
        JSONObject customParam = new JSONObject();
        customParam.put("sourceSys", (Object)ResManager.loadKDString((String)"\u82cd\u7a79\u62a5\u9500\u5355\u7ba1\u7406", (String)"ExpenseManagePlugin_31", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        DynamicObject typeObject = (DynamicObject)this.getModel().getValue("expense_type");
        if (typeObject != null) {
            customParam.put("billType", (Object)typeObject.getString("number"));
        }
        customParam.put("billNo", this.getModel().getValue("billno"));
        customParam.put("billId", (Object)expenseId);
        Long userId = BigDecimalUtil.transDecimal((Object)this.getModel().getValue("reimburser")).longValue();
        customParam.put("reimburser", (Object)userId);
        customParam.put("orgId", this.getModel().getValue("org"));
        String companyTaxNo = (String)this.getModel().getValue("company_tax_no");
        String buyerName = (String)this.getModel().getValue("company_name");
        ArrayList<String> companyTaxNos = new ArrayList<String>(1);
        companyTaxNos.add(companyTaxNo);
        ArrayList<String> buyerNames = new ArrayList<String>(1);
        buyerNames.add(buyerName);
        customParam.put("buyer_tax_no", companyTaxNos);
        customParam.put("buyer_name", buyerNames);
        JSONArray invoiceArray = VerifyUtil.verifyByMainIds((Map)customParam, invoiceIds, null, (boolean)true);
        logger.info("\u62a5\u9500\u5355\u7ba1\u7406\u53d1\u7968\u5408\u89c4\u6027\u6821\u9a8c\u7ed3\u679c\uff1a" + invoiceArray);
        JSONObject invoiceObjectArray = new JSONObject(true);
        for (int i = 0; i < invoiceArray.size(); ++i) {
            JSONObject invoice = invoiceArray.getJSONObject(i);
            if (invoice == null) continue;
            String serialNo = invoice.getString("serialNo");
            invoiceObjectArray.put(serialNo, (Object)invoice);
        }
        JSONObject invoiceArraySort = new JSONObject(true);
        for (String serialNo : serialNoList) {
            JSONObject invoice = invoiceObjectArray.getJSONObject(serialNo);
            if (invoice == null) continue;
            invoiceArraySort.put(serialNo, (Object)invoice);
        }
        FpzsMainService.updateInvoiceGrid((AbstractFormPlugin)this, (JSONObject)invoiceArraySort, (Boolean)Boolean.FALSE);
        this.getView().getPageCache().put(CACHED_INVOICE, invoiceArraySort.toJSONString());
    }

    public void initAttachView() {
        String expenseId = this.getModel().getDataEntity().getPkValue().toString();
        QFilter expenseFilter = new QFilter("expense_id", "=", (Object)expenseId);
        DynamicObjectCollection attachIdObjs = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id", (QFilter[])expenseFilter.toArray());
        if (attachIdObjs == null || attachIdObjs.size() == 0) {
            return;
        }
        ArrayList<Long> attachIds = new ArrayList<Long>(attachIdObjs.size());
        for (DynamicObject attachIdObj : attachIdObjs) {
            Long attachId = attachIdObj.getLong("attach_id");
            if (attachIds.contains(attachId)) continue;
            attachIds.add(attachId);
        }
        MainEntityType attachEntityType = EntityMetadataCache.getDataEntityType((String)"rim_attach");
        DynamicObject[] attachObjs = BusinessDataServiceHelper.load((Object[])attachIds.toArray(), (DynamicObjectType)attachEntityType);
        if (attachObjs == null || attachObjs.length == 0) {
            return;
        }
        this.getModel().deleteEntryData("attach_entity");
        for (DynamicObject attach : attachObjs) {
            this.addNewAttach(attach);
        }
    }

    private void addNewAttach(DynamicObject attach) {
        int index = this.getModel().createNewEntryRow("attach_entity");
        this.getModel().setValue("attach_name", (Object)attach.getString("attach_name"), index);
        this.getModel().setValue("attach_type", attach.get("attach_type"), index);
        this.getModel().setValue("upload_date", (Object)attach.getDate("update_time"), index);
        this.getModel().setValue("remark", (Object)attach.getString("remark"), index);
        this.getModel().setValue("attach_id", (Object)attach.getLong("id"), index);
    }

    private void updateExpenseStatus(String expenseStatus) {
        String expenseId = this.getModel().getDataEntity().getPkValue().toString();
        QFilter expenseRelationFilter = new QFilter("expense_id", "=", (Object)expenseId);
        DynamicObject[] expenseRelation = BusinessDataServiceHelper.load((String)"rim_expense_relation", (String)"id, status, serial_no", (QFilter[])expenseRelationFilter.toArray());
        if (expenseRelation == null || expenseRelation.length == 0) {
            return;
        }
        ArrayList<String> serialNos = new ArrayList<String>(expenseRelation.length);
        for (int i = 0; i < expenseRelation.length; ++i) {
            expenseRelation[i].set("status", (Object)expenseStatus);
            serialNos.add(expenseRelation[i].getString("serial_no"));
        }
        SaveServiceHelper.update((DynamicObject[])expenseRelation);
        DynamicObject[] expenses = BusinessDataServiceHelper.load((String)"rim_expense", (String)"id, status", (QFilter[])expenseRelationFilter.toArray());
        if (expenses != null && expenses.length > 0) {
            for (int j = 0; j < expenses.length; ++j) {
                expenses[j].set("status", (Object)expenseStatus);
            }
        }
        SaveServiceHelper.update((DynamicObject[])expenses);
        ExpenseService expenseService = new ExpenseService();
        expenseService.updateInvoiceMain(serialNos, null);
        this.getView().invokeOperation("refresh");
    }

    public void viewInvoice() {
        FormShowParameter param = new FormShowParameter();
        ArrayList<String> taxNoList = new ArrayList<String>(8);
        String expenseId = this.getModel().getDataEntity().getPkValue().toString();
        QFilter expenseRelationFilter = new QFilter("expense_id", "=", (Object)expenseId);
        DynamicObjectCollection existedInvoices = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])expenseRelationFilter.toArray());
        if (!CollectionUtils.isEmpty((Collection)existedInvoices)) {
            for (DynamicObject existedInvoice : existedInvoices) {
                taxNoList.add(existedInvoice.getString("serial_no"));
            }
        }
        DynamicObject typeObject = (DynamicObject)this.getModel().getValue("expense_type");
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        if (typeObject != null) {
            customParams.put("billType", typeObject.getString("number"));
        }
        customParams.put("expenseId", expenseId);
        customParams.put("sourceSys", "local");
        customParams.put("viewPage", "local");
        customParams.put("entityId", "local");
        customParams.put("resource", ResManager.loadKDString((String)"\u82cd\u7a79\u62a5\u9500\u5355\u7ba1\u7406", (String)"ExpenseManagePlugin_31", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        customParams.put("serialList", taxNoList);
        ArrayList list = new ArrayList(8);
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("taxNo", (String)this.getModel().getValue("company_tax_no"));
        map.put("name", (String)this.getModel().getValue("company_name"));
        list.add(map);
        customParams.put("companyInfo", list);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("rim_view_invoice");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_view_invoice");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private void showInvoiceEdit(String serialNo) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u53d1\u7968\u9884\u89c8", (String)"ExpenseManagePlugin_32", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("serialNo", serialNo);
        customParams.put("editAllow", Boolean.FALSE);
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("rim_inv_collect_edit");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_inv_collect_edit");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }
}

