/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.fpzs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.service.InvoiceAutoFillBillService;
import kd.imc.rim.common.service.InvoiceLog;

public class AttachDelAttachPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(AttachDelAttachPlugin.class);
    private static final String DELETE_ATTACH = "del_attach";
    private static final String ENTRY_ATTACH = "entry_attach";
    private static final String CANCEL_BUTTON = "cancelbutton";
    private static final String SUBMIT_BUTTON = "submitbutton";
    private static final String DELETED_KEY = "deleted_attach";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap_attach", SUBMIT_BUTTON, CANCEL_BUTTON});
        this.addClickListeners(new String[]{SUBMIT_BUTTON, CANCEL_BUTTON});
    }

    public void afterCreateNewData(EventObject e) {
        this.showAttachList();
    }

    public void itemClick(ItemClickEvent evt) {
        String item = evt.getItemKey();
        if (DELETE_ATTACH.equals(item)) {
            this.multiDelete();
        }
    }

    public void click(EventObject evt) {
        Button button = (Button)evt.getSource();
        String key = button.getKey();
        HashMap map = Maps.newHashMap();
        if (CANCEL_BUTTON.equals(key)) {
            map.put("optType", "close");
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
        }
        if (SUBMIT_BUTTON.equals(key)) {
            if (!ObjectUtils.isEmpty((Object)this.getPageCache().get(DELETED_KEY))) {
                List needDeleteAttachIds = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(DELETED_KEY), String.class);
                this.delete(needDeleteAttachIds);
            }
            this.returnAttachInfo();
            map.put("optType", "submit");
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("delete_attach".equals(afterDoOperationEventArgs.getOperateKey())) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AttachDelAttachPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"AttachDelAttachPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u8be5\u9644\u4ef6\uff1f", (String)"AttachDelAttachPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("delSingle"), btnNameMaps);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(DELETED_KEY);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            if ("delSingle".equals(callBackId)) {
                this.singleDelete();
            }
            if ("delMulti".equals(callBackId)) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ATTACH);
                int[] selectRows = entryGrid.getSelectRows();
                ArrayList<String> deleteAttachIds = new ArrayList<String>(selectRows.length);
                for (int i = 0; i < selectRows.length; ++i) {
                    deleteAttachIds.add(this.getModel().getValue("attachid", selectRows[i]).toString());
                }
                if (!ObjectUtils.isEmpty((Object)this.getPageCache().get(DELETED_KEY))) {
                    List deletedAttachIds = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(DELETED_KEY), String.class);
                    deleteAttachIds.addAll(deletedAttachIds);
                }
                this.getPageCache().put(DELETED_KEY, SerializationUtils.toJsonString(deleteAttachIds));
                this.getModel().deleteEntryRows(ENTRY_ATTACH, selectRows);
                this.updateAtachNum();
            }
        } else if (MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) {
            // empty if block
        }
    }

    private void multiDelete() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ATTACH);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u9644\u4ef6\u3002", (String)"AttachDelAttachPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AttachDelAttachPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"AttachDelAttachPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u8be5\u9644\u4ef6\uff1f", (String)"AttachDelAttachPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("delMulti"), btnNameMaps);
        }
    }

    private void singleDelete() {
        int attachIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ATTACH);
        String attachId = this.getModel().getValue("attachid", attachIndex).toString();
        ArrayList<String> attachIds = new ArrayList<String>(16);
        attachIds.add(attachId);
        if (!ObjectUtils.isEmpty((Object)this.getPageCache().get(DELETED_KEY))) {
            List deletedAttachIds = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(DELETED_KEY), String.class);
            attachIds.addAll(deletedAttachIds);
        }
        this.getPageCache().put(DELETED_KEY, SerializationUtils.toJsonString(attachIds));
        this.getModel().deleteEntryRow(ENTRY_ATTACH, attachIndex);
        this.updateAtachNum();
    }

    private void delete(List<String> deleteAttachIds) {
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        String expenseId = (String)customParam.get("billId");
        String entityId = (String)customParam.get("entityId");
        AttachQueryService attachQueryService = new AttachQueryService();
        attachQueryService.deleteFpzsAttach(expenseId, entityId, null, deleteAttachIds);
        InvoiceLog.insertExpenseLog((String)ResManager.loadKDString((String)"\u5220\u9664\u9644\u4ef6", (String)"AttachDelAttachPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)expenseId, (String)((String)customParam.get("billNo")), (String)String.join((CharSequence)",", deleteAttachIds));
    }

    private void showAttachList() {
        AttachQueryService attachQueryService;
        JSONArray attaches;
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        String expenseId = (String)customParam.get("billId");
        String entityId = (String)customParam.get("entityId");
        Object delSerialNos = customParam.get("delSerialNos");
        if (StringUtils.isEmpty((Object)expenseId) && StringUtils.isEmpty((Object)entityId)) {
            return;
        }
        JSONArray delSerials = new JSONArray();
        if (delSerialNos != null) {
            try {
                delSerials = JSON.parseArray((String)(delSerialNos + ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(attaches = (attachQueryService = new AttachQueryService()).queryFpzsAttach(expenseId, entityId, null, true)))) {
            for (int i = 0; i < attaches.size(); ++i) {
                String serialNo;
                JSONObject jsonObject = attaches.getJSONObject(i);
                if (ObjectUtils.isEmpty((Object)jsonObject) || delSerials.contains((Object)(serialNo = jsonObject.getString("serialNo")))) continue;
                int attachIndex = this.getModel().createNewEntryRow(ENTRY_ATTACH);
                this.getModel().setValue("attach_name", jsonObject.get((Object)"attachName"), attachIndex);
                this.getModel().setValue("attach_type", jsonObject.get((Object)"attachType"), attachIndex);
                this.getModel().setValue("upload_date", jsonObject.get((Object)"createTime"), attachIndex);
                this.getModel().setValue("attach_remark", jsonObject.get((Object)"remark"), attachIndex);
                this.getModel().setValue("attachid", jsonObject.get((Object)"attachId"), attachIndex);
            }
            this.updateAtachNum();
        }
    }

    private void updateAtachNum() {
        Label labelapAttachMsgCount = (Label)this.getView().getControl("labelap_attach_msg_count");
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ATTACH);
        labelapAttachMsgCount.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u5f20", (String)"AttachDelAttachPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), rowCount));
    }

    private void returnAttachInfo() {
        new InvoiceAutoFillBillService().autoUpdateAttach(this.getView());
    }
}

